<?php
/**
 * Aliases for Special:CategoryTree
 *
 * @file
 * @ingroup Extensions
 * @author Daniel Kinzler, brightbyte.de
 * @copyright © 2006-2008 Daniel Kinzler and others
 * @license GPL-2.0-or-later
 */

$specialPageAliases = [];

/** English (English) */
$specialPageAliases['en'] = [
	'CategoryTree' => [ 'CategoryTree' ],
];

/** Afrikaans (Afrikaans) */
$specialPageAliases['af'] = [
	'CategoryTree' => [ 'KategorieBoom' ],
];

/** Aragonese (aragonés) */
$specialPageAliases['an'] = [
	'CategoryTree' => [ 'Árbol_de_categorías' ],
];

/** Arabic (العربية) */
$specialPageAliases['ar'] = [
	'CategoryTree' => [ 'شجرة_تصنيف' ],
];

/** Aramaic (ܐܪܡܝܐ) */
$specialPageAliases['arc'] = [
	'CategoryTree' => [ 'ܐܝܠܢܐ_ܕܣܕܪܐ' ],
];

/** Egyptian Arabic (مصرى) */
$specialPageAliases['arz'] = [
	'CategoryTree' => [ 'شجرة_تصنيف' ],
];

/** Assamese (অসমীয়া) */
$specialPageAliases['as'] = [
	'CategoryTree' => [ 'শ্ৰেণীবৃক্ষ' ],
];

/** Avaric (авар) */
$specialPageAliases['av'] = [
	'CategoryTree' => [ 'Категориязул_гъветІ' ],
];

/** Bashkir (башҡортса) */
$specialPageAliases['ba'] = [
	'CategoryTree' => [ 'Категория_ағасы' ],
];

/** Bikol Central (Bikol Central) */
$specialPageAliases['bcl'] = [
	'CategoryTree' => [ 'KahoyNinKategorya' ],
];

/** Belarusian (Taraškievica orthography) (беларуская (тарашкевіца)) */
$specialPageAliases['be-tarask'] = [
	'CategoryTree' => [ 'Дрэва_катэгорыяў' ],
];

/** Bulgarian (български) */
$specialPageAliases['bg'] = [
	'CategoryTree' => [ 'Дърво_на_категориите' ],
];

/** Western Balochi (بلوچی رخشانی) */
$specialPageAliases['bgn'] = [
	'CategoryTree' => [ 'تهری_درچّگ_یا_درخت' ],
];

/** Banjar (Bahasa Banjar) */
$specialPageAliases['bjn'] = [
	'CategoryTree' => [ 'Puhun_tumbung' ],
];

/** Bengali (বাংলা) */
$specialPageAliases['bn'] = [
	'CategoryTree' => [ 'বিষয়শ্রেণী_বৃক্ষ' ],
];

/** Breton (brezhoneg) */
$specialPageAliases['br'] = [
	'CategoryTree' => [ 'GwezennadurRummad' ],
];

/** Bosnian (bosanski) */
$specialPageAliases['bs'] = [
	'CategoryTree' => [ 'StabloKategorija' ],
];

/** Catalan (català) */
$specialPageAliases['ca'] = [
	'CategoryTree' => [ 'Categories_en_arbre', 'Arbre_de_categories' ],
];

/** Min Dong Chinese (Mìng-dĕ̤ng-ngṳ̄) */
$specialPageAliases['cdo'] = [
	'CategoryTree' => [ '分類樹' ],
];

/** Chechen (нохчийн) */
$specialPageAliases['ce'] = [
	'CategoryTree' => [ 'Категорийн_дит' ],
];

/** Czech (čeština) */
$specialPageAliases['cs'] = [
	'CategoryTree' => [ 'Strom_kategorií' ],
];

/** Danish (dansk) */
$specialPageAliases['da'] = [
	'CategoryTree' => [ 'Kategoritræ' ],
];

/** German (Deutsch) */
$specialPageAliases['de'] = [
	'CategoryTree' => [ 'Kategorienbaum', 'Kategoriebaum' ],
];

/** Zazaki (Zazaki) */
$specialPageAliases['diq'] = [
	'CategoryTree' => [ 'DaraKategoriye' ],
];

/** Lower Sorbian (dolnoserbski) */
$specialPageAliases['dsb'] = [
	'CategoryTree' => [ 'Bom_kategorijow' ],
];

/** Greek (Ελληνικά) */
$specialPageAliases['el'] = [
	'CategoryTree' => [ 'ΔέντροΚατηγορίας' ],
];

/** Esperanto (Esperanto) */
$specialPageAliases['eo'] = [
	'CategoryTree' => [ 'Arbo_de_kategorioj', 'Kategorio-arbo' ],
];

/** Spanish (español) */
$specialPageAliases['es'] = [
	'CategoryTree' => [ 'ÁrbolDeCategorías', 'Árbol_de_categorías' ],
];

/** Estonian (eesti) */
$specialPageAliases['et'] = [
	'CategoryTree' => [ 'Kategooriapuu' ],
];

/** Basque (euskara) */
$specialPageAliases['eu'] = [
	'CategoryTree' => [ 'KategoriaZuhaitza' ],
];

/** Persian (فارسی) */
$specialPageAliases['fa'] = [
	'CategoryTree' => [ 'درخت_رده' ],
];

/** Finnish (suomi) */
$specialPageAliases['fi'] = [
	'CategoryTree' => [ 'Luokkapuu' ],
];

/** French (français) */
$specialPageAliases['fr'] = [
	'CategoryTree' => [ 'ArbreCatégorie', 'ArbreCategorie', 'Arbre_catégorie' ],
];

/** Arpitan (arpetan) */
$specialPageAliases['frp'] = [
	'CategoryTree' => [ 'Structura_d\'âbro_de_les_catègories', 'StructuraDÂbroDeLesCatègories' ],
];

/** Western Frisian (Frysk) */
$specialPageAliases['fy'] = [
	'CategoryTree' => [ 'Kategorybeam' ],
];

/** Galician (galego) */
$specialPageAliases['gl'] = [
	'CategoryTree' => [ 'Árbore_de_categorías' ],
];

/** Swiss German (Alemannisch) */
$specialPageAliases['gsw'] = [
	'CategoryTree' => [ 'Kategoriebaum' ],
];

/** Gujarati (ગુજરાતી) */
$specialPageAliases['gu'] = [
	'CategoryTree' => [ 'શ્રેણીવૃક્ષ' ],
];

/** Hebrew (עברית) */
$specialPageAliases['he'] = [
	'CategoryTree' => [ 'עץ_קטגוריות' ],
];

/** Hindi (हिन्दी) */
$specialPageAliases['hi'] = [
	'CategoryTree' => [ 'श्रेणी_वृक्ष', 'श्रेणीवृक्ष' ],
];

/** Upper Sorbian (hornjoserbsce) */
$specialPageAliases['hsb'] = [
	'CategoryTree' => [ 'Kategorijowy_štom' ],
];

/** Xiang Chinese (湘语) */
$specialPageAliases['hsn'] = [
	'CategoryTree' => [ '类别树' ],
];

/** Haitian (Kreyòl ayisyen) */
$specialPageAliases['ht'] = [
	'CategoryTree' => [ 'NivoKategori' ],
];

/** Hungarian (magyar) */
$specialPageAliases['hu'] = [
	'CategoryTree' => [ 'Kategóriafa' ],
];

/** Interlingua (interlingua) */
$specialPageAliases['ia'] = [
	'CategoryTree' => [ 'Arbore_de_categorias' ],
];

/** Indonesian (Bahasa Indonesia) */
$specialPageAliases['id'] = [
	'CategoryTree' => [ 'Pohon_kategori', 'PohonKategori' ],
];

/** Ido (Ido) */
$specialPageAliases['io'] = [
	'CategoryTree' => [ 'KategorioArboro' ],
];

/** Italian (italiano) */
$specialPageAliases['it'] = [
	'CategoryTree' => [ 'AlberoCategorie' ],
];

/** Japanese (日本語) */
$specialPageAliases['ja'] = [
	'CategoryTree' => [ 'カテゴリツリー' ],
];

/** Georgian (ქართული) */
$specialPageAliases['ka'] = [
	'CategoryTree' => [ 'კატეგორიის_ხე' ],
];

/** Khmer (ភាសាខ្មែរ) */
$specialPageAliases['km'] = [
	'CategoryTree' => [ 'មែកធាងចំណាត់ថ្នាក់ក្រុម' ],
];

/** Korean (한국어) */
$specialPageAliases['ko'] = [
	'CategoryTree' => [ '분류트리' ],
];

/** Colognian (Ripoarisch) */
$specialPageAliases['ksh'] = [
	'CategoryTree' => [ 'Saachjruppeboum' ],
];

/** Kurdish (Kurdî) */
$specialPageAliases['ku'] = [
	'CategoryTree' => [ 'Dara_kategoriyan' ],
];

/** Cornish (kernowek) */
$specialPageAliases['kw'] = [
	'CategoryTree' => [ 'GwedhenGlassys' ],
];

/** Latin (Latina) */
$specialPageAliases['la'] = [
	'CategoryTree' => [ 'Categoriarum_arbor' ],
];

/** Ladino (Ladino) */
$specialPageAliases['lad'] = [
	'CategoryTree' => [ 'Árvole_de_Kateggorías' ],
];

/** Luxembourgish (Lëtzebuergesch) */
$specialPageAliases['lb'] = [
	'CategoryTree' => [ 'Struktur_vun_de_Kategorien' ],
];

/** Northern Luri (لۊری شومالی) */
$specialPageAliases['lrc'] = [
	'CategoryTree' => [ 'دار_دأسە' ],
];

/** Malagasy (Malagasy) */
$specialPageAliases['mg'] = [
	'CategoryTree' => [ 'Hazon-tsokajy', 'Hazontsokajy' ],
];

/** Minangkabau (Baso Minangkabau) */
$specialPageAliases['min'] = [
	'CategoryTree' => [ 'BatangKategori' ],
];

/** Macedonian (македонски) */
$specialPageAliases['mk'] = [
	'CategoryTree' => [ 'ДрвоНаКатегории' ],
];

/** Malayalam (മലയാളം) */
$specialPageAliases['ml'] = [
	'CategoryTree' => [ 'വർഗ്ഗവൃക്ഷം' ],
];

/** Marathi (मराठी) */
$specialPageAliases['mr'] = [
	'CategoryTree' => [ 'वर्गवृक्ष' ],
];

/** Malay (Bahasa Melayu) */
$specialPageAliases['ms'] = [
	'CategoryTree' => [ 'Salasilah_kategori' ],
];

/** Maltese (Malti) */
$specialPageAliases['mt'] = [
	'CategoryTree' => [ 'SiġraKategorija' ],
];

/** Erzya (эрзянь) */
$specialPageAliases['myv'] = [
	'CategoryTree' => [ 'КатегорияньЧувто' ],
];

/** Norwegian Bokmål (norsk bokmål) */
$specialPageAliases['nb'] = [
	'CategoryTree' => [ 'Kategoritre' ],
];

/** Low German (Plattdüütsch) */
$specialPageAliases['nds'] = [
	'CategoryTree' => [ 'Kategorieboom' ],
];

/** Low Saxon (Netherlands) (Nedersaksies) */
$specialPageAliases['nds-nl'] = [
	'CategoryTree' => [ 'Kategorieboom' ],
];

/** Dutch (Nederlands) */
$specialPageAliases['nl'] = [
	'CategoryTree' => [ 'Categorieboom' ],
];

/** Norwegian Nynorsk (norsk nynorsk) */
$specialPageAliases['nn'] = [
	'CategoryTree' => [ 'Kategoritre' ],
];

/** Occitan (occitan) */
$specialPageAliases['oc'] = [
	'CategoryTree' => [ 'ArbreCategoria', 'Arbre_categoria' ],
];

/** Polish (polski) */
$specialPageAliases['pl'] = [
	'CategoryTree' => [ 'Drzewo_kategorii' ],
];

/** Pashto (پښتو) */
$specialPageAliases['ps'] = [
	'CategoryTree' => [ 'د_وېشنيزو_ونه' ],
];

/** Portuguese (português) */
$specialPageAliases['pt'] = [
	'CategoryTree' => [ 'Árvore_de_categorias' ],
];

/** Brazilian Portuguese (português do Brasil) */
$specialPageAliases['pt-br'] = [
	'CategoryTree' => [ 'Árvore_de_categorias', 'Árvore_de_categoria' ],
];

/** Romanian (română) */
$specialPageAliases['ro'] = [
	'CategoryTree' => [ 'Arborele_categoriilor' ],
];

/** Russian (русский) */
$specialPageAliases['ru'] = [
	'CategoryTree' => [ 'Дерево_категорий' ],
];

/** Sanskrit (संस्कृतम्) */
$specialPageAliases['sa'] = [
	'CategoryTree' => [ 'वर्गवृक्ष:' ],
];

/** Sicilian (sicilianu) */
$specialPageAliases['scn'] = [
	'CategoryTree' => [ 'AlberoCategorie' ],
];

/** Sinhala (සිංහල) */
$specialPageAliases['si'] = [
	'CategoryTree' => [ 'ප්‍රවර්ගරුක' ],
];

/** Slovak (slovenčina) */
$specialPageAliases['sk'] = [
	'CategoryTree' => [ 'StromKategórií' ],
];

/** Serbian Cyrillic (српски (ћирилица)) */
$specialPageAliases['sr-cyrl'] = [
	'CategoryTree' => [ 'СтаблоКатегорија' ],
];

/** Serbian Latin (srpski (latinica)) */
$specialPageAliases['sr-latn'] = [
	'CategoryTree' => [ 'StabloKategorija' ],
];

/** Swedish (svenska) */
$specialPageAliases['sv'] = [
	'CategoryTree' => [ 'Kategoriträd' ],
];

/** Swahili (Kiswahili) */
$specialPageAliases['sw'] = [
	'CategoryTree' => [ 'SafuyaJamii' ],
];

/** Telugu (తెలుగు) */
$specialPageAliases['te'] = [
	'CategoryTree' => [ 'వర్గవృక్షం' ],
];

/** Thai (ไทย) */
$specialPageAliases['th'] = [
	'CategoryTree' => [ 'หมวดหมู่แบบผังต้นไม้' ],
];

/** Tagalog (Tagalog) */
$specialPageAliases['tl'] = [
	'CategoryTree' => [ 'Puno_ng_kaurian' ],
];

/** Talysh (толышә зывон) */
$specialPageAliases['tly'] = [
	'CategoryTree' => [ 'Категоријон_до' ],
];

/** Turkish (Türkçe) */
$specialPageAliases['tr'] = [
	'CategoryTree' => [ 'KategoriAğacı', 'KategoriHiyerarşisi', 'UlamAğacı', 'UlamHiyerarşisi' ],
];

/** Ukrainian (українська) */
$specialPageAliases['uk'] = [
	'CategoryTree' => [ 'Дерево_категорій', 'Дерево_категорий' ],
];

/** Urdu (اردو) */
$specialPageAliases['ur'] = [
	'CategoryTree' => [ 'شجرہ_زمرہ' ],
];

/** Venetian (vèneto) */
$specialPageAliases['vec'] = [
	'CategoryTree' => [ 'ÀlbaroCategorie' ],
];

/** Veps (vepsän kel’) */
$specialPageAliases['vep'] = [
	'CategoryTree' => [ 'KategorijoidenPu' ],
];

/** Vietnamese (Tiếng Việt) */
$specialPageAliases['vi'] = [
	'CategoryTree' => [ 'Cây_thể_loại' ],
];

/** Yiddish (ייִדיש) */
$specialPageAliases['yi'] = [
	'CategoryTree' => [ 'קאטעגאריע_בוים' ],
];

/** Chinese (中文) */
$specialPageAliases['zh'] = [
	'CategoryTree' => [ 'CategoryTree' ],
];

/** Simplified Chinese (中文（简体）) */
$specialPageAliases['zh-hans'] = [
	'CategoryTree' => [ '分类树' ],
];

/** Traditional Chinese (中文（繁體）) */
$specialPageAliases['zh-hant'] = [
	'CategoryTree' => [ '分類樹' ],
];
