<?php

namespace MediaWiki\Extension\VisualEditor;

use MediaWiki\Context\RequestContext;
use MediaWiki\Permissions\Authority;
use MediaWiki\Rest\Handler\Helper\PageRestHelperFactory;

/**
 * @since 1.40
 */
class VisualEditorParsoidClientFactory {

	/**
	 * @internal For use by ServiceWiring.php only or when locating the service
	 */
	public const SERVICE_NAME = 'VisualEditor.ParsoidClientFactory';

	public function __construct(
		private readonly PageRestHelperFactory $pageRestHelperFactory,
	) {
	}

	/**
	 * Create a ParsoidClient for accessing Parsoid.
	 *
	 * @param string|string[]|false $cookiesToForward
	 * @param Authority|null $performer
	 *
	 * @return ParsoidClient
	 */
	public function createParsoidClient(
		/* Kept for compatibility with other extensions */ $cookiesToForward,
		?Authority $performer = null
	): ParsoidClient {
		if ( $performer === null ) {
			$performer = RequestContext::getMain()->getAuthority();
		}

		return $this->createDirectClient( $performer );
	}

	/**
	 * Create a ParsoidClient for accessing Parsoid.
	 */
	private function createDirectClient( Authority $performer ): ParsoidClient {
		return new DirectParsoidClient(
			$this->pageRestHelperFactory,
			$performer
		);
	}

}
