/* ========================================================================
 * PlantUML : a free UML diagram generator
 * ========================================================================
 *
 * (C) Copyright 2009-2020, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 * 
 * If you like this project or if you find it useful, you can support us at:
 * 
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/paypal
 * 
 * This file is part of PlantUML.
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PlantUML distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
 * USA.
 *
 *
 * Original Author:  Arnaud Roques
 *
 *
 */
package net.sourceforge.plantuml.regexdiagram;

public enum ReTokenType {

	SIMPLE_CHAR, //
	ESCAPED_CHAR, //
	CLASS, //
	QUANTIFIER, //
	ANCHOR, //
	GROUP, //
	NAMED_GROUP, //
	LOOK_AHEAD, //
	LOOK_BEHIND, //
	ALTERNATIVE, //
	PARENTHESIS_OPEN, //
	PARENTHESIS_CLOSE, //
	CONCATENATION_IMPLICIT;

	public boolean isNamedGroupOrLookAheadOrLookBehind() {
		return this == NAMED_GROUP || this == LOOK_AHEAD || this == LOOK_BEHIND;
	}

	static public boolean needImplicitConcatenation(ReTokenType token1, ReTokenType token2) {
		if (token1.isNamedGroupOrLookAheadOrLookBehind())
			return false;
		if (token1 == ALTERNATIVE)
			return false;
		if (token2 == ALTERNATIVE)
			return false;
		if (token2 == QUANTIFIER)
			return false;
		if (token1 == PARENTHESIS_OPEN)
			return false;
		if (token2 == PARENTHESIS_CLOSE)
			return false;
		return true;
	}

}
