// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The container for the records event.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct RecordsEvent {
    /// <p>The byte array of partial, one or more result records. S3 Select doesn't guarantee that a record will be self-contained in one record frame. To ensure continuous streaming of data, S3 Select might split the same record across multiple record frames instead of aggregating the results in memory. Some S3 clients (for example, the SDK for Java) handle this behavior by creating a <code>ByteStream</code> out of the response by default. Other clients might not handle this behavior by default. In those cases, you must aggregate the results on the client side and parse the response.</p>
    pub payload: ::std::option::Option<::aws_smithy_types::Blob>,
}
impl RecordsEvent {
    /// <p>The byte array of partial, one or more result records. S3 Select doesn't guarantee that a record will be self-contained in one record frame. To ensure continuous streaming of data, S3 Select might split the same record across multiple record frames instead of aggregating the results in memory. Some S3 clients (for example, the SDK for Java) handle this behavior by creating a <code>ByteStream</code> out of the response by default. Other clients might not handle this behavior by default. In those cases, you must aggregate the results on the client side and parse the response.</p>
    pub fn payload(&self) -> ::std::option::Option<&::aws_smithy_types::Blob> {
        self.payload.as_ref()
    }
}
impl RecordsEvent {
    /// Creates a new builder-style object to manufacture [`RecordsEvent`](crate::types::RecordsEvent).
    pub fn builder() -> crate::types::builders::RecordsEventBuilder {
        crate::types::builders::RecordsEventBuilder::default()
    }
}

/// A builder for [`RecordsEvent`](crate::types::RecordsEvent).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct RecordsEventBuilder {
    pub(crate) payload: ::std::option::Option<::aws_smithy_types::Blob>,
}
impl RecordsEventBuilder {
    /// <p>The byte array of partial, one or more result records. S3 Select doesn't guarantee that a record will be self-contained in one record frame. To ensure continuous streaming of data, S3 Select might split the same record across multiple record frames instead of aggregating the results in memory. Some S3 clients (for example, the SDK for Java) handle this behavior by creating a <code>ByteStream</code> out of the response by default. Other clients might not handle this behavior by default. In those cases, you must aggregate the results on the client side and parse the response.</p>
    pub fn payload(mut self, input: ::aws_smithy_types::Blob) -> Self {
        self.payload = ::std::option::Option::Some(input);
        self
    }
    /// <p>The byte array of partial, one or more result records. S3 Select doesn't guarantee that a record will be self-contained in one record frame. To ensure continuous streaming of data, S3 Select might split the same record across multiple record frames instead of aggregating the results in memory. Some S3 clients (for example, the SDK for Java) handle this behavior by creating a <code>ByteStream</code> out of the response by default. Other clients might not handle this behavior by default. In those cases, you must aggregate the results on the client side and parse the response.</p>
    pub fn set_payload(mut self, input: ::std::option::Option<::aws_smithy_types::Blob>) -> Self {
        self.payload = input;
        self
    }
    /// <p>The byte array of partial, one or more result records. S3 Select doesn't guarantee that a record will be self-contained in one record frame. To ensure continuous streaming of data, S3 Select might split the same record across multiple record frames instead of aggregating the results in memory. Some S3 clients (for example, the SDK for Java) handle this behavior by creating a <code>ByteStream</code> out of the response by default. Other clients might not handle this behavior by default. In those cases, you must aggregate the results on the client side and parse the response.</p>
    pub fn get_payload(&self) -> &::std::option::Option<::aws_smithy_types::Blob> {
        &self.payload
    }
    /// Consumes the builder and constructs a [`RecordsEvent`](crate::types::RecordsEvent).
    pub fn build(self) -> crate::types::RecordsEvent {
        crate::types::RecordsEvent { payload: self.payload }
    }
}
