/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.lang;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jlibs.core.io.FileNavigator;
import jlibs.core.io.FileUtil;
import jlibs.core.lang.OS;
import jlibs.core.lang.RuntimeUtil;

public class JavaProcessBuilder {
    private File javaHome = FileUtil.JAVA_HOME;
    private File workingDir = FileUtil.USER_DIR;
    private List<File> classpath = new ArrayList<File>();
    private List<File> endorsedDirs = new ArrayList<File>();
    private List<File> extDirs = new ArrayList<File>();
    private List<File> libraryPath = new ArrayList<File>();
    private List<File> bootClasspath = new ArrayList<File>();
    private List<File> appendBootClasspath = new ArrayList<File>();
    private List<File> prependBootClasspath = new ArrayList<File>();
    private Map<String, String> systemProperties = new HashMap<String, String>();
    private String initialHeap;
    private String maxHeap;
    private String vmType;
    private List<String> jvmArgs = new ArrayList<String>();
    private String mainClass;
    private boolean debugSuspend;
    private int debugPort = -1;
    private List<String> args = new ArrayList<String>();

    public JavaProcessBuilder javaHome(File javaHome) {
        this.javaHome = javaHome;
        return this;
    }

    public File javaHome() {
        return this.javaHome;
    }

    public JavaProcessBuilder workingDir(String dir) {
        return this.workingDir(new File(dir));
    }

    public JavaProcessBuilder workingDir(File dir) {
        this.workingDir = dir;
        return this;
    }

    public File workingDir() {
        return this.workingDir;
    }

    public JavaProcessBuilder classpath(String resource) {
        return this.classpath(new File(resource));
    }

    public JavaProcessBuilder classpath(File resource) {
        this.classpath.add(resource);
        return this;
    }

    public List<File> classpath() {
        return this.classpath;
    }

    public JavaProcessBuilder endorsedDir(String dir) {
        return this.endorsedDir(new File(dir));
    }

    public JavaProcessBuilder endorsedDir(File dir) {
        this.endorsedDirs.add(dir);
        return this;
    }

    public List<File> endorsedDirs() {
        return this.endorsedDirs;
    }

    public JavaProcessBuilder extDir(String dir) {
        return this.extDir(new File(dir));
    }

    public JavaProcessBuilder extDir(File dir) {
        this.extDirs.add(dir);
        return this;
    }

    public List<File> extDirs() {
        return this.extDirs;
    }

    public JavaProcessBuilder libraryPath(String dir) {
        return this.libraryPath(new File(dir));
    }

    public JavaProcessBuilder libraryPath(File dir) {
        this.libraryPath.add(dir);
        return this;
    }

    public List<File> libraryPath() {
        return this.libraryPath;
    }

    public JavaProcessBuilder bootClasspath(String resource) {
        return this.bootClasspath(new File(resource));
    }

    public JavaProcessBuilder bootClasspath(File resource) {
        this.bootClasspath.add(resource);
        return this;
    }

    public List<File> bootClasspath() {
        return this.bootClasspath;
    }

    public JavaProcessBuilder appendBootClasspath(String resource) {
        return this.appendBootClasspath(new File(resource));
    }

    public JavaProcessBuilder appendBootClasspath(File resource) {
        this.appendBootClasspath.add(resource);
        return this;
    }

    public List<File> appendBootClasspath() {
        return this.appendBootClasspath;
    }

    public JavaProcessBuilder prependBootClasspath(String resource) {
        return this.prependBootClasspath(new File(resource));
    }

    public JavaProcessBuilder prependBootClasspath(File resource) {
        this.prependBootClasspath.add(resource);
        return this;
    }

    public List<File> prependBootClasspath() {
        return this.prependBootClasspath;
    }

    public JavaProcessBuilder systemProperty(String name, String value) {
        this.systemProperties.put(name, value);
        return this;
    }

    public JavaProcessBuilder systemProperty(String name) {
        return this.systemProperty(name, null);
    }

    public Map<String, String> systemProperties() {
        return this.systemProperties;
    }

    public JavaProcessBuilder initialHeap(int mb) {
        return this.initialHeap(mb + "m");
    }

    public JavaProcessBuilder initialHeap(String size) {
        this.initialHeap = size;
        return this;
    }

    public String initialHeap() {
        return this.initialHeap;
    }

    public JavaProcessBuilder maxHeap(int mb) {
        return this.maxHeap(mb + "m");
    }

    public JavaProcessBuilder maxHeap(String size) {
        this.maxHeap = size;
        return this;
    }

    public String maxHeap() {
        return this.maxHeap;
    }

    public JavaProcessBuilder client() {
        this.vmType = "-client";
        return this;
    }

    public JavaProcessBuilder server() {
        this.vmType = "-server";
        return this;
    }

    public String vmType() {
        return this.vmType;
    }

    public JavaProcessBuilder jvmArg(String arg) {
        this.jvmArgs.add(arg);
        return this;
    }

    public List<String> jvmArgs() {
        return this.jvmArgs;
    }

    public JavaProcessBuilder mainClass(String mainClass) {
        this.mainClass = mainClass;
        return this;
    }

    public String mainClass() {
        return this.mainClass;
    }

    public JavaProcessBuilder debugSuspend(boolean suspend) {
        this.debugSuspend = suspend;
        return this;
    }

    public boolean debugSuspend() {
        return this.debugSuspend;
    }

    public JavaProcessBuilder debugPort(int port) {
        this.debugPort = port;
        return this;
    }

    public int debugPort() {
        return this.debugPort;
    }

    public JavaProcessBuilder arg(String arg) {
        this.args.add(arg);
        return this;
    }

    public List<String> args() {
        return this.args;
    }

    private static String toString(File fromDir, Iterable<File> files) throws IOException {
        StringBuilder buff = new StringBuilder();
        for (File file : files) {
            if (buff.length() > 0) {
                buff.append(FileUtil.PATH_SEPARATOR);
            }
            if (fromDir == null) {
                buff.append(file.getCanonicalPath());
                continue;
            }
            buff.append(FileNavigator.INSTANCE.getRelativePath(fromDir, file));
        }
        return buff.toString();
    }

    public String[] command() throws IOException {
        ArrayList<String> cmd = new ArrayList<String>();
        String executable = this.javaHome.getCanonicalPath() + FileUtil.SEPARATOR + "bin" + FileUtil.SEPARATOR + "java";
        if (OS.get().isWindows()) {
            executable = executable + ".exe";
        }
        cmd.add(executable);
        String path = JavaProcessBuilder.toString(this.workingDir, this.prependBootClasspath);
        if (path.length() > 0) {
            cmd.add("-Xbootclasspath/p:" + path);
        }
        if ((path = JavaProcessBuilder.toString(this.workingDir, this.bootClasspath)).length() > 0) {
            cmd.add("-Xbootclasspath:" + path);
        }
        if ((path = JavaProcessBuilder.toString(this.workingDir, this.appendBootClasspath)).length() > 0) {
            cmd.add("-Xbootclasspath/a:" + path);
        }
        if ((path = JavaProcessBuilder.toString(this.workingDir, this.classpath)).length() > 0) {
            cmd.add("-classpath");
            cmd.add(path);
        }
        if ((path = JavaProcessBuilder.toString(this.workingDir, this.extDirs)).length() > 0) {
            cmd.add("-Djava.ext.dirs=" + path);
        }
        if ((path = JavaProcessBuilder.toString(this.workingDir, this.endorsedDirs)).length() > 0) {
            cmd.add("-Djava.endorsed.dirs=" + path);
        }
        if ((path = JavaProcessBuilder.toString(this.workingDir, this.libraryPath)).length() > 0) {
            cmd.add("-Djava.library.path=" + path);
        }
        for (Map.Entry<String, String> prop : this.systemProperties.entrySet()) {
            if (prop.getValue() == null) {
                cmd.add("-D" + prop.getKey());
                continue;
            }
            cmd.add("-D" + prop.getKey() + "=" + prop.getValue());
        }
        if (this.initialHeap != null) {
            cmd.add("-Xms" + this.initialHeap);
        }
        if (this.maxHeap != null) {
            cmd.add("-Xmx" + this.maxHeap);
        }
        if (this.vmType != null) {
            cmd.add(this.vmType);
        }
        if (this.debugPort != -1) {
            cmd.add("-Xdebug");
            cmd.add("-Xnoagent");
            cmd.add("-Xrunjdwp:transport=dt_socket,server=y,suspend=" + (this.debugSuspend ? (char)'y' : 'n') + ",address=" + this.debugPort);
        }
        cmd.addAll(this.jvmArgs);
        if (this.mainClass != null) {
            cmd.add(this.mainClass);
            cmd.addAll(this.args);
        }
        return cmd.toArray(new String[cmd.size()]);
    }

    public Process launch(OutputStream output, OutputStream error) throws IOException {
        Process process = Runtime.getRuntime().exec(this.command(), null, this.workingDir);
        RuntimeUtil.redirectStreams(process, output, error);
        return process;
    }
}

