/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import jlibs.core.graph.Filter;
import jlibs.core.lang.Util;

public class CollectionUtil {
    public static Properties readProperties(InputStream is, Properties props) throws IOException {
        if (props == null) {
            props = new Properties();
        }
        try {
            props.load(is);
        }
        finally {
            is.close();
        }
        return props;
    }

    public static <E, T extends E> Collection<E> addAll(Collection<E> c, T ... array) {
        for (T obj : array) {
            c.add(obj);
        }
        return c;
    }

    public static <E, T extends E> Collection<E> removeAll(Collection<E> c, T ... array) {
        for (T obj : array) {
            c.remove(obj);
        }
        return c;
    }

    public static <E, T extends E> void add(List<E> list, int index, T item) {
        if (index < list.size()) {
            list.add(index, item);
        } else {
            list.add(item);
        }
    }

    public static <T> List<T> filter(Collection<T> c, Filter<T> filter) {
        if (c.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<T> filteredList = new ArrayList<T>(c.size());
        for (T element : c) {
            if (!filter.select(element)) continue;
            filteredList.add(element);
        }
        return filteredList;
    }

    public static <K, V> K getKey(Map<K, V> map, V value) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!Util.equals(entry.getValue(), value)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static boolean[] toBooleanArray(Collection<Boolean> c) {
        boolean[] arr = new boolean[c.size()];
        int i = 0;
        for (Boolean item : c) {
            arr[i++] = item;
        }
        return arr;
    }

    public static int[] toIntArray(Collection<? extends Number> c) {
        int[] arr = new int[c.size()];
        int i = 0;
        for (Number number : c) {
            arr[i++] = number.intValue();
        }
        return arr;
    }

    public static long[] toLongArray(Collection<? extends Number> c) {
        long[] arr = new long[c.size()];
        int i = 0;
        for (Number number : c) {
            arr[i++] = number.longValue();
        }
        return arr;
    }

    public static float[] toFloatArray(Collection<? extends Number> c) {
        float[] arr = new float[c.size()];
        int i = 0;
        for (Number number : c) {
            arr[i++] = number.floatValue();
        }
        return arr;
    }

    public static double[] toDoubleArray(Collection<? extends Number> c) {
        double[] arr = new double[c.size()];
        int i = 0;
        for (Number number : c) {
            arr[i++] = number.doubleValue();
        }
        return arr;
    }

    public static byte[] toByteArray(Collection<? extends Number> c) {
        byte[] arr = new byte[c.size()];
        int i = 0;
        for (Number number : c) {
            arr[i++] = number.byteValue();
        }
        return arr;
    }

    public static short[] toShortArray(Collection<? extends Number> c) {
        short[] arr = new short[c.size()];
        int i = 0;
        for (Number number : c) {
            arr[i++] = number.shortValue();
        }
        return arr;
    }
}

