<span id="news-2018"></span>
# Changelog - 2018

!!! note
    Please see [news](news.md) for the latest changes


## 19.9.0 / 2018/07/03

- fix: address a regression that prevented syslog support from working
  ([Issue #1668](https://github.com/benoitc/gunicorn/issues/1668), [PR #1773](https://github.com/benoitc/gunicorn/pull/1773))
- fix: correctly set `REMOTE_ADDR` on versions of Python 3 affected by
  `Python Issue 30205 <https://bugs.python.org/issue30205>`_
  ([Issue #1755](https://github.com/benoitc/gunicorn/issues/1755), [PR #1796](https://github.com/benoitc/gunicorn/pull/1796))
- fix: show zero response length correctly in access log ([PR #1787](https://github.com/benoitc/gunicorn/pull/1787))
- fix: prevent raising `AttributeError` when ``--reload`` is not passed
  in case of a `SyntaxError` raised from the WSGI application.
  ([Issue #1805](https://github.com/benoitc/gunicorn/issues/1805), [PR #1806](https://github.com/benoitc/gunicorn/pull/1806))
- The internal module ``gunicorn.workers.async`` was renamed to ``gunicorn.workers.base_async``
  since ``async`` is now a reserved word in Python 3.7.
  ([PR #1527](https://github.com/benoitc/gunicorn/pull/1527))

## 19.8.1 / 2018/04/30

- fix: secure scheme headers when bound to a unix socket
  ([Issue #1766](https://github.com/benoitc/gunicorn/issues/1766), [PR #1767](https://github.com/benoitc/gunicorn/pull/1767))

## 19.8.0 / 2018/04/28

- Eventlet 0.21.0 support ([Issue #1584](https://github.com/benoitc/gunicorn/issues/1584))
- Tornado 5 support ([Issue #1728](https://github.com/benoitc/gunicorn/issues/1728), [PR #1752](https://github.com/benoitc/gunicorn/pull/1752))
- support watching additional files with ``--reload-extra-file``
  ([PR #1527](https://github.com/benoitc/gunicorn/pull/1527))
- support configuring logging with a dictionary with ``--logging-config-dict``
  ([Issue #1087](https://github.com/benoitc/gunicorn/issues/1087), [PR #1110](https://github.com/benoitc/gunicorn/pull/1110), [PR #1602](https://github.com/benoitc/gunicorn/pull/1602))
- add support for the ``--config`` flag in the ``GUNICORN_CMD_ARGS`` environment
  variable ([Issue #1576](https://github.com/benoitc/gunicorn/issues/1576), [PR #1581](https://github.com/benoitc/gunicorn/pull/1581))
- disable ``SO_REUSEPORT`` by default and add the ``--reuse-port`` setting
  ([Issue #1553](https://github.com/benoitc/gunicorn/issues/1553), [Issue #1603](https://github.com/benoitc/gunicorn/issues/1603), [PR #1669](https://github.com/benoitc/gunicorn/pull/1669))
- fix: installing `inotify` on MacOS no longer breaks the reloader
  ([Issue #1540](https://github.com/benoitc/gunicorn/issues/1540), [PR #1541](https://github.com/benoitc/gunicorn/pull/1541))
- fix: do not throw ``TypeError`` when ``SO_REUSEPORT`` is not available
  ([Issue #1501](https://github.com/benoitc/gunicorn/issues/1501), [PR #1491](https://github.com/benoitc/gunicorn/pull/1491))
- fix: properly decode HTTP paths containing certain non-ASCII characters
  ([Issue #1577](https://github.com/benoitc/gunicorn/issues/1577), [PR #1578](https://github.com/benoitc/gunicorn/pull/1578))
- fix: remove whitespace when logging header values under gevent ([PR #1607](https://github.com/benoitc/gunicorn/pull/1607))
- fix: close unlinked temporary files ([Issue #1327](https://github.com/benoitc/gunicorn/issues/1327), [PR #1428](https://github.com/benoitc/gunicorn/pull/1428))
- fix: parse ``--umask=0`` correctly ([Issue #1622](https://github.com/benoitc/gunicorn/issues/1622), [PR #1632](https://github.com/benoitc/gunicorn/pull/1632))
- fix: allow loading applications using relative file paths
  ([Issue #1349](https://github.com/benoitc/gunicorn/issues/1349), [PR #1481](https://github.com/benoitc/gunicorn/pull/1481))
- fix: force blocking mode on the gevent sockets ([Issue #880](https://github.com/benoitc/gunicorn/issues/880), [PR #1616](https://github.com/benoitc/gunicorn/pull/1616))
- fix: preserve leading `/` in request path ([Issue #1512](https://github.com/benoitc/gunicorn/issues/1512), [PR #1511](https://github.com/benoitc/gunicorn/pull/1511))
- fix: forbid contradictory secure scheme headers
- fix: handle malformed basic authentication headers in access log
  ([Issue #1683](https://github.com/benoitc/gunicorn/issues/1683), [PR #1684](https://github.com/benoitc/gunicorn/pull/1684))
- fix: defer handling of ``USR1`` signal to a new greenlet under gevent
  ([Issue #1645](https://github.com/benoitc/gunicorn/issues/1645), [PR #1651](https://github.com/benoitc/gunicorn/pull/1651))
- fix: the threaded worker would sometimes close the wrong keep-alive
  connection under Python 2 ([Issue #1698](https://github.com/benoitc/gunicorn/issues/1698), [PR #1699](https://github.com/benoitc/gunicorn/pull/1699))
- fix: re-open log files on ``USR1`` signal using ``handler._open`` to
  support subclasses of ``FileHandler`` ([Issue #1739](https://github.com/benoitc/gunicorn/issues/1739), [PR #1742](https://github.com/benoitc/gunicorn/pull/1742))
- deprecation: the ``gaiohttp`` worker is deprecated, see the
  [worker-class](reference/settings.md#worker_class) documentation for more information
  ([Issue #1338](https://github.com/benoitc/gunicorn/issues/1338), [PR #1418](https://github.com/benoitc/gunicorn/pull/1418), [PR #1569](https://github.com/benoitc/gunicorn/pull/1569))
