#!/usr/bin/env perl

use strict;
use warnings;

use POSIX;

print <<"END_HEADER";
# DO NOT EDIT THIS FILE.
#
# This file is generated automatically from
# nqp's tools/build/generate-constants.pl
#
# Any changes made here will be lost.
#
END_HEADER

my @errno_values;

my $max_errno_name_len = 0;
foreach my $name (sort grep { /^E[A-Z]+$/ } keys %POSIX::) {
    my $code = POSIX->can($name);

    next unless $code;

    my $value = eval { $code->() };

    next unless defined $value;

    push @errno_values, [ $name, $value ];

    if(length($name) > $max_errno_name_len) {
        $max_errno_name_len = length($name);
    }
}

my $format = ".macro_const POSIX_%-${max_errno_name_len}s %d\n";

foreach my $pair (@errno_values) {
    my ( $name, $value ) = @$pair;

    printf $format, $name, $value;
}
