use super::*;

#[test]
fn intermediate128() {
    let key = [0u8; 16];
    let twofish = Twofish::new_from_slice(&key).unwrap();
    let subkeys: [u32; 40] = [
        0x52C54DDE, 0x11F0626D, 0x7CAC9D4A, 0x4D1B4AAA, 0xB7B83A10, 0x1E7D0BEB, 0xEE9C341F,
        0xCFE14BE4, 0xF98FFEF9, 0x9C5B3C17, 0x15A48310, 0x342A4D81, 0x424D89FE, 0xC14724A7,
        0x311B834C, 0xFDE87320, 0x3302778F, 0x26CD67B4, 0x7A6C6362, 0xC2BAF60E, 0x3411B994,
        0xD972C87F, 0x84ADB1EA, 0xA7DEE434, 0x54D2960F, 0xA2F7CAA8, 0xA6B8FF8C, 0x8014C425,
        0x6A748D1C, 0xEDBAF720, 0x928EF78C, 0x0338EE13, 0x9949D6BE, 0xC8314176, 0x07C07D68,
        0xECAE7EA7, 0x1FE71844, 0x85C05C89, 0xF298311E, 0x696EA672,
    ];
    assert_eq!(&twofish.k[..], &subkeys[..]);
}

#[test]
fn intermediate192() {
    let key: [u8; 24] = [
        0x01, 0x23, 0x45, 0x67, 0x89, 0xAB, 0xCD, 0xEF, 0xFE, 0xDC, 0xBA, 0x98, 0x76, 0x54, 0x32,
        0x10, 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77,
    ];
    let twofish = Twofish::new_from_slice(&key).unwrap();
    let sboxkey: [u8; 12] = [
        0xf2, 0xf6, 0x9f, 0xb8, 0x4b, 0xbc, 0x55, 0xb2, 0x61, 0x10, 0x66, 0x45,
    ];
    let subkeys: [u32; 40] = [
        0x38394A24, 0xC36D1175, 0xE802528F, 0x219BFEB4, 0xB9141AB4, 0xBD3E70CD, 0xAF609383,
        0xFD36908A, 0x03EFB931, 0x1D2EE7EC, 0xA7489D55, 0x6E44B6E8, 0x714AD667, 0x653AD51F,
        0xB6315B66, 0xB27C05AF, 0xA06C8140, 0x9853D419, 0x4016E346, 0x8D1C0DD4, 0xF05480BE,
        0xB6AF816F, 0x2D7DC789, 0x45B7BD3A, 0x57F8A163, 0x2BEFDA69, 0x26AE7271, 0xC2900D79,
        0xED323794, 0x3D3FFD80, 0x5DE68E49, 0x9C3D2478, 0xDF326FE3, 0x5911F70D, 0xC229F13B,
        0xB1364772, 0x4235364D, 0x0CEC363A, 0x57C8DD1F, 0x6A1AD61E,
    ];
    assert_eq!(&twofish.s[..12], &sboxkey[..]);
    assert_eq!(&twofish.k[..], &subkeys[..]);
}

#[test]
fn intermediate256() {
    let key: [u8; 32] = [
        0x01, 0x23, 0x45, 0x67, 0x89, 0xAB, 0xCD, 0xEF, 0xFE, 0xDC, 0xBA, 0x98, 0x76, 0x54, 0x32,
        0x10, 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xAA, 0xBB, 0xCC, 0xDD,
        0xEE, 0xFF,
    ];
    let twofish = Twofish::new_from_slice(&key).unwrap();
    let sboxkey: [u8; 16] = [
        0xf2, 0xf6, 0x9f, 0xb8, 0x4b, 0xbc, 0x55, 0xb2, 0x61, 0x10, 0x66, 0x45, 0xf7, 0x47, 0x44,
        0x8e,
    ];
    let subkeys: [u32; 40] = [
        0x5EC769BF, 0x44D13C60, 0x76CD39B1, 0x16750474, 0x349C294B, 0xEC21F6D6, 0x4FBD10B4,
        0x578DA0ED, 0xC3479695, 0x9B6958FB, 0x6A7FBC4E, 0x0BF1830B, 0x61B5E0FB, 0xD78D9730,
        0x7C6CF0C4, 0x2F9109C8, 0xE69EA8D1, 0xED99BDFF, 0x35DC0BBD, 0xA03E5018, 0xFB18EA0B,
        0x38BD43D3, 0x76191781, 0x37A9A0D3, 0x72427BEA, 0x911CC0B8, 0xF1689449, 0x71009CA9,
        0xB6363E89, 0x494D9855, 0x590BBC63, 0xF95A28B5, 0xFB72B4E1, 0x2A43505C, 0xBFD34176,
        0x5C133D12, 0x3A9247F7, 0x9A3331DD, 0xEE7515E6, 0xF0D54DCD,
    ];
    assert_eq!(&twofish.s[..], &sboxkey[..]);
    assert_eq!(&twofish.k[..], &subkeys[..]);
}
