/* 
    TowBowlTactics: Strategy game for X11

    Copyright (C) 2001 Pascal Bourut (toweld@rocketmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef PROGRESS_BAR_H
#define PROGRESS_BAR_H

#include "global.h"

#include <SDL/SDL.h>
#ifndef _SDL_H
	#include <SDL.h>
#endif

#include <SDL/SDL_image.h>
#ifndef _IMG_h
	#include <SDL_image.h>
#endif

class ProgressBar{
 public:
  ProgressBar(SDL_Surface*);
  ~ProgressBar(void);
  void draw_next_step(char*);
  void set_data_count(int);
 protected:
  int data_count;
  int step;
  int step_width;
  SDL_Rect rect;
  SDL_Surface* load_image(char*, int);
  SDL_Surface *screen,*back_screen,*picture,*font;
  int font_id;
};
#endif












