/* This file is automatically generated from version 1.6.4 of the
 * machine-readable SPIR-V grammar.
 *
 * The original source is covered by the following license:
 *
 * Copyright (c) 2014-2024 The Khronos Group Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and/or associated documentation files (the "Materials"),
 * to deal in the Materials without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Materials, and to permit persons to whom the
 * Materials are furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Materials.
 *
 * MODIFICATIONS TO THIS FILE MAY MEAN IT NO LONGER ACCURATELY REFLECTS KHRONOS
 * STANDARDS. THE UNMODIFIED, NORMATIVE VERSIONS OF KHRONOS SPECIFICATIONS AND
 * HEADER INFORMATION ARE LOCATED AT https://www.khronos.org/registry/
 *
 * THE MATERIALS ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM,OUT OF OR IN CONNECTION WITH THE MATERIALS OR THE USE OR OTHER DEALINGS
 * IN THE MATERIALS.
 */

enum spirv_parser_operand_category
{
    SPIRV_PARSER_OPERAND_CATEGORY_BIT_ENUM,
    SPIRV_PARSER_OPERAND_CATEGORY_COMPOSITE,
    SPIRV_PARSER_OPERAND_CATEGORY_ID,
    SPIRV_PARSER_OPERAND_CATEGORY_LITERAL,
    SPIRV_PARSER_OPERAND_CATEGORY_VALUE_ENUM,
};

enum spirv_parser_operand_type
{
    SPIRV_PARSER_OPERAND_TYPE_ACCESS_QUALIFIER,
    SPIRV_PARSER_OPERAND_TYPE_ADDRESSING_MODEL,
    SPIRV_PARSER_OPERAND_TYPE_BUILT_IN,
    SPIRV_PARSER_OPERAND_TYPE_CAPABILITY,
    SPIRV_PARSER_OPERAND_TYPE_COMPONENT_TYPE,
    SPIRV_PARSER_OPERAND_TYPE_COOPERATIVE_MATRIX_LAYOUT,
    SPIRV_PARSER_OPERAND_TYPE_COOPERATIVE_MATRIX_OPERANDS,
    SPIRV_PARSER_OPERAND_TYPE_COOPERATIVE_MATRIX_REDUCE,
    SPIRV_PARSER_OPERAND_TYPE_COOPERATIVE_MATRIX_USE,
    SPIRV_PARSER_OPERAND_TYPE_COOPERATIVE_VECTOR_MATRIX_LAYOUT,
    SPIRV_PARSER_OPERAND_TYPE_DECORATION,
    SPIRV_PARSER_OPERAND_TYPE_DIM,
    SPIRV_PARSER_OPERAND_TYPE_EXECUTION_MODE,
    SPIRV_PARSER_OPERAND_TYPE_EXECUTION_MODEL,
    SPIRV_PARSER_OPERAND_TYPE_FPDENORM_MODE,
    SPIRV_PARSER_OPERAND_TYPE_FPENCODING,
    SPIRV_PARSER_OPERAND_TYPE_FPFAST_MATH_MODE,
    SPIRV_PARSER_OPERAND_TYPE_FPOPERATION_MODE,
    SPIRV_PARSER_OPERAND_TYPE_FPROUNDING_MODE,
    SPIRV_PARSER_OPERAND_TYPE_FRAGMENT_SHADING_RATE,
    SPIRV_PARSER_OPERAND_TYPE_FUNCTION_CONTROL,
    SPIRV_PARSER_OPERAND_TYPE_FUNCTION_PARAMETER_ATTRIBUTE,
    SPIRV_PARSER_OPERAND_TYPE_GROUP_OPERATION,
    SPIRV_PARSER_OPERAND_TYPE_HOST_ACCESS_QUALIFIER,
    SPIRV_PARSER_OPERAND_TYPE_ID_MEMORY_SEMANTICS,
    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
    SPIRV_PARSER_OPERAND_TYPE_ID_RESULT,
    SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE,
    SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE,
    SPIRV_PARSER_OPERAND_TYPE_IMAGE_CHANNEL_DATA_TYPE,
    SPIRV_PARSER_OPERAND_TYPE_IMAGE_CHANNEL_ORDER,
    SPIRV_PARSER_OPERAND_TYPE_IMAGE_FORMAT,
    SPIRV_PARSER_OPERAND_TYPE_IMAGE_OPERANDS,
    SPIRV_PARSER_OPERAND_TYPE_INITIALIZATION_MODE_QUALIFIER,
    SPIRV_PARSER_OPERAND_TYPE_KERNEL_ENQUEUE_FLAGS,
    SPIRV_PARSER_OPERAND_TYPE_KERNEL_PROFILING_INFO,
    SPIRV_PARSER_OPERAND_TYPE_LINKAGE_TYPE,
    SPIRV_PARSER_OPERAND_TYPE_LITERAL_CONTEXT_DEPENDENT_NUMBER,
    SPIRV_PARSER_OPERAND_TYPE_LITERAL_EXT_INST_INTEGER,
    SPIRV_PARSER_OPERAND_TYPE_LITERAL_FLOAT,
    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
    SPIRV_PARSER_OPERAND_TYPE_LITERAL_SPEC_CONSTANT_OP_INTEGER,
    SPIRV_PARSER_OPERAND_TYPE_LITERAL_STRING,
    SPIRV_PARSER_OPERAND_TYPE_LOAD_CACHE_CONTROL,
    SPIRV_PARSER_OPERAND_TYPE_LOOP_CONTROL,
    SPIRV_PARSER_OPERAND_TYPE_MATRIX_MULTIPLY_ACCUMULATE_OPERANDS,
    SPIRV_PARSER_OPERAND_TYPE_MEMORY_ACCESS,
    SPIRV_PARSER_OPERAND_TYPE_MEMORY_MODEL,
    SPIRV_PARSER_OPERAND_TYPE_MEMORY_SEMANTICS,
    SPIRV_PARSER_OPERAND_TYPE_NAMED_MAXIMUM_NUMBER_OF_REGISTERS,
    SPIRV_PARSER_OPERAND_TYPE_OVERFLOW_MODES,
    SPIRV_PARSER_OPERAND_TYPE_PACKED_VECTOR_FORMAT,
    SPIRV_PARSER_OPERAND_TYPE_PAIR_ID_REF_ID_REF,
    SPIRV_PARSER_OPERAND_TYPE_PAIR_ID_REF_LITERAL_INTEGER,
    SPIRV_PARSER_OPERAND_TYPE_PAIR_LITERAL_INTEGER_ID_REF,
    SPIRV_PARSER_OPERAND_TYPE_QUANTIZATION_MODES,
    SPIRV_PARSER_OPERAND_TYPE_RAW_ACCESS_CHAIN_OPERANDS,
    SPIRV_PARSER_OPERAND_TYPE_RAY_FLAGS,
    SPIRV_PARSER_OPERAND_TYPE_RAY_QUERY_CANDIDATE_INTERSECTION_TYPE,
    SPIRV_PARSER_OPERAND_TYPE_RAY_QUERY_COMMITTED_INTERSECTION_TYPE,
    SPIRV_PARSER_OPERAND_TYPE_RAY_QUERY_INTERSECTION,
    SPIRV_PARSER_OPERAND_TYPE_SAMPLER_ADDRESSING_MODE,
    SPIRV_PARSER_OPERAND_TYPE_SAMPLER_FILTER_MODE,
    SPIRV_PARSER_OPERAND_TYPE_SCOPE,
    SPIRV_PARSER_OPERAND_TYPE_SELECTION_CONTROL,
    SPIRV_PARSER_OPERAND_TYPE_SOURCE_LANGUAGE,
    SPIRV_PARSER_OPERAND_TYPE_STORAGE_CLASS,
    SPIRV_PARSER_OPERAND_TYPE_STORE_CACHE_CONTROL,
    SPIRV_PARSER_OPERAND_TYPE_TENSOR_ADDRESSING_OPERANDS,
    SPIRV_PARSER_OPERAND_TYPE_TENSOR_CLAMP_MODE,
};

static const struct spirv_parser_operand_type_info
{
    const char *name;
    enum spirv_parser_operand_category category;
    size_t enumerant_count;
    const struct spirv_parser_enumerant
    {
        uint32_t value;
        const char *name;
        size_t parameter_count;
        enum spirv_parser_operand_type *parameters;
    } *enumerants;
}
spirv_parser_operand_type_info[] =
{
    [SPIRV_PARSER_OPERAND_TYPE_ACCESS_QUALIFIER] =
    {
        "AccessQualifier", SPIRV_PARSER_OPERAND_CATEGORY_VALUE_ENUM, 3,
        (struct spirv_parser_enumerant[])
        {
            {0, "ReadOnly"},
            {0x1, "WriteOnly"},
            {0x2, "ReadWrite"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_ADDRESSING_MODEL] =
    {
        "AddressingModel", SPIRV_PARSER_OPERAND_CATEGORY_VALUE_ENUM, 4,
        (struct spirv_parser_enumerant[])
        {
            {0, "Logical"},
            {0x1, "Physical32"},
            {0x2, "Physical64"},
            {0x14e4, "PhysicalStorageBuffer64"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_BUILT_IN] =
    {
        "BuiltIn", SPIRV_PARSER_OPERAND_CATEGORY_VALUE_ENUM, 126,
        (struct spirv_parser_enumerant[])
        {
            {0, "Position"},
            {0x1, "PointSize"},
            {0x3, "ClipDistance"},
            {0x4, "CullDistance"},
            {0x5, "VertexId"},
            {0x6, "InstanceId"},
            {0x7, "PrimitiveId"},
            {0x8, "InvocationId"},
            {0x9, "Layer"},
            {0xa, "ViewportIndex"},
            {0xb, "TessLevelOuter"},
            {0xc, "TessLevelInner"},
            {0xd, "TessCoord"},
            {0xe, "PatchVertices"},
            {0xf, "FragCoord"},
            {0x10, "PointCoord"},
            {0x11, "FrontFacing"},
            {0x12, "SampleId"},
            {0x13, "SamplePosition"},
            {0x14, "SampleMask"},
            {0x16, "FragDepth"},
            {0x17, "HelperInvocation"},
            {0x18, "NumWorkgroups"},
            {0x19, "WorkgroupSize"},
            {0x1a, "WorkgroupId"},
            {0x1b, "LocalInvocationId"},
            {0x1c, "GlobalInvocationId"},
            {0x1d, "LocalInvocationIndex"},
            {0x1e, "WorkDim"},
            {0x1f, "GlobalSize"},
            {0x20, "EnqueuedWorkgroupSize"},
            {0x21, "GlobalOffset"},
            {0x22, "GlobalLinearId"},
            {0x24, "SubgroupSize"},
            {0x25, "SubgroupMaxSize"},
            {0x26, "NumSubgroups"},
            {0x27, "NumEnqueuedSubgroups"},
            {0x28, "SubgroupId"},
            {0x29, "SubgroupLocalInvocationId"},
            {0x2a, "VertexIndex"},
            {0x2b, "InstanceIndex"},
            {0x1040, "CoreIDARM"},
            {0x1041, "CoreCountARM"},
            {0x1042, "CoreMaxIDARM"},
            {0x1043, "WarpIDARM"},
            {0x1044, "WarpMaxIDARM"},
            {0x1140, "SubgroupEqMask"},
            {0x1141, "SubgroupGeMask"},
            {0x1142, "SubgroupGtMask"},
            {0x1143, "SubgroupLeMask"},
            {0x1144, "SubgroupLtMask"},
            {0x1148, "BaseVertex"},
            {0x1149, "BaseInstance"},
            {0x114a, "DrawIndex"},
            {0x1150, "PrimitiveShadingRateKHR"},
            {0x1156, "DeviceIndex"},
            {0x1158, "ViewIndex"},
            {0x115c, "ShadingRateKHR"},
            {0x118c, "TileOffsetQCOM"},
            {0x118d, "TileDimensionQCOM"},
            {0x118e, "TileApronSizeQCOM"},
            {0x1380, "BaryCoordNoPerspAMD"},
            {0x1381, "BaryCoordNoPerspCentroidAMD"},
            {0x1382, "BaryCoordNoPerspSampleAMD"},
            {0x1383, "BaryCoordSmoothAMD"},
            {0x1384, "BaryCoordSmoothCentroidAMD"},
            {0x1385, "BaryCoordSmoothSampleAMD"},
            {0x1386, "BaryCoordPullModelAMD"},
            {0x1396, "FragStencilRefEXT"},
            {0x139d, "RemainingRecursionLevelsAMDX"},
            {0x13d1, "ShaderIndexAMDX"},
            {0x1485, "ViewportMaskNV"},
            {0x1489, "SecondaryPositionNV"},
            {0x148a, "SecondaryViewportMaskNV"},
            {0x148d, "PositionPerViewNV"},
            {0x148e, "ViewportMaskPerViewNV"},
            {0x1490, "FullyCoveredEXT"},
            {0x149a, "TaskCountNV"},
            {0x149b, "PrimitiveCountNV"},
            {0x149c, "PrimitiveIndicesNV"},
            {0x149d, "ClipDistancePerViewNV"},
            {0x149e, "CullDistancePerViewNV"},
            {0x149f, "LayerPerViewNV"},
            {0x14a0, "MeshViewCountNV"},
            {0x14a1, "MeshViewIndicesNV"},
            {0x14a6, "BaryCoordKHR"},
            {0x14a7, "BaryCoordNoPerspKHR"},
            {0x14ac, "FragSizeEXT"},
            {0x14ad, "FragInvocationCountEXT"},
            {0x14ae, "PrimitivePointIndicesEXT"},
            {0x14af, "PrimitiveLineIndicesEXT"},
            {0x14b0, "PrimitiveTriangleIndicesEXT"},
            {0x14b3, "CullPrimitiveEXT"},
            {0x14c7, "LaunchIdKHR"},
            {0x14c8, "LaunchSizeKHR"},
            {0x14c9, "WorldRayOriginKHR"},
            {0x14ca, "WorldRayDirectionKHR"},
            {0x14cb, "ObjectRayOriginKHR"},
            {0x14cc, "ObjectRayDirectionKHR"},
            {0x14cd, "RayTminKHR"},
            {0x14ce, "RayTmaxKHR"},
            {0x14cf, "InstanceCustomIndexKHR"},
            {0x14d2, "ObjectToWorldKHR"},
            {0x14d3, "WorldToObjectKHR"},
            {0x14d4, "HitTNV"},
            {0x14d5, "HitKindKHR"},
            {0x14d6, "CurrentRayTimeNV"},
            {0x14d7, "HitTriangleVertexPositionsKHR"},
            {0x14d9, "HitMicroTriangleVertexPositionsNV"},
            {0x14e0, "HitMicroTriangleVertexBarycentricsNV"},
            {0x14e7, "IncomingRayFlagsKHR"},
            {0x14e8, "RayGeometryIndexKHR"},
            {0x14ef, "HitIsSphereNV"},
            {0x14f0, "HitIsLSSNV"},
            {0x14f1, "HitSpherePositionNV"},
            {0x14fe, "WarpsPerSMNV"},
            {0x14ff, "SMCountNV"},
            {0x1500, "WarpIDNV"},
            {0x1501, "SMIDNV"},
            {0x1514, "HitLSSPositionsNV"},
            {0x151d, "HitKindFrontFacingMicroTriangleNV"},
            {0x151e, "HitKindBackFacingMicroTriangleNV"},
            {0x152c, "HitSphereRadiusNV"},
            {0x152d, "HitLSSRadiiNV"},
            {0x153c, "ClusterIDNV"},
            {0x1785, "CullMaskKHR"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_CAPABILITY] =
    {
        "Capability", SPIRV_PARSER_OPERAND_CATEGORY_VALUE_ENUM, 261,
        (struct spirv_parser_enumerant[])
        {
            {0, "Matrix"},
            {0x1, "Shader"},
            {0x2, "Geometry"},
            {0x3, "Tessellation"},
            {0x4, "Addresses"},
            {0x5, "Linkage"},
            {0x6, "Kernel"},
            {0x7, "Vector16"},
            {0x8, "Float16Buffer"},
            {0x9, "Float16"},
            {0xa, "Float64"},
            {0xb, "Int64"},
            {0xc, "Int64Atomics"},
            {0xd, "ImageBasic"},
            {0xe, "ImageReadWrite"},
            {0xf, "ImageMipmap"},
            {0x11, "Pipes"},
            {0x12, "Groups"},
            {0x13, "DeviceEnqueue"},
            {0x14, "LiteralSampler"},
            {0x15, "AtomicStorage"},
            {0x16, "Int16"},
            {0x17, "TessellationPointSize"},
            {0x18, "GeometryPointSize"},
            {0x19, "ImageGatherExtended"},
            {0x1b, "StorageImageMultisample"},
            {0x1c, "UniformBufferArrayDynamicIndexing"},
            {0x1d, "SampledImageArrayDynamicIndexing"},
            {0x1e, "StorageBufferArrayDynamicIndexing"},
            {0x1f, "StorageImageArrayDynamicIndexing"},
            {0x20, "ClipDistance"},
            {0x21, "CullDistance"},
            {0x22, "ImageCubeArray"},
            {0x23, "SampleRateShading"},
            {0x24, "ImageRect"},
            {0x25, "SampledRect"},
            {0x26, "GenericPointer"},
            {0x27, "Int8"},
            {0x28, "InputAttachment"},
            {0x29, "SparseResidency"},
            {0x2a, "MinLod"},
            {0x2b, "Sampled1D"},
            {0x2c, "Image1D"},
            {0x2d, "SampledCubeArray"},
            {0x2e, "SampledBuffer"},
            {0x2f, "ImageBuffer"},
            {0x30, "ImageMSArray"},
            {0x31, "StorageImageExtendedFormats"},
            {0x32, "ImageQuery"},
            {0x33, "DerivativeControl"},
            {0x34, "InterpolationFunction"},
            {0x35, "TransformFeedback"},
            {0x36, "GeometryStreams"},
            {0x37, "StorageImageReadWithoutFormat"},
            {0x38, "StorageImageWriteWithoutFormat"},
            {0x39, "MultiViewport"},
            {0x3a, "SubgroupDispatch"},
            {0x3b, "NamedBarrier"},
            {0x3c, "PipeStorage"},
            {0x3d, "GroupNonUniform"},
            {0x3e, "GroupNonUniformVote"},
            {0x3f, "GroupNonUniformArithmetic"},
            {0x40, "GroupNonUniformBallot"},
            {0x41, "GroupNonUniformShuffle"},
            {0x42, "GroupNonUniformShuffleRelative"},
            {0x43, "GroupNonUniformClustered"},
            {0x44, "GroupNonUniformQuad"},
            {0x45, "ShaderLayer"},
            {0x46, "ShaderViewportIndex"},
            {0x47, "UniformDecoration"},
            {0x1045, "CoreBuiltinsARM"},
            {0x1046, "TileImageColorReadAccessEXT"},
            {0x1047, "TileImageDepthReadAccessEXT"},
            {0x1048, "TileImageStencilReadAccessEXT"},
            {0x1069, "CooperativeMatrixLayoutsARM"},
            {0x1146, "FragmentShadingRateKHR"},
            {0x1147, "SubgroupBallotKHR"},
            {0x114b, "DrawParameters"},
            {0x114c, "WorkgroupMemoryExplicitLayoutKHR"},
            {0x114d, "WorkgroupMemoryExplicitLayout8BitAccessKHR"},
            {0x114e, "WorkgroupMemoryExplicitLayout16BitAccessKHR"},
            {0x114f, "SubgroupVoteKHR"},
            {0x1151, "StorageBuffer16BitAccess"},
            {0x1152, "UniformAndStorageBuffer16BitAccess"},
            {0x1153, "StoragePushConstant16"},
            {0x1154, "StorageInputOutput16"},
            {0x1155, "DeviceGroup"},
            {0x1157, "MultiView"},
            {0x1159, "VariablePointersStorageBuffer"},
            {0x115a, "VariablePointers"},
            {0x115d, "AtomicStorageOps"},
            {0x115f, "SampleMaskPostDepthCoverage"},
            {0x1160, "StorageBuffer8BitAccess"},
            {0x1161, "UniformAndStorageBuffer8BitAccess"},
            {0x1162, "StoragePushConstant8"},
            {0x1170, "DenormPreserve"},
            {0x1171, "DenormFlushToZero"},
            {0x1172, "SignedZeroInfNanPreserve"},
            {0x1173, "RoundingModeRTE"},
            {0x1174, "RoundingModeRTZ"},
            {0x1177, "RayQueryProvisionalKHR"},
            {0x1178, "RayQueryKHR"},
            {0x1179, "UntypedPointersKHR"},
            {0x117e, "RayTraversalPrimitiveCullingKHR"},
            {0x117f, "RayTracingKHR"},
            {0x1184, "TextureSampleWeightedQCOM"},
            {0x1185, "TextureBoxFilterQCOM"},
            {0x1186, "TextureBlockMatchQCOM"},
            {0x118f, "TileShadingQCOM"},
            {0x1192, "TextureBlockMatch2QCOM"},
            {0x1390, "Float16ImageAMD"},
            {0x1391, "ImageGatherBiasLodAMD"},
            {0x1392, "FragmentMaskAMD"},
            {0x1395, "StencilExportEXT"},
            {0x1397, "ImageReadWriteLodAMD"},
            {0x1398, "Int64ImageEXT"},
            {0x13bf, "ShaderClockKHR"},
            {0x13cb, "ShaderEnqueueAMDX"},
            {0x13df, "QuadControlKHR"},
            {0x13fc, "BFloat16TypeKHR"},
            {0x13fd, "BFloat16DotProductKHR"},
            {0x13fe, "BFloat16CooperativeMatrixKHR"},
            {0x1481, "SampleMaskOverrideCoverageNV"},
            {0x1483, "GeometryShaderPassthroughNV"},
            {0x1486, "ShaderViewportIndexLayerEXT"},
            {0x1487, "ShaderViewportMaskNV"},
            {0x148b, "ShaderStereoViewNV"},
            {0x148c, "PerViewAttributesNV"},
            {0x1491, "FragmentFullyCoveredEXT"},
            {0x1492, "MeshShadingNV"},
            {0x14a2, "ImageFootprintNV"},
            {0x14a3, "MeshShadingEXT"},
            {0x14a4, "FragmentBarycentricKHR"},
            {0x14a8, "ComputeDerivativeGroupQuadsKHR"},
            {0x14ab, "FragmentDensityEXT"},
            {0x14b1, "GroupNonUniformPartitionedNV"},
            {0x14b5, "ShaderNonUniform"},
            {0x14b6, "RuntimeDescriptorArray"},
            {0x14b7, "InputAttachmentArrayDynamicIndexing"},
            {0x14b8, "UniformTexelBufferArrayDynamicIndexing"},
            {0x14b9, "StorageTexelBufferArrayDynamicIndexing"},
            {0x14ba, "UniformBufferArrayNonUniformIndexing"},
            {0x14bb, "SampledImageArrayNonUniformIndexing"},
            {0x14bc, "StorageBufferArrayNonUniformIndexing"},
            {0x14bd, "StorageImageArrayNonUniformIndexing"},
            {0x14be, "InputAttachmentArrayNonUniformIndexing"},
            {0x14bf, "UniformTexelBufferArrayNonUniformIndexing"},
            {0x14c0, "StorageTexelBufferArrayNonUniformIndexing"},
            {0x14d8, "RayTracingPositionFetchKHR"},
            {0x14dc, "RayTracingNV"},
            {0x14dd, "RayTracingMotionBlurNV"},
            {0x14e1, "VulkanMemoryModel"},
            {0x14e2, "VulkanMemoryModelDeviceScope"},
            {0x14e3, "PhysicalStorageBufferAddresses"},
            {0x14e6, "ComputeDerivativeGroupLinearKHR"},
            {0x14e9, "RayTracingProvisionalKHR"},
            {0x14ed, "CooperativeMatrixNV"},
            {0x14f3, "FragmentShaderSampleInterlockEXT"},
            {0x14fc, "FragmentShaderShadingRateInterlockEXT"},
            {0x14fd, "ShaderSMBuiltinsNV"},
            {0x1502, "FragmentShaderPixelInterlockEXT"},
            {0x1503, "DemoteToHelperInvocation"},
            {0x1504, "DisplacementMicromapNV"},
            {0x1505, "RayTracingOpacityMicromapEXT"},
            {0x1507, "ShaderInvocationReorderNV"},
            {0x150e, "BindlessTextureNV"},
            {0x150f, "RayQueryPositionFetchKHR"},
            {0x1512, "CooperativeVectorNV"},
            {0x151c, "AtomicFloat16VectorNV"},
            {0x1521, "RayTracingDisplacementMicromapNV"},
            {0x1526, "RawAccessChainsNV"},
            {0x152a, "RayTracingSpheresGeometryNV"},
            {0x152b, "RayTracingLinearSweptSpheresGeometryNV"},
            {0x1536, "CooperativeMatrixReductionsNV"},
            {0x1537, "CooperativeMatrixConversionsNV"},
            {0x1538, "CooperativeMatrixPerElementOperationsNV"},
            {0x1539, "CooperativeMatrixTensorAddressingNV"},
            {0x153a, "CooperativeMatrixBlockLoadsNV"},
            {0x153b, "CooperativeVectorTrainingNV"},
            {0x153d, "RayTracingClusterAccelerationStructureNV"},
            {0x153f, "TensorAddressingNV"},
            {0x15c0, "SubgroupShuffleINTEL"},
            {0x15c1, "SubgroupBufferBlockIOINTEL"},
            {0x15c2, "SubgroupImageBlockIOINTEL"},
            {0x15cb, "SubgroupImageMediaBlockIOINTEL"},
            {0x15ce, "RoundToInfinityINTEL"},
            {0x15cf, "FloatingPointModeINTEL"},
            {0x15d0, "IntegerFunctions2INTEL"},
            {0x15e3, "FunctionPointersINTEL"},
            {0x15e4, "IndirectReferencesINTEL"},
            {0x15e6, "AsmINTEL"},
            {0x15ec, "AtomicFloat32MinMaxEXT"},
            {0x15ed, "AtomicFloat64MinMaxEXT"},
            {0x15f0, "AtomicFloat16MinMaxEXT"},
            {0x15f1, "VectorComputeINTEL"},
            {0x15f3, "VectorAnyINTEL"},
            {0x15fd, "ExpectAssumeKHR"},
            {0x1640, "SubgroupAvcMotionEstimationINTEL"},
            {0x1641, "SubgroupAvcMotionEstimationIntraINTEL"},
            {0x1642, "SubgroupAvcMotionEstimationChromaINTEL"},
            {0x16b9, "VariableLengthArrayINTEL"},
            {0x16bd, "FunctionFloatControlINTEL"},
            {0x16c0, "FPGAMemoryAttributesINTEL"},
            {0x16cd, "FPFastMathModeINTEL"},
            {0x16d4, "ArbitraryPrecisionIntegersINTEL"},
            {0x16d5, "ArbitraryPrecisionFloatingPointINTEL"},
            {0x16fe, "UnstructuredLoopControlsINTEL"},
            {0x1700, "FPGALoopControlsINTEL"},
            {0x1704, "KernelAttributesINTEL"},
            {0x1709, "FPGAKernelAttributesINTEL"},
            {0x170a, "FPGAMemoryAccessesINTEL"},
            {0x1710, "FPGAClusterAttributesINTEL"},
            {0x1712, "LoopFuseINTEL"},
            {0x1714, "FPGADSPControlINTEL"},
            {0x1716, "MemoryAccessAliasingINTEL"},
            {0x171c, "FPGAInvocationPipeliningAttributesINTEL"},
            {0x1720, "FPGABufferLocationINTEL"},
            {0x1722, "ArbitraryPrecisionFixedPointINTEL"},
            {0x172f, "USMStorageClassesINTEL"},
            {0x1733, "RuntimeAlignedAttributeINTEL"},
            {0x1737, "IOPipesINTEL"},
            {0x1739, "BlockingPipesINTEL"},
            {0x173c, "FPGARegINTEL"},
            {0x1780, "DotProductInputAll"},
            {0x1781, "DotProductInput4x8Bit"},
            {0x1782, "DotProductInput4x8BitPacked"},
            {0x1783, "DotProduct"},
            {0x1784, "RayCullMaskKHR"},
            {0x1786, "CooperativeMatrixKHR"},
            {0x1788, "ReplicatedCompositesEXT"},
            {0x1789, "BitInstructions"},
            {0x178a, "GroupNonUniformRotateKHR"},
            {0x178d, "FloatControls2"},
            {0x1791, "AtomicFloat32AddEXT"},
            {0x1792, "AtomicFloat64AddEXT"},
            {0x17c9, "LongCompositesINTEL"},
            {0x17ce, "OptNoneEXT"},
            {0x17cf, "AtomicFloat16AddEXT"},
            {0x17e2, "DebugInfoModuleINTEL"},
            {0x17e3, "BFloat16ConversionINTEL"},
            {0x17fd, "SplitBarrierINTEL"},
            {0x1800, "ArithmeticFenceEXT"},
            {0x1806, "FPGAClusterAttributesV2INTEL"},
            {0x1811, "FPGAKernelAttributesv2INTEL"},
            {0x1812, "TaskSequenceINTEL"},
            {0x1819, "FPMaxErrorINTEL"},
            {0x181b, "FPGALatencyControlINTEL"},
            {0x181e, "FPGAArgumentInterfacesINTEL"},
            {0x182b, "GlobalVariableHostAccessINTEL"},
            {0x182d, "GlobalVariableFPGADecorationsINTEL"},
            {0x184c, "SubgroupBufferPrefetchINTEL"},
            {0x1854, "Subgroup2DBlockIOINTEL"},
            {0x1855, "Subgroup2DBlockTransformINTEL"},
            {0x1856, "Subgroup2DBlockTransposeINTEL"},
            {0x185c, "SubgroupMatrixMultiplyAccumulateINTEL"},
            {0x1861, "TernaryBitwiseFunctionINTEL"},
            {0x1900, "GroupUniformArithmeticKHR"},
            {0x1919, "TensorFloat32RoundingINTEL"},
            {0x191b, "MaskedGatherScatterINTEL"},
            {0x1929, "CacheControlsINTEL"},
            {0x193c, "RegisterLimitsINTEL"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_COMPONENT_TYPE] =
    {
        "ComponentType", SPIRV_PARSER_OPERAND_CATEGORY_VALUE_ENUM, 15,
        (struct spirv_parser_enumerant[])
        {
            {0, "Float16NV"},
            {0x1, "Float32NV"},
            {0x2, "Float64NV"},
            {0x3, "SignedInt8NV"},
            {0x4, "SignedInt16NV"},
            {0x5, "SignedInt32NV"},
            {0x6, "SignedInt64NV"},
            {0x7, "UnsignedInt8NV"},
            {0x8, "UnsignedInt16NV"},
            {0x9, "UnsignedInt32NV"},
            {0xa, "UnsignedInt64NV"},
            {0x3ba247f8, "SignedInt8PackedNV"},
            {0x3ba247f9, "UnsignedInt8PackedNV"},
            {0x3ba247fa, "FloatE4M3NV"},
            {0x3ba247fb, "FloatE5M2NV"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_COOPERATIVE_MATRIX_LAYOUT] =
    {
        "CooperativeMatrixLayout", SPIRV_PARSER_OPERAND_CATEGORY_VALUE_ENUM, 4,
        (struct spirv_parser_enumerant[])
        {
            {0, "RowMajorKHR"},
            {0x1, "ColumnMajorKHR"},
            {0x106a, "RowBlockedInterleavedARM"},
            {0x106b, "ColumnBlockedInterleavedARM"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_COOPERATIVE_MATRIX_OPERANDS] =
    {
        "CooperativeMatrixOperands", SPIRV_PARSER_OPERAND_CATEGORY_BIT_ENUM, 6,
        (struct spirv_parser_enumerant[])
        {
            {0, "NoneKHR"},
            {0x1, "MatrixASignedComponentsKHR"},
            {0x2, "MatrixBSignedComponentsKHR"},
            {0x4, "MatrixCSignedComponentsKHR"},
            {0x8, "MatrixResultSignedComponentsKHR"},
            {0x10, "SaturatingAccumulationKHR"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_COOPERATIVE_MATRIX_REDUCE] =
    {
        "CooperativeMatrixReduce", SPIRV_PARSER_OPERAND_CATEGORY_BIT_ENUM, 3,
        (struct spirv_parser_enumerant[])
        {
            {0x1, "Row"},
            {0x2, "Column"},
            {0x4, "2x2"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_COOPERATIVE_MATRIX_USE] =
    {
        "CooperativeMatrixUse", SPIRV_PARSER_OPERAND_CATEGORY_VALUE_ENUM, 3,
        (struct spirv_parser_enumerant[])
        {
            {0, "MatrixAKHR"},
            {0x1, "MatrixBKHR"},
            {0x2, "MatrixAccumulatorKHR"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_COOPERATIVE_VECTOR_MATRIX_LAYOUT] =
    {
        "CooperativeVectorMatrixLayout", SPIRV_PARSER_OPERAND_CATEGORY_VALUE_ENUM, 4,
        (struct spirv_parser_enumerant[])
        {
            {0, "RowMajorNV"},
            {0x1, "ColumnMajorNV"},
            {0x2, "InferencingOptimalNV"},
            {0x3, "TrainingOptimalNV"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_DECORATION] =
    {
        "Decoration", SPIRV_PARSER_OPERAND_CATEGORY_VALUE_ENUM, 142,
        (struct spirv_parser_enumerant[])
        {
            {0, "RelaxedPrecision"},
            {
                0x1, "SpecId", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {0x2, "Block"},
            {0x3, "BufferBlock"},
            {0x4, "RowMajor"},
            {0x5, "ColMajor"},
            {
                0x6, "ArrayStride", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x7, "MatrixStride", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {0x8, "GLSLShared"},
            {0x9, "GLSLPacked"},
            {0xa, "CPacked"},
            {
                0xb, "BuiltIn", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_BUILT_IN,
                }
            },
            {0xd, "NoPerspective"},
            {0xe, "Flat"},
            {0xf, "Patch"},
            {0x10, "Centroid"},
            {0x11, "Sample"},
            {0x12, "Invariant"},
            {0x13, "Restrict"},
            {0x14, "Aliased"},
            {0x15, "Volatile"},
            {0x16, "Constant"},
            {0x17, "Coherent"},
            {0x18, "NonWritable"},
            {0x19, "NonReadable"},
            {0x1a, "Uniform"},
            {
                0x1b, "UniformId", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE,
                }
            },
            {0x1c, "SaturatedConversion"},
            {
                0x1d, "Stream", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x1e, "Location", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x1f, "Component", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x20, "Index", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x21, "Binding", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x22, "DescriptorSet", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x23, "Offset", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x24, "XfbBuffer", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x25, "XfbStride", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x26, "FuncParamAttr", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_FUNCTION_PARAMETER_ATTRIBUTE,
                }
            },
            {
                0x27, "FPRoundingMode", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_FPROUNDING_MODE,
                }
            },
            {
                0x28, "FPFastMathMode", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_FPFAST_MATH_MODE,
                }
            },
            {
                0x29, "LinkageAttributes", 2,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_STRING,
                    SPIRV_PARSER_OPERAND_TYPE_LINKAGE_TYPE,
                }
            },
            {0x2a, "NoContraction"},
            {
                0x2b, "InputAttachmentIndex", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x2c, "Alignment", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x2d, "MaxByteOffset", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x2e, "AlignmentId", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                }
            },
            {
                0x2f, "MaxByteOffsetId", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                }
            },
            {0x1175, "NoSignedWrap"},
            {0x1176, "NoUnsignedWrap"},
            {0x1187, "WeightTextureQCOM"},
            {0x1188, "BlockMatchTextureQCOM"},
            {0x1193, "BlockMatchSamplerQCOM"},
            {0x1387, "ExplicitInterpAMD"},
            {
                0x139b, "NodeSharesPayloadLimitsWithAMDX", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                }
            },
            {
                0x139c, "NodeMaxPayloadsAMDX", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                }
            },
            {0x13d6, "TrackFinishWritingAMDX"},
            {
                0x13e3, "PayloadNodeNameAMDX", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                }
            },
            {
                0x13ea, "PayloadNodeBaseIndexAMDX", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                }
            },
            {0x13eb, "PayloadNodeSparseArrayAMDX"},
            {
                0x13ec, "PayloadNodeArraySizeAMDX", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                }
            },
            {0x13f1, "PayloadDispatchIndirectAMDX"},
            {0x1480, "OverrideCoverageNV"},
            {0x1482, "PassthroughNV"},
            {0x1484, "ViewportRelativeNV"},
            {
                0x1488, "SecondaryViewportRelativeNV", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {0x1497, "PerPrimitiveEXT"},
            {0x1498, "PerViewNV"},
            {0x1499, "PerTaskNV"},
            {0x14a5, "PerVertexKHR"},
            {0x14b4, "NonUniform"},
            {0x14eb, "RestrictPointer"},
            {0x14ec, "AliasedPointer"},
            {0x150a, "HitObjectShaderRecordBufferNV"},
            {0x1516, "BindlessSamplerNV"},
            {0x1517, "BindlessImageNV"},
            {0x1518, "BoundSamplerNV"},
            {0x1519, "BoundImageNV"},
            {
                0x15df, "SIMTCallINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {0x15e2, "ReferencedIndirectlyINTEL"},
            {
                0x15e7, "ClobberINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_STRING,
                }
            },
            {0x15e8, "SideEffectsINTEL"},
            {0x15f8, "VectorComputeVariableINTEL"},
            {
                0x15f9, "FuncParamIOKindINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {0x15fa, "VectorComputeFunctionINTEL"},
            {0x15fb, "StackCallINTEL"},
            {
                0x15fc, "GlobalVariableOffsetINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x1602, "CounterBuffer", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                }
            },
            {
                0x1603, "UserSemantic", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_STRING,
                }
            },
            {
                0x1604, "UserTypeGOOGLE", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_STRING,
                }
            },
            {
                0x16be, "FunctionRoundingModeINTEL", 2,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                    SPIRV_PARSER_OPERAND_TYPE_FPROUNDING_MODE,
                }
            },
            {
                0x16bf, "FunctionDenormModeINTEL", 2,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                    SPIRV_PARSER_OPERAND_TYPE_FPDENORM_MODE,
                }
            },
            {0x16c1, "RegisterINTEL"},
            {
                0x16c2, "MemoryINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_STRING,
                }
            },
            {
                0x16c3, "NumbanksINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x16c4, "BankwidthINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x16c5, "MaxPrivateCopiesINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {0x16c6, "SinglepumpINTEL"},
            {0x16c7, "DoublepumpINTEL"},
            {
                0x16c8, "MaxReplicatesINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {0x16c9, "SimpleDualPortINTEL"},
            {
                0x16ca, "MergeINTEL", 2,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_STRING,
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_STRING,
                }
            },
            {
                0x16cb, "BankBitsINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x16cc, "ForcePow2DepthINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x16fb, "StridesizeINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x16fc, "WordsizeINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {0x16fd, "TrueDualPortINTEL"},
            {0x170b, "BurstCoalesceINTEL"},
            {
                0x170c, "CacheSizeINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {0x170d, "DontStaticallyCoalesceINTEL"},
            {
                0x170e, "PrefetchINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {0x1711, "StallEnableINTEL"},
            {0x1713, "FuseLoopsInFunctionINTEL"},
            {
                0x1715, "MathOpDSPModeINTEL", 2,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x171a, "AliasScopeINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                }
            },
            {
                0x171b, "NoAliasINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                }
            },
            {
                0x171d, "InitiationIntervalINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x171e, "MaxConcurrencyINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x171f, "PipelineEnableINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x1721, "BufferLocationINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x1738, "IOPipeStorageINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x17c0, "FunctionFloatingPointModeINTEL", 2,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                    SPIRV_PARSER_OPERAND_TYPE_FPOPERATION_MODE,
                }
            },
            {0x17c5, "SingleElementVectorINTEL"},
            {0x17c7, "VectorComputeCallableFunctionINTEL"},
            {0x17fc, "MediaBlockIOINTEL"},
            {0x1807, "StallFreeINTEL"},
            {
                0x181a, "FPMaxErrorDecorationINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_FLOAT,
                }
            },
            {
                0x181c, "LatencyControlLabelINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x181d, "LatencyControlConstraintINTEL", 3,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {0x181f, "ConduitKernelArgumentINTEL"},
            {0x1820, "RegisterMapKernelArgumentINTEL"},
            {
                0x1821, "MMHostInterfaceAddressWidthINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x1822, "MMHostInterfaceDataWidthINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x1823, "MMHostInterfaceLatencyINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x1824, "MMHostInterfaceReadWriteModeINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_ACCESS_QUALIFIER,
                }
            },
            {
                0x1825, "MMHostInterfaceMaxBurstINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x1826, "MMHostInterfaceWaitRequestINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {0x1827, "StableKernelArgumentINTEL"},
            {
                0x182c, "HostAccessINTEL", 2,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_HOST_ACCESS_QUALIFIER,
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_STRING,
                }
            },
            {
                0x182e, "InitModeINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_INITIALIZATION_MODE_QUALIFIER,
                }
            },
            {
                0x182f, "ImplementInRegisterMapINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x192a, "CacheControlLoadINTEL", 2,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                    SPIRV_PARSER_OPERAND_TYPE_LOAD_CACHE_CONTROL,
                }
            },
            {
                0x192b, "CacheControlStoreINTEL", 2,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                    SPIRV_PARSER_OPERAND_TYPE_STORE_CACHE_CONTROL,
                }
            },
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_DIM] =
    {
        "Dim", SPIRV_PARSER_OPERAND_CATEGORY_VALUE_ENUM, 8,
        (struct spirv_parser_enumerant[])
        {
            {0, "1D"},
            {0x1, "2D"},
            {0x2, "3D"},
            {0x3, "Cube"},
            {0x4, "Rect"},
            {0x5, "Buffer"},
            {0x6, "SubpassData"},
            {0x104d, "TileImageDataEXT"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_EXECUTION_MODE] =
    {
        "ExecutionMode", SPIRV_PARSER_OPERAND_CATEGORY_VALUE_ENUM, 96,
        (struct spirv_parser_enumerant[])
        {
            {
                0, "Invocations", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {0x1, "SpacingEqual"},
            {0x2, "SpacingFractionalEven"},
            {0x3, "SpacingFractionalOdd"},
            {0x4, "VertexOrderCw"},
            {0x5, "VertexOrderCcw"},
            {0x6, "PixelCenterInteger"},
            {0x7, "OriginUpperLeft"},
            {0x8, "OriginLowerLeft"},
            {0x9, "EarlyFragmentTests"},
            {0xa, "PointMode"},
            {0xb, "Xfb"},
            {0xc, "DepthReplacing"},
            {0xe, "DepthGreater"},
            {0xf, "DepthLess"},
            {0x10, "DepthUnchanged"},
            {
                0x11, "LocalSize", 3,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x12, "LocalSizeHint", 3,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {0x13, "InputPoints"},
            {0x14, "InputLines"},
            {0x15, "InputLinesAdjacency"},
            {0x16, "Triangles"},
            {0x17, "InputTrianglesAdjacency"},
            {0x18, "Quads"},
            {0x19, "Isolines"},
            {
                0x1a, "OutputVertices", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {0x1b, "OutputPoints"},
            {0x1c, "OutputLineStrip"},
            {0x1d, "OutputTriangleStrip"},
            {
                0x1e, "VecTypeHint", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {0x1f, "ContractionOff"},
            {0x21, "Initializer"},
            {0x22, "Finalizer"},
            {
                0x23, "SubgroupSize", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x24, "SubgroupsPerWorkgroup", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x25, "SubgroupsPerWorkgroupId", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                }
            },
            {
                0x26, "LocalSizeId", 3,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                }
            },
            {
                0x27, "LocalSizeHintId", 3,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                }
            },
            {0x1049, "NonCoherentColorAttachmentReadEXT"},
            {0x104a, "NonCoherentDepthAttachmentReadEXT"},
            {0x104b, "NonCoherentStencilAttachmentReadEXT"},
            {0x1145, "SubgroupUniformControlFlowKHR"},
            {0x115e, "PostDepthCoverage"},
            {
                0x116b, "DenormPreserve", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x116c, "DenormFlushToZero", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x116d, "SignedZeroInfNanPreserve", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x116e, "RoundingModeRTE", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x116f, "RoundingModeRTZ", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {0x1189, "NonCoherentTileAttachmentReadQCOM"},
            {
                0x118a, "TileShadingRateQCOM", 3,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {0x1399, "EarlyAndLateFragmentTestsAMD"},
            {0x13a3, "StencilRefReplacingEXT"},
            {0x13cd, "CoalescingAMDX"},
            {
                0x13ce, "IsApiEntryAMDX", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                }
            },
            {
                0x13cf, "MaxNodeRecursionAMDX", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                }
            },
            {
                0x13d0, "StaticNumWorkgroupsAMDX", 3,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                }
            },
            {
                0x13d1, "ShaderIndexAMDX", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                }
            },
            {
                0x13d5, "MaxNumWorkgroupsAMDX", 3,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                }
            },
            {0x13d7, "StencilRefUnchangedFrontAMD"},
            {0x13d8, "StencilRefGreaterFrontAMD"},
            {0x13d9, "StencilRefLessFrontAMD"},
            {0x13da, "StencilRefUnchangedBackAMD"},
            {0x13db, "StencilRefGreaterBackAMD"},
            {0x13dc, "StencilRefLessBackAMD"},
            {0x13e0, "QuadDerivativesKHR"},
            {0x13e1, "RequireFullQuadsKHR"},
            {
                0x13ee, "SharesInputWithAMDX", 2,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                }
            },
            {0x1495, "OutputLinesEXT"},
            {
                0x1496, "OutputPrimitivesEXT", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {0x14a9, "DerivativeGroupQuadsKHR"},
            {0x14aa, "DerivativeGroupLinearKHR"},
            {0x14b2, "OutputTrianglesEXT"},
            {0x14f6, "PixelInterlockOrderedEXT"},
            {0x14f7, "PixelInterlockUnorderedEXT"},
            {0x14f8, "SampleInterlockOrderedEXT"},
            {0x14f9, "SampleInterlockUnorderedEXT"},
            {0x14fa, "ShadingRateInterlockOrderedEXT"},
            {0x14fb, "ShadingRateInterlockUnorderedEXT"},
            {
                0x15f2, "SharedLocalMemorySizeINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x15f4, "RoundingModeRTPINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x15f5, "RoundingModeRTNINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x15f6, "FloatingPointModeALTINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x15f7, "FloatingPointModeIEEEINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x1705, "MaxWorkgroupSizeINTEL", 3,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x1706, "MaxWorkDimINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {0x1707, "NoGlobalOffsetINTEL"},
            {
                0x1708, "NumSIMDWorkitemsINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x170f, "SchedulerTargetFmaxMhzINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {0x1787, "MaximallyReconvergesKHR"},
            {
                0x178c, "FPFastMathDefault", 2,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                }
            },
            {
                0x180a, "StreamingInterfaceINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x1810, "RegisterMapInterfaceINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x1911, "NamedBarrierCountINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x193d, "MaximumRegistersINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x193e, "MaximumRegistersIdINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                }
            },
            {
                0x193f, "NamedMaximumRegistersINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_NAMED_MAXIMUM_NUMBER_OF_REGISTERS,
                }
            },
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_EXECUTION_MODEL] =
    {
        "ExecutionModel", SPIRV_PARSER_OPERAND_CATEGORY_VALUE_ENUM, 17,
        (struct spirv_parser_enumerant[])
        {
            {0, "Vertex"},
            {0x1, "TessellationControl"},
            {0x2, "TessellationEvaluation"},
            {0x3, "Geometry"},
            {0x4, "Fragment"},
            {0x5, "GLCompute"},
            {0x6, "Kernel"},
            {0x1493, "TaskNV"},
            {0x1494, "MeshNV"},
            {0x14c1, "RayGenerationKHR"},
            {0x14c2, "IntersectionKHR"},
            {0x14c3, "AnyHitKHR"},
            {0x14c4, "ClosestHitKHR"},
            {0x14c5, "MissKHR"},
            {0x14c6, "CallableKHR"},
            {0x14f4, "TaskEXT"},
            {0x14f5, "MeshEXT"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_FPDENORM_MODE] =
    {
        "FPDenormMode", SPIRV_PARSER_OPERAND_CATEGORY_VALUE_ENUM, 2,
        (struct spirv_parser_enumerant[])
        {
            {0, "Preserve"},
            {0x1, "FlushToZero"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_FPENCODING] =
    {
        "FPEncoding", SPIRV_PARSER_OPERAND_CATEGORY_VALUE_ENUM, 1,
        (struct spirv_parser_enumerant[])
        {
            {0, "BFloat16KHR"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_FPFAST_MATH_MODE] =
    {
        "FPFastMathMode", SPIRV_PARSER_OPERAND_CATEGORY_BIT_ENUM, 9,
        (struct spirv_parser_enumerant[])
        {
            {0, "None"},
            {0x1, "NotNaN"},
            {0x2, "NotInf"},
            {0x4, "NSZ"},
            {0x8, "AllowRecip"},
            {0x10, "Fast"},
            {0x10000, "AllowContract"},
            {0x20000, "AllowReassoc"},
            {0x40000, "AllowTransform"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_FPOPERATION_MODE] =
    {
        "FPOperationMode", SPIRV_PARSER_OPERAND_CATEGORY_VALUE_ENUM, 2,
        (struct spirv_parser_enumerant[])
        {
            {0, "IEEE"},
            {0x1, "ALT"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_FPROUNDING_MODE] =
    {
        "FPRoundingMode", SPIRV_PARSER_OPERAND_CATEGORY_VALUE_ENUM, 4,
        (struct spirv_parser_enumerant[])
        {
            {0, "RTE"},
            {0x1, "RTZ"},
            {0x2, "RTP"},
            {0x3, "RTN"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_FRAGMENT_SHADING_RATE] =
    {
        "FragmentShadingRate", SPIRV_PARSER_OPERAND_CATEGORY_BIT_ENUM, 4,
        (struct spirv_parser_enumerant[])
        {
            {0x1, "Vertical2Pixels"},
            {0x2, "Vertical4Pixels"},
            {0x4, "Horizontal2Pixels"},
            {0x8, "Horizontal4Pixels"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_FUNCTION_CONTROL] =
    {
        "FunctionControl", SPIRV_PARSER_OPERAND_CATEGORY_BIT_ENUM, 6,
        (struct spirv_parser_enumerant[])
        {
            {0, "None"},
            {0x1, "Inline"},
            {0x2, "DontInline"},
            {0x4, "Pure"},
            {0x8, "Const"},
            {0x10000, "OptNoneEXT"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_FUNCTION_PARAMETER_ATTRIBUTE] =
    {
        "FunctionParameterAttribute", SPIRV_PARSER_OPERAND_CATEGORY_VALUE_ENUM, 9,
        (struct spirv_parser_enumerant[])
        {
            {0, "Zext"},
            {0x1, "Sext"},
            {0x2, "ByVal"},
            {0x3, "Sret"},
            {0x4, "NoAlias"},
            {0x5, "NoCapture"},
            {0x6, "NoWrite"},
            {0x7, "NoReadWrite"},
            {0x1734, "RuntimeAlignedINTEL"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_GROUP_OPERATION] =
    {
        "GroupOperation", SPIRV_PARSER_OPERAND_CATEGORY_VALUE_ENUM, 7,
        (struct spirv_parser_enumerant[])
        {
            {0, "Reduce"},
            {0x1, "InclusiveScan"},
            {0x2, "ExclusiveScan"},
            {0x3, "ClusteredReduce"},
            {0x6, "PartitionedReduceNV"},
            {0x7, "PartitionedInclusiveScanNV"},
            {0x8, "PartitionedExclusiveScanNV"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_HOST_ACCESS_QUALIFIER] =
    {
        "HostAccessQualifier", SPIRV_PARSER_OPERAND_CATEGORY_VALUE_ENUM, 4,
        (struct spirv_parser_enumerant[])
        {
            {0, "NoneINTEL"},
            {0x1, "ReadINTEL"},
            {0x2, "WriteINTEL"},
            {0x3, "ReadWriteINTEL"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_ID_MEMORY_SEMANTICS] =
    {
        "IdMemorySemantics", SPIRV_PARSER_OPERAND_CATEGORY_ID
    },
    [SPIRV_PARSER_OPERAND_TYPE_ID_REF] =
    {
        "IdRef", SPIRV_PARSER_OPERAND_CATEGORY_ID
    },
    [SPIRV_PARSER_OPERAND_TYPE_ID_RESULT] =
    {
        "IdResult", SPIRV_PARSER_OPERAND_CATEGORY_ID
    },
    [SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE] =
    {
        "IdResultType", SPIRV_PARSER_OPERAND_CATEGORY_ID
    },
    [SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE] =
    {
        "IdScope", SPIRV_PARSER_OPERAND_CATEGORY_ID
    },
    [SPIRV_PARSER_OPERAND_TYPE_IMAGE_CHANNEL_DATA_TYPE] =
    {
        "ImageChannelDataType", SPIRV_PARSER_OPERAND_CATEGORY_VALUE_ENUM, 26,
        (struct spirv_parser_enumerant[])
        {
            {0, "SnormInt8"},
            {0x1, "SnormInt16"},
            {0x2, "UnormInt8"},
            {0x3, "UnormInt16"},
            {0x4, "UnormShort565"},
            {0x5, "UnormShort555"},
            {0x6, "UnormInt101010"},
            {0x7, "SignedInt8"},
            {0x8, "SignedInt16"},
            {0x9, "SignedInt32"},
            {0xa, "UnsignedInt8"},
            {0xb, "UnsignedInt16"},
            {0xc, "UnsignedInt32"},
            {0xd, "HalfFloat"},
            {0xe, "Float"},
            {0xf, "UnormInt24"},
            {0x10, "UnormInt101010_2"},
            {0x11, "UnormInt10X6EXT"},
            {0x13, "UnsignedIntRaw10EXT"},
            {0x14, "UnsignedIntRaw12EXT"},
            {0x15, "UnormInt2_101010EXT"},
            {0x16, "UnsignedInt10X6EXT"},
            {0x17, "UnsignedInt12X4EXT"},
            {0x18, "UnsignedInt14X2EXT"},
            {0x19, "UnormInt12X4EXT"},
            {0x1a, "UnormInt14X2EXT"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_IMAGE_CHANNEL_ORDER] =
    {
        "ImageChannelOrder", SPIRV_PARSER_OPERAND_CATEGORY_VALUE_ENUM, 20,
        (struct spirv_parser_enumerant[])
        {
            {0, "R"},
            {0x1, "A"},
            {0x2, "RG"},
            {0x3, "RA"},
            {0x4, "RGB"},
            {0x5, "RGBA"},
            {0x6, "BGRA"},
            {0x7, "ARGB"},
            {0x8, "Intensity"},
            {0x9, "Luminance"},
            {0xa, "Rx"},
            {0xb, "RGx"},
            {0xc, "RGBx"},
            {0xd, "Depth"},
            {0xe, "DepthStencil"},
            {0xf, "sRGB"},
            {0x10, "sRGBx"},
            {0x11, "sRGBA"},
            {0x12, "sBGRA"},
            {0x13, "ABGR"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_IMAGE_FORMAT] =
    {
        "ImageFormat", SPIRV_PARSER_OPERAND_CATEGORY_VALUE_ENUM, 42,
        (struct spirv_parser_enumerant[])
        {
            {0, "Unknown"},
            {0x1, "Rgba32f"},
            {0x2, "Rgba16f"},
            {0x3, "R32f"},
            {0x4, "Rgba8"},
            {0x5, "Rgba8Snorm"},
            {0x6, "Rg32f"},
            {0x7, "Rg16f"},
            {0x8, "R11fG11fB10f"},
            {0x9, "R16f"},
            {0xa, "Rgba16"},
            {0xb, "Rgb10A2"},
            {0xc, "Rg16"},
            {0xd, "Rg8"},
            {0xe, "R16"},
            {0xf, "R8"},
            {0x10, "Rgba16Snorm"},
            {0x11, "Rg16Snorm"},
            {0x12, "Rg8Snorm"},
            {0x13, "R16Snorm"},
            {0x14, "R8Snorm"},
            {0x15, "Rgba32i"},
            {0x16, "Rgba16i"},
            {0x17, "Rgba8i"},
            {0x18, "R32i"},
            {0x19, "Rg32i"},
            {0x1a, "Rg16i"},
            {0x1b, "Rg8i"},
            {0x1c, "R16i"},
            {0x1d, "R8i"},
            {0x1e, "Rgba32ui"},
            {0x1f, "Rgba16ui"},
            {0x20, "Rgba8ui"},
            {0x21, "R32ui"},
            {0x22, "Rgb10a2ui"},
            {0x23, "Rg32ui"},
            {0x24, "Rg16ui"},
            {0x25, "Rg8ui"},
            {0x26, "R16ui"},
            {0x27, "R8ui"},
            {0x28, "R64ui"},
            {0x29, "R64i"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_IMAGE_OPERANDS] =
    {
        "ImageOperands", SPIRV_PARSER_OPERAND_CATEGORY_BIT_ENUM, 17,
        (struct spirv_parser_enumerant[])
        {
            {0, "None"},
            {
                0x1, "Bias", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                }
            },
            {
                0x2, "Lod", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                }
            },
            {
                0x4, "Grad", 2,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                }
            },
            {
                0x8, "ConstOffset", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                }
            },
            {
                0x10, "Offset", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                }
            },
            {
                0x20, "ConstOffsets", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                }
            },
            {
                0x40, "Sample", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                }
            },
            {
                0x80, "MinLod", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                }
            },
            {
                0x100, "MakeTexelAvailable", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE,
                }
            },
            {
                0x200, "MakeTexelVisible", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE,
                }
            },
            {0x400, "NonPrivateTexel"},
            {0x800, "VolatileTexel"},
            {0x1000, "SignExtend"},
            {0x2000, "ZeroExtend"},
            {0x4000, "Nontemporal"},
            {
                0x10000, "Offsets", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                }
            },
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_INITIALIZATION_MODE_QUALIFIER] =
    {
        "InitializationModeQualifier", SPIRV_PARSER_OPERAND_CATEGORY_VALUE_ENUM, 2,
        (struct spirv_parser_enumerant[])
        {
            {0, "InitOnDeviceReprogramINTEL"},
            {0x1, "InitOnDeviceResetINTEL"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_KERNEL_ENQUEUE_FLAGS] =
    {
        "KernelEnqueueFlags", SPIRV_PARSER_OPERAND_CATEGORY_VALUE_ENUM, 3,
        (struct spirv_parser_enumerant[])
        {
            {0, "NoWait"},
            {0x1, "WaitKernel"},
            {0x2, "WaitWorkGroup"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_KERNEL_PROFILING_INFO] =
    {
        "KernelProfilingInfo", SPIRV_PARSER_OPERAND_CATEGORY_BIT_ENUM, 2,
        (struct spirv_parser_enumerant[])
        {
            {0, "None"},
            {0x1, "CmdExecTime"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_LINKAGE_TYPE] =
    {
        "LinkageType", SPIRV_PARSER_OPERAND_CATEGORY_VALUE_ENUM, 3,
        (struct spirv_parser_enumerant[])
        {
            {0, "Export"},
            {0x1, "Import"},
            {0x2, "LinkOnceODR"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_LITERAL_CONTEXT_DEPENDENT_NUMBER] =
    {
        "LiteralContextDependentNumber", SPIRV_PARSER_OPERAND_CATEGORY_LITERAL
    },
    [SPIRV_PARSER_OPERAND_TYPE_LITERAL_EXT_INST_INTEGER] =
    {
        "LiteralExtInstInteger", SPIRV_PARSER_OPERAND_CATEGORY_LITERAL
    },
    [SPIRV_PARSER_OPERAND_TYPE_LITERAL_FLOAT] =
    {
        "LiteralFloat", SPIRV_PARSER_OPERAND_CATEGORY_LITERAL
    },
    [SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER] =
    {
        "LiteralInteger", SPIRV_PARSER_OPERAND_CATEGORY_LITERAL
    },
    [SPIRV_PARSER_OPERAND_TYPE_LITERAL_SPEC_CONSTANT_OP_INTEGER] =
    {
        "LiteralSpecConstantOpInteger", SPIRV_PARSER_OPERAND_CATEGORY_LITERAL
    },
    [SPIRV_PARSER_OPERAND_TYPE_LITERAL_STRING] =
    {
        "LiteralString", SPIRV_PARSER_OPERAND_CATEGORY_LITERAL
    },
    [SPIRV_PARSER_OPERAND_TYPE_LOAD_CACHE_CONTROL] =
    {
        "LoadCacheControl", SPIRV_PARSER_OPERAND_CATEGORY_VALUE_ENUM, 5,
        (struct spirv_parser_enumerant[])
        {
            {0, "UncachedINTEL"},
            {0x1, "CachedINTEL"},
            {0x2, "StreamingINTEL"},
            {0x3, "InvalidateAfterReadINTEL"},
            {0x4, "ConstCachedINTEL"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_LOOP_CONTROL] =
    {
        "LoopControl", SPIRV_PARSER_OPERAND_CATEGORY_BIT_ENUM, 20,
        (struct spirv_parser_enumerant[])
        {
            {0, "None"},
            {0x1, "Unroll"},
            {0x2, "DontUnroll"},
            {0x4, "DependencyInfinite"},
            {
                0x8, "DependencyLength", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x10, "MinIterations", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x20, "MaxIterations", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x40, "IterationMultiple", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x80, "PeelCount", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x100, "PartialCount", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x10000, "InitiationIntervalINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x20000, "MaxConcurrencyINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x40000, "DependencyArrayINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x80000, "PipelineEnableINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x100000, "LoopCoalesceINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x200000, "MaxInterleavingINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x400000, "SpeculatedIterationsINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {0x800000, "NoFusionINTEL"},
            {
                0x1000000, "LoopCountINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {
                0x2000000, "MaxReinvocationDelayINTEL", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_MATRIX_MULTIPLY_ACCUMULATE_OPERANDS] =
    {
        "MatrixMultiplyAccumulateOperands", SPIRV_PARSER_OPERAND_CATEGORY_BIT_ENUM, 15,
        (struct spirv_parser_enumerant[])
        {
            {0, "None"},
            {0x1, "MatrixASignedComponentsINTEL"},
            {0x2, "MatrixBSignedComponentsINTEL"},
            {0x4, "MatrixCBFloat16INTEL"},
            {0x8, "MatrixResultBFloat16INTEL"},
            {0x10, "MatrixAPackedInt8INTEL"},
            {0x20, "MatrixBPackedInt8INTEL"},
            {0x40, "MatrixAPackedInt4INTEL"},
            {0x80, "MatrixBPackedInt4INTEL"},
            {0x100, "MatrixATF32INTEL"},
            {0x200, "MatrixBTF32INTEL"},
            {0x400, "MatrixAPackedFloat16INTEL"},
            {0x800, "MatrixBPackedFloat16INTEL"},
            {0x1000, "MatrixAPackedBFloat16INTEL"},
            {0x2000, "MatrixBPackedBFloat16INTEL"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_MEMORY_ACCESS] =
    {
        "MemoryAccess", SPIRV_PARSER_OPERAND_CATEGORY_BIT_ENUM, 9,
        (struct spirv_parser_enumerant[])
        {
            {0, "None"},
            {0x1, "Volatile"},
            {
                0x2, "Aligned", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER,
                }
            },
            {0x4, "Nontemporal"},
            {
                0x8, "MakePointerAvailable", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE,
                }
            },
            {
                0x10, "MakePointerVisible", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE,
                }
            },
            {0x20, "NonPrivatePointer"},
            {
                0x10000, "AliasScopeINTELMask", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                }
            },
            {
                0x20000, "NoAliasINTELMask", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                }
            },
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_MEMORY_MODEL] =
    {
        "MemoryModel", SPIRV_PARSER_OPERAND_CATEGORY_VALUE_ENUM, 4,
        (struct spirv_parser_enumerant[])
        {
            {0, "Simple"},
            {0x1, "GLSL450"},
            {0x2, "OpenCL"},
            {0x3, "Vulkan"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_MEMORY_SEMANTICS] =
    {
        "MemorySemantics", SPIRV_PARSER_OPERAND_CATEGORY_BIT_ENUM, 15,
        (struct spirv_parser_enumerant[])
        {
            {0, "Relaxed"},
            {0x2, "Acquire"},
            {0x4, "Release"},
            {0x8, "AcquireRelease"},
            {0x10, "SequentiallyConsistent"},
            {0x40, "UniformMemory"},
            {0x80, "SubgroupMemory"},
            {0x100, "WorkgroupMemory"},
            {0x200, "CrossWorkgroupMemory"},
            {0x400, "AtomicCounterMemory"},
            {0x800, "ImageMemory"},
            {0x1000, "OutputMemory"},
            {0x2000, "MakeAvailable"},
            {0x4000, "MakeVisible"},
            {0x8000, "Volatile"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_NAMED_MAXIMUM_NUMBER_OF_REGISTERS] =
    {
        "NamedMaximumNumberOfRegisters", SPIRV_PARSER_OPERAND_CATEGORY_VALUE_ENUM, 1,
        (struct spirv_parser_enumerant[])
        {
            {0, "AutoINTEL"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_OVERFLOW_MODES] =
    {
        "OverflowModes", SPIRV_PARSER_OPERAND_CATEGORY_VALUE_ENUM, 4,
        (struct spirv_parser_enumerant[])
        {
            {0, "WRAP"},
            {0x1, "SAT"},
            {0x2, "SAT_ZERO"},
            {0x3, "SAT_SYM"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_PACKED_VECTOR_FORMAT] =
    {
        "PackedVectorFormat", SPIRV_PARSER_OPERAND_CATEGORY_VALUE_ENUM, 1,
        (struct spirv_parser_enumerant[])
        {
            {0, "PackedVectorFormat4x8Bit"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_PAIR_ID_REF_ID_REF] =
    {
        "PairIdRefIdRef", SPIRV_PARSER_OPERAND_CATEGORY_COMPOSITE
    },
    [SPIRV_PARSER_OPERAND_TYPE_PAIR_ID_REF_LITERAL_INTEGER] =
    {
        "PairIdRefLiteralInteger", SPIRV_PARSER_OPERAND_CATEGORY_COMPOSITE
    },
    [SPIRV_PARSER_OPERAND_TYPE_PAIR_LITERAL_INTEGER_ID_REF] =
    {
        "PairLiteralIntegerIdRef", SPIRV_PARSER_OPERAND_CATEGORY_COMPOSITE
    },
    [SPIRV_PARSER_OPERAND_TYPE_QUANTIZATION_MODES] =
    {
        "QuantizationModes", SPIRV_PARSER_OPERAND_CATEGORY_VALUE_ENUM, 8,
        (struct spirv_parser_enumerant[])
        {
            {0, "TRN"},
            {0x1, "TRN_ZERO"},
            {0x2, "RND"},
            {0x3, "RND_ZERO"},
            {0x4, "RND_INF"},
            {0x5, "RND_MIN_INF"},
            {0x6, "RND_CONV"},
            {0x7, "RND_CONV_ODD"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_RAW_ACCESS_CHAIN_OPERANDS] =
    {
        "RawAccessChainOperands", SPIRV_PARSER_OPERAND_CATEGORY_BIT_ENUM, 3,
        (struct spirv_parser_enumerant[])
        {
            {0, "None"},
            {0x1, "RobustnessPerComponentNV"},
            {0x2, "RobustnessPerElementNV"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_RAY_FLAGS] =
    {
        "RayFlags", SPIRV_PARSER_OPERAND_CATEGORY_BIT_ENUM, 12,
        (struct spirv_parser_enumerant[])
        {
            {0, "NoneKHR"},
            {0x1, "OpaqueKHR"},
            {0x2, "NoOpaqueKHR"},
            {0x4, "TerminateOnFirstHitKHR"},
            {0x8, "SkipClosestHitShaderKHR"},
            {0x10, "CullBackFacingTrianglesKHR"},
            {0x20, "CullFrontFacingTrianglesKHR"},
            {0x40, "CullOpaqueKHR"},
            {0x80, "CullNoOpaqueKHR"},
            {0x100, "SkipTrianglesKHR"},
            {0x200, "SkipAABBsKHR"},
            {0x400, "ForceOpacityMicromap2StateEXT"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_RAY_QUERY_CANDIDATE_INTERSECTION_TYPE] =
    {
        "RayQueryCandidateIntersectionType", SPIRV_PARSER_OPERAND_CATEGORY_VALUE_ENUM, 2,
        (struct spirv_parser_enumerant[])
        {
            {0, "RayQueryCandidateIntersectionTriangleKHR"},
            {0x1, "RayQueryCandidateIntersectionAABBKHR"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_RAY_QUERY_COMMITTED_INTERSECTION_TYPE] =
    {
        "RayQueryCommittedIntersectionType", SPIRV_PARSER_OPERAND_CATEGORY_VALUE_ENUM, 3,
        (struct spirv_parser_enumerant[])
        {
            {0, "RayQueryCommittedIntersectionNoneKHR"},
            {0x1, "RayQueryCommittedIntersectionTriangleKHR"},
            {0x2, "RayQueryCommittedIntersectionGeneratedKHR"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_RAY_QUERY_INTERSECTION] =
    {
        "RayQueryIntersection", SPIRV_PARSER_OPERAND_CATEGORY_VALUE_ENUM, 2,
        (struct spirv_parser_enumerant[])
        {
            {0, "RayQueryCandidateIntersectionKHR"},
            {0x1, "RayQueryCommittedIntersectionKHR"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_SAMPLER_ADDRESSING_MODE] =
    {
        "SamplerAddressingMode", SPIRV_PARSER_OPERAND_CATEGORY_VALUE_ENUM, 5,
        (struct spirv_parser_enumerant[])
        {
            {0, "None"},
            {0x1, "ClampToEdge"},
            {0x2, "Clamp"},
            {0x3, "Repeat"},
            {0x4, "RepeatMirrored"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_SAMPLER_FILTER_MODE] =
    {
        "SamplerFilterMode", SPIRV_PARSER_OPERAND_CATEGORY_VALUE_ENUM, 2,
        (struct spirv_parser_enumerant[])
        {
            {0, "Nearest"},
            {0x1, "Linear"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_SCOPE] =
    {
        "Scope", SPIRV_PARSER_OPERAND_CATEGORY_VALUE_ENUM, 7,
        (struct spirv_parser_enumerant[])
        {
            {0, "CrossDevice"},
            {0x1, "Device"},
            {0x2, "Workgroup"},
            {0x3, "Subgroup"},
            {0x4, "Invocation"},
            {0x5, "QueueFamily"},
            {0x6, "ShaderCallKHR"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_SELECTION_CONTROL] =
    {
        "SelectionControl", SPIRV_PARSER_OPERAND_CATEGORY_BIT_ENUM, 3,
        (struct spirv_parser_enumerant[])
        {
            {0, "None"},
            {0x1, "Flatten"},
            {0x2, "DontFlatten"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_SOURCE_LANGUAGE] =
    {
        "SourceLanguage", SPIRV_PARSER_OPERAND_CATEGORY_VALUE_ENUM, 14,
        (struct spirv_parser_enumerant[])
        {
            {0, "Unknown"},
            {0x1, "ESSL"},
            {0x2, "GLSL"},
            {0x3, "OpenCL_C"},
            {0x4, "OpenCL_CPP"},
            {0x5, "HLSL"},
            {0x6, "CPP_for_OpenCL"},
            {0x7, "SYCL"},
            {0x8, "HERO_C"},
            {0x9, "NZSL"},
            {0xa, "WGSL"},
            {0xb, "Slang"},
            {0xc, "Zig"},
            {0xd, "Rust"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_STORAGE_CLASS] =
    {
        "StorageClass", SPIRV_PARSER_OPERAND_CATEGORY_VALUE_ENUM, 28,
        (struct spirv_parser_enumerant[])
        {
            {0, "UniformConstant"},
            {0x1, "Input"},
            {0x2, "Uniform"},
            {0x3, "Output"},
            {0x4, "Workgroup"},
            {0x5, "CrossWorkgroup"},
            {0x6, "Private"},
            {0x7, "Function"},
            {0x8, "Generic"},
            {0x9, "PushConstant"},
            {0xa, "AtomicCounter"},
            {0xb, "Image"},
            {0xc, "StorageBuffer"},
            {0x104c, "TileImageEXT"},
            {0x118b, "TileAttachmentQCOM"},
            {0x13cc, "NodePayloadAMDX"},
            {0x14d0, "CallableDataKHR"},
            {0x14d1, "IncomingCallableDataKHR"},
            {0x14da, "RayPayloadKHR"},
            {0x14db, "HitAttributeKHR"},
            {0x14de, "IncomingRayPayloadKHR"},
            {0x14df, "ShaderRecordBufferKHR"},
            {0x14e5, "PhysicalStorageBuffer"},
            {0x1509, "HitObjectAttributeNV"},
            {0x151a, "TaskPayloadWorkgroupEXT"},
            {0x15e5, "CodeSectionINTEL"},
            {0x1730, "DeviceOnlyINTEL"},
            {0x1731, "HostOnlyINTEL"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_STORE_CACHE_CONTROL] =
    {
        "StoreCacheControl", SPIRV_PARSER_OPERAND_CATEGORY_VALUE_ENUM, 4,
        (struct spirv_parser_enumerant[])
        {
            {0, "UncachedINTEL"},
            {0x1, "WriteThroughINTEL"},
            {0x2, "WriteBackINTEL"},
            {0x3, "StreamingINTEL"},
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_TENSOR_ADDRESSING_OPERANDS] =
    {
        "TensorAddressingOperands", SPIRV_PARSER_OPERAND_CATEGORY_BIT_ENUM, 3,
        (struct spirv_parser_enumerant[])
        {
            {0, "None"},
            {
                0x1, "TensorView", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                }
            },
            {
                0x2, "DecodeFunc", 1,
                (enum spirv_parser_operand_type[])
                {
                    SPIRV_PARSER_OPERAND_TYPE_ID_REF,
                }
            },
        }
    },
    [SPIRV_PARSER_OPERAND_TYPE_TENSOR_CLAMP_MODE] =
    {
        "TensorClampMode", SPIRV_PARSER_OPERAND_CATEGORY_VALUE_ENUM, 5,
        (struct spirv_parser_enumerant[])
        {
            {0, "Undefined"},
            {0x1, "Constant"},
            {0x2, "ClampToEdge"},
            {0x3, "Repeat"},
            {0x4, "RepeatMirrored"},
        }
    },
};

static const struct spirv_parser_opcode_info
{
    uint16_t op;
    const char *name;
    size_t operand_count;
    const struct spirv_parser_instruction_operand
    {
        enum spirv_parser_operand_type type;
        char quantifier;
    } *operands;
}
spirv_parser_opcode_info[] =
{
    {0x0000, "OpNop"},
    {
        0x0001, "OpUndef", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x0002, "OpSourceContinued", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_STRING},
        }
    },
    {
        0x0003, "OpSource", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_SOURCE_LANGUAGE},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '?'},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_STRING, '?'},
        }
    },
    {
        0x0004, "OpSourceExtension", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_STRING},
        }
    },
    {
        0x0005, "OpName", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_STRING},
        }
    },
    {
        0x0006, "OpMemberName", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_STRING},
        }
    },
    {
        0x0007, "OpString", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_STRING},
        }
    },
    {
        0x0008, "OpLine", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x000a, "OpExtension", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_STRING},
        }
    },
    {
        0x000b, "OpExtInstImport", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_STRING},
        }
    },
    {
        0x000c, "OpExtInst", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_EXT_INST_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '*'},
        }
    },
    {
        0x000e, "OpMemoryModel", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ADDRESSING_MODEL},
            {SPIRV_PARSER_OPERAND_TYPE_MEMORY_MODEL},
        }
    },
    {
        0x000f, "OpEntryPoint", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_EXECUTION_MODEL},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_STRING},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '*'},
        }
    },
    {
        0x0010, "OpExecutionMode", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_EXECUTION_MODE},
        }
    },
    {
        0x0011, "OpCapability", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_CAPABILITY},
        }
    },
    {
        0x0013, "OpTypeVoid", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x0014, "OpTypeBool", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x0015, "OpTypeInt", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x0016, "OpTypeFloat", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_FPENCODING, '?'},
        }
    },
    {
        0x0017, "OpTypeVector", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x0018, "OpTypeMatrix", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x0019, "OpTypeImage", 9,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_DIM},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_IMAGE_FORMAT},
            {SPIRV_PARSER_OPERAND_TYPE_ACCESS_QUALIFIER, '?'},
        }
    },
    {
        0x001a, "OpTypeSampler", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x001b, "OpTypeSampledImage", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x001c, "OpTypeArray", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x001d, "OpTypeRuntimeArray", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x001e, "OpTypeStruct", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '*'},
        }
    },
    {
        0x001f, "OpTypeOpaque", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_STRING},
        }
    },
    {
        0x0020, "OpTypePointer", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_STORAGE_CLASS},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0021, "OpTypeFunction", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '*'},
        }
    },
    {
        0x0022, "OpTypeEvent", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x0023, "OpTypeDeviceEvent", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x0024, "OpTypeReserveId", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x0025, "OpTypeQueue", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x0026, "OpTypePipe", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ACCESS_QUALIFIER},
        }
    },
    {
        0x0027, "OpTypeForwardPointer", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_STORAGE_CLASS},
        }
    },
    {
        0x0029, "OpConstantTrue", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x002a, "OpConstantFalse", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x002b, "OpConstant", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_CONTEXT_DEPENDENT_NUMBER},
        }
    },
    {
        0x002c, "OpConstantComposite", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '*'},
        }
    },
    {
        0x002d, "OpConstantSampler", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_SAMPLER_ADDRESSING_MODE},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_SAMPLER_FILTER_MODE},
        }
    },
    {
        0x002e, "OpConstantNull", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x0030, "OpSpecConstantTrue", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x0031, "OpSpecConstantFalse", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x0032, "OpSpecConstant", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_CONTEXT_DEPENDENT_NUMBER},
        }
    },
    {
        0x0033, "OpSpecConstantComposite", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '*'},
        }
    },
    {
        0x0034, "OpSpecConstantOp", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_SPEC_CONSTANT_OP_INTEGER},
        }
    },
    {
        0x0036, "OpFunction", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_FUNCTION_CONTROL},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0037, "OpFunctionParameter", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {0x0038, "OpFunctionEnd"},
    {
        0x0039, "OpFunctionCall", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '*'},
        }
    },
    {
        0x003b, "OpVariable", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_STORAGE_CLASS},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '?'},
        }
    },
    {
        0x003c, "OpImageTexelPointer", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x003d, "OpLoad", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_MEMORY_ACCESS, '?'},
        }
    },
    {
        0x003e, "OpStore", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_MEMORY_ACCESS, '?'},
        }
    },
    {
        0x003f, "OpCopyMemory", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_MEMORY_ACCESS, '?'},
            {SPIRV_PARSER_OPERAND_TYPE_MEMORY_ACCESS, '?'},
        }
    },
    {
        0x0040, "OpCopyMemorySized", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_MEMORY_ACCESS, '?'},
            {SPIRV_PARSER_OPERAND_TYPE_MEMORY_ACCESS, '?'},
        }
    },
    {
        0x0041, "OpAccessChain", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '*'},
        }
    },
    {
        0x0042, "OpInBoundsAccessChain", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '*'},
        }
    },
    {
        0x0043, "OpPtrAccessChain", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '*'},
        }
    },
    {
        0x0044, "OpArrayLength", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x0045, "OpGenericPtrMemSemantics", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0046, "OpInBoundsPtrAccessChain", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '*'},
        }
    },
    {
        0x0047, "OpDecorate", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_DECORATION},
        }
    },
    {
        0x0048, "OpMemberDecorate", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_DECORATION},
        }
    },
    {
        0x0049, "OpDecorationGroup", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x004a, "OpGroupDecorate", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '*'},
        }
    },
    {
        0x004b, "OpGroupMemberDecorate", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_PAIR_ID_REF_LITERAL_INTEGER, '*'},
        }
    },
    {
        0x004d, "OpVectorExtractDynamic", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x004e, "OpVectorInsertDynamic", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x004f, "OpVectorShuffle", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER, '*'},
        }
    },
    {
        0x0050, "OpCompositeConstruct", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '*'},
        }
    },
    {
        0x0051, "OpCompositeExtract", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER, '*'},
        }
    },
    {
        0x0052, "OpCompositeInsert", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER, '*'},
        }
    },
    {
        0x0053, "OpCopyObject", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0054, "OpTranspose", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0056, "OpSampledImage", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0057, "OpImageSampleImplicitLod", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_IMAGE_OPERANDS, '?'},
        }
    },
    {
        0x0058, "OpImageSampleExplicitLod", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_IMAGE_OPERANDS},
        }
    },
    {
        0x0059, "OpImageSampleDrefImplicitLod", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_IMAGE_OPERANDS, '?'},
        }
    },
    {
        0x005a, "OpImageSampleDrefExplicitLod", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_IMAGE_OPERANDS},
        }
    },
    {
        0x005b, "OpImageSampleProjImplicitLod", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_IMAGE_OPERANDS, '?'},
        }
    },
    {
        0x005c, "OpImageSampleProjExplicitLod", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_IMAGE_OPERANDS},
        }
    },
    {
        0x005d, "OpImageSampleProjDrefImplicitLod", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_IMAGE_OPERANDS, '?'},
        }
    },
    {
        0x005e, "OpImageSampleProjDrefExplicitLod", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_IMAGE_OPERANDS},
        }
    },
    {
        0x005f, "OpImageFetch", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_IMAGE_OPERANDS, '?'},
        }
    },
    {
        0x0060, "OpImageGather", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_IMAGE_OPERANDS, '?'},
        }
    },
    {
        0x0061, "OpImageDrefGather", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_IMAGE_OPERANDS, '?'},
        }
    },
    {
        0x0062, "OpImageRead", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_IMAGE_OPERANDS, '?'},
        }
    },
    {
        0x0063, "OpImageWrite", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_IMAGE_OPERANDS, '?'},
        }
    },
    {
        0x0064, "OpImage", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0065, "OpImageQueryFormat", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0066, "OpImageQueryOrder", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0067, "OpImageQuerySizeLod", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0068, "OpImageQuerySize", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0069, "OpImageQueryLod", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x006a, "OpImageQueryLevels", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x006b, "OpImageQuerySamples", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x006d, "OpConvertFToU", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x006e, "OpConvertFToS", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x006f, "OpConvertSToF", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0070, "OpConvertUToF", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0071, "OpUConvert", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0072, "OpSConvert", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0073, "OpFConvert", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0074, "OpQuantizeToF16", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0075, "OpConvertPtrToU", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0076, "OpSatConvertSToU", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0077, "OpSatConvertUToS", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0078, "OpConvertUToPtr", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0079, "OpPtrCastToGeneric", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x007a, "OpGenericCastToPtr", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x007b, "OpGenericCastToPtrExplicit", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_STORAGE_CLASS},
        }
    },
    {
        0x007c, "OpBitcast", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x007e, "OpSNegate", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x007f, "OpFNegate", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0080, "OpIAdd", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0081, "OpFAdd", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0082, "OpISub", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0083, "OpFSub", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0084, "OpIMul", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0085, "OpFMul", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0086, "OpUDiv", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0087, "OpSDiv", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0088, "OpFDiv", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0089, "OpUMod", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x008a, "OpSRem", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x008b, "OpSMod", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x008c, "OpFRem", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x008d, "OpFMod", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x008e, "OpVectorTimesScalar", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x008f, "OpMatrixTimesScalar", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0090, "OpVectorTimesMatrix", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0091, "OpMatrixTimesVector", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0092, "OpMatrixTimesMatrix", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0093, "OpOuterProduct", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0094, "OpDot", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0095, "OpIAddCarry", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0096, "OpISubBorrow", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0097, "OpUMulExtended", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0098, "OpSMulExtended", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x009a, "OpAny", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x009b, "OpAll", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x009c, "OpIsNan", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x009d, "OpIsInf", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x009e, "OpIsFinite", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x009f, "OpIsNormal", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00a0, "OpSignBitSet", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00a1, "OpLessOrGreater", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00a2, "OpOrdered", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00a3, "OpUnordered", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00a4, "OpLogicalEqual", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00a5, "OpLogicalNotEqual", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00a6, "OpLogicalOr", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00a7, "OpLogicalAnd", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00a8, "OpLogicalNot", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00a9, "OpSelect", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00aa, "OpIEqual", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00ab, "OpINotEqual", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00ac, "OpUGreaterThan", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00ad, "OpSGreaterThan", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00ae, "OpUGreaterThanEqual", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00af, "OpSGreaterThanEqual", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00b0, "OpULessThan", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00b1, "OpSLessThan", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00b2, "OpULessThanEqual", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00b3, "OpSLessThanEqual", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00b4, "OpFOrdEqual", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00b5, "OpFUnordEqual", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00b6, "OpFOrdNotEqual", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00b7, "OpFUnordNotEqual", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00b8, "OpFOrdLessThan", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00b9, "OpFUnordLessThan", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00ba, "OpFOrdGreaterThan", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00bb, "OpFUnordGreaterThan", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00bc, "OpFOrdLessThanEqual", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00bd, "OpFUnordLessThanEqual", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00be, "OpFOrdGreaterThanEqual", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00bf, "OpFUnordGreaterThanEqual", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00c2, "OpShiftRightLogical", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00c3, "OpShiftRightArithmetic", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00c4, "OpShiftLeftLogical", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00c5, "OpBitwiseOr", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00c6, "OpBitwiseXor", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00c7, "OpBitwiseAnd", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00c8, "OpNot", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00c9, "OpBitFieldInsert", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00ca, "OpBitFieldSExtract", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00cb, "OpBitFieldUExtract", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00cc, "OpBitReverse", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00cd, "OpBitCount", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00cf, "OpDPdx", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00d0, "OpDPdy", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00d1, "OpFwidth", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00d2, "OpDPdxFine", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00d3, "OpDPdyFine", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00d4, "OpFwidthFine", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00d5, "OpDPdxCoarse", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00d6, "OpDPdyCoarse", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00d7, "OpFwidthCoarse", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {0x00da, "OpEmitVertex"},
    {0x00db, "OpEndPrimitive"},
    {
        0x00dc, "OpEmitStreamVertex", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00dd, "OpEndStreamPrimitive", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00e0, "OpControlBarrier", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_MEMORY_SEMANTICS},
        }
    },
    {
        0x00e1, "OpMemoryBarrier", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_MEMORY_SEMANTICS},
        }
    },
    {
        0x00e3, "OpAtomicLoad", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_MEMORY_SEMANTICS},
        }
    },
    {
        0x00e4, "OpAtomicStore", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_MEMORY_SEMANTICS},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00e5, "OpAtomicExchange", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_MEMORY_SEMANTICS},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00e6, "OpAtomicCompareExchange", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_MEMORY_SEMANTICS},
            {SPIRV_PARSER_OPERAND_TYPE_ID_MEMORY_SEMANTICS},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00e7, "OpAtomicCompareExchangeWeak", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_MEMORY_SEMANTICS},
            {SPIRV_PARSER_OPERAND_TYPE_ID_MEMORY_SEMANTICS},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00e8, "OpAtomicIIncrement", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_MEMORY_SEMANTICS},
        }
    },
    {
        0x00e9, "OpAtomicIDecrement", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_MEMORY_SEMANTICS},
        }
    },
    {
        0x00ea, "OpAtomicIAdd", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_MEMORY_SEMANTICS},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00eb, "OpAtomicISub", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_MEMORY_SEMANTICS},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00ec, "OpAtomicSMin", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_MEMORY_SEMANTICS},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00ed, "OpAtomicUMin", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_MEMORY_SEMANTICS},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00ee, "OpAtomicSMax", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_MEMORY_SEMANTICS},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00ef, "OpAtomicUMax", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_MEMORY_SEMANTICS},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00f0, "OpAtomicAnd", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_MEMORY_SEMANTICS},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00f1, "OpAtomicOr", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_MEMORY_SEMANTICS},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00f2, "OpAtomicXor", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_MEMORY_SEMANTICS},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00f5, "OpPhi", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_PAIR_ID_REF_ID_REF, '*'},
        }
    },
    {
        0x00f6, "OpLoopMerge", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LOOP_CONTROL},
        }
    },
    {
        0x00f7, "OpSelectionMerge", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_SELECTION_CONTROL},
        }
    },
    {
        0x00f8, "OpLabel", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x00f9, "OpBranch", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x00fa, "OpBranchConditional", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER, '*'},
        }
    },
    {
        0x00fb, "OpSwitch", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_PAIR_LITERAL_INTEGER_ID_REF, '*'},
        }
    },
    {0x00fc, "OpKill"},
    {0x00fd, "OpReturn"},
    {
        0x00fe, "OpReturnValue", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {0x00ff, "OpUnreachable"},
    {
        0x0100, "OpLifetimeStart", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x0101, "OpLifetimeStop", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x0103, "OpGroupAsyncCopy", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0104, "OpGroupWaitEvents", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0105, "OpGroupAll", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0106, "OpGroupAny", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0107, "OpGroupBroadcast", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0108, "OpGroupIAdd", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_GROUP_OPERATION},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0109, "OpGroupFAdd", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_GROUP_OPERATION},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x010a, "OpGroupFMin", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_GROUP_OPERATION},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x010b, "OpGroupUMin", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_GROUP_OPERATION},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x010c, "OpGroupSMin", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_GROUP_OPERATION},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x010d, "OpGroupFMax", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_GROUP_OPERATION},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x010e, "OpGroupUMax", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_GROUP_OPERATION},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x010f, "OpGroupSMax", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_GROUP_OPERATION},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0112, "OpReadPipe", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0113, "OpWritePipe", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0114, "OpReservedReadPipe", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0115, "OpReservedWritePipe", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0116, "OpReserveReadPipePackets", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0117, "OpReserveWritePipePackets", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0118, "OpCommitReadPipe", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0119, "OpCommitWritePipe", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x011a, "OpIsValidReserveId", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x011b, "OpGetNumPipePackets", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x011c, "OpGetMaxPipePackets", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x011d, "OpGroupReserveReadPipePackets", 7,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x011e, "OpGroupReserveWritePipePackets", 7,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x011f, "OpGroupCommitReadPipe", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0120, "OpGroupCommitWritePipe", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0123, "OpEnqueueMarker", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0124, "OpEnqueueKernel", 13,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '*'},
        }
    },
    {
        0x0125, "OpGetKernelNDrangeSubGroupCount", 7,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0126, "OpGetKernelNDrangeMaxSubGroupSize", 7,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0127, "OpGetKernelWorkGroupSize", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0128, "OpGetKernelPreferredWorkGroupSizeMultiple", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0129, "OpRetainEvent", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x012a, "OpReleaseEvent", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x012b, "OpCreateUserEvent", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x012c, "OpIsValidEvent", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x012d, "OpSetUserEventStatus", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x012e, "OpCaptureEventProfilingInfo", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x012f, "OpGetDefaultQueue", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x0130, "OpBuildNDRange", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0131, "OpImageSparseSampleImplicitLod", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_IMAGE_OPERANDS, '?'},
        }
    },
    {
        0x0132, "OpImageSparseSampleExplicitLod", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_IMAGE_OPERANDS},
        }
    },
    {
        0x0133, "OpImageSparseSampleDrefImplicitLod", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_IMAGE_OPERANDS, '?'},
        }
    },
    {
        0x0134, "OpImageSparseSampleDrefExplicitLod", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_IMAGE_OPERANDS},
        }
    },
    {
        0x0135, "OpImageSparseSampleProjImplicitLod", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_IMAGE_OPERANDS, '?'},
        }
    },
    {
        0x0136, "OpImageSparseSampleProjExplicitLod", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_IMAGE_OPERANDS},
        }
    },
    {
        0x0137, "OpImageSparseSampleProjDrefImplicitLod", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_IMAGE_OPERANDS, '?'},
        }
    },
    {
        0x0138, "OpImageSparseSampleProjDrefExplicitLod", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_IMAGE_OPERANDS},
        }
    },
    {
        0x0139, "OpImageSparseFetch", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_IMAGE_OPERANDS, '?'},
        }
    },
    {
        0x013a, "OpImageSparseGather", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_IMAGE_OPERANDS, '?'},
        }
    },
    {
        0x013b, "OpImageSparseDrefGather", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_IMAGE_OPERANDS, '?'},
        }
    },
    {
        0x013c, "OpImageSparseTexelsResident", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {0x013d, "OpNoLine"},
    {
        0x013e, "OpAtomicFlagTestAndSet", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_MEMORY_SEMANTICS},
        }
    },
    {
        0x013f, "OpAtomicFlagClear", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_MEMORY_SEMANTICS},
        }
    },
    {
        0x0140, "OpImageSparseRead", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_IMAGE_OPERANDS, '?'},
        }
    },
    {
        0x0141, "OpSizeOf", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0142, "OpTypePipeStorage", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x0143, "OpConstantPipeStorage", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x0144, "OpCreatePipeFromPipeStorage", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0145, "OpGetKernelLocalSizeForSubgroupCount", 7,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0146, "OpGetKernelMaxNumSubgroups", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0147, "OpTypeNamedBarrier", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x0148, "OpNamedBarrierInitialize", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0149, "OpMemoryNamedBarrier", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_MEMORY_SEMANTICS},
        }
    },
    {
        0x014a, "OpModuleProcessed", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_STRING},
        }
    },
    {
        0x014b, "OpExecutionModeId", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_EXECUTION_MODE},
        }
    },
    {
        0x014c, "OpDecorateId", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_DECORATION},
        }
    },
    {
        0x014d, "OpGroupNonUniformElect", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
        }
    },
    {
        0x014e, "OpGroupNonUniformAll", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x014f, "OpGroupNonUniformAny", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0150, "OpGroupNonUniformAllEqual", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0151, "OpGroupNonUniformBroadcast", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0152, "OpGroupNonUniformBroadcastFirst", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0153, "OpGroupNonUniformBallot", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0154, "OpGroupNonUniformInverseBallot", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0155, "OpGroupNonUniformBallotBitExtract", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0156, "OpGroupNonUniformBallotBitCount", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_GROUP_OPERATION},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0157, "OpGroupNonUniformBallotFindLSB", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0158, "OpGroupNonUniformBallotFindMSB", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0159, "OpGroupNonUniformShuffle", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x015a, "OpGroupNonUniformShuffleXor", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x015b, "OpGroupNonUniformShuffleUp", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x015c, "OpGroupNonUniformShuffleDown", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x015d, "OpGroupNonUniformIAdd", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_GROUP_OPERATION},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '?'},
        }
    },
    {
        0x015e, "OpGroupNonUniformFAdd", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_GROUP_OPERATION},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '?'},
        }
    },
    {
        0x015f, "OpGroupNonUniformIMul", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_GROUP_OPERATION},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '?'},
        }
    },
    {
        0x0160, "OpGroupNonUniformFMul", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_GROUP_OPERATION},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '?'},
        }
    },
    {
        0x0161, "OpGroupNonUniformSMin", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_GROUP_OPERATION},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '?'},
        }
    },
    {
        0x0162, "OpGroupNonUniformUMin", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_GROUP_OPERATION},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '?'},
        }
    },
    {
        0x0163, "OpGroupNonUniformFMin", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_GROUP_OPERATION},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '?'},
        }
    },
    {
        0x0164, "OpGroupNonUniformSMax", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_GROUP_OPERATION},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '?'},
        }
    },
    {
        0x0165, "OpGroupNonUniformUMax", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_GROUP_OPERATION},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '?'},
        }
    },
    {
        0x0166, "OpGroupNonUniformFMax", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_GROUP_OPERATION},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '?'},
        }
    },
    {
        0x0167, "OpGroupNonUniformBitwiseAnd", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_GROUP_OPERATION},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '?'},
        }
    },
    {
        0x0168, "OpGroupNonUniformBitwiseOr", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_GROUP_OPERATION},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '?'},
        }
    },
    {
        0x0169, "OpGroupNonUniformBitwiseXor", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_GROUP_OPERATION},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '?'},
        }
    },
    {
        0x016a, "OpGroupNonUniformLogicalAnd", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_GROUP_OPERATION},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '?'},
        }
    },
    {
        0x016b, "OpGroupNonUniformLogicalOr", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_GROUP_OPERATION},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '?'},
        }
    },
    {
        0x016c, "OpGroupNonUniformLogicalXor", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_GROUP_OPERATION},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '?'},
        }
    },
    {
        0x016d, "OpGroupNonUniformQuadBroadcast", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x016e, "OpGroupNonUniformQuadSwap", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0190, "OpCopyLogical", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0191, "OpPtrEqual", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0192, "OpPtrNotEqual", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x0193, "OpPtrDiff", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1040, "OpColorAttachmentReadEXT", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '?'},
        }
    },
    {
        0x1041, "OpDepthAttachmentReadEXT", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '?'},
        }
    },
    {
        0x1042, "OpStencilAttachmentReadEXT", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '?'},
        }
    },
    {0x1140, "OpTerminateInvocation"},
    {
        0x1141, "OpTypeUntypedPointerKHR", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_STORAGE_CLASS},
        }
    },
    {
        0x1142, "OpUntypedVariableKHR", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_STORAGE_CLASS},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '?'},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '?'},
        }
    },
    {
        0x1143, "OpUntypedAccessChainKHR", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '*'},
        }
    },
    {
        0x1144, "OpUntypedInBoundsAccessChainKHR", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '*'},
        }
    },
    {
        0x1145, "OpSubgroupBallotKHR", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1146, "OpSubgroupFirstInvocationKHR", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1147, "OpUntypedPtrAccessChainKHR", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '*'},
        }
    },
    {
        0x1148, "OpUntypedInBoundsPtrAccessChainKHR", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '*'},
        }
    },
    {
        0x1149, "OpUntypedArrayLengthKHR", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x114a, "OpUntypedPrefetchKHR", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '?'},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '?'},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '?'},
        }
    },
    {
        0x114c, "OpSubgroupAllKHR", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x114d, "OpSubgroupAnyKHR", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x114e, "OpSubgroupAllEqualKHR", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x114f, "OpGroupNonUniformRotateKHR", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '?'},
        }
    },
    {
        0x1150, "OpSubgroupReadInvocationKHR", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1151, "OpExtInstWithForwardRefsKHR", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_EXT_INST_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '*'},
        }
    },
    {
        0x115d, "OpTraceRayKHR", 11,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x115e, "OpExecuteCallableKHR", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x115f, "OpConvertUToAccelerationStructureKHR", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {0x1160, "OpIgnoreIntersectionKHR"},
    {0x1161, "OpTerminateRayKHR"},
    {
        0x1162, "OpSDot", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_PACKED_VECTOR_FORMAT, '?'},
        }
    },
    {
        0x1163, "OpUDot", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_PACKED_VECTOR_FORMAT, '?'},
        }
    },
    {
        0x1164, "OpSUDot", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_PACKED_VECTOR_FORMAT, '?'},
        }
    },
    {
        0x1165, "OpSDotAccSat", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_PACKED_VECTOR_FORMAT, '?'},
        }
    },
    {
        0x1166, "OpUDotAccSat", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_PACKED_VECTOR_FORMAT, '?'},
        }
    },
    {
        0x1167, "OpSUDotAccSat", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_PACKED_VECTOR_FORMAT, '?'},
        }
    },
    {
        0x1168, "OpTypeCooperativeMatrixKHR", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1169, "OpCooperativeMatrixLoadKHR", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '?'},
            {SPIRV_PARSER_OPERAND_TYPE_MEMORY_ACCESS, '?'},
        }
    },
    {
        0x116a, "OpCooperativeMatrixStoreKHR", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '?'},
            {SPIRV_PARSER_OPERAND_TYPE_MEMORY_ACCESS, '?'},
        }
    },
    {
        0x116b, "OpCooperativeMatrixMulAddKHR", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_COOPERATIVE_MATRIX_OPERANDS, '?'},
        }
    },
    {
        0x116c, "OpCooperativeMatrixLengthKHR", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x116d, "OpConstantCompositeReplicateEXT", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x116e, "OpSpecConstantCompositeReplicateEXT", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x116f, "OpCompositeConstructReplicateEXT", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1178, "OpTypeRayQueryKHR", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x1179, "OpRayQueryInitializeKHR", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x117a, "OpRayQueryTerminateKHR", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x117b, "OpRayQueryGenerateIntersectionKHR", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x117c, "OpRayQueryConfirmIntersectionKHR", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x117d, "OpRayQueryProceedKHR", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x117f, "OpRayQueryGetIntersectionTypeKHR", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1180, "OpImageSampleWeightedQCOM", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1181, "OpImageBoxFilterQCOM", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1182, "OpImageBlockMatchSSDQCOM", 7,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1183, "OpImageBlockMatchSADQCOM", 7,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1194, "OpImageBlockMatchWindowSSDQCOM", 7,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1195, "OpImageBlockMatchWindowSADQCOM", 7,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1196, "OpImageBlockMatchGatherSSDQCOM", 7,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1197, "OpImageBlockMatchGatherSADQCOM", 7,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1388, "OpGroupIAddNonUniformAMD", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_GROUP_OPERATION},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1389, "OpGroupFAddNonUniformAMD", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_GROUP_OPERATION},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x138a, "OpGroupFMinNonUniformAMD", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_GROUP_OPERATION},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x138b, "OpGroupUMinNonUniformAMD", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_GROUP_OPERATION},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x138c, "OpGroupSMinNonUniformAMD", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_GROUP_OPERATION},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x138d, "OpGroupFMaxNonUniformAMD", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_GROUP_OPERATION},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x138e, "OpGroupUMaxNonUniformAMD", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_GROUP_OPERATION},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x138f, "OpGroupSMaxNonUniformAMD", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_GROUP_OPERATION},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1393, "OpFragmentMaskFetchAMD", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1394, "OpFragmentFetchAMD", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x13c0, "OpReadClockKHR", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
        }
    },
    {
        0x13d2, "OpAllocateNodePayloadsAMDX", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x13d3, "OpEnqueueNodePayloadsAMDX", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x13d4, "OpTypeNodePayloadArrayAMDX", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x13d6, "OpFinishWritingNodePayloadAMDX", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x13e2, "OpNodePayloadArrayLengthAMDX", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x13ed, "OpIsNodePayloadValidAMDX", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x13ef, "OpConstantStringAMDX", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_STRING},
        }
    },
    {
        0x13f0, "OpSpecConstantStringAMDX", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_STRING},
        }
    },
    {
        0x13f6, "OpGroupNonUniformQuadAllKHR", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x13f7, "OpGroupNonUniformQuadAnyKHR", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1481, "OpHitObjectRecordHitMotionNV", 14,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1482, "OpHitObjectRecordHitWithIndexMotionNV", 13,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1483, "OpHitObjectRecordMissMotionNV", 7,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1484, "OpHitObjectGetWorldToObjectNV", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1485, "OpHitObjectGetObjectToWorldNV", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1486, "OpHitObjectGetObjectRayDirectionNV", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1487, "OpHitObjectGetObjectRayOriginNV", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1488, "OpHitObjectTraceRayMotionNV", 13,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1489, "OpHitObjectGetShaderRecordBufferHandleNV", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x148a, "OpHitObjectGetShaderBindingTableRecordIndexNV", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x148b, "OpHitObjectRecordEmptyNV", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x148c, "OpHitObjectTraceRayNV", 12,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x148d, "OpHitObjectRecordHitNV", 13,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x148e, "OpHitObjectRecordHitWithIndexNV", 12,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x148f, "OpHitObjectRecordMissNV", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1490, "OpHitObjectExecuteShaderNV", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1491, "OpHitObjectGetCurrentTimeNV", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1492, "OpHitObjectGetAttributesNV", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1493, "OpHitObjectGetHitKindNV", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1494, "OpHitObjectGetPrimitiveIndexNV", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1495, "OpHitObjectGetGeometryIndexNV", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1496, "OpHitObjectGetInstanceIdNV", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1497, "OpHitObjectGetInstanceCustomIndexNV", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1498, "OpHitObjectGetWorldRayDirectionNV", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1499, "OpHitObjectGetWorldRayOriginNV", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x149a, "OpHitObjectGetRayTMaxNV", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x149b, "OpHitObjectGetRayTMinNV", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x149c, "OpHitObjectIsEmptyNV", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x149d, "OpHitObjectIsHitNV", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x149e, "OpHitObjectIsMissNV", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x149f, "OpReorderThreadWithHitObjectNV", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '?'},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '?'},
        }
    },
    {
        0x14a0, "OpReorderThreadWithHintNV", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x14a1, "OpTypeHitObjectNV", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x14a3, "OpImageSampleFootprintNV", 7,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_IMAGE_OPERANDS, '?'},
        }
    },
    {
        0x14a8, "OpTypeCooperativeVectorNV", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x14a9, "OpCooperativeVectorMatrixMulNV", 13,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '?'},
            {SPIRV_PARSER_OPERAND_TYPE_COOPERATIVE_MATRIX_OPERANDS, '?'},
        }
    },
    {
        0x14aa, "OpCooperativeVectorOuterProductAccumulateNV", 7,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '?'},
        }
    },
    {
        0x14ab, "OpCooperativeVectorReduceSumAccumulateNV", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x14ac, "OpCooperativeVectorMatrixMulAddNV", 16,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '?'},
            {SPIRV_PARSER_OPERAND_TYPE_COOPERATIVE_MATRIX_OPERANDS, '?'},
        }
    },
    {
        0x14ad, "OpCooperativeMatrixConvertNV", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x14ae, "OpEmitMeshTasksEXT", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '?'},
        }
    },
    {
        0x14af, "OpSetMeshOutputsEXT", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x14b0, "OpGroupNonUniformPartitionNV", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x14b3, "OpWritePackedPrimitiveIndices4x8NV", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x14b4, "OpFetchMicroTriangleVertexPositionNV", 7,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x14b5, "OpFetchMicroTriangleVertexBarycentricNV", 7,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x14b6, "OpCooperativeVectorLoadNV", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_MEMORY_ACCESS, '?'},
        }
    },
    {
        0x14b7, "OpCooperativeVectorStoreNV", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_MEMORY_ACCESS, '?'},
        }
    },
    {
        0x14d6, "OpReportIntersectionKHR", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {0x14d7, "OpIgnoreIntersectionNV"},
    {0x14d8, "OpTerminateRayNV"},
    {
        0x14d9, "OpTraceNV", 11,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x14da, "OpTraceMotionNV", 12,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x14db, "OpTraceRayMotionNV", 12,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x14dc, "OpRayQueryGetIntersectionTriangleVertexPositionsKHR", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x14dd, "OpTypeAccelerationStructureKHR", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x14e0, "OpExecuteCallableNV", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x14e1, "OpRayQueryGetClusterIdNV", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x14e2, "OpHitObjectGetClusterIdNV", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x14ee, "OpTypeCooperativeMatrixNV", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x14ef, "OpCooperativeMatrixLoadNV", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_MEMORY_ACCESS, '?'},
        }
    },
    {
        0x14f0, "OpCooperativeMatrixStoreNV", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_MEMORY_ACCESS, '?'},
        }
    },
    {
        0x14f1, "OpCooperativeMatrixMulAddNV", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x14f2, "OpCooperativeMatrixLengthNV", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {0x14f4, "OpBeginInvocationInterlockEXT"},
    {0x14f5, "OpEndInvocationInterlockEXT"},
    {
        0x14f6, "OpCooperativeMatrixReduceNV", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_COOPERATIVE_MATRIX_REDUCE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x14f7, "OpCooperativeMatrixLoadTensorNV", 7,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_MEMORY_ACCESS},
            {SPIRV_PARSER_OPERAND_TYPE_TENSOR_ADDRESSING_OPERANDS},
        }
    },
    {
        0x14f8, "OpCooperativeMatrixStoreTensorNV", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_MEMORY_ACCESS},
            {SPIRV_PARSER_OPERAND_TYPE_TENSOR_ADDRESSING_OPERANDS},
        }
    },
    {
        0x14f9, "OpCooperativeMatrixPerElementOpNV", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '*'},
        }
    },
    {
        0x14fa, "OpTypeTensorLayoutNV", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x14fb, "OpTypeTensorViewNV", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '*'},
        }
    },
    {
        0x14fc, "OpCreateTensorLayoutNV", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x14fd, "OpTensorLayoutSetDimensionNV", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '*'},
        }
    },
    {
        0x14fe, "OpTensorLayoutSetStrideNV", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '*'},
        }
    },
    {
        0x14ff, "OpTensorLayoutSliceNV", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '*'},
        }
    },
    {
        0x1500, "OpTensorLayoutSetClampValueNV", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1501, "OpCreateTensorViewNV", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x1502, "OpTensorViewSetDimensionNV", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '*'},
        }
    },
    {
        0x1503, "OpTensorViewSetStrideNV", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '*'},
        }
    },
    {0x1504, "OpDemoteToHelperInvocation"},
    {
        0x1505, "OpIsHelperInvocationEXT", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x1506, "OpTensorViewSetClipNV", 7,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1508, "OpTensorLayoutSetBlockSizeNV", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '*'},
        }
    },
    {
        0x150e, "OpCooperativeMatrixTransposeNV", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x150f, "OpConvertUToImageNV", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1510, "OpConvertUToSamplerNV", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1511, "OpConvertImageToUNV", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1512, "OpConvertSamplerToUNV", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1513, "OpConvertUToSampledImageNV", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1514, "OpConvertSampledImageToUNV", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1515, "OpSamplerImageAddressingModeNV", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x1516, "OpRawAccessChainNV", 7,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_RAW_ACCESS_CHAIN_OPERANDS, '?'},
        }
    },
    {
        0x1533, "OpRayQueryGetIntersectionSpherePositionNV", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1534, "OpRayQueryGetIntersectionSphereRadiusNV", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1535, "OpRayQueryGetIntersectionLSSPositionsNV", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1536, "OpRayQueryGetIntersectionLSSRadiiNV", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1537, "OpRayQueryGetIntersectionLSSHitValueNV", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1538, "OpHitObjectGetSpherePositionNV", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1539, "OpHitObjectGetSphereRadiusNV", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x153a, "OpHitObjectGetLSSPositionsNV", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x153b, "OpHitObjectGetLSSRadiiNV", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x153c, "OpHitObjectIsSphereHitNV", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x153d, "OpHitObjectIsLSSHitNV", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x153e, "OpRayQueryIsSphereHitNV", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x153f, "OpRayQueryIsLSSHitNV", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x15c3, "OpSubgroupShuffleINTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x15c4, "OpSubgroupShuffleDownINTEL", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x15c5, "OpSubgroupShuffleUpINTEL", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x15c6, "OpSubgroupShuffleXorINTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x15c7, "OpSubgroupBlockReadINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x15c8, "OpSubgroupBlockWriteINTEL", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x15c9, "OpSubgroupImageBlockReadINTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x15ca, "OpSubgroupImageBlockWriteINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x15cc, "OpSubgroupImageMediaBlockReadINTEL", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x15cd, "OpSubgroupImageMediaBlockWriteINTEL", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x15d1, "OpUCountLeadingZerosINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x15d2, "OpUCountTrailingZerosINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x15d3, "OpAbsISubINTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x15d4, "OpAbsUSubINTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x15d5, "OpIAddSatINTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x15d6, "OpUAddSatINTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x15d7, "OpIAverageINTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x15d8, "OpUAverageINTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x15d9, "OpIAverageRoundedINTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x15da, "OpUAverageRoundedINTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x15db, "OpISubSatINTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x15dc, "OpUSubSatINTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x15dd, "OpIMul32x16INTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x15de, "OpUMul32x16INTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x15e0, "OpConstantFunctionPointerINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x15e1, "OpFunctionPointerCallINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '*'},
        }
    },
    {
        0x15e9, "OpAsmTargetINTEL", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_STRING},
        }
    },
    {
        0x15ea, "OpAsmINTEL", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_STRING},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_STRING},
        }
    },
    {
        0x15eb, "OpAsmCallINTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '*'},
        }
    },
    {
        0x15ee, "OpAtomicFMinEXT", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_MEMORY_SEMANTICS},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x15ef, "OpAtomicFMaxEXT", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_MEMORY_SEMANTICS},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x15fe, "OpAssumeTrueKHR", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x15ff, "OpExpectKHR", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1600, "OpDecorateString", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_DECORATION},
        }
    },
    {
        0x1601, "OpMemberDecorateString", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_DECORATION},
        }
    },
    {
        0x1643, "OpVmeImageINTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1644, "OpTypeVmeImageINTEL", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1645, "OpTypeAvcImePayloadINTEL", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x1646, "OpTypeAvcRefPayloadINTEL", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x1647, "OpTypeAvcSicPayloadINTEL", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x1648, "OpTypeAvcMcePayloadINTEL", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x1649, "OpTypeAvcMceResultINTEL", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x164a, "OpTypeAvcImeResultINTEL", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x164b, "OpTypeAvcImeResultSingleReferenceStreamoutINTEL", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x164c, "OpTypeAvcImeResultDualReferenceStreamoutINTEL", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x164d, "OpTypeAvcImeSingleReferenceStreaminINTEL", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x164e, "OpTypeAvcImeDualReferenceStreaminINTEL", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x164f, "OpTypeAvcRefResultINTEL", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x1650, "OpTypeAvcSicResultINTEL", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x1651, "OpSubgroupAvcMceGetDefaultInterBaseMultiReferencePenaltyINTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1652, "OpSubgroupAvcMceSetInterBaseMultiReferencePenaltyINTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1653, "OpSubgroupAvcMceGetDefaultInterShapePenaltyINTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1654, "OpSubgroupAvcMceSetInterShapePenaltyINTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1655, "OpSubgroupAvcMceGetDefaultInterDirectionPenaltyINTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1656, "OpSubgroupAvcMceSetInterDirectionPenaltyINTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1657, "OpSubgroupAvcMceGetDefaultIntraLumaShapePenaltyINTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1658, "OpSubgroupAvcMceGetDefaultInterMotionVectorCostTableINTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1659, "OpSubgroupAvcMceGetDefaultHighPenaltyCostTableINTEL", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x165a, "OpSubgroupAvcMceGetDefaultMediumPenaltyCostTableINTEL", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x165b, "OpSubgroupAvcMceGetDefaultLowPenaltyCostTableINTEL", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x165c, "OpSubgroupAvcMceSetMotionVectorCostFunctionINTEL", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x165d, "OpSubgroupAvcMceGetDefaultIntraLumaModePenaltyINTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x165e, "OpSubgroupAvcMceGetDefaultNonDcLumaIntraPenaltyINTEL", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x165f, "OpSubgroupAvcMceGetDefaultIntraChromaModeBasePenaltyINTEL", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x1660, "OpSubgroupAvcMceSetAcOnlyHaarINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1661, "OpSubgroupAvcMceSetSourceInterlacedFieldPolarityINTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1662, "OpSubgroupAvcMceSetSingleReferenceInterlacedFieldPolarityINTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1663, "OpSubgroupAvcMceSetDualReferenceInterlacedFieldPolaritiesINTEL", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1664, "OpSubgroupAvcMceConvertToImePayloadINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1665, "OpSubgroupAvcMceConvertToImeResultINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1666, "OpSubgroupAvcMceConvertToRefPayloadINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1667, "OpSubgroupAvcMceConvertToRefResultINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1668, "OpSubgroupAvcMceConvertToSicPayloadINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1669, "OpSubgroupAvcMceConvertToSicResultINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x166a, "OpSubgroupAvcMceGetMotionVectorsINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x166b, "OpSubgroupAvcMceGetInterDistortionsINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x166c, "OpSubgroupAvcMceGetBestInterDistortionsINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x166d, "OpSubgroupAvcMceGetInterMajorShapeINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x166e, "OpSubgroupAvcMceGetInterMinorShapeINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x166f, "OpSubgroupAvcMceGetInterDirectionsINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1670, "OpSubgroupAvcMceGetInterMotionVectorCountINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1671, "OpSubgroupAvcMceGetInterReferenceIdsINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1672, "OpSubgroupAvcMceGetInterReferenceInterlacedFieldPolaritiesINTEL", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1673, "OpSubgroupAvcImeInitializeINTEL", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1674, "OpSubgroupAvcImeSetSingleReferenceINTEL", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1675, "OpSubgroupAvcImeSetDualReferenceINTEL", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1676, "OpSubgroupAvcImeRefWindowSizeINTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1677, "OpSubgroupAvcImeAdjustRefOffsetINTEL", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1678, "OpSubgroupAvcImeConvertToMcePayloadINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1679, "OpSubgroupAvcImeSetMaxMotionVectorCountINTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x167a, "OpSubgroupAvcImeSetUnidirectionalMixDisableINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x167b, "OpSubgroupAvcImeSetEarlySearchTerminationThresholdINTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x167c, "OpSubgroupAvcImeSetWeightedSadINTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x167d, "OpSubgroupAvcImeEvaluateWithSingleReferenceINTEL", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x167e, "OpSubgroupAvcImeEvaluateWithDualReferenceINTEL", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x167f, "OpSubgroupAvcImeEvaluateWithSingleReferenceStreaminINTEL", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1680, "OpSubgroupAvcImeEvaluateWithDualReferenceStreaminINTEL", 7,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1681, "OpSubgroupAvcImeEvaluateWithSingleReferenceStreamoutINTEL", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1682, "OpSubgroupAvcImeEvaluateWithDualReferenceStreamoutINTEL", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1683, "OpSubgroupAvcImeEvaluateWithSingleReferenceStreaminoutINTEL", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1684, "OpSubgroupAvcImeEvaluateWithDualReferenceStreaminoutINTEL", 7,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1685, "OpSubgroupAvcImeConvertToMceResultINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1686, "OpSubgroupAvcImeGetSingleReferenceStreaminINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1687, "OpSubgroupAvcImeGetDualReferenceStreaminINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1688, "OpSubgroupAvcImeStripSingleReferenceStreamoutINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1689, "OpSubgroupAvcImeStripDualReferenceStreamoutINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x168a, "OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeMotionVectorsINTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x168b, "OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeDistortionsINTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x168c, "OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeReferenceIdsINTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x168d, "OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeMotionVectorsINTEL", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x168e, "OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeDistortionsINTEL", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x168f, "OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeReferenceIdsINTEL", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1690, "OpSubgroupAvcImeGetBorderReachedINTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1691, "OpSubgroupAvcImeGetTruncatedSearchIndicationINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1692, "OpSubgroupAvcImeGetUnidirectionalEarlySearchTerminationINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1693, "OpSubgroupAvcImeGetWeightingPatternMinimumMotionVectorINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1694, "OpSubgroupAvcImeGetWeightingPatternMinimumDistortionINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1695, "OpSubgroupAvcFmeInitializeINTEL", 9,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1696, "OpSubgroupAvcBmeInitializeINTEL", 10,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1697, "OpSubgroupAvcRefConvertToMcePayloadINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1698, "OpSubgroupAvcRefSetBidirectionalMixDisableINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1699, "OpSubgroupAvcRefSetBilinearFilterEnableINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x169a, "OpSubgroupAvcRefEvaluateWithSingleReferenceINTEL", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x169b, "OpSubgroupAvcRefEvaluateWithDualReferenceINTEL", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x169c, "OpSubgroupAvcRefEvaluateWithMultiReferenceINTEL", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x169d, "OpSubgroupAvcRefEvaluateWithMultiReferenceInterlacedINTEL", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x169e, "OpSubgroupAvcRefConvertToMceResultINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x169f, "OpSubgroupAvcSicInitializeINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x16a0, "OpSubgroupAvcSicConfigureSkcINTEL", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x16a1, "OpSubgroupAvcSicConfigureIpeLumaINTEL", 10,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x16a2, "OpSubgroupAvcSicConfigureIpeLumaChromaINTEL", 13,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x16a3, "OpSubgroupAvcSicGetMotionVectorMaskINTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x16a4, "OpSubgroupAvcSicConvertToMcePayloadINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x16a5, "OpSubgroupAvcSicSetIntraLumaShapePenaltyINTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x16a6, "OpSubgroupAvcSicSetIntraLumaModeCostFunctionINTEL", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x16a7, "OpSubgroupAvcSicSetIntraChromaModeCostFunctionINTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x16a8, "OpSubgroupAvcSicSetBilinearFilterEnableINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x16a9, "OpSubgroupAvcSicSetSkcForwardTransformEnableINTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x16aa, "OpSubgroupAvcSicSetBlockBasedRawSkipSadINTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x16ab, "OpSubgroupAvcSicEvaluateIpeINTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x16ac, "OpSubgroupAvcSicEvaluateWithSingleReferenceINTEL", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x16ad, "OpSubgroupAvcSicEvaluateWithDualReferenceINTEL", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x16ae, "OpSubgroupAvcSicEvaluateWithMultiReferenceINTEL", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x16af, "OpSubgroupAvcSicEvaluateWithMultiReferenceInterlacedINTEL", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x16b0, "OpSubgroupAvcSicConvertToMceResultINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x16b1, "OpSubgroupAvcSicGetIpeLumaShapeINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x16b2, "OpSubgroupAvcSicGetBestIpeLumaDistortionINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x16b3, "OpSubgroupAvcSicGetBestIpeChromaDistortionINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x16b4, "OpSubgroupAvcSicGetPackedIpeLumaModesINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x16b5, "OpSubgroupAvcSicGetIpeChromaModeINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x16b6, "OpSubgroupAvcSicGetPackedSkcLumaCountThresholdINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x16b7, "OpSubgroupAvcSicGetPackedSkcLumaSumThresholdINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x16b8, "OpSubgroupAvcSicGetInterRawSadsINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x16ba, "OpVariableLengthArrayINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x16bb, "OpSaveMemoryINTEL", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x16bc, "OpRestoreMemoryINTEL", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x16d0, "OpArbitraryFloatSinCosPiINTEL", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x16d1, "OpArbitraryFloatCastINTEL", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x16d2, "OpArbitraryFloatCastFromIntINTEL", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x16d3, "OpArbitraryFloatCastToIntINTEL", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x16d6, "OpArbitraryFloatAddINTEL", 10,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x16d7, "OpArbitraryFloatSubINTEL", 10,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x16d8, "OpArbitraryFloatMulINTEL", 10,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x16d9, "OpArbitraryFloatDivINTEL", 10,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x16da, "OpArbitraryFloatGTINTEL", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x16db, "OpArbitraryFloatGEINTEL", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x16dc, "OpArbitraryFloatLTINTEL", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x16dd, "OpArbitraryFloatLEINTEL", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x16de, "OpArbitraryFloatEQINTEL", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x16df, "OpArbitraryFloatRecipINTEL", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x16e0, "OpArbitraryFloatRSqrtINTEL", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x16e1, "OpArbitraryFloatCbrtINTEL", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x16e2, "OpArbitraryFloatHypotINTEL", 10,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x16e3, "OpArbitraryFloatSqrtINTEL", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x16e4, "OpArbitraryFloatLogINTEL", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x16e5, "OpArbitraryFloatLog2INTEL", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x16e6, "OpArbitraryFloatLog10INTEL", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x16e7, "OpArbitraryFloatLog1pINTEL", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x16e8, "OpArbitraryFloatExpINTEL", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x16e9, "OpArbitraryFloatExp2INTEL", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x16ea, "OpArbitraryFloatExp10INTEL", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x16eb, "OpArbitraryFloatExpm1INTEL", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x16ec, "OpArbitraryFloatSinINTEL", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x16ed, "OpArbitraryFloatCosINTEL", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x16ee, "OpArbitraryFloatSinCosINTEL", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x16ef, "OpArbitraryFloatSinPiINTEL", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x16f0, "OpArbitraryFloatCosPiINTEL", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x16f1, "OpArbitraryFloatASinINTEL", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x16f2, "OpArbitraryFloatASinPiINTEL", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x16f3, "OpArbitraryFloatACosINTEL", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x16f4, "OpArbitraryFloatACosPiINTEL", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x16f5, "OpArbitraryFloatATanINTEL", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x16f6, "OpArbitraryFloatATanPiINTEL", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x16f7, "OpArbitraryFloatATan2INTEL", 10,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x16f8, "OpArbitraryFloatPowINTEL", 10,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x16f9, "OpArbitraryFloatPowRINTEL", 10,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x16fa, "OpArbitraryFloatPowNINTEL", 10,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x16ff, "OpLoopControlINTEL", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER, '*'},
        }
    },
    {
        0x1717, "OpAliasDomainDeclINTEL", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '?'},
        }
    },
    {
        0x1718, "OpAliasScopeDeclINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '?'},
        }
    },
    {
        0x1719, "OpAliasScopeListDeclINTEL", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '*'},
        }
    },
    {
        0x1723, "OpFixedSqrtINTEL", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x1724, "OpFixedRecipINTEL", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x1725, "OpFixedRsqrtINTEL", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x1726, "OpFixedSinINTEL", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x1727, "OpFixedCosINTEL", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x1728, "OpFixedSinCosINTEL", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x1729, "OpFixedSinPiINTEL", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x172a, "OpFixedCosPiINTEL", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x172b, "OpFixedSinCosPiINTEL", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x172c, "OpFixedLogINTEL", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x172d, "OpFixedExpINTEL", 8,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x172e, "OpPtrCastToCrossWorkgroupINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1732, "OpCrossWorkgroupCastToPtrINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x173a, "OpReadPipeBlockingINTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x173b, "OpWritePipeBlockingINTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x173d, "OpFPGARegINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1780, "OpRayQueryGetRayTMinKHR", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1781, "OpRayQueryGetRayFlagsKHR", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1782, "OpRayQueryGetIntersectionTKHR", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1783, "OpRayQueryGetIntersectionInstanceCustomIndexKHR", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1784, "OpRayQueryGetIntersectionInstanceIdKHR", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1785, "OpRayQueryGetIntersectionInstanceShaderBindingTableRecordOffsetKHR", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1786, "OpRayQueryGetIntersectionGeometryIndexKHR", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1787, "OpRayQueryGetIntersectionPrimitiveIndexKHR", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1788, "OpRayQueryGetIntersectionBarycentricsKHR", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1789, "OpRayQueryGetIntersectionFrontFaceKHR", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x178a, "OpRayQueryGetIntersectionCandidateAABBOpaqueKHR", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x178b, "OpRayQueryGetIntersectionObjectRayDirectionKHR", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x178c, "OpRayQueryGetIntersectionObjectRayOriginKHR", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x178d, "OpRayQueryGetWorldRayDirectionKHR", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x178e, "OpRayQueryGetWorldRayOriginKHR", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x178f, "OpRayQueryGetIntersectionObjectToWorldKHR", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1790, "OpRayQueryGetIntersectionWorldToObjectKHR", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1793, "OpAtomicFAddEXT", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_MEMORY_SEMANTICS},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x17c6, "OpTypeBufferSurfaceINTEL", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ACCESS_QUALIFIER},
        }
    },
    {
        0x17ca, "OpTypeStructContinuedINTEL", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '*'},
        }
    },
    {
        0x17cb, "OpConstantCompositeContinuedINTEL", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '*'},
        }
    },
    {
        0x17cc, "OpSpecConstantCompositeContinuedINTEL", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '*'},
        }
    },
    {
        0x17d0, "OpCompositeConstructContinuedINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '*'},
        }
    },
    {
        0x17e4, "OpConvertFToBF16INTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x17e5, "OpConvertBF16ToFINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x17fe, "OpControlBarrierArriveINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_MEMORY_SEMANTICS},
        }
    },
    {
        0x17ff, "OpControlBarrierWaitINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_MEMORY_SEMANTICS},
        }
    },
    {
        0x1801, "OpArithmeticFenceEXT", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1813, "OpTaskSequenceCreateINTEL", 7,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
        }
    },
    {
        0x1814, "OpTaskSequenceAsyncINTEL", 2,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF, '*'},
        }
    },
    {
        0x1815, "OpTaskSequenceGetINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1816, "OpTaskSequenceReleaseINTEL", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1837, "OpTypeTaskSequenceINTEL", 1,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
        }
    },
    {
        0x184d, "OpSubgroupBlockPrefetchINTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_MEMORY_ACCESS, '?'},
        }
    },
    {
        0x1857, "OpSubgroup2DBlockLoadINTEL", 10,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1858, "OpSubgroup2DBlockLoadTransformINTEL", 10,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1859, "OpSubgroup2DBlockLoadTransposeINTEL", 10,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x185a, "OpSubgroup2DBlockPrefetchINTEL", 9,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x185b, "OpSubgroup2DBlockStoreINTEL", 10,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x185d, "OpSubgroupMatrixMultiplyAccumulateINTEL", 7,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_MATRIX_MULTIPLY_ACCUMULATE_OPERANDS, '?'},
        }
    },
    {
        0x1862, "OpBitwiseFunctionINTEL", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1901, "OpGroupIMulKHR", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_GROUP_OPERATION},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1902, "OpGroupFMulKHR", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_GROUP_OPERATION},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1903, "OpGroupBitwiseAndKHR", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_GROUP_OPERATION},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1904, "OpGroupBitwiseOrKHR", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_GROUP_OPERATION},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1905, "OpGroupBitwiseXorKHR", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_GROUP_OPERATION},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1906, "OpGroupLogicalAndKHR", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_GROUP_OPERATION},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1907, "OpGroupLogicalOrKHR", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_GROUP_OPERATION},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x1908, "OpGroupLogicalXorKHR", 5,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_SCOPE},
            {SPIRV_PARSER_OPERAND_TYPE_GROUP_OPERATION},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x191a, "OpRoundFToTF32INTEL", 3,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x191c, "OpMaskedGatherINTEL", 6,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT_TYPE},
            {SPIRV_PARSER_OPERAND_TYPE_ID_RESULT},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
    {
        0x191d, "OpMaskedScatterINTEL", 4,
        (struct spirv_parser_instruction_operand[])
        {
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
            {SPIRV_PARSER_OPERAND_TYPE_LITERAL_INTEGER},
            {SPIRV_PARSER_OPERAND_TYPE_ID_REF},
        }
    },
};
