/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.CollectSupportDataLogCaptureWindow;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class HeadAndTailSizeCollectSupportDataLogCaptureWindow
extends CollectSupportDataLogCaptureWindow {
    private static final byte TYPE_HEAD_SIZE_KB = -128;
    private static final byte TYPE_TAIL_SIZE_KB = -127;
    private static final long serialVersionUID = 6810565494534462677L;
    @NotNull
    private final ASN1Element encodedWindow;
    @Nullable
    private final Integer headSizeKB;
    @Nullable
    private final Integer tailSizeKB;

    public HeadAndTailSizeCollectSupportDataLogCaptureWindow(@Nullable Integer headSizeKB, @Nullable Integer tailSizeKB) {
        if (headSizeKB != null) {
            Validator.ensureTrue(headSizeKB >= 0, "If HeadAndTailSizeCollectSupportDataLogCaptureWindow.headSizeKB is non-null, then it must also be non-negative.");
        }
        if (tailSizeKB != null) {
            Validator.ensureTrue(tailSizeKB >= 0, "If HeadAndTailSizeCollectSupportDataLogCaptureWindow.tailSizeKB is non-null, then it must also be non-negative.");
        }
        this.headSizeKB = headSizeKB;
        this.tailSizeKB = tailSizeKB;
        ArrayList<ASN1Integer> elements = new ArrayList<ASN1Integer>(2);
        if (headSizeKB != null) {
            elements.add(new ASN1Integer(-128, headSizeKB));
        }
        if (tailSizeKB != null) {
            elements.add(new ASN1Integer(-127, tailSizeKB));
        }
        this.encodedWindow = new ASN1Sequence(-93, elements);
    }

    @Nullable
    public Integer getHeadSizeKB() {
        return this.headSizeKB;
    }

    @Nullable
    public Integer getTailSizeKB() {
        return this.tailSizeKB;
    }

    @NotNull
    static HeadAndTailSizeCollectSupportDataLogCaptureWindow decodeInternal(@NotNull ASN1Element e) throws LDAPException {
        try {
            Integer headSizeKB = null;
            Integer tailSizeKB = null;
            block7: for (ASN1Element element : ASN1Sequence.decodeAsSequence(e).elements()) {
                switch (element.getType()) {
                    case -128: {
                        headSizeKB = ASN1Integer.decodeAsInteger(element).intValue();
                        if (headSizeKB >= 0) continue block7;
                        throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_HT_SIZE_CSD_LOG_CAPTURE_WINDOW_INVALID_HEAD_SIZE.get(headSizeKB));
                    }
                    case -127: {
                        tailSizeKB = ASN1Integer.decodeAsInteger(element).intValue();
                        if (tailSizeKB >= 0) continue block7;
                        throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_HT_SIZE_CSD_LOG_CAPTURE_WINDOW_INVALID_TAIL_SIZE.get(tailSizeKB));
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_HT_SIZE_CSD_LOG_CAPTURE_WINDOW_INVALID_ELEMENT_TYPE.get(StaticUtils.toHex(element.getType())));
                    }
                }
            }
            return new HeadAndTailSizeCollectSupportDataLogCaptureWindow(headSizeKB, tailSizeKB);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception ex) {
            Debug.debugException(ex);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_HT_SIZE_CSD_LOG_WINDOW_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(ex)), ex);
        }
    }

    @Override
    @NotNull
    public ASN1Element encode() {
        return this.encodedWindow;
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("HeadAndTailSizeCollectSupportDataLogCaptureWindow(");
        if (this.headSizeKB != null) {
            buffer.append("headSizeKB=");
            buffer.append(this.headSizeKB);
        }
        if (this.tailSizeKB != null) {
            if (this.headSizeKB != null) {
                buffer.append(", ");
            }
            buffer.append("tailSizeKB=");
            buffer.append(this.tailSizeKB);
        }
        buffer.append(')');
    }
}

