// generated by diplomat-tool
import wasm from "./diplomat-wasm.mjs";
import * as diplomatRuntime from "./diplomat-runtime.mjs";



export class TimeZoneVariant {
    #value = undefined;

    static #values = new Map([
        ["Standard", 0],
        ["Daylight", 1]
    ]);

    static getAllEntries() {
        return TimeZoneVariant.#values.entries();
    }

    #internalConstructor(value) {
        if (arguments.length > 1 && arguments[0] === diplomatRuntime.internalConstructor) {
            // We pass in two internalConstructor arguments to create *new*
            // instances of this type, otherwise the enums are treated as singletons.
            if (arguments[1] === diplomatRuntime.internalConstructor ) {
                this.#value = arguments[2];
                return this;
            }
            return TimeZoneVariant.#objectValues[arguments[1]];
        }

        if (value instanceof TimeZoneVariant) {
            return value;
        }

        let intVal = TimeZoneVariant.#values.get(value);

        // Nullish check, checks for null or undefined
        if (intVal != null) {
            return TimeZoneVariant.#objectValues[intVal];
        }

        throw TypeError(value + " is not a TimeZoneVariant and does not correspond to any of its enumerator values.");
    }

    static fromValue(value) {
        return new TimeZoneVariant(value);
    }

    get value(){
        return [...TimeZoneVariant.#values.keys()][this.#value];
    }

    get ffiValue(){
        return this.#value;
    }
    static #objectValues = [
        new TimeZoneVariant(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 0),
        new TimeZoneVariant(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 1),
    ];

    static Standard = TimeZoneVariant.#objectValues[0];
    static Daylight = TimeZoneVariant.#objectValues[1];


    /**
     * Sets the `variant` field to "daylight" time.
     *
     * See the [Rust documentation for `from_rearguard_isdst`](https://docs.rs/icu/latest/icu/time/zone/enum.TimeZoneVariant.html#method.from_rearguard_isdst) for more information.
     *
     * See the [Rust documentation for `with_variant`](https://docs.rs/icu/latest/icu/time/struct.TimeZoneInfo.html#method.with_variant) for more information.
     *
     * Additional information: [1](https://docs.rs/icu/latest/icu/time/zone/enum.TimeZoneVariant.html)
     */
    fromRearguardIsdst(isdst) {

        const result = wasm.icu4x_TimeZoneVariant_from_rearguard_isdst_mv1(this.ffiValue, isdst);

        try {
            return new TimeZoneVariant(diplomatRuntime.internalConstructor, result);
        }

        finally {
        }
    }

    constructor(value) {
        return this.#internalConstructor(...arguments)
    }
}