// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct GetWebIdentityTokenInput {
    /// <p>The intended recipient of the web identity token. This value populates the <code>aud</code> claim in the JWT and should identify the service or application that will validate and use the token. The external service should verify this claim to ensure the token was intended for their use.</p>
    pub audience: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    /// <p>The duration, in seconds, for which the JSON Web Token (JWT) will remain valid. The value can range from 60 seconds (1 minute) to 3600 seconds (1 hour). If not specified, the default duration is 300 seconds (5 minutes). The token is designed to be short-lived and should be used for proof of identity, then exchanged for credentials or short-lived tokens in the external service.</p>
    pub duration_seconds: ::std::option::Option<i32>,
    /// <p>The cryptographic algorithm to use for signing the JSON Web Token (JWT). Valid values are RS256 (RSA with SHA-256) and ES384 (ECDSA using P-384 curve with SHA-384).</p>
    pub signing_algorithm: ::std::option::Option<::std::string::String>,
    /// <p>An optional list of tags to include in the JSON Web Token (JWT). These tags are added as custom claims to the JWT and can be used by the downstream service for authorization decisions.</p>
    pub tags: ::std::option::Option<::std::vec::Vec<crate::types::Tag>>,
}
impl GetWebIdentityTokenInput {
    /// <p>The intended recipient of the web identity token. This value populates the <code>aud</code> claim in the JWT and should identify the service or application that will validate and use the token. The external service should verify this claim to ensure the token was intended for their use.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.audience.is_none()`.
    pub fn audience(&self) -> &[::std::string::String] {
        self.audience.as_deref().unwrap_or_default()
    }
    /// <p>The duration, in seconds, for which the JSON Web Token (JWT) will remain valid. The value can range from 60 seconds (1 minute) to 3600 seconds (1 hour). If not specified, the default duration is 300 seconds (5 minutes). The token is designed to be short-lived and should be used for proof of identity, then exchanged for credentials or short-lived tokens in the external service.</p>
    pub fn duration_seconds(&self) -> ::std::option::Option<i32> {
        self.duration_seconds
    }
    /// <p>The cryptographic algorithm to use for signing the JSON Web Token (JWT). Valid values are RS256 (RSA with SHA-256) and ES384 (ECDSA using P-384 curve with SHA-384).</p>
    pub fn signing_algorithm(&self) -> ::std::option::Option<&str> {
        self.signing_algorithm.as_deref()
    }
    /// <p>An optional list of tags to include in the JSON Web Token (JWT). These tags are added as custom claims to the JWT and can be used by the downstream service for authorization decisions.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.tags.is_none()`.
    pub fn tags(&self) -> &[crate::types::Tag] {
        self.tags.as_deref().unwrap_or_default()
    }
}
impl GetWebIdentityTokenInput {
    /// Creates a new builder-style object to manufacture [`GetWebIdentityTokenInput`](crate::operation::get_web_identity_token::GetWebIdentityTokenInput).
    pub fn builder() -> crate::operation::get_web_identity_token::builders::GetWebIdentityTokenInputBuilder {
        crate::operation::get_web_identity_token::builders::GetWebIdentityTokenInputBuilder::default()
    }
}

/// A builder for [`GetWebIdentityTokenInput`](crate::operation::get_web_identity_token::GetWebIdentityTokenInput).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct GetWebIdentityTokenInputBuilder {
    pub(crate) audience: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    pub(crate) duration_seconds: ::std::option::Option<i32>,
    pub(crate) signing_algorithm: ::std::option::Option<::std::string::String>,
    pub(crate) tags: ::std::option::Option<::std::vec::Vec<crate::types::Tag>>,
}
impl GetWebIdentityTokenInputBuilder {
    /// Appends an item to `audience`.
    ///
    /// To override the contents of this collection use [`set_audience`](Self::set_audience).
    ///
    /// <p>The intended recipient of the web identity token. This value populates the <code>aud</code> claim in the JWT and should identify the service or application that will validate and use the token. The external service should verify this claim to ensure the token was intended for their use.</p>
    pub fn audience(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        let mut v = self.audience.unwrap_or_default();
        v.push(input.into());
        self.audience = ::std::option::Option::Some(v);
        self
    }
    /// <p>The intended recipient of the web identity token. This value populates the <code>aud</code> claim in the JWT and should identify the service or application that will validate and use the token. The external service should verify this claim to ensure the token was intended for their use.</p>
    pub fn set_audience(mut self, input: ::std::option::Option<::std::vec::Vec<::std::string::String>>) -> Self {
        self.audience = input;
        self
    }
    /// <p>The intended recipient of the web identity token. This value populates the <code>aud</code> claim in the JWT and should identify the service or application that will validate and use the token. The external service should verify this claim to ensure the token was intended for their use.</p>
    pub fn get_audience(&self) -> &::std::option::Option<::std::vec::Vec<::std::string::String>> {
        &self.audience
    }
    /// <p>The duration, in seconds, for which the JSON Web Token (JWT) will remain valid. The value can range from 60 seconds (1 minute) to 3600 seconds (1 hour). If not specified, the default duration is 300 seconds (5 minutes). The token is designed to be short-lived and should be used for proof of identity, then exchanged for credentials or short-lived tokens in the external service.</p>
    pub fn duration_seconds(mut self, input: i32) -> Self {
        self.duration_seconds = ::std::option::Option::Some(input);
        self
    }
    /// <p>The duration, in seconds, for which the JSON Web Token (JWT) will remain valid. The value can range from 60 seconds (1 minute) to 3600 seconds (1 hour). If not specified, the default duration is 300 seconds (5 minutes). The token is designed to be short-lived and should be used for proof of identity, then exchanged for credentials or short-lived tokens in the external service.</p>
    pub fn set_duration_seconds(mut self, input: ::std::option::Option<i32>) -> Self {
        self.duration_seconds = input;
        self
    }
    /// <p>The duration, in seconds, for which the JSON Web Token (JWT) will remain valid. The value can range from 60 seconds (1 minute) to 3600 seconds (1 hour). If not specified, the default duration is 300 seconds (5 minutes). The token is designed to be short-lived and should be used for proof of identity, then exchanged for credentials or short-lived tokens in the external service.</p>
    pub fn get_duration_seconds(&self) -> &::std::option::Option<i32> {
        &self.duration_seconds
    }
    /// <p>The cryptographic algorithm to use for signing the JSON Web Token (JWT). Valid values are RS256 (RSA with SHA-256) and ES384 (ECDSA using P-384 curve with SHA-384).</p>
    /// This field is required.
    pub fn signing_algorithm(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.signing_algorithm = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The cryptographic algorithm to use for signing the JSON Web Token (JWT). Valid values are RS256 (RSA with SHA-256) and ES384 (ECDSA using P-384 curve with SHA-384).</p>
    pub fn set_signing_algorithm(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.signing_algorithm = input;
        self
    }
    /// <p>The cryptographic algorithm to use for signing the JSON Web Token (JWT). Valid values are RS256 (RSA with SHA-256) and ES384 (ECDSA using P-384 curve with SHA-384).</p>
    pub fn get_signing_algorithm(&self) -> &::std::option::Option<::std::string::String> {
        &self.signing_algorithm
    }
    /// Appends an item to `tags`.
    ///
    /// To override the contents of this collection use [`set_tags`](Self::set_tags).
    ///
    /// <p>An optional list of tags to include in the JSON Web Token (JWT). These tags are added as custom claims to the JWT and can be used by the downstream service for authorization decisions.</p>
    pub fn tags(mut self, input: crate::types::Tag) -> Self {
        let mut v = self.tags.unwrap_or_default();
        v.push(input);
        self.tags = ::std::option::Option::Some(v);
        self
    }
    /// <p>An optional list of tags to include in the JSON Web Token (JWT). These tags are added as custom claims to the JWT and can be used by the downstream service for authorization decisions.</p>
    pub fn set_tags(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::Tag>>) -> Self {
        self.tags = input;
        self
    }
    /// <p>An optional list of tags to include in the JSON Web Token (JWT). These tags are added as custom claims to the JWT and can be used by the downstream service for authorization decisions.</p>
    pub fn get_tags(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::Tag>> {
        &self.tags
    }
    /// Consumes the builder and constructs a [`GetWebIdentityTokenInput`](crate::operation::get_web_identity_token::GetWebIdentityTokenInput).
    pub fn build(
        self,
    ) -> ::std::result::Result<crate::operation::get_web_identity_token::GetWebIdentityTokenInput, ::aws_smithy_types::error::operation::BuildError>
    {
        ::std::result::Result::Ok(crate::operation::get_web_identity_token::GetWebIdentityTokenInput {
            audience: self.audience,
            duration_seconds: self.duration_seconds,
            signing_algorithm: self.signing_algorithm,
            tags: self.tags,
        })
    }
}
