/*
************************************************************************
*
*   cmd_tab.h - command table
*
*   Copyright (c) 1994-2001
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 01/07/04
*   Pathname of SCCS file     : /tmp_mnt/net/sn/homeb/rkoradi/molmol-master/src/cip/SCCS/s.cmd_tab.h
*   SCCS identification       : 1.109
*
************************************************************************
*/

#include "cmd_p.h"

#include <cmd_io.h>
#include <cmd_dial.h>
#include <cmd_misc.h>
#include <cmd_help.h>
#include <cmd_attr.h>
#include <cmd_rep.h>
#include <cmd_prop.h>
#include <cmd_prim.h>
#include <cmd_anim.h>
#include <cmd_struc.h>
#include <cmd_calc.h>
#include <cmd_fig.h>

static CmdTabEntry BuiltinCmdTab[] = {
  {"AddAco", ExAddAco, US_ALL},
  {"AddAngle", ExAddAngle, US_ALL},
  {"AddAtom", ExAddAtom, US_ALL},
  {"AddBond", ExAddBond, US_ALL},
  {"AddCircles", ExAddCircles, US_ALL},
  {"AddCylinder", ExAddCylinder, US_ALL},
  {"AddDipole", ExAddDipole, US_ALL},
  {"AddDist", ExAddDist, US_ALL},
  {"AddDrawobj", ExAddDrawobj, US_ALL},
  {"AddHbond", ExAddDist, US_ALL},
  {"AddIsosurface", ExAddIsosurface, US_ALL},
  {"AddLol", ExAddLimit, US_ALL},
  {"AddPlates", ExAddPlates, US_ALL},
  {"AddPseudo", ExAddPseudo, US_ALL},
  {"AddRes", ExAddRes, US_ALL},
  {"AddRibbon", ExAddRibbon, US_ALL},
  {"AddSheet", ExAddSheet, US_ALL},
  {"AddSolid", ExAddSolid, US_ALL},
  {"AddSurface", ExAddSurface, US_ALL},
  {"AddText", ExAddText, US_ALL},
  {"AddTitle", ExAddTitle, US_ALL},
  {"AddTrajec", ExAddTrajec, US_ALL},
  {"AddUpl", ExAddLimit, US_ALL},
  {"AttrAtom", ExAttr, US_NONE},
  {"AttrBond", ExAttr, US_NONE},
  {"AttrDist", ExAttr, US_NONE},
  {"AttrInit", ExAttr, US_NONE},
  {"AttrPrim", ExAttr, US_NONE},
  {"AutoScale", ExAutoScale, US_ALL},
  {"BackColor", ExBackColor, US_PAR},
  {"BondMode", ExBondMode, US_PAR},
  {"CalcAngle", ExCalcAngle, US_NONE},
  {"CalcAtom", ExCalcAtom, US_ALL},
  {"CalcAxis", ExCalcAxis, US_NONE},
  {"CalcBond", ExCalcBond, US_ALL},
  {"CalcCluster", ExCalcCluster, US_ALL},
  {"CalcDist", ExCalcDist, US_ALL},
  {"CalcHbond", ExCalcHbond, US_ALL},
  {"CalcHelix", ExCalcHelix, US_NONE},
  {"CalcMatch", ExCalcMatch, US_ALL},
  {"CalcPot", ExCalcPot, US_NONE},
  {"CalcRmsd", ExCalcRmsd, US_NONE},
  {"CalcSecondary", ExCalcSecondary, US_ALL},
  {"CalcShift", ExCalcShift, US_NONE},
  {"CalcSurface", ExCalcSurface, US_NONE},
  {"CalcVdw", ExCalcVdw, US_ALL},
  {"Center", ExCenter, US_ALL},
  {"ChangeRes", ExChangeRes, US_ALL},
  {"CheckAco", ExCheckAco, US_NONE},
  {"CheckBond", ExCheckBond, US_ALL},
  {"CheckLol", ExCheckLimit, US_NONE},
  {"CheckUpl", ExCheckLimit, US_NONE},
  {"ClipPos", ExClip, US_PAR},
  {"ClipSize", ExClip, US_PAR},
  {"ColorAtom", ExColor, US_ALL},
  {"ColorBond", ExColor, US_ALL},
  {"ColorDist", ExColor, US_ALL},
  {"ColorInit", ExColor, US_ALL},
  {"ColorPrim", ExColor, US_ALL},
  {"DefPropAngle", ExDefProp, US_ALL},
  {"DefPropAtom", ExDefProp, US_ALL},
  {"DefPropBond", ExDefProp, US_ALL},
  {"DefPropDist", ExDefProp, US_ALL},
  {"DefPropMol", ExDefProp, US_ALL},
  {"DefPropPrim", ExDefProp, US_ALL},
  {"DefPropRes", ExDefProp, US_ALL},
  {"DialColor", ExDialColor, US_NONE},
  {"DialMeasure", ExDialMeasure, US_NONE},
  {"DialMol", ExDialMol, US_NONE},
  {"DialRmsd", ExDialRmsd, US_NONE},
  {"DialSelect", ExDialSelect, US_NONE},
  {"DialStyle", ExDialStyle, US_NONE},
  {"DrawDelay", ExDrawDelay, US_PAR},
  {"DrawPrec", ExDrawPrec, US_PAR},
  {"DrawSize", ExDrawSize, US_PAR},
  {"EditText", ExEditText, US_ALL},
  {"FigAngles", ExFigAngles, US_NONE},
  {"FigCircles", ExFigCircles, US_NONE},
  {"FigContact", ExFigContact, US_NONE},
  {"FigDist", ExFigDist, US_NONE},
  {"FigLimit", ExFigLimit, US_NONE},
  {"FigOff", ExFigOff, US_NONE},
  {"FigRamach", ExFigRamach, US_NONE},
  {"FirstMol", ExFirstMol, US_ALL},
  {"Fit", ExFit, US_ALL},
  {"FlipAtom", ExFlipAtom, US_ALL},
  {"Fog", ExFog, US_PAR},
  {"Fullscreen", ExFullscreen, US_PAR},
  {"Group", ExGroup, US_ALL},
  {"HelpAbout", ExHelpAbout, US_NONE},
  {"HelpApropos", ExHelpApropos, US_NONE},
  {"HelpButton", ExHelpButton, US_NONE},
  {"HelpCmd", ExHelpCmd, US_NONE},
  {"HelpIndex", ExHelpHtml, US_NONE},
  {"HelpManual", ExHelpHtml, US_NONE},
  {"HelpMouse", ExHelpMouse, US_NONE},
  {"HelpProp", ExHelpProp, US_NONE},
  {"HelpTip", ExHelpTip, US_NONE},
  {"HelpTutorial", ExHelpHtml, US_NONE},
  {"HelpViewer", ExHelpViewer, US_PAR},
  {"InitAll", ExInitAll, US_ALL},
  {"LabelAtom", ExLabelAtom, US_ALL},
  {"LabelDist", ExLabelDist, US_ALL},
  {"LabelInit", ExLabelInit, US_ALL},
  {"LengthBond", ExLengthBond, US_ALL},
  {"LengthPrim", ExLengthPrim, US_ALL},
  {"Light", ExLight, US_PAR},
  {"LineAtom", ExLine, US_ALL},
  {"LineBond", ExLine, US_ALL},
  {"LineDist", ExLine, US_ALL},
  {"LineInit", ExLine, US_ALL},
  {"LinePrim", ExLine, US_ALL},
  {"ListPropAngle", ExListProp, US_NONE},
  {"ListPropAtom", ExListProp, US_NONE},
  {"ListPropBond", ExListProp, US_NONE},
  {"ListPropDist", ExListProp, US_NONE},
  {"ListPropMol", ExListProp, US_NONE},
  {"ListPropPrim", ExListProp, US_NONE},
  {"ListPropRes", ExListProp, US_NONE},
  {"ListSelectedAngle", ExListSelected, US_NONE},
  {"ListSelectedAtom", ExListSelected, US_NONE},
  {"ListSelectedBond", ExListSelected, US_NONE},
  {"ListSelectedDist", ExListSelected, US_NONE},
  {"ListSelectedMol", ExListSelected, US_NONE},
  {"ListSelectedRes", ExListSelected, US_NONE},
  {"MaterialAtom", ExMaterial, US_ALL},
  {"MaterialBond", ExMaterial, US_ALL},
  {"MaterialDist", ExMaterial, US_ALL},
  {"MaterialInit", ExMaterial, US_ALL},
  {"MaterialPrim", ExMaterial, US_ALL},
  {"MeanMol", ExMeanMol, US_ALL},
  {"MoveDrawobj", ExMoveDrawobj, US_ALL},
  {"MoveInit", ExMoveInit, US_ALL},
  {"MovePrim", ExMovePrim, US_ALL},
  {"MoveX", ExMove, US_ALL},
  {"MoveY", ExMove, US_ALL},
  {"MoveZ", ExMove, US_ALL},
  {"NameMol", ExNameMol, US_ALL},
  {"NearPrim", ExNear, US_ALL},
  {"NewMol", ExNewMol, US_ALL},
  {"PaintRibbon", ExPaintRibbon, US_ALL},
  {"PaintSurface", ExPaintSurface, US_ALL},
  {"PathNames", ExPathNames, US_PAR},
  {"PlotBmp", ExPlotDump, US_NONE},
  {"PlotFm3", ExPlot, US_NONE},
  {"PlotFm4", ExPlot, US_NONE},
  {"PlotJpeg", ExPlotDump, US_NONE},
  {"PlotMeta", ExPlotDump, US_NONE},
  {"PlotMpov", ExPlot, US_NONE},
  {"PlotPar", ExPlotPar, US_PAR},
  {"PlotPng", ExPlotDump, US_NONE},
  {"PlotPov", ExPlot, US_NONE},
  {"PlotPs", ExPlot, US_NONE},
  {"PlotRib", ExPlot, US_NONE},
  {"PlotTiff", ExPlotDump, US_NONE},
  {"PlotUnit", ExPlotUnit, US_PAR},
  {"PlotVrml1", ExPlot, US_NONE},
  {"PlotVrml2", ExPlot, US_NONE},
  {"Projection", ExProjection, US_PAR},
  {"Quit", ExQuit, US_NONE},
  {"RadiusAtom", ExRadius, US_ALL},
  {"RadiusBond", ExRadius, US_ALL},
  {"RadiusDist", ExRadius, US_ALL},
  {"RadiusInit", ExRadius, US_ALL},
  {"RadiusPrim", ExRadius, US_ALL},
  {"ReadAco", ExReadAco, US_ALL},
  {"ReadAng", ExReadAng, US_ALL},
  {"ReadDg", ExReadDg, US_ALL},
  {"ReadDump", ExReadDump, US_ALL},
  {"ReadLib", ExReadLib, US_ALL},
  {"ReadListAng", ExReadListAng, US_ALL},
  {"ReadListDg", ExReadListDg, US_ALL},
  {"ReadListPdb", ExReadListPdb, US_ALL},
  {"ReadLol", ExReadLimit, US_ALL},
  {"ReadOmap", ExReadOmap, US_ALL},
  {"ReadPdb", ExReadPdb, US_ALL},
  {"ReadPot", ExReadPot, US_ALL},
  {"ReadSeq", ExReadSeq, US_ALL},
  {"ReadShift", ExReadShift, US_ALL},
  {"ReadSybyl", ExReadSybyl, US_ALL},
  {"ReadUpl", ExReadLimit, US_ALL},
  {"ReadXyz", ExReadXyz, US_ALL},
  {"RecordMac", ExRecordMac, US_NONE},
  {"Register", ExRegister, US_NONE},
  {"RemoveAco", ExRemoveAco, US_ALL},
  {"RemoveAngle", ExRemoveAngle, US_ALL},
  {"RemoveAtom", ExRemoveAtom, US_ALL},
  {"RemoveBond", ExRemoveBond, US_ALL},
  {"RemoveDist", ExRemoveDist, US_ALL},
  {"RemoveMol", ExRemoveMol, US_ALL},
  {"RemovePrim", ExRemovePrim, US_ALL},
  {"RemoveRes", ExRemoveRes, US_ALL},
  {"Rendering", ExRendering, US_PAR},
  {"ReplaceDg", ExReadDg, US_ALL},
  {"ReplaceListDg", ExReadListDg, US_ALL},
  {"ReplaceListPdb", ExReadListPdb, US_ALL},
  {"ReplacePdb", ExReadPdb, US_ALL},
  {"RotateAngle", ExRotateAngle, US_ALL},
  {"RotateInit", ExRotateInit, US_ALL},
  {"RotateX", ExRotate, US_ALL},
  {"RotateY", ExRotate, US_ALL},
  {"RotateZ", ExRotate, US_ALL},
  {"SelectAngle", ExSelect, US_ALL},
  {"SelectAtom", ExSelect, US_ALL},
  {"SelectBond", ExSelect, US_ALL},
  {"SelectDist", ExSelect, US_ALL},
  {"SelectMol", ExSelect, US_ALL},
  {"SelectPrim", ExSelect, US_ALL},
  {"SelectRes", ExSelect, US_ALL},
  {"SetAngle", ExSetAngle, US_ALL},
  {"SetNeigh", ExSetNeigh, US_ALL},
  {"SetRef", ExSetRef, US_NONE},
  {"SetUndo", ExSetUndo, US_PAR},
  {"ShadeAtom", ExShade, US_ALL},
  {"ShadeBond", ExShade, US_ALL},
  {"ShadeDist", ExShade, US_ALL},
  {"ShadePrim", ExShade, US_ALL},
  {"SizePlate", ExSizePlate, US_ALL},
  {"SizeRibbon", ExSizeRibbon, US_ALL},
  {"SizeText", ExFontSize, US_ALL},
  {"SplitRibbon", ExSplitRibbon, US_ALL},
  {"StartAnim", ExStartAnim, US_NONE},
  {"StartRock", ExStartRock, US_NONE},
  {"Stereo", ExStereo, US_PAR},
  {"StopAnim", ExStopAnim, US_NONE},
  {"StopRock", ExStopRock, US_NONE},
  {"StyleAtom", ExStyleAtom, US_ALL},
  {"StyleBond", ExStyleBond, US_ALL},
  {"StyleCylinder", ExStyleCylinder, US_ALL},
  {"StyleDist", ExStyleDist, US_ALL},
  {"StyleDrawobj", ExStyleDrawobj, US_ALL},
  {"StyleInit", ExStyleInit, US_ALL},
  {"StyleMap", ExStyleMap, US_ALL},
  {"StyleRibbon", ExStyleRibbon, US_ALL},
  {"StyleTrajec", ExStyleTrajec, US_ALL},
  {"System", ExSystem, US_NONE},
  {"TextureAtom", ExTexture, US_ALL},
  {"TextureBond", ExTexture, US_ALL},
  {"TextureDist", ExTexture, US_ALL},
  {"TextureInit", ExTexture, US_ALL},
  {"TexturePrim", ExTexture, US_ALL},
  {"TintDist", ExColor, US_ALL},
  {"TintInit", ExColor, US_ALL},
  {"TintPrim", ExColor, US_ALL},
  {"TrimSurface", ExTrimSurface, US_ALL},
  {"TypeRibbon", ExTypeRibbon, US_ALL},
  {"UndefProp", ExUndefProp, US_ALL},
  {"Undo", ExUndo, US_LEAVE},
  {"UserInterface", ExUserInterface, US_PAR},
  {"ViewAngle", ExViewAngle, US_PAR},
  {"WriteAng", ExWriteAng, US_NONE},
  {"WriteDg", ExWriteDg, US_NONE},
  {"WriteDump", ExWriteDump, US_NONE},
  {"WriteLib", ExWriteLib, US_NONE},
  {"WriteLol", ExWriteLimit, US_NONE},
  {"WritePdb", ExWritePdb, US_NONE},
  {"WriteSecondary", ExWriteSecondary, US_NONE},
  {"WriteSeq", ExWriteSeq, US_NONE},
  {"WriteTransform", ExWriteTransform, US_NONE},
  {"WriteUpl", ExWriteLimit, US_NONE},
  {"XMacStand", ExXMac, US_ALL},
  {"XMacUser", ExXMac, US_ALL},
  {"ZoomAbs", ExZoom, US_PAR},
  {"ZoomRel", ExZoom, US_PAR}
};
