/* i386-linux.elf.shell-entry.h
   created from i386-linux.elf.shell-entry.bin, 25004 (0x61ac) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) Markus Franz Xaver Johannes Oberhumer
   Copyright (C) Laszlo Molnar
   Copyright (C) John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */

/* clang-format off */

#define STUB_I386_LINUX_ELF_SHELL_ENTRY_SIZE    25004
#define STUB_I386_LINUX_ELF_SHELL_ENTRY_ADLER32 0x1ebc0d2d
#define STUB_I386_LINUX_ELF_SHELL_ENTRY_CRC32   0x1dae285f

unsigned char stub_i386_linux_elf_shell_entry[25004] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0,  3,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */  24, 33,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,
/* 0x0030 */   0,  0,  0,  0,232,252,255,255,255, 96,252,139,116, 36, 36,139,
/* 0x0040 */ 124, 36, 44,131,205,255,235,  3,164,235,  3,138,  6, 70,136,  7,
/* 0x0050 */  71,  1,219,117,  7,139, 30,131,238,252, 17,219,114,  1, 49,192,
/* 0x0060 */  64,138,  7,114,255,184,  1,  0,  0,  0,  1,219,117,  7,139, 30,
/* 0x0070 */ 131,238,252, 17,219, 17,192,  1,219,117,  7,139, 30,131,238,252,
/* 0x0080 */  17,219,115,255,  1,219,115,255,117,  9,139, 30,131,238,252, 17,
/* 0x0090 */ 219,115,255, 49,201,131,232,  3,114, 13,193,224,  8,138,  6, 70,
/* 0x00a0 */ 131,240,255,116,255,137,197,  1,219,117,  7,139, 30,131,238,252,
/* 0x00b0 */  17,219, 17,201,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,
/* 0x00c0 */ 201,117,255, 65,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,
/* 0x00d0 */ 201,  1,219,117,  7,139, 30,131,238,252, 17,219,115, 48,  1,219,
/* 0x00e0 */ 115, 48,117,  9,139, 30,131,238,252, 17,219,115, 48, 65, 65,131,
/* 0x00f0 */ 193,  2,129,253,  0,243,255,255,131,209,  1, 86,141, 52, 47,243,
/* 0x0100 */ 164, 94,233,252,255,255,255,141, 20, 47,131,253,252,138,  4, 15,
/* 0x0110 */ 118,255,138,  2, 66,136,  7, 71, 73,117,247,233,252,255,255,255,
/* 0x0120 */ 139,  2,131,194,  4,137,  7,131,199,  4,131,233,  4,119,241,  1,
/* 0x0130 */ 207,233,252,255,255,255,235,  3,164,235,  3,138,  6, 70,136,  7,
/* 0x0140 */  71,  1,219,117,  7,139, 30,131,238,252, 17,219,114,  1, 49,192,
/* 0x0150 */  64,138,  7,114,255,184,  1,  0,  0,  0,  1,219,117,  7,139, 30,
/* 0x0160 */ 131,238,252, 17,219, 17,192,  1,219,117,  7,139, 30,131,238,252,
/* 0x0170 */  17,219,114, 15,  1,219,115, 11,117, 15,139, 30,131,238,252, 17,
/* 0x0180 */ 219,114, 15, 72,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,
/* 0x0190 */ 192,235,255, 49,201,131,232,  3,114, 17,193,224,  8,138,  6, 70,
/* 0x01a0 */ 131,240,255,116,255,209,248,137,197,235, 11,  1,219,117,  7,139,
/* 0x01b0 */  30,131,238,252, 17,219, 17,201,  1,219,117,  7,139, 30,131,238,
/* 0x01c0 */ 252, 17,219, 17,201,117,255, 65,  1,219,117,  7,139, 30,131,238,
/* 0x01d0 */ 252, 17,219, 17,201,  1,219,117,  7,139, 30,131,238,252, 17,219,
/* 0x01e0 */ 115, 68,  1,219,115, 68,117,  9,139, 30,131,238,252, 17,219,115,
/* 0x01f0 */  68, 65, 65,131,193,  2,129,253,  0,251,255,255,131,209,  1, 86,
/* 0x0200 */ 141, 52, 47,243,164, 94,233,252,255,255,255,141, 20, 47,131,253,
/* 0x0210 */ 252,138,  4, 15,118,255,138,  2, 66,136,  7, 71, 73,117,247,233,
/* 0x0220 */ 252,255,255,255,139,  2,131,194,  4,137,  7,131,199,  4,131,233,
/* 0x0230 */   4,119,241,  1,207,233,252,255,255,255,235,  3,164,235,  3,138,
/* 0x0240 */   6, 70,136,  7, 71,  1,219,117,  7,139, 30,131,238,252, 17,219,
/* 0x0250 */ 114,  1, 49,192, 64,138,  7,114,255,184,  1,  0,  0,  0,  1,219,
/* 0x0260 */ 117,  7,139, 30,131,238,252, 17,219, 17,192,  1,219,117,  7,139,
/* 0x0270 */  30,131,238,252, 17,219,114, 30,  1,219,115, 11,117, 30,139, 30,
/* 0x0280 */ 131,238,252, 17,219,114, 30, 72,  1,219,117,  7,139, 30,131,238,
/* 0x0290 */ 252, 17,219, 17,192,235,255,  1,219,117,  7,139, 30,131,238,252,
/* 0x02a0 */  17,219, 17,201,235,255, 49,201,131,232,  3,114, 17,193,224,  8,
/* 0x02b0 */ 138,  6, 70,131,240,255,116,255,209,248,137,197,235, 11,  1,219,
/* 0x02c0 */ 117,  7,139, 30,131,238,252, 17,219,114,204, 65,  1,219,117,  7,
/* 0x02d0 */ 139, 30,131,238,252, 17,219,114,190,  1,219,117,  7,139, 30,131,
/* 0x02e0 */ 238,252, 17,219, 17,201,  1,219,117,  7,139, 30,131,238,252, 17,
/* 0x02f0 */ 219,115, 81,  1,219,115, 81,117,  9,139, 30,131,238,252, 17,219,
/* 0x0300 */ 115, 81, 65, 65,131,193,  2,129,253,  0,251,255,255,131,209,  2,
/* 0x0310 */  86,141, 52, 47,243,164, 94,233,252,255,255,255,141, 20, 47,131,
/* 0x0320 */ 253,252,138,  4, 15,118,255,138,  2, 66,136,  7, 71, 73,117,247,
/* 0x0330 */ 233,252,255,255,255,139,  2,131,194,  4,137,  7,131,199,  4,131,
/* 0x0340 */ 233,  4,119,241,  1,207,233,252,255,255,255,255,210,  1,219,117,
/* 0x0350 */   2,255,210,144,232,252,255,255,255,  1,219,116,255,195,139, 30,
/* 0x0360 */ 131,238,252, 17,219,195, 41,201, 17,201,114, 11, 17,201,114,  6,
/* 0x0370 */  17,201, 17,192, 72, 17,192,131,233,  1,115,  1,141, 72, 15, 61,
/* 0x0380 */ 240,255,  0,  0,114, 14,141,  4, 14, 80,233, 14,  0,  0,  0, 17,
/* 0x0390 */ 201, 17,201,131,193, 13,235,  1,133,201,116, 25, 65,131,193,  8,
/* 0x03a0 */ 235,  1, 41,201, 90, 41,219,141, 65,  1,115, 22,114, 21,114, 20,
/* 0x03b0 */ 114, 19,131,193,  2,114,  6, 65,114,  5,233,252,255,255,255, 17,
/* 0x03c0 */ 201,209,233,115,  1,164,209,233,115,  2,102,165,243,165,141, 65,
/* 0x03d0 */   1,235,  3,164,164,164, 17,192,115, 22,131,232,  3,114, 11,193,
/* 0x03e0 */ 224,  8,172,131,240,255,116, 50,137,197, 17,201, 17,201,117,255,
/* 0x03f0 */  65, 17,201,115,  0,131,193,  2,129,253,  0,243,255,255,131,209,
/* 0x0400 */   1, 86,141, 52, 47,131,253,252,119, 19,209,233,115,  1,164,209,
/* 0x0410 */ 233,115,  2,102,165,243,165, 94,233,252,255,255,255,131,253,255,
/* 0x0420 */ 117,  5,172,243,170,235,240,243,164,235,236,137,229,141,156, 36,
/* 0x0430 */   0,  0,  0,  0, 49,192, 80, 57,220,117,251, 70, 70, 83,104,  0,
/* 0x0440 */   0,  0,  0, 87,131,195,  4, 83,104,  0,  0,  0,  0, 86,131,195,
/* 0x0450 */   4, 83, 80,199,  3,  0,  0,  0,  0,137,229,139, 85,  0,172, 74,
/* 0x0460 */ 136,193, 36,  7,192,233,  3,187,  0,253,255,255,211,227,141,164,
/* 0x0470 */  92,144,241,255,255,131,228,224,106,  0,106,  0,137,227, 83,131,
/* 0x0480 */ 195,  4,139, 77,  0,255, 49, 87, 83,131,195,  4,136, 67,  2,172,
/* 0x0490 */  74,136,193, 36, 15,136,  3,192,233,  4,136, 75,  1, 82, 86, 83,
/* 0x04a0 */  80, 85, 87,191,  0,  0,  0,  0, 86, 83,131,236,100,139, 84, 36,
/* 0x04b0 */ 120,199, 68, 36, 92,  0,  0,  0,  0,141, 66,  4,137, 68, 36, 96,
/* 0x04c0 */ 184,  1,  0,  0,  0, 15,182, 74,  2,137,195,211,227,137,217, 73,
/* 0x04d0 */ 137, 76, 36, 88, 15,182, 74,  1,211,224,139,140, 36,144,  0,  0,
/* 0x04e0 */   0, 72,137, 68, 36, 84,139,132, 36,132,  0,  0,  0, 15,182, 50,
/* 0x04f0 */ 199, 68, 36, 76,  0,  0,  0,  0,199,  0,  0,  0,  0,  0,184,  0,
/* 0x0500 */   3,  0,  0,199, 68, 36, 72,  1,  0,  0,  0,137,116, 36, 80,199,
/* 0x0510 */  68, 36, 68,  1,  0,  0,  0,199, 68, 36, 64,  1,  0,  0,  0,199,
/* 0x0520 */  68, 36, 60,  1,  0,  0,  0,199,  1,  0,  0,  0,  0, 15,182, 74,
/* 0x0530 */   1,  1,241,211,224,141,136, 54,  7,  0,  0, 57, 76, 36, 92,115,
/* 0x0540 */  14,139, 68, 36, 96,102,199,  0,  0,  4,131,192,  2,226,246,139,
/* 0x0550 */ 108, 36,124,199, 68, 36, 48,  0,  0,  0,  0,199, 68, 36, 52,255,
/* 0x0560 */ 255,255,255,186,  0,  0,  0,  0,137,235,  3,156, 36,128,  0,  0,
/* 0x0570 */   0,137, 92, 36, 56, 59,108, 36, 56, 15,132,128,  8,  0,  0,193,
/* 0x0580 */ 100, 36, 48,  8, 66, 15,182, 69,  0, 69,  9, 68, 36, 48,131,250,
/* 0x0590 */   4,126,226,139,180, 36,140,  0,  0,  0, 57,116, 36, 92, 15,131,
/* 0x05a0 */ 226,  1,  0,  0,139,132, 36,136,  0,  0,  0,137, 68, 36, 24,139,
/* 0x05b0 */  84, 36, 92, 35, 84, 36, 88,139, 68, 36, 76,139, 76, 36, 96,193,
/* 0x05c0 */ 224,  4,137, 84, 36, 44,  1,208,129,124, 36, 52,255,255,255,  0,
/* 0x05d0 */ 141, 52, 65,119, 29, 59,108, 36, 56, 15,132, 32,  8,  0,  0,193,
/* 0x05e0 */ 100, 36, 48,  8,193,100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68,
/* 0x05f0 */  36, 48,139, 68, 36, 52,102,139, 22,193,232, 11, 15,183,202, 15,
/* 0x0600 */ 175,193, 57, 68, 36, 48, 15,131, 80,  2,  0,  0,137, 68, 36, 52,
/* 0x0610 */ 184,  0,  8,  0,  0, 41,200,138, 76, 36, 80,193,248,  5,187,  1,
/* 0x0620 */   0,  0,  0,141,  4,  2,102,137,  6,139, 68, 36, 92, 35, 68, 36,
/* 0x0630 */  84,139,116, 36, 96,211,224,137,249, 15,182,209,185,  8,  0,  0,
/* 0x0640 */   0, 43, 76, 36, 80,211,250,  1,208,105,192,  0,  6,  0,  0,131,
/* 0x0650 */ 124, 36, 76,  6,141,132, 48,108, 14,  0,  0,137, 68, 36, 20, 15,
/* 0x0660 */ 142, 72,  1,  0,  0,139, 68, 36, 92, 43, 68, 36, 72,139,148, 36,
/* 0x0670 */ 136,  0,  0,  0, 15,182,  4, 16,137, 68, 36, 40,235, 46,137, 68,
/* 0x0680 */  36, 52,184,  0,  8,  0,  0, 41,216,137,251,193,248,  5,133,210,
/* 0x0690 */ 141,  4,  1,102,137,134,  0,  2,  0,  0, 15,133,106,  1,  0,  0,
/* 0x06a0 */ 129,251,255,  0,  0,  0, 15,143,143,  0,  0,  0,209,100, 36, 40,
/* 0x06b0 */ 139, 84, 36, 40,141, 60, 27,139, 76, 36, 20,129,226,  0,  1,  0,
/* 0x06c0 */   0,129,124, 36, 52,255,255,255,  0,141,  4, 81,141, 52, 56,119,
/* 0x06d0 */  29, 59,108, 36, 56, 15,132, 36,  7,  0,  0,193,100, 36, 48,  8,
/* 0x06e0 */ 193,100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,139, 68,
/* 0x06f0 */  36, 52,102,139,142,  0,  2,  0,  0,193,232, 11, 15,183,217, 15,
/* 0x0700 */ 175,195, 57, 68, 36, 48, 15,130,114,255,255,255, 41, 68, 36, 52,
/* 0x0710 */  41, 68, 36, 48,137,200,102,193,232,  5,141, 95,  1,102, 41,193,
/* 0x0720 */ 133,210,102,137,142,  0,  2,  0,  0, 15,132,219,  0,  0,  0,129,
/* 0x0730 */ 251,255,  0,  0,  0, 15,142,113,255,255,255,139, 84, 36, 24,137,
/* 0x0740 */ 223,136, 26, 66,255, 68, 36, 92,131,124, 36, 76,  3,137, 84, 36,
/* 0x0750 */  24, 15,143,215,  0,  0,  0,199, 68, 36, 76,  0,  0,  0,  0,139,
/* 0x0760 */ 132, 36,140,  0,  0,  0, 57, 68, 36, 92, 15,130, 63,254,255,255,
/* 0x0770 */ 129,124, 36, 52,255,255,255,  0,119, 12, 59,108, 36, 56,184,  1,
/* 0x0780 */   0,  0,  0,116, 32, 69, 43,108, 36,124,184,  0,  0,  0,  0,139,
/* 0x0790 */ 148, 36,132,  0,  0,  0,139, 92, 36, 92,139,140, 36,144,  0,  0,
/* 0x07a0 */   0,137, 42,137, 25,131,196,100,233, 46,  8,  0,  0,129,124, 36,
/* 0x07b0 */  52,255,255,255,  0,141, 52, 27,139, 68, 36, 20,141, 28,  6,119,
/* 0x07c0 */  29, 59,108, 36, 56, 15,132, 52,  6,  0,  0,193,100, 36, 48,  8,
/* 0x07d0 */ 193,100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,139, 68,
/* 0x07e0 */  36, 52,102,139, 11,193,232, 11, 15,183,209, 15,175,194, 57, 68,
/* 0x07f0 */  36, 48,115, 79,137, 68, 36, 52,184,  0,  8,  0,  0, 41,208,193,
/* 0x0800 */ 248,  5,141,  4,  1,102,137,  3,137,243,129,251,255,  0,  0,  0,
/* 0x0810 */ 126,155,139, 84, 36, 24,137,223,136, 26, 66,255, 68, 36, 92,131,
/* 0x0820 */ 124, 36, 76,  3,137, 84, 36, 24, 15,142, 41,255,255,255,131,124,
/* 0x0830 */  36, 76,  9, 15,143,107,  6,  0,  0,131,108, 36, 76,  3,233, 28,
/* 0x0840 */ 255,255,255, 41, 68, 36, 52, 41, 68, 36, 48,137,200,102,193,232,
/* 0x0850 */   5,102, 41,193,102,137, 11,141, 94,  1,235,174,139, 92, 36, 52,
/* 0x0860 */  41, 68, 36, 48, 41,195,137,208,102,193,232,  5,139, 76, 36, 76,
/* 0x0870 */ 102, 41,194,129,251,255,255,255,  0,102,137, 22,139,116, 36, 96,
/* 0x0880 */ 141, 60, 78,119, 27, 59,108, 36, 56, 15,132,112,  5,  0,  0,193,
/* 0x0890 */ 100, 36, 48,  8, 15,182, 69,  0,193,227,  8,  9, 68, 36, 48, 69,
/* 0x08a0 */ 102,139,151,128,  1,  0,  0,137,216,193,232, 11, 15,183,202, 15,
/* 0x08b0 */ 175,193, 57, 68, 36, 48, 15,131,228,  2,  0,  0,137,198,184,  0,
/* 0x08c0 */   8,  0,  0, 41,200,139, 92, 36, 96,193,248,  5,131,124, 36, 76,
/* 0x08d0 */   6,141,  4,  2,139, 76, 36, 72,139, 84, 36, 68,102,137,135,128,
/* 0x08e0 */   1,  0,  0,139, 68, 36, 64,137, 76, 36, 68,137, 68, 36, 60,184,
/* 0x08f0 */   0,  0,  0,  0, 15,159,192,137, 84, 36, 64,141,  4, 64,129,195,
/* 0x0900 */ 100,  6,  0,  0,137, 68, 36, 76,129,254,255,255,255,  0,119, 27,
/* 0x0910 */  59,108, 36, 56, 15,132,229,  4,  0,  0,193,100, 36, 48,  8, 15,
/* 0x0920 */ 182, 69,  0,193,230,  8,  9, 68, 36, 48, 69,102,139, 19,137,240,
/* 0x0930 */ 193,232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48, 15,131,102,
/* 0x0940 */   3,  0,  0,137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,193,100,
/* 0x0950 */  36, 44,  4,193,248,  5,139, 76, 36, 44,141,  4,  2,199, 68, 36,
/* 0x0960 */  32,  0,  0,  0,  0,102,137,  3,141, 92, 25,  4,137, 92, 36, 16,
/* 0x0970 */ 199, 68, 36, 36,  3,  0,  0,  0,139,124, 36, 36,186,  1,  0,  0,
/* 0x0980 */   0,235, 25,137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,193,248,
/* 0x0990 */   5, 79,141,  4,  2,137,242,102,137,  3,116, 97,129,124, 36, 52,
/* 0x09a0 */ 255,255,255,  0,141, 52, 18,139, 68, 36, 16,141, 28,  6,119, 29,
/* 0x09b0 */  59,108, 36, 56, 15,132, 69,  4,  0,  0,193,100, 36, 48,  8,193,
/* 0x09c0 */ 100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,139, 68, 36,
/* 0x09d0 */  52,102,139, 19,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36,
/* 0x09e0 */  48,114,160, 41, 68, 36, 52, 41, 68, 36, 48,137,208,102,193,232,
/* 0x09f0 */   5,102, 41,194, 79,102,137, 19,141, 86,  1,117,159,138, 76, 36,
/* 0x0a00 */  36,184,  1,  0,  0,  0,211,224, 41,194,  3, 84, 36, 32,131,124,
/* 0x0a10 */  36, 76,  3,137, 84, 36, 12, 15,143,254,  3,  0,  0,131, 68, 36,
/* 0x0a20 */  76,  7,131,250,  3,137,208,126,  5,184,  3,  0,  0,  0,139, 92,
/* 0x0a30 */  36, 96,193,224,  7,191,  6,  0,  0,  0,141,132, 24, 96,  3,  0,
/* 0x0a40 */   0,137, 68, 36,  8,184,  1,  0,  0,  0,235, 25,137, 68, 36, 52,
/* 0x0a50 */ 184,  0,  8,  0,  0, 41,200,193,248,  5, 79,141,  4,  2,102,137,
/* 0x0a60 */   3,137,240,116, 97,129,124, 36, 52,255,255,255,  0,141, 52,  0,
/* 0x0a70 */ 139, 68, 36,  8,141, 28,  6,119, 29, 59,108, 36, 56, 15,132,124,
/* 0x0a80 */   3,  0,  0,193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182, 69,
/* 0x0a90 */   0, 69,  9, 68, 36, 48,139, 68, 36, 52,102,139, 19,193,232, 11,
/* 0x0aa0 */  15,183,202, 15,175,193, 57, 68, 36, 48,114,160, 41, 68, 36, 52,
/* 0x0ab0 */  41, 68, 36, 48,137,208,102,193,232,  5,102, 41,194, 79,102,137,
/* 0x0ac0 */  19,141, 70,  1,117,159,141, 80,192,131,250,  3,137, 84, 36,  4,
/* 0x0ad0 */  15,142, 54,  3,  0,  0,137,211,137,208,131,227,  1,209,248,131,
/* 0x0ae0 */ 203,  2,131,250, 13,141,120,255, 15,143, 66,  4,  0,  0,137,249,
/* 0x0af0 */ 139,116, 36, 96,211,227,  1,210,141,  4, 94,137, 92, 36,  4, 41,
/* 0x0b00 */ 208,  5, 94,  5,  0,  0,137,  4, 36,184,  1,  0,  0,  0,199, 68,
/* 0x0b10 */  36, 28,  1,  0,  0,  0,235, 33,137, 68, 36, 52,184,  0,  8,  0,
/* 0x0b20 */   0, 41,200,193,248,  5,141,  4,  2,102,137,  3,137,240,209,100,
/* 0x0b30 */  36, 28, 79, 15,132,211,  2,  0,  0,129,124, 36, 52,255,255,255,
/* 0x0b40 */   0,141, 52,  0,139, 12, 36,141, 28, 14,119, 29, 59,108, 36, 56,
/* 0x0b50 */  15,132,169,  2,  0,  0,193,100, 36, 48,  8,193,100, 36, 52,  8,
/* 0x0b60 */  15,182, 69,  0, 69,  9, 68, 36, 48,139, 68, 36, 52,102,139, 19,
/* 0x0b70 */ 193,232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48,114,153, 41,
/* 0x0b80 */  68, 36, 52, 41, 68, 36, 48,137,208,102,193,232,  5,102, 41,194,
/* 0x0b90 */ 141, 70,  1,102,137, 19,139, 92, 36, 28,  9, 92, 36,  4,235,142,
/* 0x0ba0 */  41,195, 41, 68, 36, 48,137,208,102,193,232,  5,102, 41,194,129,
/* 0x0bb0 */ 251,255,255,255,  0,102,137,151,128,  1,  0,  0, 15,134,107,  1,
/* 0x0bc0 */   0,  0,102,139,143,152,  1,  0,  0,137,218,193,234, 11, 15,183,
/* 0x0bd0 */ 193, 15,175,208, 57, 84, 36, 48, 15,131,134,  1,  0,  0,190,  0,
/* 0x0be0 */   8,  0,  0,137,211, 41,198,137,240,193,248,  5,141,  4,  1,139,
/* 0x0bf0 */  76, 36, 44,102,137,135,152,  1,  0,  0,139, 68, 36, 76,193,224,
/* 0x0c00 */   5,  3, 68, 36, 96,129,250,255,255,255,  0,141, 60, 72,119, 27,
/* 0x0c10 */  59,108, 36, 56, 15,132,229,  1,  0,  0,193,100, 36, 48,  8, 15,
/* 0x0c20 */ 182, 69,  0,193,227,  8,  9, 68, 36, 48, 69,102,139,151,224,  1,
/* 0x0c30 */   0,  0,137,216,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36,
/* 0x0c40 */  48, 15,131,103,  2,  0,  0,137, 68, 36, 52,184,  0,  8,  0,  0,
/* 0x0c50 */  41,200,193,248,  5,141,  4,  2,102,137,135,224,  1,  0,  0,139,
/* 0x0c60 */  68, 36, 92,133,192, 15,132,148,  1,  0,  0,131,124, 36, 76,  6,
/* 0x0c70 */ 184,  0,  0,  0,  0,139,156, 36,136,  0,  0,  0,139, 84, 36, 24,
/* 0x0c80 */  15,159,192,141, 68,  0,  9,137, 68, 36, 76,139, 68, 36, 92, 43,
/* 0x0c90 */  68, 36, 72, 15,182, 60, 24,137,248,136,  2, 66,255, 68, 36, 92,
/* 0x0ca0 */ 137, 84, 36, 24,233,182,250,255,255, 41,198, 41, 68, 36, 48,137,
/* 0x0cb0 */ 208,102,193,232,  5,102, 41,194,129,254,255,255,255,  0,102,137,
/* 0x0cc0 */  19,119, 27, 59,108, 36, 56, 15,132, 50,  1,  0,  0,193,100, 36,
/* 0x0cd0 */  48,  8, 15,182, 69,  0,193,230,  8,  9, 68, 36, 48, 69,102,139,
/* 0x0ce0 */  83,  2,137,240,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36,
/* 0x0cf0 */  48, 15,131,119,  1,  0,  0,137, 68, 36, 52,184,  0,  8,  0,  0,
/* 0x0d00 */  41,200,193,100, 36, 44,  4,193,248,  5,139,116, 36, 44,141,  4,
/* 0x0d10 */   2,199, 68, 36, 32,  8,  0,  0,  0,102,137, 67,  2,141,156, 30,
/* 0x0d20 */   4,  1,  0,  0,137, 92, 36, 16,233, 67,252,255,255, 59,108, 36,
/* 0x0d30 */  56, 15,132,200,  0,  0,  0,193,100, 36, 48,  8,193,227,  8,102,
/* 0x0d40 */ 139,143,152,  1,  0,  0, 15,182, 69,  0,137,218,  9, 68, 36, 48,
/* 0x0d50 */ 193,234, 11, 15,183,193, 69, 15,175,208, 57, 84, 36, 48, 15,130,
/* 0x0d60 */ 122,254,255,255,137,200, 41,211,102,193,232,  5, 41, 84, 36, 48,
/* 0x0d70 */ 102, 41,193,129,251,255,255,255,  0,102,137,143,152,  1,  0,  0,
/* 0x0d80 */ 119, 23, 59,108, 36, 56,116,119,193,100, 36, 48,  8, 15,182, 69,
/* 0x0d90 */   0,193,227,  8,  9, 68, 36, 48, 69,102,139,151,176,  1,  0,  0,
/* 0x0da0 */ 137,216,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48, 15,
/* 0x0db0 */ 131, 22,  1,  0,  0,137,198,184,  0,  8,  0,  0, 41,200,193,248,
/* 0x0dc0 */   5,141,  4,  2,102,137,135,176,  1,  0,  0,139, 68, 36, 68,139,
/* 0x0dd0 */  84, 36, 72,137, 68, 36, 72,137, 84, 36, 68,131,124, 36, 76,  6,
/* 0x0de0 */ 184,  0,  0,  0,  0,139, 92, 36, 96, 15,159,192,129,195,104, 10,
/* 0x0df0 */   0,  0,141, 68, 64,  8,137, 68, 36, 76,233,  9,251,255,255,131,
/* 0x0e00 */ 196,100,184,  1,  0,  0,  0,233,207,  1,  0,  0,139,116, 36,  4,
/* 0x0e10 */  70,137,116, 36, 72, 15,132, 85,249,255,255,139, 76, 36, 12,139,
/* 0x0e20 */  68, 36, 92,131,193,  2, 57, 68, 36, 72,119,211,137,194,139,132,
/* 0x0e30 */  36,136,  0,  0,  0, 43, 68, 36, 72,  3,148, 36,136,  0,  0,  0,
/* 0x0e40 */   3, 68, 36, 92, 15,182, 56, 64,137,251,136, 26, 66,255, 68, 36,
/* 0x0e50 */  92,255, 68, 36, 24, 73, 15,132,  3,249,255,255,139,180, 36,140,
/* 0x0e60 */   0,  0,  0, 57,116, 36, 92,114,219,233,  2,249,255,255, 41,198,
/* 0x0e70 */  41, 68, 36, 48,137,208,137,116, 36, 52,102,193,232,  5,199, 68,
/* 0x0e80 */  36, 32, 16,  0,  0,  0,102, 41,194,199, 68, 36, 36,  8,  0,  0,
/* 0x0e90 */   0,102,137, 83,  2,129,195,  4,  2,  0,  0,137, 92, 36, 16,233,
/* 0x0ea0 */ 212,250,255,255,131,108, 36, 76,  6,233,177,248,255,255,137,222,
/* 0x0eb0 */  41, 68, 36, 48, 41,198,137,208,102,193,232,  5,102, 41,194,102,
/* 0x0ec0 */ 137,151,224,  1,  0,  0,233, 16,255,255,255, 41,195, 41, 68, 36,
/* 0x0ed0 */  48,137,208,102,193,232,  5,102, 41,194,129,251,255,255,255,  0,
/* 0x0ee0 */ 102,137,151,176,  1,  0,  0, 15,134,165,  0,  0,  0,102,139,151,
/* 0x0ef0 */ 200,  1,  0,  0,137,216,193,232, 11, 15,183,202, 15,175,193, 57,
/* 0x0f00 */  68, 36, 48, 15,131,169,  0,  0,  0,137,198,184,  0,  8,  0,  0,
/* 0x0f10 */  41,200,193,248,  5,141,  4,  2,102,137,135,200,  1,  0,  0,139,
/* 0x0f20 */  68, 36, 64,139, 92, 36, 68,137, 92, 36, 64,233,159,254,255,255,
/* 0x0f30 */ 141, 80,251,129,124, 36, 52,255,255,255,  0,119, 29, 59,108, 36,
/* 0x0f40 */  56, 15,132,184,254,255,255,193,100, 36, 48,  8,193,100, 36, 52,
/* 0x0f50 */   8, 15,182, 69,  0, 69,  9, 68, 36, 48,209,108, 36, 52,  1,219,
/* 0x0f60 */ 139, 68, 36, 52, 57, 68, 36, 48,114,  7, 41, 68, 36, 48,131,203,
/* 0x0f70 */   1, 74,117,191,139, 84, 36, 96,193,227,  4,191,  4,  0,  0,  0,
/* 0x0f80 */ 137, 92, 36,  4,129,194, 68,  6,  0,  0,137, 20, 36,233,119,251,
/* 0x0f90 */ 255,255, 59,108, 36, 56, 15,132, 99,254,255,255,193,100, 36, 48,
/* 0x0fa0 */   8, 15,182, 69,  0,193,227,  8,  9, 68, 36, 48, 69,233, 59,255,
/* 0x0fb0 */ 255,255,137,222, 41, 68, 36, 48, 41,198,137,208,102,193,232,  5,
/* 0x0fc0 */ 139, 76, 36, 64,102, 41,194,139, 68, 36, 60,102,137,151,200,  1,
/* 0x0fd0 */   0,  0,137, 76, 36, 60,233, 72,255,255,255, 91, 94, 95, 93, 85,
/* 0x0fe0 */  87,191,  0,  0,  0,  0, 86, 83,131,236,100,139, 84, 36,120,199,
/* 0x0ff0 */  68, 36, 92,  0,  0,  0,  0,141, 66,  4,137, 68, 36, 96,184,  1,
/* 0x1000 */   0,  0,  0, 15,182, 74,  2,137,195,211,227,137,217, 73,137, 76,
/* 0x1010 */  36, 88, 15,182, 74,  1,211,224,139,140, 36,144,  0,  0,  0, 72,
/* 0x1020 */ 137, 68, 36, 84,139,132, 36,132,  0,  0,  0, 15,182, 50,199, 68,
/* 0x1030 */  36, 76,  0,  0,  0,  0,199,  0,  0,  0,  0,  0,184,  0,  3,  0,
/* 0x1040 */   0,199, 68, 36, 72,  1,  0,  0,  0,137,116, 36, 80,199, 68, 36,
/* 0x1050 */  68,  1,  0,  0,  0,199, 68, 36, 64,  1,  0,  0,  0,199, 68, 36,
/* 0x1060 */  60,  1,  0,  0,  0,199,  1,  0,  0,  0,  0, 15,182, 74,  1,  1,
/* 0x1070 */ 241,211,224,141,136, 54,  7,  0,  0, 57, 76, 36, 92,115, 14,139,
/* 0x1080 */  68, 36, 96,102,199,  0,  0,  4,131,192,  2,226,246,139,108, 36,
/* 0x1090 */ 124,199, 68, 36, 48,  0,  0,  0,  0,199, 68, 36, 52,255,255,255,
/* 0x10a0 */ 255,186,  0,  0,  0,  0,137,235,  3,156, 36,128,  0,  0,  0,137,
/* 0x10b0 */  92, 36, 56, 59,108, 36, 56, 15,132,128,  8,  0,  0,193,100, 36,
/* 0x10c0 */  48,  8, 66, 15,182, 69,  0, 69,  9, 68, 36, 48,131,250,  4,126,
/* 0x10d0 */ 226,139,180, 36,140,  0,  0,  0, 57,116, 36, 92, 15,131,226,  1,
/* 0x10e0 */   0,  0,139,132, 36,136,  0,  0,  0,137, 68, 36, 24,139, 84, 36,
/* 0x10f0 */  92, 35, 84, 36, 88,139, 68, 36, 76,139, 76, 36, 96,193,224,  4,
/* 0x1100 */ 137, 84, 36, 44,  1,208,129,124, 36, 52,255,255,255,  0,141, 52,
/* 0x1110 */  65,119, 29, 59,108, 36, 56, 15,132, 32,  8,  0,  0,193,100, 36,
/* 0x1120 */  48,  8,193,100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,
/* 0x1130 */ 139, 68, 36, 52,102,139, 22,193,232, 11, 15,183,202, 15,175,193,
/* 0x1140 */  57, 68, 36, 48, 15,131, 80,  2,  0,  0,137, 68, 36, 52,184,  0,
/* 0x1150 */   8,  0,  0, 41,200,138, 76, 36, 80,193,248,  5,187,  1,  0,  0,
/* 0x1160 */   0,141,  4,  2,102,137,  6,139, 68, 36, 92, 35, 68, 36, 84,139,
/* 0x1170 */ 116, 36, 96,211,224,137,249, 15,182,209,185,  8,  0,  0,  0, 43,
/* 0x1180 */  76, 36, 80,211,250,  1,208,105,192,  0,  6,  0,  0,131,124, 36,
/* 0x1190 */  76,  6,141,132, 48,108, 14,  0,  0,137, 68, 36, 20, 15,142, 72,
/* 0x11a0 */   1,  0,  0,139, 68, 36, 92, 43, 68, 36, 72,139,148, 36,136,  0,
/* 0x11b0 */   0,  0, 15,182,  4, 16,137, 68, 36, 40,235, 46,137, 68, 36, 52,
/* 0x11c0 */ 184,  0,  8,  0,  0, 41,216,137,251,193,248,  5,133,210,141,  4,
/* 0x11d0 */   1,102,137,134,  0,  2,  0,  0, 15,133,106,  1,  0,  0,129,251,
/* 0x11e0 */ 255,  0,  0,  0, 15,143,143,  0,  0,  0,209,100, 36, 40,139, 84,
/* 0x11f0 */  36, 40,141, 60, 27,139, 76, 36, 20,129,226,  0,  1,  0,  0,129,
/* 0x1200 */ 124, 36, 52,255,255,255,  0,141,  4, 81,141, 52, 56,119, 29, 59,
/* 0x1210 */ 108, 36, 56, 15,132, 36,  7,  0,  0,193,100, 36, 48,  8,193,100,
/* 0x1220 */  36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,139, 68, 36, 52,
/* 0x1230 */ 102,139,142,  0,  2,  0,  0,193,232, 11, 15,183,217, 15,175,195,
/* 0x1240 */  57, 68, 36, 48, 15,130,114,255,255,255, 41, 68, 36, 52, 41, 68,
/* 0x1250 */  36, 48,137,200,102,193,232,  5,141, 95,  1,102, 41,193,133,210,
/* 0x1260 */ 102,137,142,  0,  2,  0,  0, 15,132,219,  0,  0,  0,129,251,255,
/* 0x1270 */   0,  0,  0, 15,142,113,255,255,255,139, 84, 36, 24,137,223,136,
/* 0x1280 */  26, 66,255, 68, 36, 92,131,124, 36, 76,  3,137, 84, 36, 24, 15,
/* 0x1290 */ 143,215,  0,  0,  0,199, 68, 36, 76,  0,  0,  0,  0,139,132, 36,
/* 0x12a0 */ 140,  0,  0,  0, 57, 68, 36, 92, 15,130, 63,254,255,255,129,124,
/* 0x12b0 */  36, 52,255,255,255,  0,119, 12, 59,108, 36, 56,184,  1,  0,  0,
/* 0x12c0 */   0,116, 32, 69, 43,108, 36,124,184,  0,  0,  0,  0,139,148, 36,
/* 0x12d0 */ 132,  0,  0,  0,139, 92, 36, 92,139,140, 36,144,  0,  0,  0,137,
/* 0x12e0 */  42,137, 25,131,196,100,233, 46,  8,  0,  0,129,124, 36, 52,255,
/* 0x12f0 */ 255,255,  0,141, 52, 27,139, 68, 36, 20,141, 28,  6,119, 29, 59,
/* 0x1300 */ 108, 36, 56, 15,132, 52,  6,  0,  0,193,100, 36, 48,  8,193,100,
/* 0x1310 */  36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,139, 68, 36, 52,
/* 0x1320 */ 102,139, 11,193,232, 11, 15,183,209, 15,175,194, 57, 68, 36, 48,
/* 0x1330 */ 115, 79,137, 68, 36, 52,184,  0,  8,  0,  0, 41,208,193,248,  5,
/* 0x1340 */ 141,  4,  1,102,137,  3,137,243,129,251,255,  0,  0,  0,126,155,
/* 0x1350 */ 139, 84, 36, 24,137,223,136, 26, 66,255, 68, 36, 92,131,124, 36,
/* 0x1360 */  76,  3,137, 84, 36, 24, 15,142, 41,255,255,255,131,124, 36, 76,
/* 0x1370 */   9, 15,143,107,  6,  0,  0,131,108, 36, 76,  3,233, 28,255,255,
/* 0x1380 */ 255, 41, 68, 36, 52, 41, 68, 36, 48,137,200,102,193,232,  5,102,
/* 0x1390 */  41,193,102,137, 11,141, 94,  1,235,174,139, 92, 36, 52, 41, 68,
/* 0x13a0 */  36, 48, 41,195,137,208,102,193,232,  5,139, 76, 36, 76,102, 41,
/* 0x13b0 */ 194,129,251,255,255,255,  0,102,137, 22,139,116, 36, 96,141, 60,
/* 0x13c0 */  78,119, 27, 59,108, 36, 56, 15,132,112,  5,  0,  0,193,100, 36,
/* 0x13d0 */  48,  8, 15,182, 69,  0,193,227,  8,  9, 68, 36, 48, 69,102,139,
/* 0x13e0 */ 151,128,  1,  0,  0,137,216,193,232, 11, 15,183,202, 15,175,193,
/* 0x13f0 */  57, 68, 36, 48, 15,131,228,  2,  0,  0,137,198,184,  0,  8,  0,
/* 0x1400 */   0, 41,200,139, 92, 36, 96,193,248,  5,131,124, 36, 76,  6,141,
/* 0x1410 */   4,  2,139, 76, 36, 72,139, 84, 36, 68,102,137,135,128,  1,  0,
/* 0x1420 */   0,139, 68, 36, 64,137, 76, 36, 68,137, 68, 36, 60,184,  0,  0,
/* 0x1430 */   0,  0, 15,159,192,137, 84, 36, 64,141,  4, 64,129,195,100,  6,
/* 0x1440 */   0,  0,137, 68, 36, 76,129,254,255,255,255,  0,119, 27, 59,108,
/* 0x1450 */  36, 56, 15,132,229,  4,  0,  0,193,100, 36, 48,  8, 15,182, 69,
/* 0x1460 */   0,193,230,  8,  9, 68, 36, 48, 69,102,139, 19,137,240,193,232,
/* 0x1470 */  11, 15,183,202, 15,175,193, 57, 68, 36, 48, 15,131,102,  3,  0,
/* 0x1480 */   0,137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,193,100, 36, 44,
/* 0x1490 */   4,193,248,  5,139, 76, 36, 44,141,  4,  2,199, 68, 36, 32,  0,
/* 0x14a0 */   0,  0,  0,102,137,  3,141, 92, 25,  4,137, 92, 36, 16,199, 68,
/* 0x14b0 */  36, 36,  3,  0,  0,  0,139,124, 36, 36,186,  1,  0,  0,  0,235,
/* 0x14c0 */  25,137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,193,248,  5, 79,
/* 0x14d0 */ 141,  4,  2,137,242,102,137,  3,116, 97,129,124, 36, 52,255,255,
/* 0x14e0 */ 255,  0,141, 52, 18,139, 68, 36, 16,141, 28,  6,119, 29, 59,108,
/* 0x14f0 */  36, 56, 15,132, 69,  4,  0,  0,193,100, 36, 48,  8,193,100, 36,
/* 0x1500 */  52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,139, 68, 36, 52,102,
/* 0x1510 */ 139, 19,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48,114,
/* 0x1520 */ 160, 41, 68, 36, 52, 41, 68, 36, 48,137,208,102,193,232,  5,102,
/* 0x1530 */  41,194, 79,102,137, 19,141, 86,  1,117,159,138, 76, 36, 36,184,
/* 0x1540 */   1,  0,  0,  0,211,224, 41,194,  3, 84, 36, 32,131,124, 36, 76,
/* 0x1550 */   3,137, 84, 36, 12, 15,143,254,  3,  0,  0,131, 68, 36, 76,  7,
/* 0x1560 */ 131,250,  3,137,208,126,  5,184,  3,  0,  0,  0,139, 92, 36, 96,
/* 0x1570 */ 193,224,  7,191,  6,  0,  0,  0,141,132, 24, 96,  3,  0,  0,137,
/* 0x1580 */  68, 36,  8,184,  1,  0,  0,  0,235, 25,137, 68, 36, 52,184,  0,
/* 0x1590 */   8,  0,  0, 41,200,193,248,  5, 79,141,  4,  2,102,137,  3,137,
/* 0x15a0 */ 240,116, 97,129,124, 36, 52,255,255,255,  0,141, 52,  0,139, 68,
/* 0x15b0 */  36,  8,141, 28,  6,119, 29, 59,108, 36, 56, 15,132,124,  3,  0,
/* 0x15c0 */   0,193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182, 69,  0, 69,
/* 0x15d0 */   9, 68, 36, 48,139, 68, 36, 52,102,139, 19,193,232, 11, 15,183,
/* 0x15e0 */ 202, 15,175,193, 57, 68, 36, 48,114,160, 41, 68, 36, 52, 41, 68,
/* 0x15f0 */  36, 48,137,208,102,193,232,  5,102, 41,194, 79,102,137, 19,141,
/* 0x1600 */  70,  1,117,159,141, 80,192,131,250,  3,137, 84, 36,  4, 15,142,
/* 0x1610 */  54,  3,  0,  0,137,211,137,208,131,227,  1,209,248,131,203,  2,
/* 0x1620 */ 131,250, 13,141,120,255, 15,143, 66,  4,  0,  0,137,249,139,116,
/* 0x1630 */  36, 96,211,227,  1,210,141,  4, 94,137, 92, 36,  4, 41,208,  5,
/* 0x1640 */  94,  5,  0,  0,137,  4, 36,184,  1,  0,  0,  0,199, 68, 36, 28,
/* 0x1650 */   1,  0,  0,  0,235, 33,137, 68, 36, 52,184,  0,  8,  0,  0, 41,
/* 0x1660 */ 200,193,248,  5,141,  4,  2,102,137,  3,137,240,209,100, 36, 28,
/* 0x1670 */  79, 15,132,211,  2,  0,  0,129,124, 36, 52,255,255,255,  0,141,
/* 0x1680 */  52,  0,139, 12, 36,141, 28, 14,119, 29, 59,108, 36, 56, 15,132,
/* 0x1690 */ 169,  2,  0,  0,193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182,
/* 0x16a0 */  69,  0, 69,  9, 68, 36, 48,139, 68, 36, 52,102,139, 19,193,232,
/* 0x16b0 */  11, 15,183,202, 15,175,193, 57, 68, 36, 48,114,153, 41, 68, 36,
/* 0x16c0 */  52, 41, 68, 36, 48,137,208,102,193,232,  5,102, 41,194,141, 70,
/* 0x16d0 */   1,102,137, 19,139, 92, 36, 28,  9, 92, 36,  4,235,142, 41,195,
/* 0x16e0 */  41, 68, 36, 48,137,208,102,193,232,  5,102, 41,194,129,251,255,
/* 0x16f0 */ 255,255,  0,102,137,151,128,  1,  0,  0, 15,134,107,  1,  0,  0,
/* 0x1700 */ 102,139,143,152,  1,  0,  0,137,218,193,234, 11, 15,183,193, 15,
/* 0x1710 */ 175,208, 57, 84, 36, 48, 15,131,134,  1,  0,  0,190,  0,  8,  0,
/* 0x1720 */   0,137,211, 41,198,137,240,193,248,  5,141,  4,  1,139, 76, 36,
/* 0x1730 */  44,102,137,135,152,  1,  0,  0,139, 68, 36, 76,193,224,  5,  3,
/* 0x1740 */  68, 36, 96,129,250,255,255,255,  0,141, 60, 72,119, 27, 59,108,
/* 0x1750 */  36, 56, 15,132,229,  1,  0,  0,193,100, 36, 48,  8, 15,182, 69,
/* 0x1760 */   0,193,227,  8,  9, 68, 36, 48, 69,102,139,151,224,  1,  0,  0,
/* 0x1770 */ 137,216,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48, 15,
/* 0x1780 */ 131,103,  2,  0,  0,137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,
/* 0x1790 */ 193,248,  5,141,  4,  2,102,137,135,224,  1,  0,  0,139, 68, 36,
/* 0x17a0 */  92,133,192, 15,132,148,  1,  0,  0,131,124, 36, 76,  6,184,  0,
/* 0x17b0 */   0,  0,  0,139,156, 36,136,  0,  0,  0,139, 84, 36, 24, 15,159,
/* 0x17c0 */ 192,141, 68,  0,  9,137, 68, 36, 76,139, 68, 36, 92, 43, 68, 36,
/* 0x17d0 */  72, 15,182, 60, 24,137,248,136,  2, 66,255, 68, 36, 92,137, 84,
/* 0x17e0 */  36, 24,233,182,250,255,255, 41,198, 41, 68, 36, 48,137,208,102,
/* 0x17f0 */ 193,232,  5,102, 41,194,129,254,255,255,255,  0,102,137, 19,119,
/* 0x1800 */  27, 59,108, 36, 56, 15,132, 50,  1,  0,  0,193,100, 36, 48,  8,
/* 0x1810 */  15,182, 69,  0,193,230,  8,  9, 68, 36, 48, 69,102,139, 83,  2,
/* 0x1820 */ 137,240,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48, 15,
/* 0x1830 */ 131,119,  1,  0,  0,137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,
/* 0x1840 */ 193,100, 36, 44,  4,193,248,  5,139,116, 36, 44,141,  4,  2,199,
/* 0x1850 */  68, 36, 32,  8,  0,  0,  0,102,137, 67,  2,141,156, 30,  4,  1,
/* 0x1860 */   0,  0,137, 92, 36, 16,233, 67,252,255,255, 59,108, 36, 56, 15,
/* 0x1870 */ 132,200,  0,  0,  0,193,100, 36, 48,  8,193,227,  8,102,139,143,
/* 0x1880 */ 152,  1,  0,  0, 15,182, 69,  0,137,218,  9, 68, 36, 48,193,234,
/* 0x1890 */  11, 15,183,193, 69, 15,175,208, 57, 84, 36, 48, 15,130,122,254,
/* 0x18a0 */ 255,255,137,200, 41,211,102,193,232,  5, 41, 84, 36, 48,102, 41,
/* 0x18b0 */ 193,129,251,255,255,255,  0,102,137,143,152,  1,  0,  0,119, 23,
/* 0x18c0 */  59,108, 36, 56,116,119,193,100, 36, 48,  8, 15,182, 69,  0,193,
/* 0x18d0 */ 227,  8,  9, 68, 36, 48, 69,102,139,151,176,  1,  0,  0,137,216,
/* 0x18e0 */ 193,232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48, 15,131, 22,
/* 0x18f0 */   1,  0,  0,137,198,184,  0,  8,  0,  0, 41,200,193,248,  5,141,
/* 0x1900 */   4,  2,102,137,135,176,  1,  0,  0,139, 68, 36, 68,139, 84, 36,
/* 0x1910 */  72,137, 68, 36, 72,137, 84, 36, 68,131,124, 36, 76,  6,184,  0,
/* 0x1920 */   0,  0,  0,139, 92, 36, 96, 15,159,192,129,195,104, 10,  0,  0,
/* 0x1930 */ 141, 68, 64,  8,137, 68, 36, 76,233,  9,251,255,255,131,196,100,
/* 0x1940 */ 184,  1,  0,  0,  0,233,207,  1,  0,  0,139,116, 36,  4, 70,137,
/* 0x1950 */ 116, 36, 72, 15,132, 85,249,255,255,139, 76, 36, 12,139, 68, 36,
/* 0x1960 */  92,131,193,  2, 57, 68, 36, 72,119,211,137,194,139,132, 36,136,
/* 0x1970 */   0,  0,  0, 43, 68, 36, 72,  3,148, 36,136,  0,  0,  0,  3, 68,
/* 0x1980 */  36, 92, 15,182, 56, 64,137,251,136, 26, 66,255, 68, 36, 92,255,
/* 0x1990 */  68, 36, 24, 73, 15,132,  3,249,255,255,139,180, 36,140,  0,  0,
/* 0x19a0 */   0, 57,116, 36, 92,114,219,233,  2,249,255,255, 41,198, 41, 68,
/* 0x19b0 */  36, 48,137,208,137,116, 36, 52,102,193,232,  5,199, 68, 36, 32,
/* 0x19c0 */  16,  0,  0,  0,102, 41,194,199, 68, 36, 36,  8,  0,  0,  0,102,
/* 0x19d0 */ 137, 83,  2,129,195,  4,  2,  0,  0,137, 92, 36, 16,233,212,250,
/* 0x19e0 */ 255,255,131,108, 36, 76,  6,233,177,248,255,255,137,222, 41, 68,
/* 0x19f0 */  36, 48, 41,198,137,208,102,193,232,  5,102, 41,194,102,137,151,
/* 0x1a00 */ 224,  1,  0,  0,233, 16,255,255,255, 41,195, 41, 68, 36, 48,137,
/* 0x1a10 */ 208,102,193,232,  5,102, 41,194,129,251,255,255,255,  0,102,137,
/* 0x1a20 */ 151,176,  1,  0,  0, 15,134,165,  0,  0,  0,102,139,151,200,  1,
/* 0x1a30 */   0,  0,137,216,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36,
/* 0x1a40 */  48, 15,131,169,  0,  0,  0,137,198,184,  0,  8,  0,  0, 41,200,
/* 0x1a50 */ 193,248,  5,141,  4,  2,102,137,135,200,  1,  0,  0,139, 68, 36,
/* 0x1a60 */  64,139, 92, 36, 68,137, 92, 36, 64,233,159,254,255,255,141, 80,
/* 0x1a70 */ 251,129,124, 36, 52,255,255,255,  0,119, 29, 59,108, 36, 56, 15,
/* 0x1a80 */ 132,184,254,255,255,193,100, 36, 48,  8,193,100, 36, 52,  8, 15,
/* 0x1a90 */ 182, 69,  0, 69,  9, 68, 36, 48,209,108, 36, 52,  1,219,139, 68,
/* 0x1aa0 */  36, 52, 57, 68, 36, 48,114,  7, 41, 68, 36, 48,131,203,  1, 74,
/* 0x1ab0 */ 117,191,139, 84, 36, 96,193,227,  4,191,  4,  0,  0,  0,137, 92,
/* 0x1ac0 */  36,  4,129,194, 68,  6,  0,  0,137, 20, 36,233,119,251,255,255,
/* 0x1ad0 */  59,108, 36, 56, 15,132, 99,254,255,255,193,100, 36, 48,  8, 15,
/* 0x1ae0 */ 182, 69,  0,193,227,  8,  9, 68, 36, 48, 69,233, 59,255,255,255,
/* 0x1af0 */ 137,222, 41, 68, 36, 48, 41,198,137,208,102,193,232,  5,139, 76,
/* 0x1b00 */  36, 64,102, 41,194,139, 68, 36, 60,102,137,151,200,  1,  0,  0,
/* 0x1b10 */ 137, 76, 36, 60,233, 72,255,255,255, 91, 94, 95, 93,  3,115,252,
/* 0x1b20 */   3,123,248, 49,192,141,140, 36,  0,255,255,255,137,236, 80, 57,
/* 0x1b30 */ 204,117,251,137,236, 49,201,185,  0,  0,  0,  0,138,  7, 71, 44,
/* 0x1b40 */ 232, 60,  1,119,247,128, 63,  0,117,  4,139,  7,138, 95,  4,102,
/* 0x1b50 */ 193,232,  8,134,196,193,192, 16,134,196, 41,248,128,235,232,137,
/* 0x1b60 */   7,131,199,  5,136,216,226,  9,185,  0,  0,  0,  0,176,232,176,
/* 0x1b70 */ 233,242,174,117,  4,128, 63,  0,117,255,139,  7,102,193,232,  8,
/* 0x1b80 */ 134,196,193,192, 16,134,196, 41,248,171,235,  4,139, 84, 36, 36,
/* 0x1b90 */   3, 84, 36, 40, 57,214,116,  1, 72, 43,124, 36, 44,139, 84, 36,
/* 0x1ba0 */  48,137, 58,137, 68, 36, 28, 97,195, 93,184,  0,  0, 64,  1,141,
/* 0x1bb0 */ 144,140,  0,  0,  0,  3, 64, 72,  5,255, 15,  0,  0, 37,  0,240,
/* 0x1bc0 */ 255,255,106,  0,106,255,106, 50,106,  3,255, 50, 80,137,227,106,
/* 0x1bd0 */  90, 88,205,128,131,196, 24,141, 88,  3,102,105,108,101, 32,102,
/* 0x1be0 */ 111,114,109, 97,116, 32,101,108,102, 51, 50, 45,105, 51, 56, 54,
/* 0x1bf0 */  10, 10, 83,101, 99,116,105,111,110,115, 58, 10, 73,100,120, 32,
/* 0x1c00 */  78, 97,109,101, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 83,105,
/* 0x1c10 */ 122,101, 32, 32, 32, 32, 32, 32, 86, 77, 65, 32, 32, 32, 32, 32,
/* 0x1c20 */  32, 32, 76, 77, 65, 32, 32, 32, 32, 32, 32, 32, 70,105,108,101,
/* 0x1c30 */  32,111,102,102, 32, 32, 65,108,103,110, 32, 32, 70,108, 97,103,
/* 0x1c40 */ 115, 10, 32, 32, 48, 32, 76, 69, 88, 69, 67, 48, 48, 48, 32, 32,
/* 0x1c50 */  32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51,
/* 0x1c60 */  52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x1c70 */  83, 10, 32, 32, 49, 32, 76, 69, 88, 69, 67, 48, 49, 48, 32, 32,
/* 0x1c80 */  32, 32, 32, 32, 48,100, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51,
/* 0x1c90 */  57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x1ca0 */  83, 10, 32, 32, 50, 32, 78, 50, 66, 83, 77, 65, 49, 48, 32, 32,
/* 0x1cb0 */  32, 32, 32, 32, 48, 51, 32, 32, 48, 32, 32, 48, 32, 32, 48, 52,
/* 0x1cc0 */  54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x1cd0 */  83, 10, 32, 32, 51, 32, 78, 50, 66, 70, 65, 83, 49, 48, 32, 32,
/* 0x1ce0 */  32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 52,
/* 0x1cf0 */  57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x1d00 */  83, 10, 32, 32, 52, 32, 78, 50, 66, 70, 65, 83, 49, 49, 32, 32,
/* 0x1d10 */  32, 32, 32, 32, 48, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48, 52,
/* 0x1d20 */  98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x1d30 */  83, 10, 32, 32, 53, 32, 78, 50, 66, 68, 69, 67, 49, 48, 32, 32,
/* 0x1d40 */  32, 32, 32, 32, 48, 98, 32, 32, 48, 32, 32, 48, 32, 32, 48, 53,
/* 0x1d50 */  49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x1d60 */  83, 10, 32, 32, 54, 32, 78, 50, 66, 83, 77, 65, 50, 48, 32, 32,
/* 0x1d70 */  32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 53,
/* 0x1d80 */  99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x1d90 */  83, 10, 32, 32, 55, 32, 78, 50, 66, 70, 65, 83, 50, 48, 32, 32,
/* 0x1da0 */  32, 32, 32, 32, 48, 57, 32, 32, 48, 32, 32, 48, 32, 32, 48, 54,
/* 0x1db0 */  49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x1dc0 */  83, 10, 32, 32, 56, 32, 78, 50, 66, 68, 69, 67, 50, 48, 32, 32,
/* 0x1dd0 */  32, 32, 32, 32, 48,100, 32, 32, 48, 32, 32, 48, 32, 32, 48, 54,
/* 0x1de0 */  97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x1df0 */  83, 10, 32, 32, 57, 32, 78, 50, 66, 83, 77, 65, 51, 48, 32, 32,
/* 0x1e00 */  32, 32, 32, 32, 48,100, 32, 32, 48, 32, 32, 48, 32, 32, 48, 55,
/* 0x1e10 */  55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x1e20 */  83, 10, 32, 49, 48, 32, 78, 50, 66, 70, 65, 83, 51, 48, 32, 32,
/* 0x1e30 */  32, 32, 32, 32, 48,102, 32, 32, 48, 32, 32, 48, 32, 32, 48, 56,
/* 0x1e40 */  52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x1e50 */  83, 10, 32, 49, 49, 32, 78, 50, 66, 68, 69, 67, 51, 48, 32, 32,
/* 0x1e60 */  32, 32, 32, 32, 48, 51,101, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x1e70 */  57, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x1e80 */  84, 83, 10, 32, 49, 50, 32, 78, 50, 66, 83, 77, 65, 52, 48, 32,
/* 0x1e90 */  32, 32, 32, 32, 32, 48,100, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x1ea0 */ 100, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x1eb0 */  84, 83, 10, 32, 49, 51, 32, 78, 50, 66, 70, 65, 83, 52, 48, 32,
/* 0x1ec0 */  32, 32, 32, 32, 32, 48,102, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x1ed0 */ 100,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x1ee0 */  84, 83, 10, 32, 49, 52, 32, 78, 50, 66, 83, 77, 65, 53, 48, 32,
/* 0x1ef0 */  32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x1f00 */ 101,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x1f10 */  84, 83, 10, 32, 49, 53, 32, 78, 50, 66, 70, 65, 83, 53, 48, 32,
/* 0x1f20 */  32, 32, 32, 32, 32, 48, 51, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x1f30 */ 101,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x1f40 */  84, 83, 10, 32, 49, 54, 32, 78, 50, 66, 68, 69, 67, 53, 48, 32,
/* 0x1f50 */  32, 32, 32, 32, 32, 48, 57, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x1f60 */ 102, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x1f70 */  84, 83, 10, 32, 49, 55, 32, 78, 50, 66, 83, 77, 65, 54, 48, 32,
/* 0x1f80 */  32, 32, 32, 32, 32, 48, 99, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x1f90 */ 102, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x1fa0 */  84, 83, 10, 32, 49, 56, 32, 78, 50, 66, 70, 65, 83, 54, 48, 32,
/* 0x1fb0 */  32, 32, 32, 32, 32, 48, 49, 57, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x1fc0 */  48, 49, 48, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x1fd0 */  69, 78, 84, 83, 10, 32, 49, 57, 32, 78, 50, 66, 70, 65, 83, 54,
/* 0x1fe0 */  49, 32, 32, 32, 32, 32, 32, 48, 49, 54, 32, 32, 48, 32, 32, 48,
/* 0x1ff0 */  32, 32, 48, 49, 50, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2000 */  78, 84, 69, 78, 84, 83, 10, 32, 50, 48, 32, 78, 50, 66, 68, 69,
/* 0x2010 */  67, 54, 48, 32, 32, 32, 32, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x2020 */  32, 32, 48, 49, 51, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2030 */  78, 84, 69, 78, 84, 83, 10, 32, 50, 49, 32, 78, 50, 68, 83, 77,
/* 0x2040 */  65, 49, 48, 32, 32, 32, 32, 32, 32, 48, 51, 32, 32, 48, 32, 32,
/* 0x2050 */  48, 32, 32, 48, 49, 51, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2060 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 50, 50, 32, 78, 50, 68, 70,
/* 0x2070 */  65, 83, 49, 48, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32,
/* 0x2080 */  32, 48, 32, 32, 48, 49, 51, 57, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2090 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 50, 51, 32, 78, 50, 68,
/* 0x20a0 */  70, 65, 83, 49, 49, 32, 32, 32, 32, 32, 32, 48, 54, 32, 32, 48,
/* 0x20b0 */  32, 32, 48, 32, 32, 48, 49, 51, 98, 32, 32, 50, 42, 42, 48, 32,
/* 0x20c0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 50, 52, 32, 78, 50,
/* 0x20d0 */  68, 68, 69, 67, 49, 48, 32, 32, 32, 32, 32, 32, 48, 98, 32, 32,
/* 0x20e0 */  48, 32, 32, 48, 32, 32, 48, 49, 52, 49, 32, 32, 50, 42, 42, 48,
/* 0x20f0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 50, 53, 32, 78,
/* 0x2100 */  50, 68, 83, 77, 65, 50, 48, 32, 32, 32, 32, 32, 32, 48, 53, 32,
/* 0x2110 */  32, 48, 32, 32, 48, 32, 32, 48, 49, 52, 99, 32, 32, 50, 42, 42,
/* 0x2120 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 50, 54, 32,
/* 0x2130 */  78, 50, 68, 70, 65, 83, 50, 48, 32, 32, 32, 32, 32, 32, 48, 57,
/* 0x2140 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 53, 49, 32, 32, 50, 42,
/* 0x2150 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 50, 55,
/* 0x2160 */  32, 78, 50, 68, 68, 69, 67, 50, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x2170 */ 100, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 53, 97, 32, 32, 50,
/* 0x2180 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 50,
/* 0x2190 */  56, 32, 78, 50, 68, 83, 77, 65, 51, 48, 32, 32, 32, 32, 32, 32,
/* 0x21a0 */  48,100, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 54, 55, 32, 32,
/* 0x21b0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x21c0 */  50, 57, 32, 78, 50, 68, 70, 65, 83, 51, 48, 32, 32, 32, 32, 32,
/* 0x21d0 */  32, 48,102, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 55, 52, 32,
/* 0x21e0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x21f0 */  32, 51, 48, 32, 78, 50, 68, 68, 69, 67, 51, 48, 32, 32, 32, 32,
/* 0x2200 */  32, 32, 48, 53, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 56,
/* 0x2210 */  51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2220 */  83, 10, 32, 51, 49, 32, 78, 50, 68, 83, 77, 65, 52, 48, 32, 32,
/* 0x2230 */  32, 32, 32, 32, 48,100, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x2240 */ 100, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2250 */  84, 83, 10, 32, 51, 50, 32, 78, 50, 68, 70, 65, 83, 52, 48, 32,
/* 0x2260 */  32, 32, 32, 32, 32, 48,102, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x2270 */  49,101, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2280 */  78, 84, 83, 10, 32, 51, 51, 32, 78, 50, 68, 83, 77, 65, 53, 48,
/* 0x2290 */  32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x22a0 */  48, 49,102, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x22b0 */  69, 78, 84, 83, 10, 32, 51, 52, 32, 78, 50, 68, 70, 65, 83, 53,
/* 0x22c0 */  48, 32, 32, 32, 32, 32, 32, 48, 51, 32, 32, 48, 32, 32, 48, 32,
/* 0x22d0 */  32, 48, 49,102, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x22e0 */  84, 69, 78, 84, 83, 10, 32, 51, 53, 32, 78, 50, 68, 68, 69, 67,
/* 0x22f0 */  53, 48, 32, 32, 32, 32, 32, 32, 48, 57, 32, 32, 48, 32, 32, 48,
/* 0x2300 */  32, 32, 48, 49,102, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2310 */  78, 84, 69, 78, 84, 83, 10, 32, 51, 54, 32, 78, 50, 68, 83, 77,
/* 0x2320 */  65, 54, 48, 32, 32, 32, 32, 32, 32, 48, 99, 32, 32, 48, 32, 32,
/* 0x2330 */  48, 32, 32, 48, 49,102,102, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2340 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 51, 55, 32, 78, 50, 68, 70,
/* 0x2350 */  65, 83, 54, 48, 32, 32, 32, 32, 32, 32, 48, 49, 57, 32, 32, 48,
/* 0x2360 */  32, 32, 48, 32, 32, 48, 50, 48, 98, 32, 32, 50, 42, 42, 48, 32,
/* 0x2370 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 51, 56, 32, 78, 50,
/* 0x2380 */  68, 70, 65, 83, 54, 49, 32, 32, 32, 32, 32, 32, 48, 49, 54, 32,
/* 0x2390 */  32, 48, 32, 32, 48, 32, 32, 48, 50, 50, 52, 32, 32, 50, 42, 42,
/* 0x23a0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 51, 57, 32,
/* 0x23b0 */  78, 50, 68, 68, 69, 67, 54, 48, 32, 32, 32, 32, 32, 32, 48, 32,
/* 0x23c0 */  32, 48, 32, 32, 48, 32, 32, 48, 50, 51, 97, 32, 32, 50, 42, 42,
/* 0x23d0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 52, 48, 32,
/* 0x23e0 */  78, 50, 69, 83, 77, 65, 49, 48, 32, 32, 32, 32, 32, 32, 48, 51,
/* 0x23f0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 51, 97, 32, 32, 50, 42,
/* 0x2400 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 52, 49,
/* 0x2410 */  32, 78, 50, 69, 70, 65, 83, 49, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x2420 */  50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 51,100, 32, 32, 50,
/* 0x2430 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 52,
/* 0x2440 */  50, 32, 78, 50, 69, 70, 65, 83, 49, 49, 32, 32, 32, 32, 32, 32,
/* 0x2450 */  48, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 51,102, 32, 32,
/* 0x2460 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x2470 */  52, 51, 32, 78, 50, 69, 68, 69, 67, 49, 48, 32, 32, 32, 32, 32,
/* 0x2480 */  32, 48, 98, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 52, 53, 32,
/* 0x2490 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x24a0 */  32, 52, 52, 32, 78, 50, 69, 83, 77, 65, 50, 48, 32, 32, 32, 32,
/* 0x24b0 */  32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 53, 48,
/* 0x24c0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x24d0 */  10, 32, 52, 53, 32, 78, 50, 69, 70, 65, 83, 50, 48, 32, 32, 32,
/* 0x24e0 */  32, 32, 32, 48, 57, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 53,
/* 0x24f0 */  53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2500 */  83, 10, 32, 52, 54, 32, 78, 50, 69, 68, 69, 67, 50, 48, 32, 32,
/* 0x2510 */  32, 32, 32, 32, 48,100, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50,
/* 0x2520 */  53,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2530 */  84, 83, 10, 32, 52, 55, 32, 78, 50, 69, 83, 77, 65, 51, 48, 32,
/* 0x2540 */  32, 32, 32, 32, 32, 48,100, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x2550 */  50, 54, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2560 */  78, 84, 83, 10, 32, 52, 56, 32, 78, 50, 69, 70, 65, 83, 51, 48,
/* 0x2570 */  32, 32, 32, 32, 32, 32, 48,102, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x2580 */  48, 50, 55, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2590 */  69, 78, 84, 83, 10, 32, 52, 57, 32, 78, 50, 69, 68, 69, 67, 51,
/* 0x25a0 */  48, 32, 32, 32, 32, 32, 32, 48, 53,102, 32, 32, 48, 32, 32, 48,
/* 0x25b0 */  32, 32, 48, 50, 56, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x25c0 */  78, 84, 69, 78, 84, 83, 10, 32, 53, 48, 32, 78, 50, 69, 83, 77,
/* 0x25d0 */  65, 52, 48, 32, 32, 32, 32, 32, 32, 48,100, 32, 32, 48, 32, 32,
/* 0x25e0 */  48, 32, 32, 48, 50,101, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x25f0 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 53, 49, 32, 78, 50, 69, 70,
/* 0x2600 */  65, 83, 52, 48, 32, 32, 32, 32, 32, 32, 48,102, 32, 32, 48, 32,
/* 0x2610 */  32, 48, 32, 32, 48, 50,102, 51, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2620 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 53, 50, 32, 78, 50, 69,
/* 0x2630 */  83, 77, 65, 53, 48, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48,
/* 0x2640 */  32, 32, 48, 32, 32, 48, 51, 48, 50, 32, 32, 50, 42, 42, 48, 32,
/* 0x2650 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 53, 51, 32, 78, 50,
/* 0x2660 */  69, 70, 65, 83, 53, 48, 32, 32, 32, 32, 32, 32, 48, 51, 32, 32,
/* 0x2670 */  48, 32, 32, 48, 32, 32, 48, 51, 48, 52, 32, 32, 50, 42, 42, 48,
/* 0x2680 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 53, 52, 32, 78,
/* 0x2690 */  50, 69, 68, 69, 67, 53, 48, 32, 32, 32, 32, 32, 32, 48, 57, 32,
/* 0x26a0 */  32, 48, 32, 32, 48, 32, 32, 48, 51, 48, 55, 32, 32, 50, 42, 42,
/* 0x26b0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 53, 53, 32,
/* 0x26c0 */  78, 50, 69, 83, 77, 65, 54, 48, 32, 32, 32, 32, 32, 32, 48, 99,
/* 0x26d0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 49, 48, 32, 32, 50, 42,
/* 0x26e0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 53, 54,
/* 0x26f0 */  32, 78, 50, 69, 70, 65, 83, 54, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x2700 */  49, 57, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 49, 99, 32, 32,
/* 0x2710 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x2720 */  53, 55, 32, 78, 50, 69, 70, 65, 83, 54, 49, 32, 32, 32, 32, 32,
/* 0x2730 */  32, 48, 49, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 51, 53,
/* 0x2740 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2750 */  10, 32, 53, 56, 32, 78, 50, 69, 68, 69, 67, 54, 48, 32, 32, 32,
/* 0x2760 */  32, 32, 32, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 52, 98,
/* 0x2770 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2780 */  10, 32, 53, 57, 32, 67, 76, 49, 83, 77, 65, 49, 66, 32, 32, 32,
/* 0x2790 */  32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 52,
/* 0x27a0 */  98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x27b0 */  83, 10, 32, 54, 48, 32, 67, 76, 49, 70, 65, 83, 49, 66, 32, 32,
/* 0x27c0 */  32, 32, 32, 32, 48, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51,
/* 0x27d0 */  52,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x27e0 */  84, 83, 10, 32, 54, 49, 32, 67, 76, 49, 71, 69, 84, 49, 66, 32,
/* 0x27f0 */  32, 32, 32, 32, 32, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51,
/* 0x2800 */  53, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2810 */  84, 83, 10, 32, 54, 50, 32, 67, 76, 49, 69, 78, 84, 69, 82, 32,
/* 0x2820 */  32, 32, 32, 32, 32, 48, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x2830 */  51, 53, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2840 */  78, 84, 83, 10, 32, 54, 51, 32, 67, 76, 49, 83, 77, 65, 49, 48,
/* 0x2850 */  32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x2860 */  48, 51, 53, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2870 */  69, 78, 84, 83, 10, 32, 54, 52, 32, 67, 76, 49, 82, 76, 79, 65,
/* 0x2880 */  68, 32, 32, 32, 32, 32, 32, 48, 56, 32, 32, 48, 32, 32, 48, 32,
/* 0x2890 */  32, 48, 51, 53,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x28a0 */  84, 69, 78, 84, 83, 10, 32, 54, 53, 32, 67, 76, 49, 87, 73, 68,
/* 0x28b0 */  48, 49, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48,
/* 0x28c0 */  32, 32, 48, 51, 54, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x28d0 */  78, 84, 69, 78, 84, 83, 10, 32, 54, 54, 32, 67, 76, 49, 87, 73,
/* 0x28e0 */  68, 48, 50, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32,
/* 0x28f0 */  48, 32, 32, 48, 51, 54, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2900 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 54, 55, 32, 67, 76, 49, 87,
/* 0x2910 */  73, 68, 48, 51, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32,
/* 0x2920 */  32, 48, 32, 32, 48, 51, 54, 97, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2930 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 54, 56, 32, 67, 76, 49,
/* 0x2940 */  87, 73, 68, 48, 52, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48,
/* 0x2950 */  32, 32, 48, 32, 32, 48, 51, 54, 99, 32, 32, 50, 42, 42, 48, 32,
/* 0x2960 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 54, 57, 32, 67, 76,
/* 0x2970 */  49, 87, 73, 68, 48, 53, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32,
/* 0x2980 */  48, 32, 32, 48, 32, 32, 48, 51, 54,101, 32, 32, 50, 42, 42, 48,
/* 0x2990 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 55, 48, 32, 67,
/* 0x29a0 */  76, 49, 87, 73, 68, 48, 54, 32, 32, 32, 32, 32, 32, 48, 50, 32,
/* 0x29b0 */  32, 48, 32, 32, 48, 32, 32, 48, 51, 55, 48, 32, 32, 50, 42, 42,
/* 0x29c0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 55, 49, 32,
/* 0x29d0 */  67, 76, 49, 87, 73, 68, 48, 55, 32, 32, 32, 32, 32, 32, 48, 51,
/* 0x29e0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 55, 50, 32, 32, 50, 42,
/* 0x29f0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 55, 50,
/* 0x2a00 */  32, 67, 76, 49, 87, 73, 68, 48, 56, 32, 32, 32, 32, 32, 32, 48,
/* 0x2a10 */  49, 97, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 55, 53, 32, 32,
/* 0x2a20 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x2a30 */  55, 51, 32, 67, 76, 49, 87, 73, 68, 48, 57, 32, 32, 32, 32, 32,
/* 0x2a40 */  32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 56,102, 32,
/* 0x2a50 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x2a60 */  32, 55, 52, 32, 67, 76, 49, 87, 73, 68, 49, 48, 32, 32, 32, 32,
/* 0x2a70 */  32, 32, 48, 49, 49, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 57,
/* 0x2a80 */  49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2a90 */  83, 10, 32, 55, 53, 32, 67, 76, 49, 83, 84, 65, 82, 84, 32, 32,
/* 0x2aa0 */  32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51,
/* 0x2ab0 */  97, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2ac0 */  84, 83, 10, 32, 55, 54, 32, 67, 76, 49, 84, 79, 80, 48, 48, 32,
/* 0x2ad0 */  32, 32, 32, 32, 32, 48, 51, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x2ae0 */  51, 97, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2af0 */  78, 84, 83, 10, 32, 55, 55, 32, 67, 76, 49, 84, 79, 80, 48, 49,
/* 0x2b00 */  32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x2b10 */  48, 51, 97, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2b20 */  69, 78, 84, 83, 10, 32, 55, 56, 32, 67, 76, 49, 84, 79, 80, 48,
/* 0x2b30 */  50, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32,
/* 0x2b40 */  32, 48, 51, 97, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x2b50 */  84, 69, 78, 84, 83, 10, 32, 55, 57, 32, 67, 76, 49, 84, 79, 80,
/* 0x2b60 */  48, 51, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48,
/* 0x2b70 */  32, 32, 48, 51, 97,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2b80 */  78, 84, 69, 78, 84, 83, 10, 32, 56, 48, 32, 67, 76, 49, 84, 79,
/* 0x2b90 */  80, 48, 52, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32,
/* 0x2ba0 */  48, 32, 32, 48, 51, 98, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2bb0 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 56, 49, 32, 67, 76, 49, 84,
/* 0x2bc0 */  79, 80, 48, 53, 32, 32, 32, 32, 32, 32, 48, 51, 32, 32, 48, 32,
/* 0x2bd0 */  32, 48, 32, 32, 48, 51, 98, 53, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2be0 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 56, 50, 32, 67, 76, 49,
/* 0x2bf0 */  84, 79, 80, 48, 54, 32, 32, 32, 32, 32, 32, 48, 55, 32, 32, 48,
/* 0x2c00 */  32, 32, 48, 32, 32, 48, 51, 98, 56, 32, 32, 50, 42, 42, 48, 32,
/* 0x2c10 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 56, 51, 32, 67, 76,
/* 0x2c20 */  49, 84, 79, 80, 48, 55, 32, 32, 32, 32, 32, 32, 48, 49, 55, 32,
/* 0x2c30 */  32, 48, 32, 32, 48, 32, 32, 48, 51, 98,102, 32, 32, 50, 42, 42,
/* 0x2c40 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 56, 52, 32,
/* 0x2c50 */  67, 76, 49, 79, 70, 70, 48, 49, 32, 32, 32, 32, 32, 32, 48, 50,
/* 0x2c60 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 51,100, 54, 32, 32, 50, 42,
/* 0x2c70 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 56, 53,
/* 0x2c80 */  32, 67, 76, 49, 79, 70, 70, 48, 50, 32, 32, 32, 32, 32, 32, 48,
/* 0x2c90 */  49, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51,100, 56, 32, 32,
/* 0x2ca0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x2cb0 */  56, 54, 32, 67, 76, 49, 79, 70, 70, 48, 51, 32, 32, 32, 32, 32,
/* 0x2cc0 */  32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51,101, 97, 32,
/* 0x2cd0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x2ce0 */  32, 56, 55, 32, 67, 76, 49, 79, 70, 70, 48, 52, 32, 32, 32, 32,
/* 0x2cf0 */  32, 32, 48, 52, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51,101, 99,
/* 0x2d00 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2d10 */  10, 32, 56, 56, 32, 67, 76, 49, 76, 69, 78, 48, 48, 32, 32, 32,
/* 0x2d20 */  32, 32, 32, 48, 49, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51,102,
/* 0x2d30 */  48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2d40 */  83, 10, 32, 56, 57, 32, 67, 76, 49, 76, 69, 78, 48, 49, 32, 32,
/* 0x2d50 */  32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51,
/* 0x2d60 */ 102, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2d70 */  84, 83, 10, 32, 57, 48, 32, 67, 76, 49, 76, 69, 78, 48, 50, 32,
/* 0x2d80 */  32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x2d90 */  51,102, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2da0 */  78, 84, 83, 10, 32, 57, 49, 32, 67, 76, 49, 67, 79, 80, 89, 48,
/* 0x2db0 */  32, 32, 32, 32, 32, 32, 48, 51, 51, 32, 32, 48, 32, 32, 48, 32,
/* 0x2dc0 */  32, 48, 51,102, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x2dd0 */  84, 69, 78, 84, 83, 10, 32, 57, 50, 32, 67, 76, 49, 69, 78, 68,
/* 0x2de0 */  32, 32, 32, 32, 32, 32, 32, 32, 48, 32, 32, 48, 32, 32, 48, 32,
/* 0x2df0 */  32, 48, 52, 50, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x2e00 */  84, 69, 78, 84, 83, 10, 32, 57, 51, 32, 76, 90, 77, 65, 95, 68,
/* 0x2e10 */  69, 67, 48, 48, 32, 32, 32, 32, 48, 50,101, 32, 32, 48, 32, 32,
/* 0x2e20 */  48, 32, 32, 48, 52, 50, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2e30 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 57, 52, 32, 76, 90, 77, 65,
/* 0x2e40 */  95, 69, 76, 70, 48, 48, 32, 32, 32, 32, 48, 52, 56, 32, 32, 48,
/* 0x2e50 */  32, 32, 48, 32, 32, 48, 52, 53, 57, 32, 32, 50, 42, 42, 48, 32,
/* 0x2e60 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 57, 53, 32, 76, 90,
/* 0x2e70 */  77, 65, 95, 68, 69, 67, 49, 48, 32, 32, 32, 32, 48, 98, 51,101,
/* 0x2e80 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 52, 97, 49, 32, 32, 50, 42,
/* 0x2e90 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 57, 54,
/* 0x2ea0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 32, 32, 32, 32, 48,
/* 0x2eb0 */  98, 51,101, 32, 32, 48, 32, 32, 48, 32, 32, 48,102,100,102, 32,
/* 0x2ec0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x2ed0 */  32, 57, 55, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 32, 32,
/* 0x2ee0 */  32, 32, 48, 49, 97, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98,
/* 0x2ef0 */  49,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2f00 */  84, 83, 10, 32, 57, 56, 32, 67, 65, 76, 76, 84, 82, 48, 48, 32,
/* 0x2f10 */  32, 32, 32, 32, 32, 48,101, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x2f20 */  49, 98, 51, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2f30 */  69, 78, 84, 83, 10, 32, 57, 57, 32, 67, 84, 67, 76, 69, 86, 69,
/* 0x2f40 */  49, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32,
/* 0x2f50 */  32, 48, 49, 98, 52, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2f60 */  78, 84, 69, 78, 84, 83, 10, 49, 48, 48, 32, 67, 65, 76, 76, 84,
/* 0x2f70 */  82, 48, 49, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32,
/* 0x2f80 */  48, 32, 32, 48, 49, 98, 52, 97, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2f90 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 48, 49, 32, 67, 84, 66,
/* 0x2fa0 */  83, 72, 82, 48, 49, 32, 32, 32, 32, 32, 32, 48, 52, 32, 32, 48,
/* 0x2fb0 */  32, 32, 48, 32, 32, 48, 49, 98, 52,102, 32, 32, 50, 42, 42, 48,
/* 0x2fc0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 48, 50, 32, 67,
/* 0x2fd0 */  84, 66, 82, 79, 82, 48, 49, 32, 32, 32, 32, 32, 32, 48, 50, 32,
/* 0x2fe0 */  32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 53, 51, 32, 32, 50, 42,
/* 0x2ff0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 48, 51,
/* 0x3000 */  32, 67, 84, 66, 83, 87, 65, 48, 49, 32, 32, 32, 32, 32, 32, 48,
/* 0x3010 */  53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 53, 53, 32, 32,
/* 0x3020 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49,
/* 0x3030 */  48, 52, 32, 67, 65, 76, 76, 84, 82, 48, 50, 32, 32, 32, 32, 32,
/* 0x3040 */  32, 48,101, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 53, 97,
/* 0x3050 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x3060 */  10, 49, 48, 53, 32, 67, 65, 76, 76, 84, 82, 49, 48, 32, 32, 32,
/* 0x3070 */  32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98,
/* 0x3080 */  54, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x3090 */  84, 83, 10, 49, 48, 54, 32, 67, 65, 76, 76, 84, 82, 69, 56, 32,
/* 0x30a0 */  32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x30b0 */  49, 98, 54,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x30c0 */  69, 78, 84, 83, 10, 49, 48, 55, 32, 67, 65, 76, 76, 84, 82, 69,
/* 0x30d0 */  57, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32,
/* 0x30e0 */  32, 48, 49, 98, 54,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x30f0 */  78, 84, 69, 78, 84, 83, 10, 49, 48, 56, 32, 67, 65, 76, 76, 84,
/* 0x3100 */  82, 49, 49, 32, 32, 32, 32, 32, 32, 48, 52, 32, 32, 48, 32, 32,
/* 0x3110 */  48, 32, 32, 48, 49, 98, 55, 49, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x3120 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 48, 57, 32, 67, 84, 67,
/* 0x3130 */  76, 69, 86, 69, 50, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48,
/* 0x3140 */  32, 32, 48, 32, 32, 48, 49, 98, 55, 53, 32, 32, 50, 42, 42, 48,
/* 0x3150 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 49, 48, 32, 67,
/* 0x3160 */  65, 76, 76, 84, 82, 49, 50, 32, 32, 32, 32, 32, 32, 48, 50, 32,
/* 0x3170 */  32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 55, 97, 32, 32, 50, 42,
/* 0x3180 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 49, 49,
/* 0x3190 */  32, 67, 84, 66, 83, 72, 82, 49, 49, 32, 32, 32, 32, 32, 32, 48,
/* 0x31a0 */  52, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 55, 99, 32, 32,
/* 0x31b0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49,
/* 0x31c0 */  49, 50, 32, 67, 84, 66, 82, 79, 82, 49, 49, 32, 32, 32, 32, 32,
/* 0x31d0 */  32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 56, 48,
/* 0x31e0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x31f0 */  10, 49, 49, 51, 32, 67, 84, 66, 83, 87, 65, 49, 49, 32, 32, 32,
/* 0x3200 */  32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98,
/* 0x3210 */  56, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x3220 */  84, 83, 10, 49, 49, 52, 32, 67, 65, 76, 76, 84, 82, 49, 51, 32,
/* 0x3230 */  32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x3240 */  49, 98, 56, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x3250 */  69, 78, 84, 83, 10, 49, 49, 53, 32, 76, 69, 88, 69, 67, 48, 49,
/* 0x3260 */  53, 32, 32, 32, 32, 32, 32, 48, 49, 98, 32, 32, 48, 32, 32, 48,
/* 0x3270 */  32, 32, 48, 49, 98, 56, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x3280 */  79, 78, 84, 69, 78, 84, 83, 10, 49, 49, 54, 32, 76, 69, 88, 69,
/* 0x3290 */  67, 48, 49, 55, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32,
/* 0x32a0 */  32, 48, 32, 32, 48, 49, 98, 97, 55, 32, 32, 50, 42, 42, 48, 32,
/* 0x32b0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 49, 55, 32, 76, 69,
/* 0x32c0 */  88, 69, 67, 48, 50, 48, 32, 32, 32, 32, 32, 32, 48, 51, 49, 32,
/* 0x32d0 */  32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 97, 57, 32, 32, 50, 42,
/* 0x32e0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 83, 89, 77,
/* 0x32f0 */  66, 79, 76, 32, 84, 65, 66, 76, 69, 58, 10, 48, 48, 48, 48, 48,
/* 0x3300 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83,
/* 0x3310 */  77, 65, 49, 48, 32, 48, 32, 78, 50, 66, 83, 77, 65, 49, 48, 10,
/* 0x3320 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x3330 */  32, 78, 50, 66, 70, 65, 83, 49, 49, 32, 48, 32, 78, 50, 66, 70,
/* 0x3340 */  65, 83, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3350 */  32, 32, 32,100, 32, 32, 78, 50, 66, 68, 69, 67, 49, 48, 32, 48,
/* 0x3360 */  32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x3370 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 68, 69,
/* 0x3380 */  67, 50, 48, 32, 48, 32, 78, 50, 66, 68, 69, 67, 50, 48, 10, 48,
/* 0x3390 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x33a0 */  78, 50, 66, 68, 69, 67, 51, 48, 32, 48, 32, 78, 50, 66, 68, 69,
/* 0x33b0 */  67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x33c0 */  32, 32,100, 32, 32, 78, 50, 66, 68, 69, 67, 53, 48, 32, 48, 32,
/* 0x33d0 */  78, 50, 66, 68, 69, 67, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x33e0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83,
/* 0x33f0 */  54, 49, 32, 48, 32, 78, 50, 66, 70, 65, 83, 54, 49, 10, 48, 48,
/* 0x3400 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x3410 */  50, 66, 68, 69, 67, 54, 48, 32, 48, 32, 78, 50, 66, 68, 69, 67,
/* 0x3420 */  54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3430 */  32,100, 32, 32, 78, 50, 68, 83, 77, 65, 49, 48, 32, 48, 32, 78,
/* 0x3440 */  50, 68, 83, 77, 65, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3450 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 49,
/* 0x3460 */  49, 32, 48, 32, 78, 50, 68, 70, 65, 83, 49, 49, 10, 48, 48, 48,
/* 0x3470 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x3480 */  68, 68, 69, 67, 49, 48, 32, 48, 32, 78, 50, 68, 68, 69, 67, 49,
/* 0x3490 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x34a0 */ 100, 32, 32, 78, 50, 68, 68, 69, 67, 50, 48, 32, 48, 32, 78, 50,
/* 0x34b0 */  68, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x34c0 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48,
/* 0x34d0 */  32, 48, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48,
/* 0x34e0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68,
/* 0x34f0 */  68, 69, 67, 53, 48, 32, 48, 32, 78, 50, 68, 68, 69, 67, 53, 48,
/* 0x3500 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x3510 */  32, 32, 78, 50, 68, 70, 65, 83, 54, 49, 32, 48, 32, 78, 50, 68,
/* 0x3520 */  70, 65, 83, 54, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x3530 */  32, 32, 32, 32,100, 32, 32, 78, 50, 68, 68, 69, 67, 54, 48, 32,
/* 0x3540 */  48, 32, 78, 50, 68, 68, 69, 67, 54, 48, 10, 48, 48, 48, 48, 48,
/* 0x3550 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83,
/* 0x3560 */  77, 65, 49, 48, 32, 48, 32, 78, 50, 69, 83, 77, 65, 49, 48, 10,
/* 0x3570 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x3580 */  32, 78, 50, 69, 70, 65, 83, 49, 49, 32, 48, 32, 78, 50, 69, 70,
/* 0x3590 */  65, 83, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x35a0 */  32, 32, 32,100, 32, 32, 78, 50, 69, 68, 69, 67, 49, 48, 32, 48,
/* 0x35b0 */  32, 78, 50, 69, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x35c0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 68, 69,
/* 0x35d0 */  67, 50, 48, 32, 48, 32, 78, 50, 69, 68, 69, 67, 50, 48, 10, 48,
/* 0x35e0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x35f0 */  78, 50, 69, 68, 69, 67, 51, 48, 32, 48, 32, 78, 50, 69, 68, 69,
/* 0x3600 */  67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x3610 */  32, 32,100, 32, 32, 78, 50, 69, 68, 69, 67, 53, 48, 32, 48, 32,
/* 0x3620 */  78, 50, 69, 68, 69, 67, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3630 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83,
/* 0x3640 */  54, 49, 32, 48, 32, 78, 50, 69, 70, 65, 83, 54, 49, 10, 48, 48,
/* 0x3650 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x3660 */  50, 69, 68, 69, 67, 54, 48, 32, 48, 32, 78, 50, 69, 68, 69, 67,
/* 0x3670 */  54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3680 */  32,100, 32, 32, 67, 76, 49, 82, 76, 79, 65, 68, 32, 48, 32, 67,
/* 0x3690 */  76, 49, 82, 76, 79, 65, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x36a0 */  32,108, 32, 32, 32, 32,100, 32, 32, 67, 76, 49, 87, 73, 68, 48,
/* 0x36b0 */  49, 32, 48, 32, 67, 76, 49, 87, 73, 68, 48, 49, 10, 48, 48, 48,
/* 0x36c0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 76,
/* 0x36d0 */  49, 87, 73, 68, 48, 54, 32, 48, 32, 67, 76, 49, 87, 73, 68, 48,
/* 0x36e0 */  54, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x36f0 */ 100, 32, 32, 67, 76, 49, 87, 73, 68, 48, 56, 32, 48, 32, 67, 76,
/* 0x3700 */  49, 87, 73, 68, 48, 56, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3710 */ 108, 32, 32, 32, 32,100, 32, 32, 67, 76, 49, 87, 73, 68, 49, 48,
/* 0x3720 */  32, 48, 32, 67, 76, 49, 87, 73, 68, 49, 48, 10, 48, 48, 48, 48,
/* 0x3730 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 76, 49,
/* 0x3740 */  83, 84, 65, 82, 84, 32, 48, 32, 67, 76, 49, 83, 84, 65, 82, 84,
/* 0x3750 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x3760 */  32, 32, 67, 76, 49, 84, 79, 80, 48, 48, 32, 48, 32, 67, 76, 49,
/* 0x3770 */  84, 79, 80, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x3780 */  32, 32, 32, 32,100, 32, 32, 67, 76, 49, 84, 79, 80, 48, 54, 32,
/* 0x3790 */  48, 32, 67, 76, 49, 84, 79, 80, 48, 54, 10, 48, 48, 48, 48, 48,
/* 0x37a0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 76, 49, 84,
/* 0x37b0 */  79, 80, 48, 55, 32, 48, 32, 67, 76, 49, 84, 79, 80, 48, 55, 10,
/* 0x37c0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x37d0 */  32, 67, 76, 49, 76, 69, 78, 48, 48, 32, 48, 32, 67, 76, 49, 76,
/* 0x37e0 */  69, 78, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x37f0 */  32, 32, 32,100, 32, 32, 67, 76, 49, 67, 79, 80, 89, 48, 32, 48,
/* 0x3800 */  32, 67, 76, 49, 67, 79, 80, 89, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x3810 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84,
/* 0x3820 */  82, 48, 48, 32, 48, 32, 67, 65, 76, 76, 84, 82, 48, 48, 10, 48,
/* 0x3830 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3840 */  67, 65, 76, 76, 84, 82, 49, 48, 32, 48, 32, 67, 65, 76, 76, 84,
/* 0x3850 */  82, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x3860 */  32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 49, 49, 32, 48, 32,
/* 0x3870 */  67, 65, 76, 76, 84, 82, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3880 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82,
/* 0x3890 */  49, 51, 32, 48, 32, 67, 65, 76, 76, 84, 82, 49, 51, 10, 48, 48,
/* 0x38a0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,
/* 0x38b0 */  69, 88, 69, 67, 48, 50, 48, 32, 48, 32, 76, 69, 88, 69, 67, 48,
/* 0x38c0 */  50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x38d0 */  32,100, 32, 32, 76, 69, 88, 69, 67, 48, 48, 48, 32, 48, 32, 76,
/* 0x38e0 */  69, 88, 69, 67, 48, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x38f0 */  32,108, 32, 32, 32, 32,100, 32, 32, 76, 69, 88, 69, 67, 48, 49,
/* 0x3900 */  48, 32, 48, 32, 76, 69, 88, 69, 67, 48, 49, 48, 10, 48, 48, 48,
/* 0x3910 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x3920 */  66, 70, 65, 83, 49, 48, 32, 48, 32, 78, 50, 66, 70, 65, 83, 49,
/* 0x3930 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x3940 */ 100, 32, 32, 78, 50, 66, 83, 77, 65, 50, 48, 32, 48, 32, 78, 50,
/* 0x3950 */  66, 83, 77, 65, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3960 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 50, 48,
/* 0x3970 */  32, 48, 32, 78, 50, 66, 70, 65, 83, 50, 48, 10, 48, 48, 48, 48,
/* 0x3980 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66,
/* 0x3990 */  83, 77, 65, 51, 48, 32, 48, 32, 78, 50, 66, 83, 77, 65, 51, 48,
/* 0x39a0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x39b0 */  32, 32, 78, 50, 66, 70, 65, 83, 51, 48, 32, 48, 32, 78, 50, 66,
/* 0x39c0 */  70, 65, 83, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x39d0 */  32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77, 65, 52, 48, 32,
/* 0x39e0 */  48, 32, 78, 50, 66, 83, 77, 65, 52, 48, 10, 48, 48, 48, 48, 48,
/* 0x39f0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70,
/* 0x3a00 */  65, 83, 52, 48, 32, 48, 32, 78, 50, 66, 70, 65, 83, 52, 48, 10,
/* 0x3a10 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x3a20 */  32, 78, 50, 66, 83, 77, 65, 53, 48, 32, 48, 32, 78, 50, 66, 83,
/* 0x3a30 */  77, 65, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3a40 */  32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 53, 48, 32, 48,
/* 0x3a50 */  32, 78, 50, 66, 70, 65, 83, 53, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x3a60 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77,
/* 0x3a70 */  65, 54, 48, 32, 48, 32, 78, 50, 66, 83, 77, 65, 54, 48, 10, 48,
/* 0x3a80 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3a90 */  78, 50, 66, 70, 65, 83, 54, 48, 32, 48, 32, 78, 50, 66, 70, 65,
/* 0x3aa0 */  83, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x3ab0 */  32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 49, 48, 32, 48, 32,
/* 0x3ac0 */  78, 50, 68, 70, 65, 83, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3ad0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 83, 77, 65,
/* 0x3ae0 */  50, 48, 32, 48, 32, 78, 50, 68, 83, 77, 65, 50, 48, 10, 48, 48,
/* 0x3af0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x3b00 */  50, 68, 70, 65, 83, 50, 48, 32, 48, 32, 78, 50, 68, 70, 65, 83,
/* 0x3b10 */  50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3b20 */  32,100, 32, 32, 78, 50, 68, 83, 77, 65, 51, 48, 32, 48, 32, 78,
/* 0x3b30 */  50, 68, 83, 77, 65, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3b40 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 51,
/* 0x3b50 */  48, 32, 48, 32, 78, 50, 68, 70, 65, 83, 51, 48, 10, 48, 48, 48,
/* 0x3b60 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x3b70 */  68, 83, 77, 65, 52, 48, 32, 48, 32, 78, 50, 68, 83, 77, 65, 52,
/* 0x3b80 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x3b90 */ 100, 32, 32, 78, 50, 68, 70, 65, 83, 52, 48, 32, 48, 32, 78, 50,
/* 0x3ba0 */  68, 70, 65, 83, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3bb0 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 83, 77, 65, 53, 48,
/* 0x3bc0 */  32, 48, 32, 78, 50, 68, 83, 77, 65, 53, 48, 10, 48, 48, 48, 48,
/* 0x3bd0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68,
/* 0x3be0 */  70, 65, 83, 53, 48, 32, 48, 32, 78, 50, 68, 70, 65, 83, 53, 48,
/* 0x3bf0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x3c00 */  32, 32, 78, 50, 68, 83, 77, 65, 54, 48, 32, 48, 32, 78, 50, 68,
/* 0x3c10 */  83, 77, 65, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x3c20 */  32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 54, 48, 32,
/* 0x3c30 */  48, 32, 78, 50, 68, 70, 65, 83, 54, 48, 10, 48, 48, 48, 48, 48,
/* 0x3c40 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70,
/* 0x3c50 */  65, 83, 49, 48, 32, 48, 32, 78, 50, 69, 70, 65, 83, 49, 48, 10,
/* 0x3c60 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x3c70 */  32, 78, 50, 69, 83, 77, 65, 50, 48, 32, 48, 32, 78, 50, 69, 83,
/* 0x3c80 */  77, 65, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3c90 */  32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83, 50, 48, 32, 48,
/* 0x3ca0 */  32, 78, 50, 69, 70, 65, 83, 50, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x3cb0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77,
/* 0x3cc0 */  65, 51, 48, 32, 48, 32, 78, 50, 69, 83, 77, 65, 51, 48, 10, 48,
/* 0x3cd0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3ce0 */  78, 50, 69, 70, 65, 83, 51, 48, 32, 48, 32, 78, 50, 69, 70, 65,
/* 0x3cf0 */  83, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x3d00 */  32, 32,100, 32, 32, 78, 50, 69, 83, 77, 65, 52, 48, 32, 48, 32,
/* 0x3d10 */  78, 50, 69, 83, 77, 65, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3d20 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83,
/* 0x3d30 */  52, 48, 32, 48, 32, 78, 50, 69, 70, 65, 83, 52, 48, 10, 48, 48,
/* 0x3d40 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x3d50 */  50, 69, 83, 77, 65, 53, 48, 32, 48, 32, 78, 50, 69, 83, 77, 65,
/* 0x3d60 */  53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3d70 */  32,100, 32, 32, 78, 50, 69, 70, 65, 83, 53, 48, 32, 48, 32, 78,
/* 0x3d80 */  50, 69, 70, 65, 83, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3d90 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77, 65, 54,
/* 0x3da0 */  48, 32, 48, 32, 78, 50, 69, 83, 77, 65, 54, 48, 10, 48, 48, 48,
/* 0x3db0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x3dc0 */  69, 70, 65, 83, 54, 48, 32, 48, 32, 78, 50, 69, 70, 65, 83, 54,
/* 0x3dd0 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x3de0 */ 100, 32, 32, 67, 76, 49, 83, 77, 65, 49, 66, 32, 48, 32, 67, 76,
/* 0x3df0 */  49, 83, 77, 65, 49, 66, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3e00 */ 108, 32, 32, 32, 32,100, 32, 32, 67, 76, 49, 70, 65, 83, 49, 66,
/* 0x3e10 */  32, 48, 32, 67, 76, 49, 70, 65, 83, 49, 66, 10, 48, 48, 48, 48,
/* 0x3e20 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 76, 49,
/* 0x3e30 */  71, 69, 84, 49, 66, 32, 48, 32, 67, 76, 49, 71, 69, 84, 49, 66,
/* 0x3e40 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x3e50 */  32, 32, 67, 76, 49, 69, 78, 84, 69, 82, 32, 48, 32, 67, 76, 49,
/* 0x3e60 */  69, 78, 84, 69, 82, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x3e70 */  32, 32, 32, 32,100, 32, 32, 67, 76, 49, 83, 77, 65, 49, 48, 32,
/* 0x3e80 */  48, 32, 67, 76, 49, 83, 77, 65, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x3e90 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 76, 49, 87,
/* 0x3ea0 */  73, 68, 48, 50, 32, 48, 32, 67, 76, 49, 87, 73, 68, 48, 50, 10,
/* 0x3eb0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x3ec0 */  32, 67, 76, 49, 87, 73, 68, 48, 51, 32, 48, 32, 67, 76, 49, 87,
/* 0x3ed0 */  73, 68, 48, 51, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3ee0 */  32, 32, 32,100, 32, 32, 67, 76, 49, 87, 73, 68, 48, 52, 32, 48,
/* 0x3ef0 */  32, 67, 76, 49, 87, 73, 68, 48, 52, 10, 48, 48, 48, 48, 48, 48,
/* 0x3f00 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 76, 49, 87, 73,
/* 0x3f10 */  68, 48, 53, 32, 48, 32, 67, 76, 49, 87, 73, 68, 48, 53, 10, 48,
/* 0x3f20 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3f30 */  67, 76, 49, 87, 73, 68, 48, 55, 32, 48, 32, 67, 76, 49, 87, 73,
/* 0x3f40 */  68, 48, 55, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x3f50 */  32, 32,100, 32, 32, 67, 76, 49, 87, 73, 68, 48, 57, 32, 48, 32,
/* 0x3f60 */  67, 76, 49, 87, 73, 68, 48, 57, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3f70 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 76, 49, 84, 79, 80,
/* 0x3f80 */  48, 49, 32, 48, 32, 67, 76, 49, 84, 79, 80, 48, 49, 10, 48, 48,
/* 0x3f90 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,
/* 0x3fa0 */  76, 49, 84, 79, 80, 48, 50, 32, 48, 32, 67, 76, 49, 84, 79, 80,
/* 0x3fb0 */  48, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3fc0 */  32,100, 32, 32, 67, 76, 49, 84, 79, 80, 48, 51, 32, 48, 32, 67,
/* 0x3fd0 */  76, 49, 84, 79, 80, 48, 51, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3fe0 */  32,108, 32, 32, 32, 32,100, 32, 32, 67, 76, 49, 84, 79, 80, 48,
/* 0x3ff0 */  52, 32, 48, 32, 67, 76, 49, 84, 79, 80, 48, 52, 10, 48, 48, 48,
/* 0x4000 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 76,
/* 0x4010 */  49, 84, 79, 80, 48, 53, 32, 48, 32, 67, 76, 49, 84, 79, 80, 48,
/* 0x4020 */  53, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x4030 */ 100, 32, 32, 67, 76, 49, 79, 70, 70, 48, 49, 32, 48, 32, 67, 76,
/* 0x4040 */  49, 79, 70, 70, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4050 */ 108, 32, 32, 32, 32,100, 32, 32, 67, 76, 49, 79, 70, 70, 48, 50,
/* 0x4060 */  32, 48, 32, 67, 76, 49, 79, 70, 70, 48, 50, 10, 48, 48, 48, 48,
/* 0x4070 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 76, 49,
/* 0x4080 */  79, 70, 70, 48, 51, 32, 48, 32, 67, 76, 49, 79, 70, 70, 48, 51,
/* 0x4090 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x40a0 */  32, 32, 67, 76, 49, 79, 70, 70, 48, 52, 32, 48, 32, 67, 76, 49,
/* 0x40b0 */  79, 70, 70, 48, 52, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x40c0 */  32, 32, 32, 32,100, 32, 32, 67, 76, 49, 76, 69, 78, 48, 49, 32,
/* 0x40d0 */  48, 32, 67, 76, 49, 76, 69, 78, 48, 49, 10, 48, 48, 48, 48, 48,
/* 0x40e0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 76, 49, 76,
/* 0x40f0 */  69, 78, 48, 50, 32, 48, 32, 67, 76, 49, 76, 69, 78, 48, 50, 10,
/* 0x4100 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x4110 */  32, 67, 76, 49, 69, 78, 68, 32, 48, 32, 67, 76, 49, 69, 78, 68,
/* 0x4120 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x4130 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 48, 48, 32, 48, 32, 76,
/* 0x4140 */  90, 77, 65, 95, 68, 69, 67, 48, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x4150 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95,
/* 0x4160 */  69, 76, 70, 48, 48, 32, 48, 32, 76, 90, 77, 65, 95, 69, 76, 70,
/* 0x4170 */  48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x4180 */  32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 32, 48,
/* 0x4190 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,
/* 0x41a0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77,
/* 0x41b0 */  65, 95, 68, 69, 67, 50, 48, 32, 48, 32, 76, 90, 77, 65, 95, 68,
/* 0x41c0 */  69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x41d0 */  32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48,
/* 0x41e0 */  32, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 10, 48, 48,
/* 0x41f0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,
/* 0x4200 */  84, 67, 76, 69, 86, 69, 49, 32, 48, 32, 67, 84, 67, 76, 69, 86,
/* 0x4210 */  69, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x4220 */  32,100, 32, 32, 67, 65, 76, 76, 84, 82, 48, 49, 32, 48, 32, 67,
/* 0x4230 */  65, 76, 76, 84, 82, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4240 */  32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 66, 83, 72, 82, 48,
/* 0x4250 */  49, 32, 48, 32, 67, 84, 66, 83, 72, 82, 48, 49, 10, 48, 48, 48,
/* 0x4260 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84,
/* 0x4270 */  66, 82, 79, 82, 48, 49, 32, 48, 32, 67, 84, 66, 82, 79, 82, 48,
/* 0x4280 */  49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x4290 */ 100, 32, 32, 67, 84, 66, 83, 87, 65, 48, 49, 32, 48, 32, 67, 84,
/* 0x42a0 */  66, 83, 87, 65, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x42b0 */ 108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 48, 50,
/* 0x42c0 */  32, 48, 32, 67, 65, 76, 76, 84, 82, 48, 50, 10, 48, 48, 48, 48,
/* 0x42d0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76,
/* 0x42e0 */  76, 84, 82, 69, 56, 32, 48, 32, 67, 65, 76, 76, 84, 82, 69, 56,
/* 0x42f0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x4300 */  32, 32, 67, 65, 76, 76, 84, 82, 69, 57, 32, 48, 32, 67, 65, 76,
/* 0x4310 */  76, 84, 82, 69, 57, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4320 */  32, 32, 32, 32,100, 32, 32, 67, 84, 67, 76, 69, 86, 69, 50, 32,
/* 0x4330 */  48, 32, 67, 84, 67, 76, 69, 86, 69, 50, 10, 48, 48, 48, 48, 48,
/* 0x4340 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76,
/* 0x4350 */  84, 82, 49, 50, 32, 48, 32, 67, 65, 76, 76, 84, 82, 49, 50, 10,
/* 0x4360 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x4370 */  32, 67, 84, 66, 83, 72, 82, 49, 49, 32, 48, 32, 67, 84, 66, 83,
/* 0x4380 */  72, 82, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x4390 */  32, 32, 32,100, 32, 32, 67, 84, 66, 82, 79, 82, 49, 49, 32, 48,
/* 0x43a0 */  32, 67, 84, 66, 82, 79, 82, 49, 49, 10, 48, 48, 48, 48, 48, 48,
/* 0x43b0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 66, 83, 87,
/* 0x43c0 */  65, 49, 49, 32, 48, 32, 67, 84, 66, 83, 87, 65, 49, 49, 10, 48,
/* 0x43d0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x43e0 */  76, 69, 88, 69, 67, 48, 49, 53, 32, 48, 32, 76, 69, 88, 69, 67,
/* 0x43f0 */  48, 49, 53, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x4400 */  32, 32,100, 32, 32, 76, 69, 88, 69, 67, 48, 49, 55, 32, 48, 32,
/* 0x4410 */  76, 69, 88, 69, 67, 48, 49, 55, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4420 */  48, 32,103, 32, 32, 32, 32, 32, 32, 32, 76, 69, 88, 69, 67, 48,
/* 0x4430 */  48, 48, 32, 48, 32, 95,115,116, 97,114,116, 10, 48, 48, 48, 48,
/* 0x4440 */  48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,
/* 0x4450 */  68, 42, 32, 48, 32,108,122,109, 97, 95,115,116, 97, 99,107, 95,
/* 0x4460 */  97,100,106,117,115,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4470 */  32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,
/* 0x4480 */ 108,122,109, 97, 95,117, 95,108,101,110, 10, 48, 48, 48, 48, 48,
/* 0x4490 */  48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68,
/* 0x44a0 */  42, 32, 48, 32,108,122,109, 97, 95, 99, 95,108,101,110, 10, 48,
/* 0x44b0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x44c0 */  42, 85, 78, 68, 42, 32, 48, 32,108,122,109, 97, 95,112,114,111,
/* 0x44d0 */ 112,101,114,116,105,101,115, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x44e0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48,
/* 0x44f0 */  32,102,105,108,116,101,114, 95,108,101,110,103,116,104, 10, 48,
/* 0x4500 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4510 */  42, 85, 78, 68, 42, 32, 48, 32,102,105,108,116,101,114, 95, 99,
/* 0x4520 */ 116,111, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x4530 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 69, 88, 69,
/* 0x4540 */  67, 48, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x4550 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4560 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49,
/* 0x4570 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32,
/* 0x4580 */  32, 32, 32, 76, 69, 88, 69, 67, 48, 50, 48, 10, 10, 82, 69, 76,
/* 0x4590 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x45a0 */  70, 79, 82, 32, 91, 78, 50, 66, 83, 77, 65, 49, 48, 93, 58, 10,
/* 0x45b0 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x45c0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x45d0 */  10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95,
/* 0x45e0 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68,
/* 0x45f0 */  69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x4600 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50,
/* 0x4610 */  66, 70, 65, 83, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x4620 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4630 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x4640 */  48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,
/* 0x4650 */  32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 10, 82,
/* 0x4660 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x4670 */  83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 83, 77, 65, 50, 48, 93,
/* 0x4680 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x4690 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x46a0 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56,
/* 0x46b0 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,
/* 0x46c0 */  66, 83, 77, 65, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x46d0 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x46e0 */  78, 50, 66, 70, 65, 83, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x46f0 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4700 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x4710 */  48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,
/* 0x4720 */  32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 70, 65, 83, 49, 49, 10,
/* 0x4730 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x4740 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 83, 77, 65, 51,
/* 0x4750 */  48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x4760 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x4770 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95,
/* 0x4780 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4790 */  78, 50, 66, 68, 69, 67, 50, 48, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x47a0 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x47b0 */  32, 91, 78, 50, 66, 70, 65, 83, 51, 48, 93, 58, 10, 79, 70, 70,
/* 0x47c0 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x47d0 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x47e0 */  48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,
/* 0x47f0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 50,
/* 0x4800 */  48, 10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54,
/* 0x4810 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66,
/* 0x4820 */  68, 69, 67, 50, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x4830 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,
/* 0x4840 */  50, 66, 68, 69, 67, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x4850 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4860 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x4870 */  48, 49, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x4880 */  32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 54, 48, 10, 48,
/* 0x4890 */  48, 48, 48, 48, 48, 50,102, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x48a0 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67,
/* 0x48b0 */  53, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x48c0 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 83,
/* 0x48d0 */  77, 65, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x48e0 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x48f0 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99,
/* 0x4900 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x4910 */  32, 32, 32, 78, 50, 66, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76,
/* 0x4920 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x4930 */  70, 79, 82, 32, 91, 78, 50, 66, 70, 65, 83, 52, 48, 93, 58, 10,
/* 0x4940 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x4950 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x4960 */  10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95,
/* 0x4970 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68,
/* 0x4980 */  69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82, 95,
/* 0x4990 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x49a0 */  78, 50, 66, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x49b0 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x49c0 */  32, 91, 78, 50, 66, 83, 77, 65, 54, 48, 93, 58, 10, 79, 70, 70,
/* 0x49d0 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x49e0 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x49f0 */  48, 48, 48, 48, 48, 56, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51,
/* 0x4a00 */  50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 49,
/* 0x4a10 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x4a20 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 70, 65,
/* 0x4a30 */  83, 54, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x4a40 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4a50 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 97, 32,
/* 0x4a60 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x4a70 */  32, 32, 78, 50, 66, 70, 65, 83, 54, 49, 10, 48, 48, 48, 48, 48,
/* 0x4a80 */  48, 49, 53, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32,
/* 0x4a90 */  32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 10,
/* 0x4aa0 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x4ab0 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 70, 65, 83, 54, 49,
/* 0x4ac0 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x4ad0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x4ae0 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 50, 32, 82, 95, 51,
/* 0x4af0 */  56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x4b00 */  50, 66, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x4b10 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x4b20 */  91, 78, 50, 68, 83, 77, 65, 49, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x4b30 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x4b40 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x4b50 */  48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x4b60 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 49, 48,
/* 0x4b70 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x4b80 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 70, 65, 83,
/* 0x4b90 */  49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x4ba0 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4bb0 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82,
/* 0x4bc0 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4bd0 */  32, 78, 50, 68, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67,
/* 0x4be0 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x4bf0 */  82, 32, 91, 78, 50, 68, 83, 77, 65, 50, 48, 93, 58, 10, 79, 70,
/* 0x4c00 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x4c10 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x4c20 */  48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x4c30 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 83, 77, 65,
/* 0x4c40 */  49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x4c50 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 70,
/* 0x4c60 */  65, 83, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x4c70 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4c80 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51,
/* 0x4c90 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x4ca0 */  32, 32, 32, 78, 50, 68, 70, 65, 83, 49, 49, 10, 10, 82, 69, 76,
/* 0x4cb0 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x4cc0 */  70, 79, 82, 32, 91, 78, 50, 68, 83, 77, 65, 51, 48, 93, 58, 10,
/* 0x4cd0 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x4ce0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x4cf0 */  10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95,
/* 0x4d00 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68,
/* 0x4d10 */  69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x4d20 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50,
/* 0x4d30 */  68, 70, 65, 83, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x4d40 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4d50 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x4d60 */  48, 53, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,
/* 0x4d70 */  32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 48, 48,
/* 0x4d80 */  48, 48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,
/* 0x4d90 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 51,
/* 0x4da0 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x4db0 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 68, 69,
/* 0x4dc0 */  67, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x4dd0 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4de0 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,102, 32,
/* 0x4df0 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x4e00 */  32, 32, 78, 50, 68, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,
/* 0x4e10 */  48, 50, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x4e20 */  32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 54, 48, 10, 48,
/* 0x4e30 */  48, 48, 48, 48, 48, 52, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x4e40 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67,
/* 0x4e50 */  53, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x4e60 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 83,
/* 0x4e70 */  77, 65, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x4e80 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4e90 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99,
/* 0x4ea0 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x4eb0 */  32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76,
/* 0x4ec0 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x4ed0 */  70, 79, 82, 32, 91, 78, 50, 68, 70, 65, 83, 52, 48, 93, 58, 10,
/* 0x4ee0 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x4ef0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x4f00 */  10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95,
/* 0x4f10 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68,
/* 0x4f20 */  69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82, 95,
/* 0x4f30 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4f40 */  78, 50, 68, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x4f50 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x4f60 */  32, 91, 78, 50, 68, 83, 77, 65, 54, 48, 93, 58, 10, 79, 70, 70,
/* 0x4f70 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x4f80 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x4f90 */  48, 48, 48, 48, 48, 56, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51,
/* 0x4fa0 */  50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 49,
/* 0x4fb0 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x4fc0 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 70, 65,
/* 0x4fd0 */  83, 54, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x4fe0 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4ff0 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 97, 32,
/* 0x5000 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x5010 */  32, 32, 78, 50, 68, 70, 65, 83, 54, 49, 10, 48, 48, 48, 48, 48,
/* 0x5020 */  48, 49, 53, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32,
/* 0x5030 */  32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 49, 48, 10, 10,
/* 0x5040 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x5050 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 70, 65, 83, 54, 49,
/* 0x5060 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x5070 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x5080 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 50, 32, 82, 95, 51,
/* 0x5090 */  56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x50a0 */  50, 68, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x50b0 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x50c0 */  91, 78, 50, 69, 83, 77, 65, 49, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x50d0 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x50e0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x50f0 */  48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x5100 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 49, 48,
/* 0x5110 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x5120 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 70, 65, 83,
/* 0x5130 */  49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x5140 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5150 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82,
/* 0x5160 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5170 */  32, 78, 50, 69, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67,
/* 0x5180 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x5190 */  82, 32, 91, 78, 50, 69, 83, 77, 65, 50, 48, 93, 58, 10, 79, 70,
/* 0x51a0 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x51b0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x51c0 */  48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x51d0 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 83, 77, 65,
/* 0x51e0 */  49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x51f0 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 70,
/* 0x5200 */  65, 83, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x5210 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5220 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51,
/* 0x5230 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x5240 */  32, 32, 32, 78, 50, 69, 70, 65, 83, 49, 49, 10, 10, 82, 69, 76,
/* 0x5250 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x5260 */  70, 79, 82, 32, 91, 78, 50, 69, 83, 77, 65, 51, 48, 93, 58, 10,
/* 0x5270 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x5280 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x5290 */  10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95,
/* 0x52a0 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68,
/* 0x52b0 */  69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x52c0 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50,
/* 0x52d0 */  69, 70, 65, 83, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x52e0 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x52f0 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x5300 */  48, 53, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,
/* 0x5310 */  32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 48, 48,
/* 0x5320 */  48, 48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,
/* 0x5330 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 51,
/* 0x5340 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x5350 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 68, 69,
/* 0x5360 */  67, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x5370 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5380 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,102, 32,
/* 0x5390 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x53a0 */  32, 32, 78, 50, 69, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,
/* 0x53b0 */  48, 49,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x53c0 */  32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 53, 48, 10, 48,
/* 0x53d0 */  48, 48, 48, 48, 48, 51, 48, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x53e0 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67,
/* 0x53f0 */  54, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x5400 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 83,
/* 0x5410 */  77, 65, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x5420 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5430 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99,
/* 0x5440 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x5450 */  32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76,
/* 0x5460 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x5470 */  70, 79, 82, 32, 91, 78, 50, 69, 70, 65, 83, 52, 48, 93, 58, 10,
/* 0x5480 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x5490 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x54a0 */  10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95,
/* 0x54b0 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68,
/* 0x54c0 */  69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82, 95,
/* 0x54d0 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x54e0 */  78, 50, 69, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x54f0 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x5500 */  32, 91, 78, 50, 69, 83, 77, 65, 54, 48, 93, 58, 10, 79, 70, 70,
/* 0x5510 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x5520 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x5530 */  48, 48, 48, 48, 48, 56, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51,
/* 0x5540 */  50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 49,
/* 0x5550 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x5560 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 70, 65,
/* 0x5570 */  83, 54, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x5580 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5590 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 97, 32,
/* 0x55a0 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x55b0 */  32, 32, 78, 50, 69, 70, 65, 83, 54, 49, 10, 48, 48, 48, 48, 48,
/* 0x55c0 */  48, 49, 53, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32,
/* 0x55d0 */  32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 49, 48, 10, 10,
/* 0x55e0 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x55f0 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 70, 65, 83, 54, 49,
/* 0x5600 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x5610 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x5620 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 50, 32, 82, 95, 51,
/* 0x5630 */  56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x5640 */  50, 69, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x5650 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x5660 */  91, 67, 76, 49, 69, 78, 84, 69, 82, 93, 58, 10, 79, 70, 70, 83,
/* 0x5670 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x5680 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x5690 */  48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50,
/* 0x56a0 */  32, 32, 32, 32, 32, 32, 32, 32, 67, 76, 49, 83, 84, 65, 82, 84,
/* 0x56b0 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x56c0 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 76, 49, 83, 77, 65,
/* 0x56d0 */  49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x56e0 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x56f0 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82,
/* 0x5700 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5710 */  32, 67, 76, 49, 82, 76, 79, 65, 68, 10, 10, 82, 69, 76, 79, 67,
/* 0x5720 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x5730 */  82, 32, 91, 67, 76, 49, 87, 73, 68, 48, 51, 93, 58, 10, 79, 70,
/* 0x5740 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x5750 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x5760 */  48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x5770 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 76, 49, 87, 73, 68,
/* 0x5780 */  49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x5790 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 76, 49, 87,
/* 0x57a0 */  73, 68, 48, 53, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x57b0 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x57c0 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49,
/* 0x57d0 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x57e0 */  32, 32, 32, 67, 76, 49, 87, 73, 68, 49, 48, 10, 10, 82, 69, 76,
/* 0x57f0 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x5800 */  70, 79, 82, 32, 91, 67, 76, 49, 87, 73, 68, 48, 56, 93, 58, 10,
/* 0x5810 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x5820 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x5830 */  10, 48, 48, 48, 48, 48, 48, 48, 54, 32, 82, 95, 51, 56, 54, 95,
/* 0x5840 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 76, 49, 87,
/* 0x5850 */  73, 68, 48, 54, 10, 48, 48, 48, 48, 48, 48, 49, 48, 32, 82, 95,
/* 0x5860 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5870 */  67, 76, 49, 87, 73, 68, 49, 48, 10, 48, 48, 48, 48, 48, 48, 49,
/* 0x5880 */  54, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32,
/* 0x5890 */  32, 32, 32, 32, 67, 76, 49, 67, 79, 80, 89, 48, 10, 10, 82, 69,
/* 0x58a0 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x58b0 */  32, 70, 79, 82, 32, 91, 67, 76, 49, 87, 73, 68, 49, 48, 93, 58,
/* 0x58c0 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x58d0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x58e0 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 54, 32, 82, 95, 51, 56, 54,
/* 0x58f0 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 76, 49,
/* 0x5900 */  84, 79, 80, 48, 55, 10, 48, 48, 48, 48, 48, 48, 48, 97, 32, 82,
/* 0x5910 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5920 */  32, 67, 76, 49, 87, 73, 68, 48, 56, 10, 48, 48, 48, 48, 48, 48,
/* 0x5930 */  49, 48, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,
/* 0x5940 */  32, 32, 32, 32, 32, 67, 76, 49, 84, 79, 80, 48, 55, 10, 10, 82,
/* 0x5950 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x5960 */  83, 32, 70, 79, 82, 32, 91, 67, 76, 49, 84, 79, 80, 48, 49, 93,
/* 0x5970 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x5980 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x5990 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56,
/* 0x59a0 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 76,
/* 0x59b0 */  49, 84, 79, 80, 48, 55, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x59c0 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x59d0 */  67, 76, 49, 84, 79, 80, 48, 50, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x59e0 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x59f0 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x5a00 */  48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,
/* 0x5a10 */  32, 32, 32, 32, 32, 32, 32, 67, 76, 49, 84, 79, 80, 48, 55, 10,
/* 0x5a20 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x5a30 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 76, 49, 84, 79, 80, 48,
/* 0x5a40 */  51, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x5a50 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x5a60 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95,
/* 0x5a70 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5a80 */  67, 76, 49, 84, 79, 80, 48, 55, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x5a90 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x5aa0 */  32, 91, 67, 76, 49, 84, 79, 80, 48, 52, 93, 58, 10, 79, 70, 70,
/* 0x5ab0 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x5ac0 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x5ad0 */  48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,
/* 0x5ae0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 76, 49, 84, 79, 80, 48,
/* 0x5af0 */  55, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x5b00 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 76, 49, 84, 79,
/* 0x5b10 */  80, 48, 53, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x5b20 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5b30 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32,
/* 0x5b40 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x5b50 */  32, 32, 67, 76, 49, 84, 79, 80, 48, 54, 10, 10, 82, 69, 76, 79,
/* 0x5b60 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x5b70 */  79, 82, 32, 91, 67, 76, 49, 84, 79, 80, 48, 54, 93, 58, 10, 79,
/* 0x5b80 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x5b90 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x5ba0 */  48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x5bb0 */  67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 67, 76, 49, 87, 73,
/* 0x5bc0 */  68, 48, 49, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x5bd0 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 76, 49,
/* 0x5be0 */  79, 70, 70, 48, 50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x5bf0 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5c00 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x5c10 */  49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x5c20 */  32, 32, 32, 32, 67, 76, 49, 84, 79, 80, 48, 55, 10, 48, 48, 48,
/* 0x5c30 */  48, 48, 48, 48,102, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x5c40 */  32, 32, 32, 32, 32, 32, 32, 32, 67, 76, 49, 67, 79, 80, 89, 48,
/* 0x5c50 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x5c60 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 76, 49, 79, 70, 70,
/* 0x5c70 */  48, 52, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x5c80 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5c90 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82,
/* 0x5ca0 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5cb0 */  32, 67, 76, 49, 67, 79, 80, 89, 48, 10, 10, 82, 69, 76, 79, 67,
/* 0x5cc0 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x5cd0 */  82, 32, 91, 67, 76, 49, 76, 69, 78, 48, 50, 93, 58, 10, 79, 70,
/* 0x5ce0 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x5cf0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x5d00 */  48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x5d10 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 76, 49, 76, 69, 78,
/* 0x5d20 */  48, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x5d30 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 76, 49, 67,
/* 0x5d40 */  79, 80, 89, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x5d50 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5d60 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 50, 49,
/* 0x5d70 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32,
/* 0x5d80 */  32, 32, 32, 67, 76, 49, 84, 79, 80, 48, 48, 10, 10, 82, 69, 76,
/* 0x5d90 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x5da0 */  70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 68, 69, 67, 48, 48, 93,
/* 0x5db0 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x5dc0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x5dd0 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 53, 32, 82, 95, 51, 56,
/* 0x5de0 */  54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,108,122,
/* 0x5df0 */ 109, 97, 95,115,116, 97, 99,107, 95, 97,100,106,117,115,116, 10,
/* 0x5e00 */  48, 48, 48, 48, 48, 48, 49, 52, 32, 82, 95, 51, 56, 54, 95, 51,
/* 0x5e10 */  50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,108,122,109, 97, 95,
/* 0x5e20 */ 117, 95,108,101,110, 10, 48, 48, 48, 48, 48, 48, 49,101, 32, 82,
/* 0x5e30 */  95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5e40 */  32,108,122,109, 97, 95, 99, 95,108,101,110, 10, 48, 48, 48, 48,
/* 0x5e50 */  48, 48, 50, 97, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32,
/* 0x5e60 */  32, 32, 32, 32, 32, 32, 32,108,122,109, 97, 95,112,114,111,112,
/* 0x5e70 */ 101,114,116,105,101,115, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x5e80 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x5e90 */  67, 65, 76, 76, 84, 82, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x5ea0 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5eb0 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x5ec0 */  48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32,
/* 0x5ed0 */  32, 32, 32, 32, 32, 32, 32,102,105,108,116,101,114, 95,108,101,
/* 0x5ee0 */ 110,103,116,104, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x5ef0 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 84,
/* 0x5f00 */  67, 76, 69, 86, 69, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x5f10 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5f20 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x5f30 */  48, 50, 32, 82, 95, 51, 56, 54, 95, 56, 32, 32, 32, 32, 32, 32,
/* 0x5f40 */  32, 32, 32, 32, 32,102,105,108,116,101,114, 95, 99,116,111, 10,
/* 0x5f50 */  48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x5f60 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84,
/* 0x5f70 */  82, 48, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x5f80 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76,
/* 0x5f90 */  76, 84, 82, 48, 50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x5fa0 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5fb0 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x5fc0 */ 100, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x5fd0 */  32, 32, 32, 32, 67, 65, 76, 76, 84, 82, 48, 48, 10, 10, 82, 69,
/* 0x5fe0 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x5ff0 */  32, 70, 79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 49, 48, 93, 58,
/* 0x6000 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x6010 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x6020 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54,
/* 0x6030 */  95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,102,105,108,
/* 0x6040 */ 116,101,114, 95,108,101,110,103,116,104, 10, 10, 82, 69, 76, 79,
/* 0x6050 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x6060 */  79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 49, 49, 93, 58, 10, 79,
/* 0x6070 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x6080 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x6090 */  48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x60a0 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84,
/* 0x60b0 */  82, 49, 51, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x60c0 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 84, 67,
/* 0x60d0 */  76, 69, 86, 69, 50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x60e0 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x60f0 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x6100 */  50, 32, 82, 95, 51, 56, 54, 95, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x6110 */  32, 32, 32, 32,102,105,108,116,101,114, 95, 99,116,111, 10, 48,
/* 0x6120 */  48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x6130 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84, 82,
/* 0x6140 */  49, 49, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x6150 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76, 76,
/* 0x6160 */  84, 82, 49, 51, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x6170 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6180 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52,
/* 0x6190 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x61a0 */  32, 32, 32, 67, 65, 76, 76, 84, 82, 49, 48, 10
};
