# 프리셋

커뮤니티가 제공한 Starship 설정 프리셋의 모음집입니다. 공유할 프리셋이 있다면 이 파일을 [수정하는 PR을 제출](https://github.com/starship/starship/edit/master/docs/presets/README.md)해 주세요! 😊

프리셋 사용 방법에 대한 자세한 내용을 보려면 이미지를 클릭하기만 하면 됩니다.

## [Nerd Font 기호](./nerd-font.md)

이 프리셋은 각 모듈의 기호가 Nerd Font 기호를 사용하도록 변경합니다.

[![Nerd Font 기호 프리셋 스크린샷](/presets/img/nerd-font-symbols.png "Click to view Nerd Font Symbols preset")](./nerd-font)

## [No Nerd Fonts](./no-nerd-font.md)

This preset changes the symbols for several modules so that no Nerd Font symbols are used anywhere in the prompt.

> [!TIP] This preset will become the default preset [in a future release of starship](https://github.com/starship/starship/pull/3544).

[클릭하여 No Nerd Font 프리셋 보기](./no-nerd-font)

## [Bracketed Segments](./bracketed-segments.md)

This preset changes the format of all the built-in modules to show their segment in brackets instead of using the default Starship wording ("via", "on", etc.).

[![Screenshot of Bracketed Segments preset](/presets/img/bracketed-segments.png "Click to view Bracketed Segments preset")](./bracketed-segments)

## [Plain Text Symbols](./plain-text.md)

This preset changes the symbols for each module into plain text. Great if you don't have access to Unicode.

[![Screenshot of Plain Text Symbols preset](/presets/img/plain-text-symbols.png "Click to view Plain Text Symbols preset")](./plain-text)

## [No Runtime Versions](./no-runtimes.md)

This preset hides the version of language runtimes. If you work in containers or virtualized environments, this one is for you!

[![Screenshot of Hide Runtime Versions preset](/presets/img/no-runtime-versions.png "Click to view No Runtime Versions preset")](./no-runtimes)

## [빈 아이콘 제거](./no-empty-icons.md)

이 프리셋은 툴셋을 찾을 수 없을 때 아이콘을 표시하지 않습니다.

[![Screenshot of No Empty Icons preset](/presets/img/no-empty-icons.png "Click to view No Runtime Versions preset")](./no-empty-icons.md)

## [Pure Prompt](./pure-preset.md)

이 프리셋은 [Pure](https://github.com/sindresorhus/pure)의 모습과 동작을 재현합니다.

[![Pure 프리셋 스크린샷](/presets/img/pure-preset.png "Click to view Pure Prompt preset")](./pure-preset)

## [Pastel Powerline](./pastel-powerline.md)

This preset is inspired by [M365Princess](https://github.com/JanDeDobbeleer/oh-my-posh/blob/main/themes/M365Princess.omp.json). It also shows how path substitution works in starship.

[![Screenshot of Pastel Powerline preset](/presets/img/pastel-powerline.png "Click to view Pure Prompt preset")](./pastel-powerline)

## [Tokyo Night](./tokyo-night.md)

이 프리셋은 [tokyo-night-vscode-theme](https://github.com/enkia/tokyo-night-vscode-theme)에서 영감을 받았습니다.

[![Tokyo Night 프리셋 스크린샷](/presets/img/tokyo-night.png "Click to view Tokyo Night preset")](./tokyo-night)

## [Gruvbox Rainbow](./gruvbox-rainbow.md)

이 프리셋은 [Pastel Powerline](./pastel-powerline.md) 및 [Tokyo Night](./tokyo-night.md)에서 강하게 영감을 받았습니다.

[![Gruvbox Rainbow 프리셋 스크린샷](/presets/img/gruvbox-rainbow.png "Click to view Gruvbox Rainbow preset")](./gruvbox-rainbow)

## [Jetpack](./jetpack.md)

This is a pseudo minimalist preset inspired by the [geometry](https://github.com/geometry-zsh/geometry) and [spaceship](https://github.com/spaceship-prompt/spaceship-prompt) prompts.

[![Screenshot of Jetpack preset](/presets/img/jetpack.png "Click to view Jetpack preset")](./jetpack)

## [Catppuccin Powerline](./catppuccin-powerline.md)

This preset is a minimally modified version of [Gruvbox Rainbow](./gruvbox-rainbow.md) using the [Catppuccin](https://github.com/catppuccin/catppuccin) theme palette.

[![Screenshot of Catppuccin Powerline preset](/presets/img/catppuccin-powerline.png "Click to view Catppuccin Powerline preset")](./catppuccin-powerline)
