/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_yue extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "格林威治標準時間",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "艾克標準時間",
               "",
               "艾克夏令時間",
               "",
               "艾克時間",
               "",
            };
        final String[] Apia = new String[] {
               "阿皮亞標準時間",
               "",
               "阿皮亞夏令時間",
               "",
               "阿皮亞時間",
               "",
            };
        final String[] Cook = new String[] {
               "庫克群島標準時間",
               "",
               "庫克群島半夏令時間",
               "",
               "庫克群島時間",
               "",
            };
        final String[] Cuba = new String[] {
               "古巴標準時間",
               "CST",
               "古巴夏令時間",
               "CDT",
               "古巴時間",
               "CT",
            };
        final String[] Fiji = new String[] {
               "斐濟標準時間",
               "",
               "斐濟夏令時間",
               "",
               "斐濟時間",
               "",
            };
        final String[] Gulf = new String[] {
               "波斯灣海域標準時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "科布多標準時間",
               "",
               "科布多夏令時間",
               "",
               "科布多時間",
               "",
            };
        final String[] Iran = new String[] {
               "伊朗標準時間",
               "",
               "伊朗夏令時間",
               "",
               "伊朗時間",
               "",
            };
        final String[] Niue = new String[] {
               "紐埃島時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "鄂木斯克標準時間",
               "",
               "鄂木斯克夏令時間",
               "",
               "鄂木斯克時間",
               "",
            };
        final String[] Peru = new String[] {
               "秘魯標準時間",
               "",
               "秘魯夏令時間",
               "",
               "秘魯時間",
               "",
            };
        final String[] Truk = new String[] {
               "楚克島時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "威克島時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "智利標準時間",
               "",
               "智利夏令時間",
               "",
               "智利時間",
               "",
            };
        final String[] China = new String[] {
               "中國標準時間",
               "CST",
               "中國夏令時間",
               "CDT",
               "中國時間",
               "CT",
            };
        final String[] Cocos = new String[] {
               "科科斯群島時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "戴維斯時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "印度標準時間",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "日本標準時間",
               "JST",
               "日本夏令時間",
               "JDT",
               "日本時間",
               "JT",
            };
        final String[] Korea = new String[] {
               "韓國標準時間",
               "KST",
               "韓國夏令時間",
               "KST",
               "韓國時間",
               "KST",
            };
        final String[] Nauru = new String[] {
               "諾魯時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "尼泊爾時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "帛琉時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "薩摩亞標準時間",
               "SST",
               "薩摩亞夏令時間",
               "SST",
               "薩摩亞時間",
               "SST",
            };
        final String[] Syowa = new String[] {
               "昭和基地時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "東加標準時間",
               "",
               "東加夏令時間",
               "",
               "東加時間",
               "",
            };
        final String[] Yukon = new String[] {
               "育空時間",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "阿拉斯加標準時間",
               "AKST",
               "阿拉斯加夏令時間",
               "AKDT",
               "阿拉斯加時間",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "亞馬遜標準時間",
               "",
               "亞馬遜夏令時間",
               "",
               "亞馬遜時間",
               "",
            };
        final String[] Azores = new String[] {
               "亞速爾群島標準時間",
               "",
               "亞速爾群島夏令時間",
               "",
               "亞速爾群島時間",
               "",
            };
        final String[] Bhutan = new String[] {
               "不丹時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "汶萊時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "復活節島標準時間",
               "",
               "復活節島夏令時間",
               "",
               "復活節島時間",
               "",
            };
        final String[] Guyana = new String[] {
               "蓋亞那時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "夏威夷-阿留申標準時間",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "以色列標準時間",
               "IST",
               "以色列夏令時間",
               "IDT",
               "以色列時間",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "科斯瑞時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "莫森時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "莫斯科標準時間",
               "MSK",
               "莫斯科夏令時間",
               "MSK",
               "莫斯科時間",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "波納佩時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "薩馬拉標準時間",
               "",
               "薩馬拉夏令時間",
               "",
               "薩馬拉時間",
               "",
            };
        final String[] Tahiti = new String[] {
               "大溪地時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "台北標準時間",
               "CST",
               "台北夏令時間",
               "CDT",
               "台北時間",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "吐瓦魯時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "沃斯托克時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "瓦利斯和富圖納群島時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "阿拉伯標準時間",
               "",
               "阿拉伯夏令時間",
               "",
               "阿拉伯時間",
               "",
            };
        final String[] Armenia = new String[] {
               "亞美尼亞標準時間",
               "",
               "亞美尼亞夏令時間",
               "",
               "亞美尼亞時間",
               "",
            };
        final String[] Bolivia = new String[] {
               "玻利維亞時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "查坦群島標準時間",
               "",
               "查坦群島夏令時間",
               "",
               "查坦群島時間",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "協調世界時間",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "厄瓜多時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "甘比爾群島時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "喬治亞標準時間",
               "",
               "喬治亞夏令時間",
               "",
               "喬治亞時間",
               "",
            };
        final String[] Irkutsk = new String[] {
               "伊爾庫次克標準時間",
               "",
               "伊爾庫次克夏令時間",
               "",
               "伊爾庫次克時間",
               "",
            };
        final String[] Magadan = new String[] {
               "馬加丹標準時間",
               "",
               "馬加丹夏令時間",
               "",
               "馬加丹時間",
               "",
            };
        final String[] Myanmar = new String[] {
               "緬甸時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "諾福克島標準時間",
               "",
               "諾福克島夏令時間",
               "",
               "諾福克島時間",
               "",
            };
        final String[] Noronha = new String[] {
               "費爾南多 - 迪諾羅尼亞標準時間",
               "",
               "費爾南多 - 迪諾羅尼亞夏令時間",
               "",
               "費爾南多 - 迪諾羅尼亞時間",
               "",
            };
        final String[] Reunion = new String[] {
               "留尼旺時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "羅瑟拉時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "索羅門群島時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "托克勞群島時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "烏拉圭標準時間",
               "",
               "烏拉圭夏令時間",
               "",
               "烏拉圭時間",
               "",
            };
        final String[] Vanuatu = new String[] {
               "萬那杜標準時間",
               "",
               "萬那杜夏令時間",
               "",
               "萬那杜時間",
               "",
            };
        final String[] Yakutsk = new String[] {
               "雅庫次克標準時間",
               "",
               "雅庫次克夏令時間",
               "",
               "雅庫次克時間",
               "",
            };
        final String[] Atlantic = new String[] {
               "大西洋標準時間",
               "AST",
               "大西洋夏令時間",
               "AST",
               "大西洋時間",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "巴西利亞標準時間",
               "",
               "巴西利亞夏令時間",
               "",
               "巴西利亞時間",
               "",
            };
        final String[] Chamorro = new String[] {
               "查莫洛時間",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "哥倫比亞標準時間",
               "",
               "哥倫比亞夏令時間",
               "",
               "哥倫比亞時間",
               "",
            };
        final String[] Falkland = new String[] {
               "福克蘭群島標準時間",
               "",
               "福克蘭群島夏令時間",
               "",
               "福克蘭群島時間",
               "",
            };
        final String[] Malaysia = new String[] {
               "馬來西亞時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "馬爾地夫時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "烏蘭巴托標準時間",
               "",
               "烏蘭巴托夏令時間",
               "",
               "烏蘭巴托時間",
               "",
            };
        final String[] Pakistan = new String[] {
               "巴基斯坦標準時間",
               "PKT",
               "巴基斯坦夏令時間",
               "PKST",
               "巴基斯坦時間",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "巴拉圭標準時間",
               "",
               "巴拉圭夏令時間",
               "",
               "巴拉圭時間",
               "",
            };
        final String[] Pitcairn = new String[] {
               "皮特肯時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "蘇利南時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "阿根廷標準時間",
               "",
               "阿根廷夏令時間",
               "",
               "阿根廷時間",
               "",
            };
        final String[] Christmas = new String[] {
               "聖誕島時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "加拉巴哥群島時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "香港標準時間",
               "HKT",
               "香港夏令時間",
               "HKST",
               "香港時間",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "印度支那時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "彼得羅巴甫洛夫斯克標準時間",
               "",
               "彼得羅巴甫洛夫斯克日光節約時間",
               "",
               "彼得羅巴甫洛夫斯克時間",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "吉爾吉斯時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "豪勳爵島標準時間",
               "",
               "豪勳爵島夏令時間",
               "",
               "豪勳爵島時間",
               "",
            };
        final String[] Marquesas = new String[] {
               "馬可薩斯時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "模里西斯標準時間",
               "",
               "模里西斯夏令時間",
               "",
               "模里西斯時間",
               "",
            };
        final String[] Singapore = new String[] {
               "新加坡標準時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "委內瑞拉時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "亞塞拜然標準時間",
               "",
               "亞塞拜然夏令時間",
               "",
               "亞塞拜然時間",
               "",
            };
        final String[] Bangladesh = new String[] {
               "孟加拉標準時間",
               "",
               "孟加拉夏令時間",
               "",
               "孟加拉時間",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "維德角標準時間",
               "",
               "維德角夏令時間",
               "",
               "維德角時間",
               "",
            };
        final String[] East_Timor = new String[] {
               "東帝汶時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "哈薩克時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "塞席爾時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "塔吉克時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "烏茲別克標準時間",
               "",
               "烏茲別克夏令時間",
               "",
               "烏茲別克時間",
               "",
            };
        final String[] Afghanistan = new String[] {
               "阿富汗時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "克拉斯諾亞爾斯克標準時間",
               "",
               "克拉斯諾亞爾斯克夏令時間",
               "",
               "克拉斯諾亞爾斯克時間",
               "",
            };
        final String[] New_Zealand = new String[] {
               "紐西蘭標準時間",
               "NZST",
               "紐西蘭夏令時間",
               "NZDT",
               "紐西蘭時間",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "菲律賓標準時間",
               "PST",
               "菲律賓夏令時間",
               "PDT",
               "菲律賓時間",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "海參崴標準時間",
               "",
               "海參崴夏令時間",
               "",
               "海參崴時間",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "印度洋時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "萊恩群島時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "紐芬蘭標準時間",
               "NST",
               "紐芬蘭夏令時間",
               "NDT",
               "紐芬蘭時間",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "土庫曼標準時間",
               "",
               "土庫曼夏令時間",
               "",
               "土庫曼時間",
               "",
            };
        final String[] French_Guiana = new String[] {
               "法屬圭亞那時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "新喀里多尼亞標準時間",
               "",
               "新喀里多尼亞群島夏令時間",
               "",
               "新喀里多尼亞時間",
               "",
            };
        final String[] South_Georgia = new String[] {
               "南喬治亞時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "葉卡捷琳堡標準時間",
               "",
               "葉卡捷琳堡夏令時間",
               "",
               "葉卡捷琳堡時間",
               "",
            };
        final String[] Africa_Central = new String[] {
               "中非時間",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "東非時間",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "西非時間",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "杜蒙杜比爾時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "中歐標準時間",
               "CET",
               "中歐夏令時間",
               "CEST",
               "中歐時間",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "東歐標準時間",
               "EET",
               "東歐夏令時間",
               "EEST",
               "東歐時間",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "西歐標準時間",
               "WET",
               "西歐夏令時間",
               "WEST",
               "西歐時間",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "墨西哥太平洋標準時間",
               "MST",
               "墨西哥太平洋夏令時間",
               "MDT",
               "墨西哥太平洋時間",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "南非標準時間",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "中部標準時間",
               "CST",
               "中部夏令時間",
               "CDT",
               "中部時間",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "東部標準時間",
               "EST",
               "東部夏令時間",
               "EST",
               "東部時間",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "太平洋標準時間",
               "PST",
               "太平洋夏令時間",
               "PDT",
               "太平洋時間",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "法國南方及南極時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "吉爾伯特群島時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "夏威夷-阿留申標準時間",
               "HST",
               "夏威夷-阿留申夏令時間",
               "HDT",
               "夏威夷-阿留申時間",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "鳳凰群島時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "聖皮埃爾和密克隆群島標準時間",
               "",
               "聖皮埃爾和密克隆群島夏令時間",
               "",
               "聖皮埃爾和密克隆群島時間",
               "",
            };
        final String[] America_Mountain = new String[] {
               "山區標準時間",
               "MST",
               "山區夏令時間",
               "MST",
               "山區時間",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "馬紹爾群島時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "巴布亞紐幾內亞時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "澳洲中部標準時間",
               "ACST",
               "澳洲中部夏令時間",
               "ACDT",
               "澳洲中部時間",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "澳洲東部標準時間",
               "AEST",
               "澳洲東部夏令時間",
               "AEDT",
               "澳洲東部時間",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "澳洲西部標準時間",
               "AWST",
               "澳洲西部夏令時間",
               "AWDT",
               "澳洲西部時間",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "印尼中部時間",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "印尼東部時間",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "印尼西部時間",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "澳洲中西部標準時間",
               "",
               "澳洲中西部夏令時間",
               "",
               "澳洲中西部時間",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "格林威治標準時間",
                    "GMT",
                    "英國夏令時間",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "協調世界時間",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "格林威治標準時間",
                    "GMT",
                    "愛爾蘭標準時間",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "協調世界時間",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "協調世界時間",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "格林威治標準時間",
                    "GMT",
                    "英國夏令時間",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "協調世界時間",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "協調世界時間",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Kamchatka },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "協調世界時間",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "格林威治標準時間",
                    "GMT",
                    "愛爾蘭標準時間",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "格林威治標準時間",
                    "GMT",
                    "英國夏令時間",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "格林威治標準時間",
                    "GMT",
                    "英國夏令時間",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "格林威治標準時間",
                    "GMT",
                    "英國夏令時間",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Saratov", Samara },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "格林威治標準時間",
                    "GMT",
                    "英國夏令時間",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Astrakhan", Samara },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Ulyanovsk", Samara },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "格林威治標準時間",
                    "GMT",
                    "英國夏令時間",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "亞丁" },
            { "timezone.excity.Asia/Baku", "巴庫" },
            { "timezone.excity.Asia/Dili", "帝力" },
            { "timezone.excity.Asia/Gaza", "加薩" },
            { "timezone.excity.Asia/Hovd", "科布多" },
            { "timezone.excity.Asia/Omsk", "鄂木斯克" },
            { "timezone.excity.Asia/Oral", "烏拉爾" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "安曼" },
            { "timezone.excity.Asia/Aqtau", "阿克套" },
            { "timezone.excity.Asia/Chita", "赤塔" },
            { "timezone.excity.Asia/Dhaka", "達卡" },
            { "timezone.excity.Asia/Dubai", "杜拜" },
            { "timezone.excity.Asia/Kabul", "喀布爾" },
            { "timezone.excity.Asia/Macau", "中華人民共和國澳門特別行政區" },
            { "timezone.excity.Asia/Qatar", "卡達" },
            { "timezone.excity.Asia/Seoul", "首爾" },
            { "timezone.excity.Asia/Tokyo", "東京" },
            { "timezone.excity.Asia/Tomsk", "托木斯克" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "朱巴" },
            { "timezone.excity.Africa/Lome", "洛美" },
            { "timezone.excity.Asia/Almaty", "阿拉木圖" },
            { "timezone.excity.Asia/Anadyr", "阿那底" },
            { "timezone.excity.Asia/Aqtobe", "阿克托比" },
            { "timezone.excity.Asia/Atyrau", "阿特勞" },
            { "timezone.excity.Asia/Beirut", "貝魯特" },
            { "timezone.excity.Asia/Brunei", "汶萊" },
            { "timezone.excity.Asia/Hebron", "赫布隆" },
            { "timezone.excity.Asia/Kuwait", "科威特" },
            { "timezone.excity.Asia/Manila", "馬尼拉" },
            { "timezone.excity.Asia/Muscat", "馬斯開特" },
            { "timezone.excity.Asia/Riyadh", "利雅德" },
            { "timezone.excity.Asia/Saigon", "胡志明市" },
            { "timezone.excity.Asia/Taipei", "台北" },
            { "timezone.excity.Asia/Tehran", "德黑蘭" },
            { "timezone.excity.Asia/Urumqi", "烏魯木齊" },
            { "timezone.excity.Etc/Unknown", "未知城市" },
            { "timezone.excity.Europe/Kiev", "基輔" },
            { "timezone.excity.Europe/Oslo", "奧斯陸" },
            { "timezone.excity.Europe/Riga", "里加" },
            { "timezone.excity.Europe/Rome", "羅馬" },
            { "timezone.excity.Indian/Mahe", "馬埃島" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "阿克拉" },
            { "timezone.excity.Africa/Cairo", "開羅" },
            { "timezone.excity.Africa/Ceuta", "休達" },
            { "timezone.excity.Africa/Dakar", "達喀爾" },
            { "timezone.excity.Africa/Lagos", "拉哥斯" },
            { "timezone.excity.Africa/Tunis", "突尼斯" },
            { "timezone.excity.America/Adak", "艾達克" },
            { "timezone.excity.America/Lima", "利馬" },
            { "timezone.excity.America/Nome", "諾姆" },
            { "timezone.excity.Asia/Baghdad", "巴格達" },
            { "timezone.excity.Asia/Bahrain", "巴林" },
            { "timezone.excity.Asia/Bangkok", "曼谷" },
            { "timezone.excity.Asia/Barnaul", "巴爾瑙爾" },
            { "timezone.excity.Asia/Bishkek", "比什凱克" },
            { "timezone.excity.Asia/Colombo", "可倫坡" },
            { "timezone.excity.Asia/Irkutsk", "伊爾庫次克" },
            { "timezone.excity.Asia/Jakarta", "雅加達" },
            { "timezone.excity.Asia/Karachi", "喀拉蚩" },
            { "timezone.excity.Asia/Kuching", "古晉" },
            { "timezone.excity.Asia/Magadan", "馬加丹" },
            { "timezone.excity.Asia/Nicosia", "尼古西亞" },
            { "timezone.excity.Asia/Rangoon", "仰光" },
            { "timezone.excity.Asia/Tbilisi", "第比利斯" },
            { "timezone.excity.Asia/Thimphu", "廷布" },
            { "timezone.excity.Asia/Yakutsk", "雅庫次克" },
            { "timezone.excity.Asia/Yerevan", "葉里溫" },
            { "timezone.excity.Europe/Kirov", "基洛夫" },
            { "timezone.excity.Europe/Malta", "馬爾他" },
            { "timezone.excity.Europe/Minsk", "明斯克" },
            { "timezone.excity.Europe/Paris", "巴黎" },
            { "timezone.excity.Europe/Sofia", "索菲亞" },
            { "timezone.excity.Europe/Vaduz", "瓦都茲" },
            { "timezone.excity.Indian/Cocos", "科科斯群島" },
            { "timezone.excity.Pacific/Apia", "阿皮亞" },
            { "timezone.excity.Pacific/Fiji", "斐濟" },
            { "timezone.excity.Pacific/Guam", "關島" },
            { "timezone.excity.Pacific/Niue", "紐埃島" },
            { "timezone.excity.Pacific/Truk", "楚克" },
            { "timezone.excity.Pacific/Wake", "威克" },
            { "timezone.excity.Africa/Asmera", "阿斯瑪拉" },
            { "timezone.excity.Africa/Bamako", "巴馬科" },
            { "timezone.excity.Africa/Bangui", "班吉" },
            { "timezone.excity.Africa/Banjul", "班竹" },
            { "timezone.excity.Africa/Bissau", "比紹" },
            { "timezone.excity.Africa/Douala", "杜阿拉" },
            { "timezone.excity.Africa/Harare", "哈拉雷" },
            { "timezone.excity.Africa/Kigali", "基加利" },
            { "timezone.excity.Africa/Luanda", "羅安達" },
            { "timezone.excity.Africa/Lusaka", "路沙卡" },
            { "timezone.excity.Africa/Malabo", "馬拉博" },
            { "timezone.excity.Africa/Maputo", "馬普托" },
            { "timezone.excity.Africa/Maseru", "馬賽魯" },
            { "timezone.excity.Africa/Niamey", "尼亞美" },
            { "timezone.excity.America/Aruba", "阿路巴" },
            { "timezone.excity.America/Bahia", "巴伊阿" },
            { "timezone.excity.America/Belem", "貝倫" },
            { "timezone.excity.America/Boise", "波夕" },
            { "timezone.excity.America/Jujuy", "胡胡伊" },
            { "timezone.excity.America/Sitka", "錫特卡" },
            { "timezone.excity.America/Thule", "杜里" },
            { "timezone.excity.Asia/Ashgabat", "阿什哈巴特" },
            { "timezone.excity.Asia/Calcutta", "加爾各答" },
            { "timezone.excity.Asia/Damascus", "大馬士革" },
            { "timezone.excity.Asia/Dushanbe", "杜桑貝" },
            { "timezone.excity.Asia/Jayapura", "加亞布拉" },
            { "timezone.excity.Asia/Katmandu", "加德滿都" },
            { "timezone.excity.Asia/Khandyga", "堪地加" },
            { "timezone.excity.Asia/Makassar", "馬卡沙爾" },
            { "timezone.excity.Asia/Qostanay", "科斯塔奈" },
            { "timezone.excity.Asia/Sakhalin", "庫頁島" },
            { "timezone.excity.Asia/Shanghai", "上海" },
            { "timezone.excity.Asia/Tashkent", "塔什干" },
            { "timezone.excity.Asia/Ust-Nera", "烏斯內拉" },
            { "timezone.excity.Europe/Athens", "雅典" },
            { "timezone.excity.Europe/Berlin", "柏林" },
            { "timezone.excity.Europe/Dublin", "都柏林" },
            { "timezone.excity.Europe/Jersey", "澤西島" },
            { "timezone.excity.Europe/Lisbon", "里斯本" },
            { "timezone.excity.Europe/London", "倫敦" },
            { "timezone.excity.Europe/Madrid", "馬德里" },
            { "timezone.excity.Europe/Monaco", "摩納哥" },
            { "timezone.excity.Europe/Moscow", "莫斯科" },
            { "timezone.excity.Europe/Prague", "布拉格" },
            { "timezone.excity.Europe/Samara", "沙馬拉" },
            { "timezone.excity.Europe/Skopje", "史高比耶" },
            { "timezone.excity.Europe/Tirane", "地拉那" },
            { "timezone.excity.Europe/Vienna", "維也納" },
            { "timezone.excity.Europe/Warsaw", "華沙" },
            { "timezone.excity.Europe/Zagreb", "札格瑞布" },
            { "timezone.excity.Europe/Zurich", "蘇黎世" },
            { "timezone.excity.Indian/Chagos", "查戈斯" },
            { "timezone.excity.Indian/Comoro", "科摩羅群島" },
            { "timezone.excity.Pacific/Efate", "埃法特" },
            { "timezone.excity.Pacific/Nauru", "諾魯" },
            { "timezone.excity.Pacific/Palau", "帛琉" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "阿比讓" },
            { "timezone.excity.Africa/Algiers", "阿爾及爾" },
            { "timezone.excity.Africa/Conakry", "柯那克里" },
            { "timezone.excity.Africa/Kampala", "坎帕拉" },
            { "timezone.excity.Africa/Mbabane", "墨巴本" },
            { "timezone.excity.Africa/Nairobi", "奈洛比" },
            { "timezone.excity.Africa/Tripoli", "的黎波里" },
            { "timezone.excity.America/Belize", "貝里斯" },
            { "timezone.excity.America/Bogota", "波哥大" },
            { "timezone.excity.America/Cancun", "坎昆" },
            { "timezone.excity.America/Cayman", "開曼群島" },
            { "timezone.excity.America/Cuiaba", "古雅巴" },
            { "timezone.excity.America/Dawson", "道森" },
            { "timezone.excity.America/Denver", "丹佛" },
            { "timezone.excity.America/Guyana", "蓋亞那" },
            { "timezone.excity.America/Havana", "哈瓦那" },
            { "timezone.excity.America/Inuvik", "伊奴維克" },
            { "timezone.excity.America/Juneau", "朱諾" },
            { "timezone.excity.America/La_Paz", "拉巴斯" },
            { "timezone.excity.America/Maceio", "馬瑟歐" },
            { "timezone.excity.America/Manaus", "瑪瑙斯" },
            { "timezone.excity.America/Merida", "梅里達" },
            { "timezone.excity.America/Nassau", "拿索" },
            { "timezone.excity.America/Panama", "巴拿馬" },
            { "timezone.excity.America/Recife", "雷西非" },
            { "timezone.excity.America/Regina", "里賈納" },
            { "timezone.excity.Asia/Famagusta", "法馬古斯塔" },
            { "timezone.excity.Asia/Hong_Kong", "中華人民共和國香港特別行政區" },
            { "timezone.excity.Asia/Jerusalem", "耶路撒冷" },
            { "timezone.excity.Asia/Kamchatka", "堪察加" },
            { "timezone.excity.Asia/Pontianak", "坤甸" },
            { "timezone.excity.Asia/Pyongyang", "平壤" },
            { "timezone.excity.Asia/Qyzylorda", "克孜勒奧爾達" },
            { "timezone.excity.Asia/Samarkand", "撒馬爾罕" },
            { "timezone.excity.Asia/Singapore", "新加坡" },
            { "timezone.excity.Asia/Vientiane", "永珍" },
            { "timezone.excity.Europe/Andorra", "安道爾" },
            { "timezone.excity.Europe/Saratov", "薩拉托夫" },
            { "timezone.excity.Europe/Tallinn", "塔林" },
            { "timezone.excity.Europe/Vatican", "梵蒂岡" },
            { "timezone.excity.Europe/Vilnius", "維爾紐斯" },
            { "timezone.excity.Indian/Mayotte", "馬約特島" },
            { "timezone.excity.Indian/Reunion", "留尼旺島" },
            { "timezone.excity.Pacific/Easter", "復活島" },
            { "timezone.excity.Pacific/Kosrae", "科斯瑞" },
            { "timezone.excity.Pacific/Majuro", "馬朱諾" },
            { "timezone.excity.Pacific/Midway", "中途島" },
            { "timezone.excity.Pacific/Noumea", "諾美亞" },
            { "timezone.excity.Pacific/Ponape", "波納佩" },
            { "timezone.excity.Pacific/Saipan", "塞班" },
            { "timezone.excity.Pacific/Tahiti", "大溪地" },
            { "timezone.excity.Pacific/Tarawa", "塔拉瓦" },
            { "timezone.excity.Pacific/Wallis", "瓦利斯" },
            { "timezone.excity.Africa/Blantyre", "布蘭太爾" },
            { "timezone.excity.Africa/Djibouti", "吉布地" },
            { "timezone.excity.Africa/El_Aaiun", "阿尤恩" },
            { "timezone.excity.Africa/Freetown", "自由城" },
            { "timezone.excity.Africa/Gaborone", "嘉柏隆里" },
            { "timezone.excity.Africa/Khartoum", "喀土穆" },
            { "timezone.excity.Africa/Kinshasa", "金夏沙" },
            { "timezone.excity.Africa/Monrovia", "蒙羅維亞" },
            { "timezone.excity.Africa/Ndjamena", "恩賈梅納" },
            { "timezone.excity.Africa/Sao_Tome", "聖多美" },
            { "timezone.excity.Africa/Windhoek", "溫得和克" },
            { "timezone.excity.America/Antigua", "安地卡" },
            { "timezone.excity.America/Caracas", "卡拉卡斯" },
            { "timezone.excity.America/Cayenne", "開雲" },
            { "timezone.excity.America/Chicago", "芝加哥" },
            { "timezone.excity.America/Cordoba", "哥多華" },
            { "timezone.excity.America/Creston", "克雷斯頓" },
            { "timezone.excity.America/Curacao", "庫拉索" },
            { "timezone.excity.America/Detroit", "底特律" },
            { "timezone.excity.America/Godthab", "努克" },
            { "timezone.excity.America/Grenada", "格瑞納達" },
            { "timezone.excity.America/Halifax", "哈里法克斯" },
            { "timezone.excity.America/Iqaluit", "伊魁特" },
            { "timezone.excity.America/Jamaica", "牙買加" },
            { "timezone.excity.America/Managua", "馬拿瓜" },
            { "timezone.excity.America/Marigot", "馬里戈特" },
            { "timezone.excity.America/Mendoza", "門多薩" },
            { "timezone.excity.America/Moncton", "蒙克頓" },
            { "timezone.excity.America/Noronha", "諾倫哈" },
            { "timezone.excity.America/Ojinaga", "奧希納加" },
            { "timezone.excity.America/Phoenix", "鳳凰城" },
            { "timezone.excity.America/Tijuana", "提華納" },
            { "timezone.excity.America/Toronto", "多倫多" },
            { "timezone.excity.America/Tortola", "托爾托拉" },
            { "timezone.excity.America/Yakutat", "雅庫塔" },
            { "timezone.excity.Asia/Phnom_Penh", "金邊" },
            { "timezone.excity.Atlantic/Azores", "亞速爾群島" },
            { "timezone.excity.Atlantic/Canary", "加納利" },
            { "timezone.excity.Atlantic/Faeroe", "法羅群島" },
            { "timezone.excity.Australia/Eucla", "尤克拉" },
            { "timezone.excity.Australia/Perth", "伯斯" },
            { "timezone.excity.Europe/Belgrade", "貝爾格勒" },
            { "timezone.excity.Europe/Brussels", "布魯塞爾" },
            { "timezone.excity.Europe/Budapest", "布達佩斯" },
            { "timezone.excity.Europe/Busingen", "布辛根" },
            { "timezone.excity.Europe/Chisinau", "奇西瑙" },
            { "timezone.excity.Europe/Guernsey", "根息島" },
            { "timezone.excity.Europe/Helsinki", "赫爾辛基" },
            { "timezone.excity.Europe/Istanbul", "伊斯坦堡" },
            { "timezone.excity.Europe/Sarajevo", "塞拉耶佛" },
            { "timezone.excity.Indian/Maldives", "馬爾地夫" },
            { "timezone.excity.Pacific/Chatham", "查坦" },
            { "timezone.excity.Pacific/Fakaofo", "法考福" },
            { "timezone.excity.Pacific/Gambier", "甘比爾群島" },
            { "timezone.excity.Pacific/Norfolk", "諾福克" },
            { "timezone.excity.Africa/Bujumbura", "布松布拉" },
            { "timezone.excity.Africa/Mogadishu", "摩加迪休" },
            { "timezone.excity.America/Anguilla", "安吉拉" },
            { "timezone.excity.America/Asuncion", "亞松森" },
            { "timezone.excity.America/Barbados", "巴貝多" },
            { "timezone.excity.America/Dominica", "多明尼加" },
            { "timezone.excity.America/Edmonton", "艾德蒙吞" },
            { "timezone.excity.America/Eirunepe", "艾魯內佩" },
            { "timezone.excity.America/Mazatlan", "馬薩特蘭" },
            { "timezone.excity.America/Miquelon", "密啟崙" },
            { "timezone.excity.America/New_York", "紐約" },
            { "timezone.excity.America/Resolute", "羅斯魯特" },
            { "timezone.excity.America/Santarem", "聖塔倫" },
            { "timezone.excity.America/Santiago", "聖地牙哥" },
            { "timezone.excity.America/St_Johns", "聖約翰" },
            { "timezone.excity.America/St_Kitts", "聖基茨" },
            { "timezone.excity.America/St_Lucia", "聖露西亞" },
            { "timezone.excity.America/Winnipeg", "溫尼伯" },
            { "timezone.excity.Antarctica/Casey", "凱西" },
            { "timezone.excity.Antarctica/Davis", "戴維斯" },
            { "timezone.excity.Antarctica/Syowa", "昭和基地" },
            { "timezone.excity.Antarctica/Troll", "綽爾" },
            { "timezone.excity.Asia/Krasnoyarsk", "克拉斯諾亞爾斯克" },
            { "timezone.excity.Asia/Novosibirsk", "新西伯利亞" },
            { "timezone.excity.Asia/Ulaanbaatar", "烏蘭巴托" },
            { "timezone.excity.Asia/Vladivostok", "海參崴" },
            { "timezone.excity.Atlantic/Bermuda", "百慕達" },
            { "timezone.excity.Atlantic/Madeira", "馬得拉群島" },
            { "timezone.excity.Atlantic/Stanley", "史坦利" },
            { "timezone.excity.Australia/Darwin", "達爾文" },
            { "timezone.excity.Australia/Hobart", "荷巴特" },
            { "timezone.excity.Australia/Sydney", "雪梨" },
            { "timezone.excity.Europe/Amsterdam", "阿姆斯特丹" },
            { "timezone.excity.Europe/Astrakhan", "阿斯特拉罕" },
            { "timezone.excity.Europe/Bucharest", "布加勒斯特" },
            { "timezone.excity.Europe/Gibraltar", "直布羅陀" },
            { "timezone.excity.Europe/Ljubljana", "盧比安納" },
            { "timezone.excity.Europe/Mariehamn", "瑪麗港" },
            { "timezone.excity.Europe/Podgorica", "波多里察" },
            { "timezone.excity.Europe/Stockholm", "斯德哥爾摩" },
            { "timezone.excity.Europe/Ulyanovsk", "烏里揚諾夫斯克" },
            { "timezone.excity.Europe/Volgograd", "伏爾加格勒" },
            { "timezone.excity.Indian/Christmas", "聖誕島" },
            { "timezone.excity.Indian/Kerguelen", "凱爾蓋朗島" },
            { "timezone.excity.Indian/Mauritius", "模里西斯" },
            { "timezone.excity.Pacific/Auckland", "奧克蘭" },
            { "timezone.excity.Pacific/Funafuti", "富那富提" },
            { "timezone.excity.Pacific/Honolulu", "檀香山" },
            { "timezone.excity.Pacific/Pitcairn", "皮特肯群島" },
            { "timezone.excity.Africa/Casablanca", "卡薩布蘭卡" },
            { "timezone.excity.Africa/Libreville", "自由市" },
            { "timezone.excity.Africa/Lubumbashi", "盧本巴希" },
            { "timezone.excity.Africa/Nouakchott", "諾克少" },
            { "timezone.excity.Africa/Porto-Novo", "波多諾佛" },
            { "timezone.excity.America/Anchorage", "安克拉治" },
            { "timezone.excity.America/Araguaina", "阿拉圭那" },
            { "timezone.excity.America/Boa_Vista", "保維斯塔" },
            { "timezone.excity.America/Catamarca", "卡塔馬卡" },
            { "timezone.excity.America/Chihuahua", "奇華華" },
            { "timezone.excity.America/Coyhaique", "科伊艾克" },
            { "timezone.excity.America/Fortaleza", "福塔力莎" },
            { "timezone.excity.America/Glace_Bay", "格雷斯貝" },
            { "timezone.excity.America/Goose_Bay", "鵝灣" },
            { "timezone.excity.America/Guatemala", "瓜地馬拉" },
            { "timezone.excity.America/Guayaquil", "瓜亞基爾" },
            { "timezone.excity.America/Matamoros", "馬塔莫羅斯" },
            { "timezone.excity.America/Menominee", "美諾米尼" },
            { "timezone.excity.America/Monterrey", "蒙特瑞" },
            { "timezone.excity.America/Sao_Paulo", "聖保羅" },
            { "timezone.excity.America/St_Thomas", "聖托馬斯" },
            { "timezone.excity.America/Vancouver", "溫哥華" },
            { "timezone.excity.Antarctica/Mawson", "莫森" },
            { "timezone.excity.Antarctica/Palmer", "帕麥" },
            { "timezone.excity.Antarctica/Vostok", "沃斯托克" },
            { "timezone.excity.Asia/Kuala_Lumpur", "吉隆坡" },
            { "timezone.excity.Asia/Novokuznetsk", "新庫茲涅茨克" },
            { "timezone.excity.Europe/Bratislava", "布拉提斯拉瓦" },
            { "timezone.excity.Europe/Copenhagen", "哥本哈根" },
            { "timezone.excity.Europe/Luxembourg", "盧森堡" },
            { "timezone.excity.Europe/San_Marino", "聖馬利諾" },
            { "timezone.excity.Europe/Simferopol", "辛非洛浦" },
            { "timezone.excity.Pacific/Enderbury", "坎頓" },
            { "timezone.excity.Pacific/Galapagos", "加拉巴哥群島" },
            { "timezone.excity.Pacific/Kwajalein", "瓜加林島" },
            { "timezone.excity.Pacific/Marquesas", "馬可薩斯島" },
            { "timezone.excity.Pacific/Pago_Pago", "巴哥巴哥" },
            { "timezone.excity.Pacific/Rarotonga", "拉羅湯加" },
            { "timezone.excity.Pacific/Tongatapu", "東加塔布島" },
            { "timezone.excity.Africa/Addis_Ababa", "阿迪斯阿貝巴" },
            { "timezone.excity.Africa/Brazzaville", "布拉柴維爾" },
            { "timezone.excity.Africa/Ouagadougou", "瓦加杜古" },
            { "timezone.excity.America/Costa_Rica", "哥斯大黎加" },
            { "timezone.excity.America/Grand_Turk", "大特克島" },
            { "timezone.excity.America/Guadeloupe", "瓜地洛普" },
            { "timezone.excity.America/Hermosillo", "埃莫西約" },
            { "timezone.excity.America/Kralendijk", "克拉倫代克" },
            { "timezone.excity.America/Louisville", "路易斯維爾" },
            { "timezone.excity.America/Martinique", "馬丁尼克" },
            { "timezone.excity.America/Metlakatla", "梅特拉卡特拉" },
            { "timezone.excity.America/Montevideo", "蒙特維多" },
            { "timezone.excity.America/Montserrat", "蒙哲臘" },
            { "timezone.excity.America/Paramaribo", "巴拉馬利波" },
            { "timezone.excity.America/Rio_Branco", "里約布蘭" },
            { "timezone.excity.America/St_Vincent", "聖文森" },
            { "timezone.excity.America/Whitehorse", "懷特霍斯" },
            { "timezone.excity.Antarctica/McMurdo", "麥克默多" },
            { "timezone.excity.Antarctica/Rothera", "羅瑟拉" },
            { "timezone.excity.Asia/Srednekolymsk", "中科雷姆斯克" },
            { "timezone.excity.Asia/Yekaterinburg", "葉卡捷林堡" },
            { "timezone.excity.Atlantic/Reykjavik", "雷克雅維克" },
            { "timezone.excity.Atlantic/St_Helena", "聖赫勒拿島" },
            { "timezone.excity.Australia/Adelaide", "阿得雷德" },
            { "timezone.excity.Australia/Brisbane", "布利斯班" },
            { "timezone.excity.Australia/Lindeman", "林德曼" },
            { "timezone.excity.Europe/Isle_of_Man", "曼島" },
            { "timezone.excity.Europe/Kaliningrad", "加里寧格勒" },
            { "timezone.excity.Pacific/Kiritimati", "基里地馬地島" },
            { "timezone.excity.Africa/Johannesburg", "約翰尼斯堡" },
            { "timezone.excity.America/El_Salvador", "薩爾瓦多" },
            { "timezone.excity.America/Fort_Nelson", "納爾遜堡" },
            { "timezone.excity.America/Los_Angeles", "洛杉磯" },
            { "timezone.excity.America/Mexico_City", "墨西哥市" },
            { "timezone.excity.America/Porto_Velho", "維留港" },
            { "timezone.excity.America/Puerto_Rico", "波多黎各" },
            { "timezone.excity.America/Tegucigalpa", "德古斯加巴" },
            { "timezone.excity.Arctic/Longyearbyen", "隆意耳拜恩" },
            { "timezone.excity.Atlantic/Cape_Verde", "維德角" },
            { "timezone.excity.Australia/Lord_Howe", "豪勳爵島" },
            { "timezone.excity.Australia/Melbourne", "墨爾本" },
            { "timezone.excity.Indian/Antananarivo", "安塔那那利佛" },
            { "timezone.excity.Pacific/Guadalcanal", "瓜達康納爾島" },
            { "timezone.excity.Africa/Dar_es_Salaam", "沙蘭港" },
            { "timezone.excity.America/Blanc-Sablon", "白朗薩布隆" },
            { "timezone.excity.America/Buenos_Aires", "布宜諾斯艾利斯" },
            { "timezone.excity.America/Campo_Grande", "格蘭場" },
            { "timezone.excity.America/Danmarkshavn", "丹馬沙文" },
            { "timezone.excity.America/Dawson_Creek", "道森克里克" },
            { "timezone.excity.America/Indiana/Knox", "印第安那州諾克斯" },
            { "timezone.excity.America/Indianapolis", "印第安那波里斯" },
            { "timezone.excity.America/Punta_Arenas", "蓬塔阿雷納斯" },
            { "timezone.excity.America/Rankin_Inlet", "蘭今灣" },
            { "timezone.excity.America/Scoresbysund", "伊托科爾托米特" },
            { "timezone.excity.Antarctica/Macquarie", "麥覺理" },
            { "timezone.excity.Pacific/Bougainville", "布干維爾" },
            { "timezone.excity.Pacific/Port_Moresby", "莫士比港" },
            { "timezone.excity.America/Cambridge_Bay", "劍橋灣" },
            { "timezone.excity.America/Ciudad_Juarez", "華雷斯城" },
            { "timezone.excity.America/Coral_Harbour", "阿蒂科肯" },
            { "timezone.excity.America/Indiana/Vevay", "印第安那州維威" },
            { "timezone.excity.America/Lower_Princes", "下太子區" },
            { "timezone.excity.America/Port_of_Spain", "西班牙港" },
            { "timezone.excity.America/Santo_Domingo", "聖多明哥" },
            { "timezone.excity.America/St_Barthelemy", "聖巴托洛繆島" },
            { "timezone.excity.America/Swift_Current", "斯威夫特卡倫特" },
            { "timezone.excity.Australia/Broken_Hill", "布羅肯希爾" },
            { "timezone.excity.America/Bahia_Banderas", "巴伊亞班德拉斯" },
            { "timezone.excity.America/Port-au-Prince", "太子港" },
            { "timezone.excity.Atlantic/South_Georgia", "南喬治亞" },
            { "timezone.excity.America/Argentina/Salta", "薩爾塔" },
            { "timezone.excity.America/Indiana/Marengo", "印第安那州馬倫哥" },
            { "timezone.excity.America/Indiana/Winamac", "印第安那州威納馬克" },
            { "timezone.excity.America/Argentina/Tucuman", "吐庫曼" },
            { "timezone.excity.America/Argentina/Ushuaia", "烏斯懷亞" },
            { "timezone.excity.America/Indiana/Tell_City", "印第安那州泰爾城" },
            { "timezone.excity.America/Indiana/Vincennes", "印第安那州溫森斯" },
            { "timezone.excity.Antarctica/DumontDUrville", "杜蒙杜比爾" },
            { "timezone.excity.America/Argentina/La_Rioja", "拉略哈" },
            { "timezone.excity.America/Argentina/San_Juan", "聖胡安" },
            { "timezone.excity.America/Argentina/San_Luis", "聖路易" },
            { "timezone.excity.America/Indiana/Petersburg", "印第安那州彼得堡" },
            { "timezone.excity.America/Kentucky/Monticello", "肯塔基州蒙地卻羅" },
            { "timezone.excity.America/North_Dakota/Beulah", "北達科他州布由拉" },
            { "timezone.excity.America/North_Dakota/Center", "北達科他州中心" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "里奧加耶戈斯" },
            { "timezone.excity.America/North_Dakota/New_Salem", "北達科他州紐沙倫" },
        };
        return data;
    }
}
