/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.ui;

import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.state.DbTextModelState;
import com.intellij.database.schemaEditor.ui.DbEditorController;
import com.intellij.database.schemaEditor.ui.DbTextEditor;
import com.intellij.database.schemaEditor.ui.DbVisualEditorBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ThreeStateCheckBox;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbToggleTextEditor<E extends BasicElement>
extends DbTextEditor<E> {
    private final ThreeStateCheckBox myBox;
    private final JComponent myComponent;
    private final String myCheckInitializer;

    public DbToggleTextEditor(@NotNull DbEditorController controller, @NotNull DbModelRef<E, DbTextModelState> model) {
        if (controller == null) {
            DbToggleTextEditor.$$$reportNull$$$0(0);
        }
        if (model == null) {
            DbToggleTextEditor.$$$reportNull$$$0(1);
        }
        this(controller, model, "");
    }

    public DbToggleTextEditor(@NotNull DbEditorController controller, @NotNull DbModelRef<E, DbTextModelState> model, @NotNull String checkInitializer) {
        if (controller == null) {
            DbToggleTextEditor.$$$reportNull$$$0(2);
        }
        if (model == null) {
            DbToggleTextEditor.$$$reportNull$$$0(3);
        }
        if (checkInitializer == null) {
            DbToggleTextEditor.$$$reportNull$$$0(4);
        }
        super(controller, model);
        this.myComponent = new JPanel(new BorderLayout());
        this.myBox = new ThreeStateCheckBox(this.getModelTitle());
        this.myBox.setThirdStateEnabled(false);
        this.myComponent.add((Component)this.myBox, "West");
        this.myComponent.add((Component)this.myTextField, "Center");
        this.myBox.setBorder((Border)JBUI.Borders.emptyRight((int)10));
        this.myBox.addItemListener(e -> this.onChecked());
        this.myCheckInitializer = checkInitializer;
    }

    private void onChecked() {
        if (this.myBox.getState() == ThreeStateCheckBox.State.DONT_CARE) {
            return;
        }
        this.myInconsistent = false;
        if (this.myBox.isSelected() && this.myTextField.getText().isEmpty()) {
            this.myTextField.setText(this.getCheckInitializer());
        } else {
            this.modified();
        }
        this.updateEnabled();
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            DbToggleTextEditor.$$$reportNull$$$0(5);
        }
        return jComponent;
    }

    @Override
    @Nullable
    public String getTitle() {
        return null;
    }

    @Override
    @NotNull
    protected String getText() {
        return this.myBox.isSelected() ? super.getText() : "";
    }

    @Override
    protected void setText(@NotNull String text) {
        if (text == null) {
            DbToggleTextEditor.$$$reportNull$$$0(6);
        }
        super.setText(text);
        this.myBox.setSelected(StringUtil.isNotEmpty((String)text));
    }

    @Override
    protected void resetImpl() {
        super.resetImpl();
        if (this.myInconsistent) {
            this.myBox.setState(ThreeStateCheckBox.State.DONT_CARE);
        }
    }

    @NotNull
    protected String getCheckInitializer() {
        String string = this.myCheckInitializer;
        if (string == null) {
            DbToggleTextEditor.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    protected void setEnabled(boolean state) {
        super.setEnabled(state);
        DbVisualEditorBase.setEnabled(this.myTextField, state && this.myBox.isSelected());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkInitializer";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/ui/DbToggleTextEditor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbToggleTextEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCheckInitializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7 -> new IllegalStateException(string);
        };
    }
}

