/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.node_modules;

import com.intellij.javascript.nodejs.library.node_modules.NodeModulesLibraryDirectory;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.util.CachedValueImpl;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

final class NodeModulesDirectoryChecker {
    private static final String PNPM_WORKSPACE_YAML_FILENAME = "pnpm-workspace.yaml";
    private static final boolean MAY_CONTAIN_APP_CODE = Registry.is((String)"node_modules.may.contain.application.code", (boolean)false);
    private final Map<VirtualFile, CachedValue<Boolean>> myCache = new ConcurrentHashMap<VirtualFile, CachedValue<Boolean>>();

    NodeModulesDirectoryChecker() {
    }

    public boolean isForApplicationSourceCode(@NotNull VirtualFile nodeModulesDir) {
        if (nodeModulesDir == null) {
            NodeModulesDirectoryChecker.$$$reportNull$$$0(0);
        }
        return MAY_CONTAIN_APP_CODE && this.getOrCalcIsForApplicationSourceCode(nodeModulesDir);
    }

    private boolean getOrCalcIsForApplicationSourceCode(@NotNull VirtualFile nodeModulesDir) {
        CachedValueImpl cachedValue;
        if (nodeModulesDir == null) {
            NodeModulesDirectoryChecker.$$$reportNull$$$0(1);
        }
        if ((cachedValue = this.myCache.get(nodeModulesDir)) == null) {
            cachedValue = new CachedValueImpl(() -> CachedValueProvider.Result.create((Object)NodeModulesDirectoryChecker.calcIsForApplicationSourceCode(nodeModulesDir), (Object[])new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS}));
            this.myCache.put(nodeModulesDir, (CachedValue<Boolean>)cachedValue);
        }
        return (Boolean)cachedValue.getValue();
    }

    private static boolean calcIsForApplicationSourceCode(@NotNull VirtualFile nodeModulesDir) {
        if (nodeModulesDir == null) {
            NodeModulesDirectoryChecker.$$$reportNull$$$0(2);
        }
        if (NodeModuleUtil.findPackageJsonByNodeModules(nodeModulesDir) != null) {
            return false;
        }
        if (NodeModulesLibraryDirectory.Companion.findChild(nodeModulesDir, ".bin", true) != null) {
            return false;
        }
        return NodeModulesLibraryDirectory.Companion.findChild(nodeModulesDir.getParent(), PNPM_WORKSPACE_YAML_FILENAME, false) == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "nodeModulesDir";
        objectArray2[1] = "com/intellij/javascript/nodejs/library/node_modules/NodeModulesDirectoryChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isForApplicationSourceCode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getOrCalcIsForApplicationSourceCode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "calcIsForApplicationSourceCode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

