/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.ecmascript6.psi.ES6ClassExpression;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.Es6MetaProperty;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptParserBundle;
import com.intellij.lang.javascript.completion.JSCompletionKeyword;
import com.intellij.lang.javascript.completion.JSCompletionKeywordsContributor;
import com.intellij.lang.javascript.completion.JSKeywordsCompletionProvider;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.KeywordCompletionConsumer;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSYieldExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInferType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.completion.TypeScriptCompletionKeywordsContributor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6CompletionKeywordsContributor
extends JSCompletionKeywordsContributor {
    private static final TokenSet FILE_REFERENCES = TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.FROM_CLAUSE, JSTokenTypes.STRING_LITERAL});

    @Override
    public boolean process(@NotNull KeywordCompletionConsumer consumer, @NotNull PsiElement context2) {
        JSClass containingClass;
        PsiElement grandParentParent;
        PsiElement parent;
        if (consumer == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(1);
        }
        if (ES6CompletionKeywordsContributor.addMetaKeyword(consumer, parent = context2.getParent())) {
            return false;
        }
        if (ES6CompletionKeywordsContributor.addFromOrAsKeyword(consumer, context2)) {
            return false;
        }
        if (ES6CompletionKeywordsContributor.addExtendsImplements(consumer, context2)) {
            return false;
        }
        if (ES6CompletionKeywordsContributor.addAfterExportDefault(consumer, parent)) {
            return false;
        }
        if (ES6CompletionKeywordsContributor.addAfterExtendsImplements(consumer, parent)) {
            return false;
        }
        if (ES6CompletionKeywordsContributor.isAfterExport(parent)) {
            this.appendKeywordsAfterExport(consumer);
            return false;
        }
        if (ES6CompletionKeywordsContributor.isAfterImport(parent)) {
            this.appendKeywordsAfterImport(consumer, context2);
            return false;
        }
        if (parent instanceof ES6ImportExportSpecifier || parent instanceof ES6ImportedBinding) {
            return false;
        }
        PsiElement grandParent = parent != null ? parent.getParent() : null;
        PsiElement psiElement = grandParentParent = grandParent != null ? grandParent.getParent() : null;
        if (ES6CompletionKeywordsContributor.isModuleContext(parent, grandParent, grandParentParent) && !TypeScriptCompletionKeywordsContributor.shouldAppendExtendsForGenerics(parent)) {
            consumer.consume(JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, true, JSCompletionKeyword.IMPORT, JSCompletionKeyword.EXPORT);
        }
        if (parent instanceof JSField && grandParent instanceof JSVarStatement && grandParent.getParent() instanceof ES6Class && !ES6CompletionKeywordsContributor.appendES6KeywordsForClassMember(consumer, (JSVarStatement)grandParent)) {
            return false;
        }
        JSPsiElementBase parentFunction = JSPsiImplUtils.getParentFunctionThroughLambdas(parent);
        if (parentFunction == null) {
            parentFunction = (JSPsiElementBase)PsiTreeUtil.getParentOfType((PsiElement)parent, JSField.class);
        }
        if ((containingClass = JSUtils.getMemberContainingClass(parentFunction)) != null && parentFunction.getJSContext() != JSContext.STATIC && !containingClass.isInterface() && containingClass.getExtendsList() != null && !(grandParent instanceof JSProperty)) {
            consumer.consume(JSLookupPriority.SMART_PRIORITY, JSCodeStyleSettings.getCommonSettings((PsiElement)parent).SPACE_BEFORE_METHOD_CALL_PARENTHESES, JSCompletionKeyword.SUPER);
        }
        return super.process(consumer, context2);
    }

    protected void appendKeywordsAfterImport(KeywordCompletionConsumer consumer, @NotNull PsiElement context2) {
        PsiElement parent;
        if (context2 == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(2);
        }
        if ((parent = context2.getParent()) == null) {
            return;
        }
        PsiElement nextSibling = parent.getNextSibling();
        if (nextSibling instanceof PsiErrorElement && nextSibling.getNextSibling() == null) {
            consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, JSCompletionKeyword.DEFER, JSCompletionKeyword.SOURCE);
        }
    }

    private static boolean isAfterImport(PsiElement parent) {
        return parent instanceof ES6ImportedBinding && parent.getParent() instanceof ES6ImportDeclaration;
    }

    private static boolean addMetaKeyword(@NotNull KeywordCompletionConsumer consumer, @Nullable PsiElement parent) {
        if (consumer == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(3);
        }
        if (parent instanceof Es6MetaProperty) {
            String parentText = parent.getText();
            if (parentText.startsWith("new.")) {
                consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, false, JSCompletionKeyword.TARGET);
                return true;
            }
            if (parentText.startsWith("import.")) {
                consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, false, JSCompletionKeyword.META, JSCompletionKeyword.DEFER, JSCompletionKeyword.SOURCE);
                return true;
            }
        }
        return false;
    }

    public static boolean appendES6KeywordsForClassMember(@NotNull KeywordCompletionConsumer consumer, @NotNull JSVarStatement fieldStatement) {
        if (consumer == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(4);
        }
        if (fieldStatement == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(5);
        }
        if (!(fieldStatement.getParent() instanceof JSClass)) {
            return true;
        }
        if (!ES6CompletionKeywordsContributor.checkClassMemberPrevSibling((PsiElement)fieldStatement)) {
            return false;
        }
        JSAttributeList attributeList = fieldStatement.getAttributeList();
        if (!JSPsiImplUtils.hasModifier(attributeList, JSAttributeList.ModifierType.STATIC)) {
            consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, JSCompletionKeyword.STATIC);
            consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, JSCodeStyleSettings.getCommonSettings((PsiElement)fieldStatement).SPACE_BEFORE_METHOD_PARENTHESES, JSCompletionKeyword.CONSTRUCTOR);
        }
        if (!JSPsiImplUtils.hasModifier(attributeList, JSAttributeList.ModifierType.ACCESSOR)) {
            consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, JSCompletionKeyword.ACCESSOR);
        }
        return false;
    }

    protected static boolean checkClassMemberPrevSibling(@NotNull PsiElement grandParent) {
        PsiElement sibling;
        PsiElement prev;
        if (grandParent == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(6);
        }
        return !((prev = grandParent.getPrevSibling()) instanceof PsiWhiteSpace) || prev.textContains('\n') || !((sibling = prev.getPrevSibling()) instanceof JSVarStatement) || !(sibling.getLastChild() instanceof PsiErrorElement);
    }

    private static boolean isModuleContext(@Nullable PsiElement parent, @Nullable PsiElement grandParent, @Nullable PsiElement grandParentParent) {
        return parent instanceof JSReferenceExpression && grandParent instanceof JSExpressionStatement && !JSKeywordsCompletionProvider.isContextForOperation((JSReferenceExpression)parent) && ES6PsiUtil.isExportScope(grandParentParent);
    }

    public static boolean isAfterExport(@Nullable PsiElement parent) {
        PsiElement grandParentParent;
        if (parent == null) {
            return false;
        }
        PsiElement grandParent = parent.getParent();
        PsiElement psiElement = grandParentParent = grandParent != null ? grandParent.getParent() : null;
        if (ES6CompletionKeywordsContributor.isModuleContext(parent, grandParent, grandParentParent)) {
            PsiElement prevPrevSibling;
            assert (grandParent != null);
            PsiElement prevSibling = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)grandParent);
            if (prevSibling instanceof PsiErrorElement && JavaScriptParserBundle.message((String)"javascript.parser.message.expected.declaration", (Object[])new Object[0]).equals(((PsiErrorElement)prevSibling).getErrorDescription()) && (prevPrevSibling = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)prevSibling)) instanceof JSAttributeList && ((JSAttributeList)prevPrevSibling).hasModifier(JSAttributeList.ModifierType.EXPORT)) {
                return true;
            }
        }
        return false;
    }

    @Contract(value="_, null -> false")
    private static boolean addAfterExportDefault(@NotNull KeywordCompletionConsumer consumer, @Nullable PsiElement parent) {
        if (consumer == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(7);
        }
        if (!(parent instanceof JSReferenceExpression)) {
            return false;
        }
        PsiElement prev = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)parent);
        if (!(prev instanceof LeafPsiElement)) {
            return false;
        }
        if (((LeafPsiElement)prev).getElementType() != JSTokenTypes.DEFAULT_KEYWORD) {
            return false;
        }
        if (!((prev = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)prev)) instanceof LeafPsiElement)) {
            return false;
        }
        if (((LeafPsiElement)prev).getElementType() != JSTokenTypes.EXPORT_KEYWORD) {
            return false;
        }
        consumer.consume(JSLookupPriority.SMART_PRIORITY, true, JSCompletionKeyword.CLASS, JSCompletionKeyword.FUNCTION, JSCompletionKeyword.ASYNC);
        return true;
    }

    public static boolean addAfterExtendsImplements(@NotNull KeywordCompletionConsumer consumer, @Nullable PsiElement parent) {
        JSExpression expression;
        if (consumer == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(8);
        }
        if (!(parent instanceof JSReferenceExpression) || ((JSReferenceExpression)parent).getQualifier() != null) {
            return false;
        }
        PsiElement grandParent = parent.getParent();
        if (grandParent instanceof JSReferenceListMember && (expression = ((JSReferenceListMember)grandParent).getExpression()) == parent) {
            consumer.consume(JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, true, JSCompletionKeyword.CLASS);
            return true;
        }
        return false;
    }

    public static boolean addExtendsImplements(@Nullable KeywordCompletionConsumer consumer, @NotNull PsiElement position) {
        PsiElement prevLeaf;
        PsiElement prevLeafParent;
        if (position == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(9);
        }
        PsiElement parent = position.getParent();
        if (position instanceof LeafPsiElement && parent instanceof ES6ClassExpression && ((ES6ClassExpression)parent).getNameIdentifier() == position) {
            return ES6CompletionKeywordsContributor.addExtendsImplementsForAnonymousClassExpression(consumer, position);
        }
        if (!(parent instanceof JSReferenceExpression)) {
            return false;
        }
        PsiElement expression = ES6CompletionKeywordsContributor.getBeforeExtendsExpression(parent);
        boolean hasInterfaces = DialectDetector.hasFeature(parent, JSLanguageFeature.INTERFACES);
        if (expression != null && JSKeywordSets.IDENTIFIER_NAMES.contains(expression.getNode().getElementType())) {
            PsiElement prevPrev = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)expression);
            if (prevPrev instanceof LeafPsiElement) {
                IElementType type2 = ((LeafPsiElement)prevPrev).getElementType();
                if (type2 == JSTokenTypes.CLASS_KEYWORD) {
                    return ES6CompletionKeywordsContributor.addExtendsImplementsKeywords(consumer, parent);
                }
                if (type2 == JSTokenTypes.INTERFACE_KEYWORD) {
                    if (consumer != null) {
                        consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, JSCompletionKeyword.EXTENDS);
                    }
                    return true;
                }
                if (type2 == JSTokenTypes.ENUM_KEYWORD) {
                    return true;
                }
            }
        } else if (expression instanceof JSReferenceList) {
            IElementType type3;
            PsiElement child = expression.getParent().getFirstChild();
            PsiElement possibleClassKeyword = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)child);
            if (hasInterfaces && possibleClassKeyword instanceof LeafPsiElement && (type3 = ((LeafPsiElement)possibleClassKeyword).getElementType()) == JSTokenTypes.CLASS_KEYWORD) {
                if (consumer != null) {
                    consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, JSCompletionKeyword.IMPLEMENTS);
                }
                return true;
            }
        }
        PsiElement psiElement = prevLeafParent = (prevLeaf = PsiTreeUtil.prevCodeLeaf((PsiElement)position)) != null ? prevLeaf.getParent() : null;
        if (prevLeafParent instanceof TypeScriptTypeParameter && ((TypeScriptTypeParameter)prevLeafParent).getNameIdentifier() == prevLeaf || prevLeafParent instanceof TypeScriptInferType && ((TypeScriptInferType)prevLeafParent).getNameIdentifier() == prevLeaf) {
            if (consumer != null) {
                consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, JSCompletionKeyword.EXTENDS);
            }
            return true;
        }
        return false;
    }

    private static boolean addExtendsImplementsKeywords(@Nullable KeywordCompletionConsumer consumer, @NotNull PsiElement parent) {
        if (parent == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(10);
        }
        boolean hasInterfaces = DialectDetector.hasFeature(parent, JSLanguageFeature.INTERFACES);
        if (consumer != null) {
            consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, JSCompletionKeyword.EXTENDS);
            if (hasInterfaces) {
                consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, JSCompletionKeyword.IMPLEMENTS);
            }
        }
        return true;
    }

    private static boolean addExtendsImplementsForAnonymousClassExpression(@Nullable KeywordCompletionConsumer consumer, @Nullable PsiElement position) {
        PsiElement possibleClassKeyword = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)position);
        if (possibleClassKeyword != null && possibleClassKeyword.getNode().getElementType() == JSTokenTypes.CLASS_KEYWORD) {
            return ES6CompletionKeywordsContributor.addExtendsImplementsKeywords(consumer, position);
        }
        return false;
    }

    @Contract(value="_, null -> false")
    public static boolean addFromOrAsKeyword(@Nullable KeywordCompletionConsumer consumer, @Nullable PsiElement context2) {
        ASTNode node;
        PsiElement leafBeforeContext;
        if (context2 == null) {
            return false;
        }
        PsiElement parent = context2.getParent();
        if (!(parent instanceof JSReferenceExpression) || PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)context2) != null) {
            return ES6CompletionKeywordsContributor.addAsKeywordForImportExportSpecifier(consumer, parent);
        }
        PsiElement grandParent = parent.getParent();
        if (!(grandParent instanceof JSExpressionStatement)) {
            return false;
        }
        PsiElement prevSibling = grandParent.getPrevSibling();
        if (!(prevSibling instanceof PsiWhiteSpace)) {
            return false;
        }
        PsiElement prevSiblingPrevSibling = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)grandParent);
        boolean isImport = prevSiblingPrevSibling instanceof ES6ImportDeclaration;
        boolean isExport = prevSiblingPrevSibling instanceof ES6ExportDeclaration;
        if (!isImport && !isExport) {
            return false;
        }
        if (!prevSibling.textContains('\n') && (leafBeforeContext = PsiTreeUtil.prevLeaf((PsiElement)prevSibling, (boolean)true)) != null && leafBeforeContext.getNode().getElementType() == JSTokenTypes.STRING_LITERAL) {
            if (consumer != null) {
                consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, JSCompletionKeyword.WITH);
            }
            return true;
        }
        PsiElement last = prevSiblingPrevSibling.getLastChild();
        if (last != null) {
            PsiElement prev;
            PsiElement lastLast = last.getLastChild();
            if (lastLast instanceof PsiErrorElement && (prev = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)lastLast)) != null && prev.getNode().getElementType() == JSTokenTypes.MULT) {
                if (consumer != null) {
                    consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, isImport ? JSCompletionKeyword.AS : JSCompletionKeyword.FROM);
                }
                return true;
            }
            prev = last.getPrevSibling();
            if (prev != null) {
                IElementType type2 = prev.getNode().getElementType();
                if (type2 == JSTokenTypes.COMMA) {
                    return true;
                }
                if (!isImport && type2 == JSTokenTypes.MULT && consumer != null) {
                    consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, JSCompletionKeyword.AS);
                }
            }
        }
        if ((node = prevSiblingPrevSibling.getNode()).findChildByType(FILE_REFERENCES) == null) {
            if (consumer != null) {
                consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, JSCompletionKeyword.FROM);
            }
            return !isExport || !prevSibling.textContains('\n');
        }
        return false;
    }

    @Contract(value="_, null -> false")
    private static boolean addAsKeywordForImportExportSpecifier(@Nullable KeywordCompletionConsumer consumer, @Nullable PsiElement parent) {
        if (!(parent instanceof ES6ImportExportSpecifier)) {
            return false;
        }
        PsiElement prevNode = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)parent);
        if (!(prevNode instanceof PsiErrorElement)) {
            return false;
        }
        if (!((prevNode = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)prevNode)) instanceof ES6ImportExportSpecifier)) {
            return false;
        }
        if (consumer != null) {
            consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, JSCompletionKeyword.AS);
        }
        return true;
    }

    @Nullable
    private static PsiElement getBeforeExtendsExpression(@NotNull PsiElement parent) {
        PsiElement prev;
        PsiElement deepestLast;
        PsiElement grandParent;
        if (parent == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(11);
        }
        if (!((grandParent = parent.getParent()) instanceof JSExpressionStatement)) {
            return null;
        }
        PsiElement prevSibling = grandParent.getPrevSibling();
        if (!(prevSibling instanceof PsiWhiteSpace)) {
            return null;
        }
        PsiElement prevSiblingPrevSibling = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)grandParent);
        if (prevSiblingPrevSibling instanceof JSClass) {
            PsiElement lastChild = prevSiblingPrevSibling.getLastChild();
            if (!(lastChild instanceof PsiErrorElement)) {
                return null;
            }
            return PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)lastChild);
        }
        if (prevSiblingPrevSibling instanceof JSStatement && (deepestLast = PsiTreeUtil.getDeepestLast((PsiElement)prevSiblingPrevSibling)) instanceof PsiErrorElement && (prev = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)deepestLast)) != null && JSKeywordSets.IDENTIFIER_NAMES.contains(prev.getNode().getElementType())) {
            return prev;
        }
        return null;
    }

    @Override
    public void appendSpecificKeywords(@NotNull KeywordCompletionConsumer consumer, @NotNull PsiElement context2, PsiElement grandParent) {
        if (consumer == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(12);
        }
        if (context2 == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(13);
        }
        super.appendSpecificKeywords(consumer, context2, grandParent);
        this.appendAwaitYieldKeywords(consumer, grandParent);
        consumer.consume(JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, true, JSCompletionKeyword.CLASS, JSCompletionKeyword.ASYNC, JSCompletionKeyword.LET, JSCompletionKeyword.CONST);
        consumer.consume(JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, false, JSCompletionKeyword.IMPORT_WITH_BRACES);
    }

    @Override
    public void appendExpressionContextKeywords(@NotNull KeywordCompletionConsumer consumer, @NotNull PsiElement context2, @Nullable PsiElement grandParent) {
        if (consumer == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(14);
        }
        if (context2 == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(15);
        }
        super.appendExpressionContextKeywords(consumer, context2, grandParent);
        consumer.consume(JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, true, JSCompletionKeyword.CLASS, JSCompletionKeyword.ASYNC);
        consumer.consume(JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, false, JSCompletionKeyword.IMPORT_WITH_BRACES);
        this.appendAwaitYieldKeywords(consumer, grandParent);
    }

    protected void appendAwaitYieldKeywords(@NotNull KeywordCompletionConsumer consumer, @Nullable PsiElement grandParent) {
        PsiNamedElement scope2;
        if (consumer == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(16);
        }
        if ((scope2 = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)grandParent, (Class[])new Class[]{JSFunction.class, JSFile.class})) instanceof JSFunction) {
            JSLookupPriority priority;
            if (((JSFunction)scope2).isAsync()) {
                priority = ES6CompletionKeywordsContributor.isAwaitExpression(grandParent) ? JSLookupPriority.LOWEST_PRIORITY : JSLookupPriority.SMART_KEYWORDS_PRIORITY;
                consumer.consume(priority, true, JSCompletionKeyword.AWAIT);
            }
            if (((JSFunction)scope2).isGenerator()) {
                priority = grandParent instanceof JSYieldExpression ? JSLookupPriority.LOWEST_PRIORITY : JSLookupPriority.SMART_KEYWORDS_PRIORITY;
                consumer.consume(priority, true, JSCompletionKeyword.YIELD);
            }
        } else if (scope2 instanceof JSFile) {
            consumer.consume(JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, true, JSCompletionKeyword.AWAIT);
        }
    }

    private static boolean isAwaitExpression(@Nullable PsiElement grandParent) {
        return grandParent instanceof JSPrefixExpression && ((JSPrefixExpression)grandParent).getOperationSign() == JSTokenTypes.AWAIT_KEYWORD;
    }

    protected void appendKeywordsAfterExport(KeywordCompletionConsumer consumer) {
        consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, JSCompletionKeyword.CLASS, JSCompletionKeyword.VAR, JSCompletionKeyword.CONST, JSCompletionKeyword.LET, JSCompletionKeyword.FUNCTION, JSCompletionKeyword.DEFAULT, JSCompletionKeyword.ASYNC);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 1: 
            case 2: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldStatement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grandParent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/completion/ES6CompletionKeywordsContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "appendKeywordsAfterImport";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addMetaKeyword";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "appendES6KeywordsForClassMember";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClassMemberPrevSibling";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addAfterExportDefault";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "addAfterExtendsImplements";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "addExtendsImplements";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "addExtendsImplementsKeywords";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getBeforeExtendsExpression";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "appendSpecificKeywords";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "appendExpressionContextKeywords";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "appendAwaitYieldKeywords";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

