/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptParenthesizedType;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.util.JSParenthesesUtils;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRemoveUnnecessaryParenthesesInspection
extends JSInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSRemoveUnnecessaryParenthesesInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSRemoveUnnecessaryParenthesesInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            @Override
            public void visitJSParenthesizedExpression(@NotNull JSParenthesizedExpression element2) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!JSInheritedLanguagesHelper.isRemoveUnnecessaryParenthesesEnabled((PsiElement)element2)) {
                    return;
                }
                if (JSParenthesesUtils.canRemoveParentheses(element2)) {
                    holder.registerProblem((PsiElement)element2, JavaScriptBundle.message("unnecessary.parentheses.problem.descriptor", new Object[0]), new LocalQuickFix[]{new RemoveParenthesesFix((PsiElement)element2)});
                }
            }

            @Override
            public void visitTypeScriptParenthesizedType(@NotNull TypeScriptParenthesizedType type2) {
                if (type2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!JSInheritedLanguagesHelper.isRemoveUnnecessaryParenthesesEnabled((PsiElement)type2)) {
                    return;
                }
                if (!(type2.getParent() instanceof TypeScriptParenthesizedType) && JSRemoveUnnecessaryParenthesesInspection.canRemoveParenthesesInType(type2)) {
                    holder.registerProblem((PsiElement)type2, JavaScriptBundle.message("unnecessary.parentheses.problem.descriptor", new Object[0]), new LocalQuickFix[]{new RemoveParenthesesFix((PsiElement)type2)});
                }
                super.visitTypeScriptParenthesizedType(type2);
            }

            @Override
            public void visitJSParameterList(@NotNull JSParameterList element2) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!JSInheritedLanguagesHelper.isRemoveUnnecessaryParenthesesEnabled((PsiElement)element2)) {
                    return;
                }
                JSFunctionExpression functionExpression = (JSFunctionExpression)ObjectUtils.tryCast((Object)element2.getParent(), JSFunctionExpression.class);
                if (DialectDetector.hasFeature((PsiElement)element2, JSLanguageFeature.ARROW_FUNCTIONS) && functionExpression != null && functionExpression.isArrowFunction() && element2.getNode().findChildByType(JSTokenTypes.LPAR) != null && !JSPsiImplUtils.parensAroundArrowFunctionParametersRequired(element2, functionExpression)) {
                    holder.registerProblem((PsiElement)element2, JavaScriptBundle.message("unnecessary.parentheses.problem.descriptor", new Object[0]), new LocalQuickFix[]{new RemoveParenthesesFix((PsiElement)element2)});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSRemoveUnnecessaryParenthesesInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSParenthesizedExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitTypeScriptParenthesizedType";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSParameterList";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    private static JSExpression removeParenthesesRecursively(@NotNull JSExpression expression) {
        JSExpression stripped;
        if (expression == null) {
            JSRemoveUnnecessaryParenthesesInspection.$$$reportNull$$$0(2);
        }
        if ((stripped = JSParenthesesUtils.stripParentheses(expression)) == null) {
            return null;
        }
        JSExpression copy = (JSExpression)stripped.copy();
        SyntaxTraverser.psiTraverser((PsiElement)copy).filter(JSParenthesizedExpression.class).forEach(e -> {
            JSExpression noPar;
            if (JSParenthesesUtils.canRemoveParentheses(e) && (noPar = JSParenthesesUtils.stripParentheses(e)) != null) {
                JSBaseIntroduceHandler.fixWhitespacesForParentheses(e);
                e.replace(noPar);
            }
        });
        return copy;
    }

    private static boolean canRemoveParenthesesInType(@NotNull TypeScriptParenthesizedType parenthesized) {
        if (parenthesized == null) {
            JSRemoveUnnecessaryParenthesesInspection.$$$reportNull$$$0(3);
        }
        if (DialectDetector.isFlow((PsiElement)parenthesized)) {
            return false;
        }
        PsiElement parent = parenthesized.getParent();
        if (!(parent instanceof JSTypeDeclaration)) {
            return true;
        }
        JSTypeDeclaration element2 = TypeScriptPsiUtil.unparenthesizeType(parenthesized);
        if (element2 == null) {
            return false;
        }
        return TypeScriptUtil.getTypePrecedence((JSTypeDeclaration)parent) > TypeScriptUtil.getTypePrecedence(element2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parenthesized";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/inspections/JSRemoveUnnecessaryParenthesesInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParenthesesRecursively";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "canRemoveParenthesesInType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class RemoveParenthesesFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        protected RemoveParenthesesFix(@Nullable PsiElement element2) {
            super(element2);
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message("remove.unnecessary.parentheses.fix.text", new Object[0]);
            if (string == null) {
                RemoveParenthesesFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                RemoveParenthesesFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                RemoveParenthesesFix.$$$reportNull$$$0(2);
            }
            if (psiFile == null) {
                RemoveParenthesesFix.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                RemoveParenthesesFix.$$$reportNull$$$0(4);
            }
            if (endElement == null) {
                RemoveParenthesesFix.$$$reportNull$$$0(5);
            }
            if (!super.isAvailable(project, psiFile, editor, startElement, endElement)) {
                return false;
            }
            if (RemoveParenthesesFix.showOnlyForBraces(startElement)) {
                return RemoveParenthesesFix.isBracesPlace(psiFile, editor);
            }
            return true;
        }

        private static boolean showOnlyForBraces(PsiElement startElement) {
            PsiElement psi;
            PsiElement sibling;
            ASTNode node;
            ASTNode lPar;
            return startElement instanceof JSParenthesizedExpression && (lPar = (node = startElement.getNode()).findChildByType(JSTokenTypes.LPAR)) != null && (sibling = (psi = lPar.getPsi()).getNextSibling()) instanceof PsiWhiteSpace && sibling.textContains('\n');
        }

        private static boolean isBracesPlace(@NotNull PsiFile file, @Nullable Editor editor) {
            if (file == null) {
                RemoveParenthesesFix.$$$reportNull$$$0(6);
            }
            if (editor == null) {
                return true;
            }
            int offset = editor.getCaretModel().getOffset();
            if (RemoveParenthesesFix.isPar(file.findElementAt(offset))) {
                return true;
            }
            if (offset > 0) {
                --offset;
            }
            return RemoveParenthesesFix.isPar(file.findElementAt(offset));
        }

        private static boolean isPar(@Nullable PsiElement el) {
            IElementType type2 = el != null ? el.getNode().getElementType() : null;
            return type2 == JSTokenTypes.RPAR || type2 == JSTokenTypes.LPAR;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                RemoveParenthesesFix.$$$reportNull$$$0(7);
            }
            if (psiFile == null) {
                RemoveParenthesesFix.$$$reportNull$$$0(8);
            }
            if (startElement == null) {
                RemoveParenthesesFix.$$$reportNull$$$0(9);
            }
            if (endElement == null) {
                RemoveParenthesesFix.$$$reportNull$$$0(10);
            }
            if (startElement instanceof TypeScriptParenthesizedType) {
                JSTypeDeclaration inner = TypeScriptPsiUtil.unparenthesizeType((JSTypeDeclaration)startElement);
                if (inner == null) {
                    return;
                }
                startElement.replace((PsiElement)JSPsiElementFactory.createTypeScriptType(inner.getText(), startElement));
                return;
            }
            if (startElement instanceof JSParameterList) {
                PsiElement first = startElement.getFirstChild();
                while (first instanceof PsiWhiteSpace || first.getNode().getElementType() == JSTokenTypes.LPAR) {
                    first.delete();
                    first = startElement.getFirstChild();
                }
                PsiElement last = startElement.getLastChild();
                while (last instanceof PsiWhiteSpace || last.getNode().getElementType() == JSTokenTypes.RPAR) {
                    last.delete();
                    last = startElement.getFirstChild();
                }
                return;
            }
            if (startElement instanceof JSExpression) {
                JSExpression exp = (JSExpression)startElement;
                while (exp.getParent() instanceof JSExpression && !(exp.getParent() instanceof JSFunctionExpression)) {
                    exp = (JSExpression)exp.getParent();
                }
                JSExpression expr = JSRemoveUnnecessaryParenthesesInspection.removeParenthesesRecursively(exp);
                if (expr != null) {
                    JSChangeUtil.replaceExpression(exp, expr);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4, 5, 6, 7, 8, 9, 10 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSRemoveUnnecessaryParenthesesInspection$RemoveParenthesesFix";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 4: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 5: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSRemoveUnnecessaryParenthesesInspection$RemoveParenthesesFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isBracesPlace";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4, 5, 6, 7, 8, 9, 10 -> new IllegalArgumentException(string);
            };
        }
    }
}

