/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.event.MouseEventPeer;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.registration.CompositeRegistration;
import org.jetbrains.letsPlot.commons.registration.Disposable;
import org.jetbrains.letsPlot.commons.registration.Registration;
import org.jetbrains.letsPlot.core.interact.EventsManager;
import org.jetbrains.letsPlot.core.interact.ToolFeedback;
import org.jetbrains.letsPlot.core.interact.ToolInteractor;
import org.jetbrains.letsPlot.core.interact.feedback.DrawRectFeedback;
import org.jetbrains.letsPlot.core.interact.feedback.PanGeomFeedback;
import org.jetbrains.letsPlot.core.interact.feedback.RollbackAllChangesFeedback;
import org.jetbrains.letsPlot.core.interact.feedback.WheelZoomFeedback;
import org.jetbrains.letsPlot.core.plot.base.PlotContext;
import org.jetbrains.letsPlot.core.plot.base.theme.Theme;
import org.jetbrains.letsPlot.core.plot.base.tooltip.GeomTargetLocator;
import org.jetbrains.letsPlot.core.plot.builder.PlotTile;
import org.jetbrains.letsPlot.core.plot.builder.interact.context.DataSelectionStrategy;
import org.jetbrains.letsPlot.core.plot.builder.interact.context.MouseDragSelectionStrategy;
import org.jetbrains.letsPlot.core.plot.builder.interact.context.MouseWheelSelectionStrategy;
import org.jetbrains.letsPlot.core.plot.builder.interact.context.NoneSelectionStrategy;
import org.jetbrains.letsPlot.core.plot.builder.interact.context.PlotTilesInteractionContext;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.HorizontalAxisTooltipPosition;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.TooltipRenderer;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.VerticalAxisTooltipPosition;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.style.StyleSheet;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B=\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\b\u0010$\u001a\u00020%H\u0016JJ\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020\u001f2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\n0*2\u0006\u0010-\u001a\u00020\b2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201J\b\u00102\u001a\u00020%H\u0016J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u001c\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001e0\u001dj\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001e`!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/PlotInteractor;", "Lorg/jetbrains/letsPlot/core/interact/ToolInteractor;", "Lorg/jetbrains/letsPlot/commons/registration/Disposable;", "decorationLayer", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgNode;", "mouseEventPeer", "Lorg/jetbrains/letsPlot/commons/event/MouseEventPeer;", "plotSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "flippedAxis", "", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/Theme;", "styleSheet", "Lorg/jetbrains/letsPlot/datamodel/svg/style/StyleSheet;", "plotContext", "Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;", "(Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgNode;Lorg/jetbrains/letsPlot/commons/event/MouseEventPeer;Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;ZLorg/jetbrains/letsPlot/core/plot/base/theme/Theme;Lorg/jetbrains/letsPlot/datamodel/svg/style/StyleSheet;Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;)V", "getDecorationLayer", "()Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgNode;", "eventsManager", "Lorg/jetbrains/letsPlot/core/interact/EventsManager;", "getEventsManager", "()Lorg/jetbrains/letsPlot/core/interact/EventsManager;", "getPlotSize", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "reg", "Lorg/jetbrains/letsPlot/commons/registration/CompositeRegistration;", "tiles", "Ljava/util/ArrayList;", "Lkotlin/Pair;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "Lorg/jetbrains/letsPlot/core/plot/builder/PlotTile;", "Lkotlin/collections/ArrayList;", "tooltipRenderer", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/TooltipRenderer;", "dispose", "", "onTileAdded", "plotTile", "geomBounds", "targetLocators", "", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetLocator;", "layerYOrientations", "axisOrigin", "hAxisTooltipPosition", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/HorizontalAxisTooltipPosition;", "vAxisTooltipPosition", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/VerticalAxisTooltipPosition;", "reset", "startToolFeedback", "Lorg/jetbrains/letsPlot/commons/registration/Registration;", "toolFeedback", "Lorg/jetbrains/letsPlot/core/interact/ToolFeedback;", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nPlotInteractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlotInteractor.kt\norg/jetbrains/letsPlot/core/plot/builder/PlotInteractor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n1855#2,2:119\n*S KotlinDebug\n*F\n+ 1 PlotInteractor.kt\norg/jetbrains/letsPlot/core/plot/builder/PlotInteractor\n*L\n111#1:119,2\n*E\n"})
public final class PlotInteractor
implements ToolInteractor,
Disposable {
    @NotNull
    private final SvgNode decorationLayer;
    @NotNull
    private final DoubleVector plotSize;
    @NotNull
    private final EventsManager eventsManager;
    @NotNull
    private final CompositeRegistration reg;
    @NotNull
    private final TooltipRenderer tooltipRenderer;
    @NotNull
    private final ArrayList<Pair<DoubleRectangle, PlotTile>> tiles;

    public PlotInteractor(@NotNull SvgNode decorationLayer, @NotNull MouseEventPeer mouseEventPeer, @NotNull DoubleVector plotSize2, boolean flippedAxis, @NotNull Theme theme2, @NotNull StyleSheet styleSheet, @NotNull PlotContext plotContext) {
        Intrinsics.checkNotNullParameter((Object)decorationLayer, (String)"decorationLayer");
        Intrinsics.checkNotNullParameter((Object)mouseEventPeer, (String)"mouseEventPeer");
        Intrinsics.checkNotNullParameter((Object)plotSize2, (String)"plotSize");
        Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
        Intrinsics.checkNotNullParameter((Object)styleSheet, (String)"styleSheet");
        Intrinsics.checkNotNullParameter((Object)plotContext, (String)"plotContext");
        this.decorationLayer = decorationLayer;
        this.plotSize = plotSize2;
        this.eventsManager = new EventsManager();
        this.reg = new CompositeRegistration(new Registration[0]);
        this.tiles = new ArrayList();
        this.reg.add(Registration.Companion.from((Disposable)this.eventsManager));
        this.eventsManager.setEventSource(mouseEventPeer);
        this.tooltipRenderer = new TooltipRenderer(this.decorationLayer, flippedAxis, this.plotSize, theme2.horizontalAxis(flippedAxis), theme2.verticalAxis(flippedAxis), theme2.tooltips(), theme2.plot().backgroundFill(), styleSheet, plotContext, mouseEventPeer);
        this.reg.add(Registration.Companion.from((Disposable)this.tooltipRenderer));
    }

    @NotNull
    public final SvgNode getDecorationLayer() {
        return this.decorationLayer;
    }

    @NotNull
    public final DoubleVector getPlotSize() {
        return this.plotSize;
    }

    @NotNull
    public final EventsManager getEventsManager() {
        return this.eventsManager;
    }

    public final void onTileAdded(@NotNull PlotTile plotTile, @NotNull DoubleRectangle geomBounds, @NotNull List<? extends GeomTargetLocator> targetLocators, @NotNull List<Boolean> layerYOrientations, @NotNull DoubleVector axisOrigin, @NotNull HorizontalAxisTooltipPosition hAxisTooltipPosition, @NotNull VerticalAxisTooltipPosition vAxisTooltipPosition) {
        Intrinsics.checkNotNullParameter((Object)plotTile, (String)"plotTile");
        Intrinsics.checkNotNullParameter((Object)geomBounds, (String)"geomBounds");
        Intrinsics.checkNotNullParameter(targetLocators, (String)"targetLocators");
        Intrinsics.checkNotNullParameter(layerYOrientations, (String)"layerYOrientations");
        Intrinsics.checkNotNullParameter((Object)axisOrigin, (String)"axisOrigin");
        Intrinsics.checkNotNullParameter((Object)((Object)hAxisTooltipPosition), (String)"hAxisTooltipPosition");
        Intrinsics.checkNotNullParameter((Object)((Object)vAxisTooltipPosition), (String)"vAxisTooltipPosition");
        this.tooltipRenderer.addTileInfo(geomBounds, targetLocators, layerYOrientations, axisOrigin, hAxisTooltipPosition, vAxisTooltipPosition);
        this.tiles.add((Pair<DoubleRectangle, PlotTile>)TuplesKt.to((Object)geomBounds, (Object)plotTile));
    }

    @Override
    @NotNull
    public Registration startToolFeedback(@NotNull ToolFeedback toolFeedback) {
        DataSelectionStrategy dataSelectionStrategy;
        Intrinsics.checkNotNullParameter((Object)toolFeedback, (String)"toolFeedback");
        ToolFeedback toolFeedback2 = toolFeedback;
        if (toolFeedback2 instanceof PanGeomFeedback ? true : toolFeedback2 instanceof DrawRectFeedback) {
            dataSelectionStrategy = new MouseDragSelectionStrategy();
        } else if (toolFeedback2 instanceof WheelZoomFeedback) {
            dataSelectionStrategy = new MouseWheelSelectionStrategy();
        } else if (toolFeedback2 instanceof RollbackAllChangesFeedback) {
            dataSelectionStrategy = new NoneSelectionStrategy();
        } else {
            throw new IllegalArgumentException("Unexpected feedback object: " + Reflection.getOrCreateKotlinClass(toolFeedback.getClass()).getSimpleName());
        }
        DataSelectionStrategy dataSelectionStrategy2 = dataSelectionStrategy;
        Disposable disposable = toolFeedback.start(new PlotTilesInteractionContext(this.decorationLayer, this.eventsManager, (List<Pair<DoubleRectangle, PlotTile>>)this.tiles, dataSelectionStrategy2));
        return Registration.Companion.from(disposable);
    }

    @Override
    public void reset() {
        Iterable $this$forEach$iv = this.tiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair2 = (Pair)element$iv;
            boolean bl = false;
            PlotTile tile2 = (PlotTile)pair2.component2();
            tile2.getTransientState().reset();
        }
    }

    @Override
    public void dispose() {
        this.reg.dispose();
    }
}

