/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.data;

import com.intellij.rt.coverage.data.CoverageData;
import com.intellij.rt.coverage.data.JumpData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.SwitchData;
import com.intellij.rt.coverage.util.ArrayUtil;
import com.intellij.rt.coverage.util.CommonArrayUtil;
import com.intellij.rt.coverage.util.CoverageIOUtil;
import com.intellij.rt.coverage.util.DictionaryLookup;
import com.intellij.rt.coverage.util.ErrorReporter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassData
implements CoverageData {
    private static final int MAX_HITS = 1000000000;
    private final String myClassName;
    private LineData[] myLinesArray;
    private Map<String, Integer> myStatus;
    private String mySource;
    private volatile Object myHitsMask;
    private volatile boolean[] myTraceMask;
    private boolean myFullyAnalysed = false;

    /*
     * WARNING - void declaration
     */
    public ClassData(String name) {
        void var1_1;
        this.myClassName = var1_1;
    }

    public String getName() {
        return this.myClassName;
    }

    public void save(DataOutputStream os, DictionaryLookup dictionaryLookup) throws IOException {
        Iterator iterator;
        CoverageIOUtil.writeINT(os, dictionaryLookup.getDictionaryIndex(this.myClassName));
        Map<String, List<LineData>> sigLines = this.prepareSignaturesMap(dictionaryLookup, true);
        Set<String> sigs = sigLines.keySet();
        CoverageIOUtil.writeINT(os, sigs.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            String sig1 = (String)iterator.next();
            CoverageIOUtil.writeUTF(os, sig1);
            List<LineData> lines = sigLines.get(sig1);
            CoverageIOUtil.writeINT(os, lines.size());
            for (LineData lineData : lines) {
                lineData.save(os);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, List<LineData>> prepareSignaturesMap(DictionaryLookup dictionaryLookup, boolean collapseSignatures) {
        void var3_3;
        HashMap<String, List<LineData>> sigLines = new HashMap<String, List<LineData>>();
        if (this.myLinesArray == null) {
            return sigLines;
        }
        LineData[] lineDataArray = this.myLinesArray;
        int n = this.myLinesArray.length;
        for (int i = 0; i < n; ++i) {
            LineData lineData = lineDataArray[i];
            if (lineData == null) continue;
            String methodSignature = lineData.getMethodSignature();
            String sig = collapseSignatures ? CoverageIOUtil.collapse(methodSignature, dictionaryLookup) : methodSignature;
            ArrayList<LineData> lines = (ArrayList<LineData>)sigLines.get(sig);
            if (lines == null) {
                lines = new ArrayList<LineData>();
                sigLines.put(sig, lines);
            }
            lines.add(lineData);
        }
        return var3_3;
    }

    public Map<String, List<LineData>> mapLinesToMethods() {
        return this.prepareSignaturesMap(null, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void merge(CoverageData data) {
        void var1_1;
        ClassData classData = (ClassData)data;
        this.mergeLines(classData.myLinesArray);
        for (String o : this.getMethodSigs()) {
            void var3_3;
            this.myStatus.put((String)var3_3, null);
        }
        if (this.mySource == null && classData.mySource != null) {
            this.mySource = classData.mySource;
        }
        if (!this.isFullyAnalysed() && var1_1.isFullyAnalysed()) {
            this.setFullyAnalysed(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void mergeLines(LineData[] dLines) {
        if (dLines == null) {
            return;
        }
        if (this.myLinesArray == null || this.myLinesArray.length < dLines.length) {
            LineData[] lines = new LineData[dLines.length];
            if (this.myLinesArray != null) {
                System.arraycopy(this.myLinesArray, 0, lines, 0, this.myLinesArray.length);
            }
            this.myLinesArray = lines;
        }
        for (int i = 0; i < dLines.length; ++i) {
            void var3_4;
            LineData mergedData = dLines[i];
            if (mergedData == null) continue;
            LineData lineData = this.myLinesArray[i];
            if (lineData == null) {
                lineData = new LineData(mergedData.getLineNumber(), mergedData.getMethodSignature());
                this.registerMethodSignature(lineData);
                this.myLinesArray[i] = lineData;
            }
            lineData.merge((CoverageData)var3_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void registerMethodSignature(LineData lineData) {
        void var1_1;
        this.initStatusMap();
        this.myStatus.put(var1_1.getMethodSignature(), null);
    }

    /*
     * WARNING - void declaration
     */
    public LineData getLineData(int line) {
        void var1_1;
        if (line < 0 || line >= this.myLinesArray.length) {
            return null;
        }
        return this.myLinesArray[var1_1];
    }

    public Object[] getLines() {
        return this.myLinesArray;
    }

    /*
     * WARNING - void declaration
     */
    public boolean containsLine(int line) {
        void var1_1;
        return line >= 0 && line < this.myLinesArray.length && this.myLinesArray[var1_1] != null;
    }

    public Collection<String> getMethodSigs() {
        this.initStatusMap();
        return this.myStatus.keySet();
    }

    private void initStatusMap() {
        if (this.myStatus == null) {
            this.myStatus = new HashMap<String, Integer>();
        }
    }

    /*
     * WARNING - void declaration
     */
    public Integer getStatus(String methodSignature) {
        void var2_2;
        if (this.myStatus == null) {
            return null;
        }
        Integer methodStatus = this.myStatus.get(methodSignature);
        if (methodStatus == null) {
            void var1_1;
            LineData[] lineDataArray = this.myLinesArray;
            int n = this.myLinesArray.length;
            for (int i = 0; i < n; ++i) {
                LineData lineData = lineDataArray[i];
                if (lineData == null || !methodSignature.equals(lineData.getMethodSignature()) || lineData.getStatus() == 0) continue;
                methodStatus = 1;
                break;
            }
            if (methodStatus == null) {
                methodStatus = 0;
            }
            this.myStatus.put((String)var1_1, methodStatus);
        }
        return var2_2;
    }

    public String toString() {
        return this.myClassName;
    }

    /*
     * WARNING - void declaration
     */
    public void setLines(LineData[] lines) {
        if (this.myLinesArray == null) {
            this.myLinesArray = lines;
        } else if (this.isFullyAnalysed()) {
            this.mergeLines(lines);
        } else {
            void var2_2;
            void var1_1;
            LineData[] incompleteData = this.myLinesArray;
            this.myLinesArray = null;
            this.myStatus = null;
            this.mergeLines((LineData[])var1_1);
            this.mergeLines((LineData[])var2_2);
        }
        this.setFullyAnalysed(true);
    }

    /*
     * WARNING - void declaration
     */
    public void resetLines(LineData[] lines) {
        void var1_1;
        this.myLinesArray = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setSource(String source) {
        void var1_1;
        this.mySource = var1_1;
    }

    public String getSource() {
        return this.mySource;
    }

    public boolean isFullyAnalysed() {
        return this.myFullyAnalysed;
    }

    /*
     * WARNING - void declaration
     */
    public void setFullyAnalysed(boolean value) {
        void var1_1;
        this.myFullyAnalysed = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void createMask(int size, boolean calculateHits) {
        void var3_5;
        Object current = this.myHitsMask;
        if (calculateHits) {
            if (current == null) {
                this.myHitsMask = new int[size];
                return;
            }
            if (!(current instanceof int[])) {
                throw new IllegalStateException("Int array expected");
            }
            int[] hits = (int[])current;
            if (hits.length < size) {
                this.myHitsMask = ArrayUtil.copy(hits, size);
            }
            return;
        }
        if (current == null) {
            this.myHitsMask = new boolean[size];
            return;
        }
        if (!(current instanceof boolean[])) {
            throw new IllegalStateException("Boolean array expected");
        }
        boolean[] hits = (boolean[])var3_5;
        if (hits.length < size) {
            void var1_1;
            void var2_4;
            this.myHitsMask = ArrayUtil.copy((boolean[])var2_4, (int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void createTraceMask(int size) {
        if (this.myTraceMask == null) {
            this.myTraceMask = new boolean[size];
            return;
        }
        if (this.myTraceMask.length < size) {
            void var1_1;
            this.myTraceMask = ArrayUtil.copy(this.myTraceMask, (int)var1_1);
        }
    }

    public Object getHitsMask() {
        return this.myHitsMask;
    }

    /*
     * WARNING - void declaration
     */
    public void setHitsMask(int[] hits) {
        void var1_1;
        this.myHitsMask = var1_1;
    }

    public boolean[] getTraceMask() {
        return this.myTraceMask;
    }

    /*
     * WARNING - void declaration
     */
    public void setTraceMask(boolean[] traceMask) {
        void var1_1;
        this.myTraceMask = var1_1;
    }

    public static int trimHits(int hits) {
        if (hits >= 0 && hits <= 1000000000) {
            int n;
            return n;
        }
        return 1000000000;
    }

    /*
     * WARNING - void declaration
     */
    public void applyHits() {
        int[] hits = CommonArrayUtil.getIntArray(this.myHitsMask);
        if (hits == null) {
            return;
        }
        for (int i = 0; i < hits.length; ++i) {
            if (hits[i] >= 0 && hits[i] <= 1000000000) continue;
            hits[i] = 1000000000;
        }
        try {
            LineData[] i = this.myLinesArray;
            int n = this.myLinesArray.length;
            for (int j = 0; j < n; ++j) {
                SwitchData[] switches;
                int n2;
                JumpData[] jumps;
                LineData lineData = i[j];
                if (lineData == null) continue;
                int lineId = lineData.getId();
                if (lineId != -1) {
                    LineData lineData2 = lineData;
                    lineData2.setHits(lineData2.getHits() + hits[lineId]);
                }
                if ((jumps = lineData.getJumps()) != null) {
                    int n3 = jumps.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        int falseId;
                        JumpData jumpData = jumps[n2];
                        if (jumpData == null) continue;
                        int trueId = jumpData.getId(true);
                        if (trueId != -1) {
                            JumpData jumpData2 = jumpData;
                            jumpData2.setTrueHits(jumpData2.getTrueHits() + hits[trueId]);
                        }
                        if ((falseId = jumpData.getId(false)) == -1) continue;
                        JumpData jumpData3 = jumpData;
                        jumpData3.setFalseHits(jumpData3.getFalseHits() + hits[falseId]);
                    }
                }
                if ((switches = lineData.getSwitches()) == null) continue;
                SwitchData[] switchDataArray = switches;
                n2 = switches.length;
                for (int k = 0; k < n2; ++k) {
                    SwitchData switchData = switchDataArray[k];
                    if (switchData == null) continue;
                    int defaultId = switchData.getId(-1);
                    if (defaultId != -1) {
                        SwitchData switchData2 = switchData;
                        switchData2.setDefaultHits(switchData2.getDefaultHits() + hits[defaultId]);
                    }
                    int[] switchHits = switchData.getHits();
                    for (int i2 = 0; i2 < switchHits.length; ++i2) {
                        int caseId = switchData.getId(i2);
                        if (caseId == -1) continue;
                        int n4 = i2;
                        switchHits[n4] = switchHits[n4] + hits[caseId];
                    }
                    SwitchData switchData3 = switchData;
                    switchData3.setKeysAndHits(switchData3.getKeys(), switchHits);
                }
            }
            if (!(this.myHitsMask instanceof int[])) {
                if (this.myHitsMask instanceof boolean[]) {
                    Arrays.fill((boolean[])this.myHitsMask, false);
                }
                return;
            }
            Arrays.fill((int[])this.myHitsMask, 0);
        }
        catch (Throwable e) {
            void var2_4;
            ErrorReporter.warn("Unexpected error during applying hits data to class " + this.getName(), (Throwable)var2_4);
        }
    }
}

