# Using DTrace for System Tracing

-   [Get Started With DTrace](how-to/dtrace-guide.md)
    -   [Install DTrace](how-to/dtrace-howto-install-dtrace.md#install_dtrace)
        -   [Build and Install DTrace on Gentoo Linux](how-to/dtrace-howto-install-dtrace.md#build_install_dtrace_gentoo_linux)
        -   [Install DTrace on Oracle Linux 10](how-to/dtrace-howto-install-dtrace.md#install_dtrace_oracle_linux_10)
        -   [Install DTrace on Oracle Linux 9](how-to/dtrace-howto-install-dtrace.md#install_dtrace_oracle_linux_9)
        -   [Install DTrace on Oracle Linux 8](how-to/dtrace-howto-install-dtrace.md#install_dtrace_oracle_linux_8)
        -   [Install DTrace on Oracle Linux 7](how-to/dtrace-howto-install-dtrace.md#install_dtrace_oracle_linux_7)
        -   [Verify the DTrace Installation](how-to/dtrace-howto-install-dtrace.md#verify_install)
    -   [List and Enable Probes](how-to/dtrace-howto-list-and-enable-probes.md#list_enable_probes)
    -   [Create a DTrace Script](how-to/dtrace-howto-create-a-dtrace-script.md#dt_create_script)
    -   [Use Predicates For Control Flow](how-to/dtrace-howto-use-predicates.md#dt_preds_dlang)
-   [DTrace Concepts](explanation/dtrace-concepts.md)
    -   [About DTrace](explanation/dtrace-about.md#concept_about)
    -   [DTrace Components and Terminology](explanation/dtrace-components-and-terminology.md#concept_terms)
        -   [Probes](explanation/dtrace-components-and-terminology.md#concept_terms_probes)
        -   [D Programs](explanation/dtrace-components-and-terminology.md#concept_terms_programs)
        -   [Aggregations](explanation/dtrace-components-and-terminology.md#concept_terms_aggregations)
        -   [Speculation](explanation/dtrace-components-and-terminology.md#concept_terms_speculation)
-   [DTrace Command Reference](reference/dtrace_command_reference.md)
    -   [About the dtrace Command](reference/dtrace_command_desc.md#dtrace_command_desc)
    -   [dtrace Command Options](reference/dtrace_command_options.md#dtrace_command_options)
    -   [dtrace Command Operands](reference/dtrace_command_operands.md#dtrace_command_operands)
    -   [dtrace Command Exit Status](reference/dtrace_command_exit_status.md#dtrace_command_exit_status)
-   [D Program Syntax Reference](reference/d_program_syntax_reference.md)
    -   [Program Structure](reference/d_program_syntax_reference_program_structure.md#dt_prog_struct)
    -   [Types, Operators, and Expressions](reference/dtrace-ref-TypesOperatorsandExpressions.md#dt_types_dlang)
        -   [Identifier Names and Keywords](reference/dtrace-ref-TypesOperatorsandExpressions.md#dt_ident_dlang)
        -   [Data Types and Sizes](reference/dtrace-ref-TypesOperatorsandExpressions.md#dt_dtypes_dlang)
        -   [Constants](reference/dtrace-ref-TypesOperatorsandExpressions.md#dt_consts_dlang)
        -   [Arithmetic Operators](reference/dtrace-ref-TypesOperatorsandExpressions.md#dt_arithops_dlang)
        -   [Relational Operators](reference/dtrace-ref-TypesOperatorsandExpressions.md#dt_relatops_dlang)
        -   [Logical Operators](reference/dtrace-ref-TypesOperatorsandExpressions.md#dt_logicops_dlang)
        -   [Bitwise Operators](reference/dtrace-ref-TypesOperatorsandExpressions.md#dt_bitwiseops_dlang)
        -   [Assignment Operators](reference/dtrace-ref-TypesOperatorsandExpressions.md#dt_assignops_dlang)
        -   [Increment and Decrement Operators](reference/dtrace-ref-TypesOperatorsandExpressions.md#dt_incdecops_dlang)
        -   [Conditional Expressions](reference/dtrace-ref-TypesOperatorsandExpressions.md#dt_condexp_dlang)
        -   [Type Conversions](reference/dtrace-ref-TypesOperatorsandExpressions.md#dt_typeconv_dlang)
        -   [Operator Precedence](reference/dtrace-ref-TypesOperatorsandExpressions.md#dt_preced_dlang)
        -   [Type and Constant Definitions](reference/dtrace-ref-TypesOperatorsandExpressions.md#dt_typcondef_dlang)
            -   [typedefs](reference/dtrace-ref-TypesOperatorsandExpressions.md#dt_typedefs_dlang)
            -   [Enumerations](reference/dtrace-ref-TypesOperatorsandExpressions.md#dt_enums_dlang)
            -   [Inlines](reference/dtrace-ref-TypesOperatorsandExpressions.md#dt_inlines_dlang)
            -   [Type Namespaces](reference/dtrace-ref-TypesOperatorsandExpressions.md#dt_typens_dlang)
    -   [Variables](reference/dtrace-ref-Variables.md#dt_vars_dlang)
        -   [Variable Scope](reference/dtrace-ref-Variables.md#dt_vscope_dlang)
    -   [Pointers](reference/dtrace-ref-PointersandScalarArrays.md#dt_ptrarr_dlang)
        -   [Pointer Safety](reference/dtrace-ref-PointersandScalarArrays.md#dt_ptrsafety_dlang)
        -   [Pointer and Array Relationship](reference/dtrace-ref-PointersandScalarArrays.md#dt_ptrarel_dlang)
        -   [Pointer Arithmetic](reference/dtrace-ref-PointersandScalarArrays.md#dt_ptrarith_dlang)
        -   [Generic Pointers](reference/dtrace-ref-PointersandScalarArrays.md#dt_genptr_dlang)
        -   [Pointers to DTrace Objects](reference/dtrace-ref-PointersandScalarArrays.md#dt_ptrobj_dlang)
        -   [Pointers and Address Spaces](reference/dtrace-ref-PointersandScalarArrays.md#dt_ptraddrsp_dlang)
    -   [Structs and Unions](reference/dtrace-ref-StructsandUnions.md#dt_structunion_dlang)
        -   [Structs](reference/dtrace-ref-StructsandUnions.md#dt_structs_dlang)
        -   [Pointers to Structs](reference/dtrace-ref-StructsandUnions.md#dt_ptrstructs_dlang)
        -   [Unions](reference/dtrace-ref-StructsandUnions.md#dt_unions_dlang)
        -   [Member Sizes and Offsets](reference/dtrace-ref-StructsandUnions.md#dt_memsz_dlang)
        -   [Bit-Fields](reference/dtrace-ref-StructsandUnions.md#dt_bitflds_dlang)
    -   [DTrace String Processing](reference/dtrace-ref-DTraceSupportforStrings.md#dt_strings_dlang)
        -   [String Representation](reference/dtrace-ref-DTraceSupportforStrings.md#dt_strrep_dlang)
        -   [String Constants](reference/dtrace-ref-DTraceSupportforStrings.md#dt_strcon_dlang)
        -   [String Assignment](reference/dtrace-ref-DTraceSupportforStrings.md#dt_strasg_dlang)
        -   [String Conversion](reference/dtrace-ref-DTraceSupportforStrings.md#dt_strconv_dlang)
        -   [String Comparison](reference/dtrace-ref-DTraceSupportforStrings.md#dt_strcomp_dlang)
    -   [Aggregations](reference/aggregation.md#dt_ref_aggregations)
        -   [Aggregation Functions](reference/aggregation.md#dt_ref_aggr_funcs)
	-   [Printing Aggregations](reference/aggregation.md#dt_ref_aggr_print)
	-   [Data Normalization](reference/aggregation.md#dt_ref_aggr_dnorm)
    -   [Speculation](reference/dtrace-ref-speculation.md#dt_ref_speculation)
-   [DTrace Runtime and Compile-time Options Reference](reference/dtrace_runtime_options.md)
    -   [Setting DTrace Compile-time and Runtime Options](reference/setting_dtrace_compiler_and_runtime_options.md#dt_runtime_option_description)
    -   [Compile-time Options](reference/compiler_options.md#dt_compiler_options)
    -   [Runtime Options](reference/runtime_options.md#dt_runtime_options)
    -   [Dynamic Runtime Options](reference/dynamic_runtime_options.md#dt_dynamic_runtime_options)
-   [DTrace Stability Reference](reference/dt_stability_reference.md)
-   [DTrace Built-in Variable Reference](reference/dtrace_builtin_variable_reference.md#dt_ref_builtin_vars)
    -   [Macro Variables](reference/dtrace_builtin_variable_reference.md#dt_macrov_scrpt)
    -   [args\[\]](reference/dtrace_builtin_variable_reference.md#dt_ref_vars_args)
    -   [arg0, …, arg9](reference/dtrace_builtin_variable_reference.md#dt_ref_var_arg0-9)
    -   [caller](reference/dtrace_builtin_variable_reference.md#dt_ref_var_caller)
    -   [curcpu](reference/dtrace_builtin_variable_reference.md#dt_ref_var_curcpu)
    -   [curthread](reference/dtrace_builtin_variable_reference.md#dt_ref_var_curthread)
    -   [epid](reference/dtrace_builtin_variable_reference.md#dt_ref_var_epid)
    -   [errno](reference/dtrace_builtin_variable_reference.md#dt_ref_var_errno)
    -   [execname](reference/dtrace_builtin_variable_reference.md#dt_ref_var_execname)
    -   [fds](reference/dtrace_builtin_variable_reference.md#dt_ref_var_fds)
    -   [gid](reference/dtrace_builtin_variable_reference.md#dt_ref_var_gid)
    -   [id](reference/dtrace_builtin_variable_reference.md#dt_ref_var_id)
    -   [ipl](reference/dtrace_builtin_variable_reference.md#dt_ref_var_ipl)
    -   [pid](reference/dtrace_builtin_variable_reference.md#dt_ref_var_pid)
    -   [ppid](reference/dtrace_builtin_variable_reference.md#dt_ref_var_ppid)
    -   [probefunc](reference/dtrace_builtin_variable_reference.md#dt_ref_var_probefunc)
    -   [probemod](reference/dtrace_builtin_variable_reference.md#dt_ref_var_probemod)
    -   [probename](reference/dtrace_builtin_variable_reference.md#dt_ref_var_probename)
    -   [probeprov](reference/dtrace_builtin_variable_reference.md#dt_ref_var_probeprov)
    -   [stackdepth](reference/dtrace_builtin_variable_reference.md#dt_ref_var_stackdepth)
    -   [tid](reference/dtrace_builtin_variable_reference.md#dt_ref_var_tid)
    -   [timestamp](reference/dtrace_builtin_variable_reference.md#dt_ref_var_timestamp)
    -   [ucaller](reference/dtrace_builtin_variable_reference.md#dt_ref_var_ucaller)
    -   [uid](reference/dtrace_builtin_variable_reference.md#dt_ref_var_uid)
    -   [uregs](reference/dtrace_builtin_variable_reference.md#dt_ref_var_uregs)
    -   [ustackdepth](reference/dtrace_builtin_variable_reference.md#dt_ref_var_ustackdepth)
    -   [vtimestamp](reference/dtrace_builtin_variable_reference.md#dt_ref_var_vtimestamp)
    -   [walltimestamp](reference/dtrace_builtin_variable_reference.md#dt_ref_var_walltimestamp)
-   [DTrace Function Reference](reference/dtrace_functions.md)
    -   [Default Action](reference/dtrace-ref-DefaultAction.md)
    -   [Unimplemented Functions](reference/unimplemented_functions.md)
    -   [alloca](reference/function_alloca.md)
    -   [avg](reference/aggregation_avg.md)
    -   [basename](reference/function_basename.md)
    -   [bcopy](reference/function_bcopy.md)
    -   [clear](reference/function_clear.md)
    -   [cleanpath](reference/dtrace-ref-cleanpath.md)
    -   [commit](reference/function_commit.md)
    -   [copyin](reference/function_copyin.md)
    -   [copyinstr](reference/function_copyinstr.md)
    -   [copyinto](reference/function_copyinto.md)
    -   [copyout](reference/function_copyout.md)
    -   [copyoutstr](reference/function_copyoutstr.md)
    -   [count](reference/aggregation_count.md)
    -   [denormalize](reference/function_denormalize.md)
    -   [dirname](reference/function_dirname.md)
    -   [discard](reference/function_discard.md)
    -   [exit](reference/function_exit.md)
    -   [freopen](reference/function_freopen.md)
    -   [ftruncate](reference/function_ftruncate.md)
    -   [func](reference/function_func.md)
    -   [getmajor](reference/function_getmajor.md)
    -   [getminor](reference/function_getminor.md)
    -   [htonl](reference/function_htonl.md)
    -   [htonll](reference/function_htonll.md)
    -   [htons](reference/function_htons.md)
    -   [index](reference/function_index.md)
    -   [inet\_ntoa](reference/function_inet_ntoa.md)
    -   [inet\_ntoa6](reference/function_inet_ntoa6.md)
    -   [inet\_ntop](reference/function_inet_ntop.md)
    -   [link\_ntop](reference/dtrace-ref-link-ntop.md)
    -   [llquantize](reference/aggregation_llquantize.md)
    -   [lltostr](reference/function_lltostr.md)
    -   [lquantize](reference/aggregation_lquantize.md)
    -   [max](reference/aggregation_max.md)
    -   [min](reference/aggregation_min.md)
    -   [mod](reference/function_mod.md)
    -   [mutex\_owned](reference/function_mutex_owned.md)
    -   [mutex\_owner](reference/function_mutex_owner.md)
    -   [mutex\_type\_adaptive](reference/function_mutex_type_adaptive.md)
    -   [mutex\_type\_spin](reference/function_mutex_type_spin.md)
    -   [normalize](reference/function_normalize.md)
    -   [ntohl](reference/function_ntohl.md)
    -   [ntohll](reference/function_ntohll.md)
    -   [ntohs](reference/function_ntohs.md)
    -   [print](reference/function_print.md)
    -   [printa](reference/function_printa.md)
    -   [printf](reference/function_printf.md)
    -   [progenyof](reference/function_progenyof.md)
    -   [quantize](reference/aggregation_quantize.md)
    -   [raise](reference/function_raise.md)
    -   [rand](reference/function_rand.md)
    -   [rindex](reference/function_rindex.md)
    -   [rw\_iswriter](reference/function_rw_iswriter.md)
    -   [rw\_read\_held](reference/function_rw_read_held.md)
    -   [rw\_write\_held](reference/function_rw_write_held.md)
    -   [setopt](reference/function_setopt.md)
    -   [speculate](reference/function_speculate.md)
    -   [speculation](reference/function_speculation.md)
    -   [stack](reference/function_stack.md)
    -   [stddev](reference/aggregation_stddev.md)
    -   [strchr](reference/function_strchr.md)
    -   [strjoin](reference/function_strjoin.md)
    -   [strlen](reference/function_strlen.md)
    -   [strrchr](reference/function_strrchr.md)
    -   [strstr](reference/function_strstr.md)
    -   [strtok](reference/function_strtok.md)
    -   [substr](reference/function_substr.md)
    -   [sum](reference/aggregation_sum.md)
    -   [sym](reference/function_sym.md)
    -   [system](reference/function_system.md)
    -   [trace](reference/function_trace.md)
    -   [tracemem](reference/function_tracemem.md)
    -   [uaddr](reference/function_uaddr.md)
    -   [ufunc](reference/function_ufunc.md)
    -   [umod](reference/function_umod.md)
    -   [ustack](reference/function_ustack.md)
    -   [usym](reference/function_usym.md)
-   [DTrace Provider Reference](reference/dtrace_providers.md)
    -   [CPC Provider](reference/dtrace_providers_cpc.md#dt_ref_cpc_prov)
        -   [cpc Probes](reference/dtrace_providers_cpc.md#dt_ref_cpcprobes_prov)
        -   [cpc Probe Arguments](reference/dtrace_providers_cpc.md#dt_ref_cpcargs_prov)
        -   [cpc Examples](reference/dtrace_providers_cpc.md#dt_ref_cpcexamples_prov)
        -   [cpc Stability](reference/dtrace_providers_cpc.md#dt_ref_cpcstab_prov)
    -   [DTrace Provider](reference/dtrace_providers_dtrace.md#dt_ref_dt_prov)
        -   [BEGIN Probe](reference/dtrace_providers_dtrace.md#dt_ref_begin_prov)
        -   [END Probe](reference/dtrace_providers_dtrace.md#dt_ref_end_prov)
        -   [ERROR Probe](reference/dtrace_providers_dtrace.md#dt_ref_error_prov)
        -   [dtrace Stability](reference/dtrace_providers_dtrace.md#dt_ref_dtstability_prov)
    -   [FBT Provider](reference/dtrace_providers_fbt.md#dt_ref_fbt_prov)
        -   [fbt Probes](reference/dtrace_providers_fbt.md#dt_ref_fbtprobes_prov)
        -   [fbt Probe Arguments](reference/dtrace_providers_fbt.md#dt_ref_fbtargs_prov)
        -   [fbt Examples](reference/dtrace_providers_fbt.md#dt_ref_fbtexamples_prov)
        -   [fbt Stability](reference/dtrace_providers_fbt.md#dt_ref_fbtstab_prov)
    -   [IO Provider](reference/dtrace_providers_io.md#dt_ref_io_prov)
        -   [io Probes](reference/dtrace_providers_io.md#dt_ref_ioprobes_prov)
        -   [io Probe Arguments](reference/dtrace_providers_io.md#dt_ref_ioargs_prov)
            -   [bufinfo\_t](reference/dtrace_providers_io.md#dt_ref_iobuf_prov)
            -   [devinfo\_t](reference/dtrace_providers_io.md#dt_ref_iodev_prov)
            -   [fileinfo\_t](reference/dtrace_providers_io.md#dt_ref_iofile_prov)
        -   [io Examples](reference/dtrace_providers_io.md#dt_ref_ioexamples_prov)
        -   [io Stability](reference/dtrace_providers_io.md#dt_ref_iostab_prov)
    -   [IP Provider](reference/dtrace_providers_ip.md)
        -   [ip Probes](reference/dtrace_providers_ip.md#dt_ref_ipprobes_prov)
        -   [ip Probe Arguments](reference/dtrace_providers_ip.md#dt_ref_ipargs_prov)
            -   [pktinfo\_t](reference/dtrace_providers_ip.md#dt_ref_ippkt_prov)
            -   [csinfo\_t](reference/dtrace_providers_ip.md#dt_ref_ipcs_prov)
            -   [ipinfo\_t](reference/dtrace_providers_ip.md#dt_ref_ipip_prov)
            -   [ifinfo\_t](reference/dtrace_providers_ip.md#dt_ref_ipif_prov)
            -   [ipv4info\_t](reference/dtrace_providers_ip.md#dt_ref_ipipv4_prov)
            -   [ipv6info\_t](reference/dtrace_providers_ip.md#dt_ref_ipipv6_prov)
        -   [ip Stability](reference/dtrace_providers_ip.md#dt_ref_ipstab_prov)
    -   [Lockstat Provider](reference/dtrace_providers_lockstat.md#dt_ref_lockstat_prov)
        -   [lockstat Probes](reference/dtrace_providers_lockstat.md#dt_ref_lockstatprobes_prov)
        -   [lockstat Probe Arguments](reference/dtrace_providers_lockstat.md#dt_ref_lockstatargs_prov)
        -   [lockstat Examples](reference/dtrace_providers_lockstat.md#dt_ref_lockstatexamples_prov)
        -   [lockstat Stability](reference/dtrace_providers_lockstat.md#dt_ref_lockstatstab_prov)
    -   [Pid Provider](reference/dtrace_providers_pid.md#dt_ref_pid_prov)
        -   [pid Probes](reference/dtrace_providers_pid.md#dt_ref_pidprobes_prov)
        -   [pid Probe Arguments](reference/dtrace_providers_pid.md#dt_ref_pidargs_prov)
        -   [pid Examples](reference/dtrace_providers_pid.md#dt_ref_pidexamples_prov)
        -   [pid Stability](reference/dtrace_providers_pid.md#dt_ref_pidstab_prov)
    -   [Proc Provider](reference/dtrace_providers_proc.md#dt_ref_proc_prov)
        -   [proc Probes](reference/dtrace_providers_proc.md#dt_ref_procprobes_prov)
        -   [proc Probe Arguments](reference/dtrace_providers_proc.md#dt_ref_procargs_prov)
            -   [lwpsinfo\_t](reference/dtrace_providers_proc.md#dt_ref_lwpsinfoproc_prov)
            -   [psinfo\_t](reference/dtrace_providers_proc.md#dt_ref_procpsinfo_prov)
        -   [proc Examples](reference/dtrace_providers_proc.md#dt_ref_procexamples_prov)
        -   [proc Stability](reference/dtrace_providers_proc.md#dt_ref_procstab_prov)
    -   [Profile Provider](reference/dtrace_providers_profile.md#dt_ref_profile_prov)
        -   [profile-n Probes](reference/dtrace_providers_profile.md#dt_ref_profile-n_prov)
        -   [tick-n Probes](reference/dtrace_providers_profile.md#dt_ref_profile-tick-n_prov)
        -   [profile Probe Arguments](reference/dtrace_providers_profile.md#dt_ref_profargs_prov)
        -   [profile Probe Creation](reference/dtrace_providers_profile.md#dt_ref_profprobecreate_prov)
        -   [profile Stability](reference/dtrace_providers_profile.md#dt_ref_profstab_prov)
    -   [Raw FBT Provider](reference/dtrace_providers_rawfbt.md)
        -   [rawfbt Probes](reference/dtrace_providers_rawfbt.md#dt_ref_rawfbtprobes_prov)
        -   [rawfbt Probe Arguments](reference/dtrace_providers_rawfbt.md#dt_ref_rawfbtargs_prov)
        -   [rawfbt Stability](reference/dtrace_providers_rawfbt.md#dt_ref_rawfbtstab_prov)
    -   [Rawtp Provider](reference/dtrace_providers_rawtp.md#dt_ref_rawtp_prov)
        -   [rawtp Stability](reference/dtrace_providers_rawtp.md#dt_ref_rawtpstab_prov)
    -   [Sched Provider](reference/dtrace_providers_sched.md#dt_ref_sched_prov)
        -   [sched Probes](reference/dtrace_providers_sched.md#dt_ref_schedprob_prov)
        -   [sched Probe Arguments](reference/dtrace_providers_sched.md#dt_ref_schedargs_prov)
            -   [lwpsinfo\_t and psinfo\_t](reference/dtrace_providers_sched.md#dt_ref_lwpsinfo_t_psinfo_t_sched_prov)
            -   [cpuinfo\_t](reference/dtrace_providers_sched.md#dt_ref_cpuinfo_sched_prov)
        -   [sched Examples](reference/dtrace_providers_sched.md#dt_ref_schedexamples_prov)
        -   [sched Stability](reference/dtrace_providers_sched.md#dt_ref_schedstab_prov)
    -   [SDT Provider](reference/dtrace_providers_sdt.md#dt_ref_sdt_prov)
        -   [Creating sdt Probes](reference/dtrace_providers_sdt.md#dt_ref_sdtcreatep_prov)
            -   [Declaring Probes](reference/dtrace_providers_sdt.md#dt_ref_sdtdeclp_prov)
            -   [sdt Probe Arguments](reference/dtrace_providers_sdt.md#dt_ref_sdtparg_prov)
        -   [sdt Stability](reference/dtrace_providers_sdt.md#dt_ref_sdtstab_prov)
    -   [Syscall Provider](reference/dtrace_providers_syscall.md#dt_ref_syscall_prov)
        -   [syscall Probes](reference/dtrace_providers_syscall.md#dt_ref_syscallprobes_prov)
        -   [syscall Probe Arguments](reference/dtrace_providers_syscall.md#dt_ref_syscallargs_prov)
        -   [syscall Stability](reference/dtrace_providers_syscall.md#dt_ref_syscallstab_prov)
    -   [TCP Provider](reference/dtrace_providers_tcp.md)
        -   [tcp Probes](reference/dtrace_providers_tcp.md#dt_ref_tcpprobes_prov)
        -   [tcp Probe Arguments](reference/dtrace_providers_tcp.md#dt_ref_tcpargs_prov)
            -   [tcpinfo\_t](reference/dtrace_providers_tcp.md#dt_ref_tcptcp_prov)
            -   [tcpsinfo\_t](reference/dtrace_providers_tcp.md#dt_ref_tcptcps_prov)
            -   [tcplsinfo\_t](reference/dtrace_providers_tcp.md#dt_ref_tcptcpls_prov)
        -   [tcp Stability](reference/dtrace_providers_tcp.md#dt_ref_tcpstab_prov)
    -   [UDP Provider](reference/dtrace_providers_udp.md)
        -   [udp Probes](reference/dtrace_providers_udp.md#dt_ref_udpprobes_prov)
        -   [udp Probe Arguments](reference/dtrace_providers_udp.md#dt_ref_udpargs_prov)
            -   [udpsinfo\_t](reference/dtrace_providers_udp.md#dt_ref_udpudps_prov)
            -   [udpinfo\_t](reference/dtrace_providers_udp.md#dt_ref_udpudp_prov)
        -   [udp Stability](reference/dtrace_providers_udp.md#dt_ref_udpstab_prov)
    -   [USDT Provider](reference/dtrace-ref-StaticallyDefinedTracingofUserApplications.md#dt_ref_usdt_prov)
        -   [Defining USDT Providers and Probes](reference/dtrace-ref-StaticallyDefinedTracingofUserApplications.md#dt_ref_usdtprobes_prov)
        -   [Adding USDT Probes to Application Code](reference/dtrace-ref-StaticallyDefinedTracingofUserApplications.md#dt_ref_usdt_probe_add_prov)
        -   [Building Applications With USDT Probes](reference/dtrace-ref-StaticallyDefinedTracingofUserApplications.md#dt_ref_usdt_build_prov)
        -   [USDT Examples](reference/dtrace-ref-StaticallyDefinedTracingofUserApplications.md#dt_ref_usdtexamples_prov)
