// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package snowball

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCancelCluster = "CancelCluster"

// CancelClusterRequest generates a "aws/request.Request" representing the
// client's request for the CancelCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelCluster for more information on using the CancelCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelClusterRequest method.
//	req, resp := client.CancelClusterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/CancelCluster
func (c *Snowball) CancelClusterRequest(input *CancelClusterInput) (req *request.Request, output *CancelClusterOutput) {
	op := &request.Operation{
		Name:       opCancelCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelClusterInput{}
	}

	output = &CancelClusterOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelCluster API operation for Amazon Import/Export Snowball.
//
// Cancels a cluster job. You can only cancel a cluster job while it's in the
// AwaitingQuorum status. You'll have at least an hour after creating a cluster
// job to cancel it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation CancelCluster for usage and error information.
//
// Returned Error Types:
//
//   - KMSRequestFailedException
//     The provided Key Management Service key lacks the permissions to perform
//     the specified CreateJob or UpdateJob action.
//
//   - InvalidJobStateException
//     The action can't be performed because the job's current state doesn't allow
//     that action to be performed.
//
//   - InvalidResourceException
//     The specified resource can't be found. Check the information you provided
//     in your last request, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/CancelCluster
func (c *Snowball) CancelCluster(input *CancelClusterInput) (*CancelClusterOutput, error) {
	req, out := c.CancelClusterRequest(input)
	return out, req.Send()
}

// CancelClusterWithContext is the same as CancelCluster with the addition of
// the ability to pass a context and additional request options.
//
// See CancelCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) CancelClusterWithContext(ctx aws.Context, input *CancelClusterInput, opts ...request.Option) (*CancelClusterOutput, error) {
	req, out := c.CancelClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelJob = "CancelJob"

// CancelJobRequest generates a "aws/request.Request" representing the
// client's request for the CancelJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelJob for more information on using the CancelJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelJobRequest method.
//	req, resp := client.CancelJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/CancelJob
func (c *Snowball) CancelJobRequest(input *CancelJobInput) (req *request.Request, output *CancelJobOutput) {
	op := &request.Operation{
		Name:       opCancelJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelJobInput{}
	}

	output = &CancelJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelJob API operation for Amazon Import/Export Snowball.
//
// Cancels the specified job. You can only cancel a job before its JobState
// value changes to PreparingAppliance. Requesting the ListJobs or DescribeJob
// action returns a job's JobState as part of the response element data returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation CancelJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidResourceException
//     The specified resource can't be found. Check the information you provided
//     in your last request, and try again.
//
//   - InvalidJobStateException
//     The action can't be performed because the job's current state doesn't allow
//     that action to be performed.
//
//   - KMSRequestFailedException
//     The provided Key Management Service key lacks the permissions to perform
//     the specified CreateJob or UpdateJob action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/CancelJob
func (c *Snowball) CancelJob(input *CancelJobInput) (*CancelJobOutput, error) {
	req, out := c.CancelJobRequest(input)
	return out, req.Send()
}

// CancelJobWithContext is the same as CancelJob with the addition of
// the ability to pass a context and additional request options.
//
// See CancelJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) CancelJobWithContext(ctx aws.Context, input *CancelJobInput, opts ...request.Option) (*CancelJobOutput, error) {
	req, out := c.CancelJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAddress = "CreateAddress"

// CreateAddressRequest generates a "aws/request.Request" representing the
// client's request for the CreateAddress operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAddress for more information on using the CreateAddress
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAddressRequest method.
//	req, resp := client.CreateAddressRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/CreateAddress
func (c *Snowball) CreateAddressRequest(input *CreateAddressInput) (req *request.Request, output *CreateAddressOutput) {
	op := &request.Operation{
		Name:       opCreateAddress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAddressInput{}
	}

	output = &CreateAddressOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAddress API operation for Amazon Import/Export Snowball.
//
// Creates an address for a Snow device to be shipped to. In most regions, addresses
// are validated at the time of creation. The address you provide must be located
// within the serviceable area of your region. If the address is invalid or
// unsupported, then an exception is thrown. If providing an address as a JSON
// file through the cli-input-json option, include the full file path. For example,
// --cli-input-json file://create-address.json.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation CreateAddress for usage and error information.
//
// Returned Error Types:
//
//   - InvalidAddressException
//     The address provided was invalid. Check the address with your region's carrier,
//     and try again.
//
//   - UnsupportedAddressException
//     The address is either outside the serviceable area for your region, or an
//     error occurred. Check the address with your region's carrier and try again.
//     If the issue persists, contact Amazon Web Services Support.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/CreateAddress
func (c *Snowball) CreateAddress(input *CreateAddressInput) (*CreateAddressOutput, error) {
	req, out := c.CreateAddressRequest(input)
	return out, req.Send()
}

// CreateAddressWithContext is the same as CreateAddress with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAddress for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) CreateAddressWithContext(ctx aws.Context, input *CreateAddressInput, opts ...request.Option) (*CreateAddressOutput, error) {
	req, out := c.CreateAddressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCluster = "CreateCluster"

// CreateClusterRequest generates a "aws/request.Request" representing the
// client's request for the CreateCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCluster for more information on using the CreateCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateClusterRequest method.
//	req, resp := client.CreateClusterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/CreateCluster
func (c *Snowball) CreateClusterRequest(input *CreateClusterInput) (req *request.Request, output *CreateClusterOutput) {
	op := &request.Operation{
		Name:       opCreateCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateClusterInput{}
	}

	output = &CreateClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCluster API operation for Amazon Import/Export Snowball.
//
// Creates an empty cluster. Each cluster supports five nodes. You use the CreateJob
// action separately to create the jobs for each of these nodes. The cluster
// does not ship until these five node jobs have been created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation CreateCluster for usage and error information.
//
// Returned Error Types:
//
//   - InvalidResourceException
//     The specified resource can't be found. Check the information you provided
//     in your last request, and try again.
//
//   - KMSRequestFailedException
//     The provided Key Management Service key lacks the permissions to perform
//     the specified CreateJob or UpdateJob action.
//
//   - InvalidInputCombinationException
//     Job or cluster creation failed. One or more inputs were invalid. Confirm
//     that the CreateClusterRequest$SnowballType value supports your CreateJobRequest$JobType,
//     and try again.
//
//   - Ec2RequestFailedException
//     Your user lacks the necessary Amazon EC2 permissions to perform the attempted
//     action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/CreateCluster
func (c *Snowball) CreateCluster(input *CreateClusterInput) (*CreateClusterOutput, error) {
	req, out := c.CreateClusterRequest(input)
	return out, req.Send()
}

// CreateClusterWithContext is the same as CreateCluster with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) CreateClusterWithContext(ctx aws.Context, input *CreateClusterInput, opts ...request.Option) (*CreateClusterOutput, error) {
	req, out := c.CreateClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateJob = "CreateJob"

// CreateJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateJob for more information on using the CreateJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateJobRequest method.
//	req, resp := client.CreateJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/CreateJob
func (c *Snowball) CreateJobRequest(input *CreateJobInput) (req *request.Request, output *CreateJobOutput) {
	op := &request.Operation{
		Name:       opCreateJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateJobInput{}
	}

	output = &CreateJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateJob API operation for Amazon Import/Export Snowball.
//
// Creates a job to import or export data between Amazon S3 and your on-premises
// data center. Your Amazon Web Services account must have the right trust policies
// and permissions in place to create a job for a Snow device. If you're creating
// a job for a node in a cluster, you only need to provide the clusterId value;
// the other job attributes are inherited from the cluster.
//
// Only the Snowball; Edge device type is supported when ordering clustered
// jobs.
//
// The device capacity is optional.
//
// Availability of device types differ by Amazon Web Services Region. For more
// information about Region availability, see Amazon Web Services Regional Services
// (https://aws.amazon.com/about-aws/global-infrastructure/regional-product-services/?p=ngi&loc=4).
//
// Snow Family devices and their capacities.
//
//   - Device type: SNC1_SSD Capacity: T14 Description: Snowcone
//
//   - Device type: SNC1_HDD Capacity: T8 Description: Snowcone
//
//   - Device type: EDGE_S Capacity: T98 Description: Snowball Edge Storage
//     Optimized for data transfer only
//
//   - Device type: EDGE_CG Capacity: T42 Description: Snowball Edge Compute
//     Optimized with GPU
//
//   - Device type: EDGE_C Capacity: T42 Description: Snowball Edge Compute
//     Optimized without GPU
//
//   - Device type: EDGE Capacity: T100 Description: Snowball Edge Storage
//     Optimized with EC2 Compute This device is replaced with T98.
//
//   - Device type: STANDARD Capacity: T50 Description: Original Snowball device
//     This device is only available in the Ningxia, Beijing, and Singapore Amazon
//     Web Services Region
//
//   - Device type: STANDARD Capacity: T80 Description: Original Snowball device
//     This device is only available in the Ningxia, Beijing, and Singapore Amazon
//     Web Services Region.
//
//   - Snow Family device type: RACK_5U_C Capacity: T13 Description: Snowblade.
//
//   - Device type: V3_5S Capacity: T240 Description: Snowball Edge Storage
//     Optimized 210TB
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation CreateJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidResourceException
//     The specified resource can't be found. Check the information you provided
//     in your last request, and try again.
//
//   - KMSRequestFailedException
//     The provided Key Management Service key lacks the permissions to perform
//     the specified CreateJob or UpdateJob action.
//
//   - InvalidInputCombinationException
//     Job or cluster creation failed. One or more inputs were invalid. Confirm
//     that the CreateClusterRequest$SnowballType value supports your CreateJobRequest$JobType,
//     and try again.
//
//   - ClusterLimitExceededException
//     Job creation failed. Currently, clusters support five nodes. If you have
//     fewer than five nodes for your cluster and you have more nodes to create
//     for this cluster, try again and create jobs until your cluster has exactly
//     five nodes.
//
//   - Ec2RequestFailedException
//     Your user lacks the necessary Amazon EC2 permissions to perform the attempted
//     action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/CreateJob
func (c *Snowball) CreateJob(input *CreateJobInput) (*CreateJobOutput, error) {
	req, out := c.CreateJobRequest(input)
	return out, req.Send()
}

// CreateJobWithContext is the same as CreateJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) CreateJobWithContext(ctx aws.Context, input *CreateJobInput, opts ...request.Option) (*CreateJobOutput, error) {
	req, out := c.CreateJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLongTermPricing = "CreateLongTermPricing"

// CreateLongTermPricingRequest generates a "aws/request.Request" representing the
// client's request for the CreateLongTermPricing operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLongTermPricing for more information on using the CreateLongTermPricing
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateLongTermPricingRequest method.
//	req, resp := client.CreateLongTermPricingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/CreateLongTermPricing
func (c *Snowball) CreateLongTermPricingRequest(input *CreateLongTermPricingInput) (req *request.Request, output *CreateLongTermPricingOutput) {
	op := &request.Operation{
		Name:       opCreateLongTermPricing,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLongTermPricingInput{}
	}

	output = &CreateLongTermPricingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLongTermPricing API operation for Amazon Import/Export Snowball.
//
// Creates a job with the long-term usage option for a device. The long-term
// usage is a 1-year or 3-year long-term pricing type for the device. You are
// billed upfront, and Amazon Web Services provides discounts for long-term
// pricing.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation CreateLongTermPricing for usage and error information.
//
// Returned Error Types:
//   - InvalidResourceException
//     The specified resource can't be found. Check the information you provided
//     in your last request, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/CreateLongTermPricing
func (c *Snowball) CreateLongTermPricing(input *CreateLongTermPricingInput) (*CreateLongTermPricingOutput, error) {
	req, out := c.CreateLongTermPricingRequest(input)
	return out, req.Send()
}

// CreateLongTermPricingWithContext is the same as CreateLongTermPricing with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLongTermPricing for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) CreateLongTermPricingWithContext(ctx aws.Context, input *CreateLongTermPricingInput, opts ...request.Option) (*CreateLongTermPricingOutput, error) {
	req, out := c.CreateLongTermPricingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateReturnShippingLabel = "CreateReturnShippingLabel"

// CreateReturnShippingLabelRequest generates a "aws/request.Request" representing the
// client's request for the CreateReturnShippingLabel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateReturnShippingLabel for more information on using the CreateReturnShippingLabel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateReturnShippingLabelRequest method.
//	req, resp := client.CreateReturnShippingLabelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/CreateReturnShippingLabel
func (c *Snowball) CreateReturnShippingLabelRequest(input *CreateReturnShippingLabelInput) (req *request.Request, output *CreateReturnShippingLabelOutput) {
	op := &request.Operation{
		Name:       opCreateReturnShippingLabel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateReturnShippingLabelInput{}
	}

	output = &CreateReturnShippingLabelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateReturnShippingLabel API operation for Amazon Import/Export Snowball.
//
// Creates a shipping label that will be used to return the Snow device to Amazon
// Web Services.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation CreateReturnShippingLabel for usage and error information.
//
// Returned Error Types:
//
//   - InvalidResourceException
//     The specified resource can't be found. Check the information you provided
//     in your last request, and try again.
//
//   - InvalidJobStateException
//     The action can't be performed because the job's current state doesn't allow
//     that action to be performed.
//
//   - InvalidInputCombinationException
//     Job or cluster creation failed. One or more inputs were invalid. Confirm
//     that the CreateClusterRequest$SnowballType value supports your CreateJobRequest$JobType,
//     and try again.
//
//   - ConflictException
//     You get this exception when you call CreateReturnShippingLabel more than
//     once when other requests are not completed.
//
//   - ReturnShippingLabelAlreadyExistsException
//     You get this exception if you call CreateReturnShippingLabel and a valid
//     return shipping label already exists. In this case, use DescribeReturnShippingLabel
//     to get the URL.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/CreateReturnShippingLabel
func (c *Snowball) CreateReturnShippingLabel(input *CreateReturnShippingLabelInput) (*CreateReturnShippingLabelOutput, error) {
	req, out := c.CreateReturnShippingLabelRequest(input)
	return out, req.Send()
}

// CreateReturnShippingLabelWithContext is the same as CreateReturnShippingLabel with the addition of
// the ability to pass a context and additional request options.
//
// See CreateReturnShippingLabel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) CreateReturnShippingLabelWithContext(ctx aws.Context, input *CreateReturnShippingLabelInput, opts ...request.Option) (*CreateReturnShippingLabelOutput, error) {
	req, out := c.CreateReturnShippingLabelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAddress = "DescribeAddress"

// DescribeAddressRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAddress operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAddress for more information on using the DescribeAddress
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAddressRequest method.
//	req, resp := client.DescribeAddressRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/DescribeAddress
func (c *Snowball) DescribeAddressRequest(input *DescribeAddressInput) (req *request.Request, output *DescribeAddressOutput) {
	op := &request.Operation{
		Name:       opDescribeAddress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAddressInput{}
	}

	output = &DescribeAddressOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAddress API operation for Amazon Import/Export Snowball.
//
// Takes an AddressId and returns specific details about that address in the
// form of an Address object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation DescribeAddress for usage and error information.
//
// Returned Error Types:
//   - InvalidResourceException
//     The specified resource can't be found. Check the information you provided
//     in your last request, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/DescribeAddress
func (c *Snowball) DescribeAddress(input *DescribeAddressInput) (*DescribeAddressOutput, error) {
	req, out := c.DescribeAddressRequest(input)
	return out, req.Send()
}

// DescribeAddressWithContext is the same as DescribeAddress with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAddress for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) DescribeAddressWithContext(ctx aws.Context, input *DescribeAddressInput, opts ...request.Option) (*DescribeAddressOutput, error) {
	req, out := c.DescribeAddressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAddresses = "DescribeAddresses"

// DescribeAddressesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAddresses operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAddresses for more information on using the DescribeAddresses
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAddressesRequest method.
//	req, resp := client.DescribeAddressesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/DescribeAddresses
func (c *Snowball) DescribeAddressesRequest(input *DescribeAddressesInput) (req *request.Request, output *DescribeAddressesOutput) {
	op := &request.Operation{
		Name:       opDescribeAddresses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAddressesInput{}
	}

	output = &DescribeAddressesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAddresses API operation for Amazon Import/Export Snowball.
//
// Returns a specified number of ADDRESS objects. Calling this API in one of
// the US regions will return addresses from the list of all addresses associated
// with this account in all US regions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation DescribeAddresses for usage and error information.
//
// Returned Error Types:
//
//   - InvalidResourceException
//     The specified resource can't be found. Check the information you provided
//     in your last request, and try again.
//
//   - InvalidNextTokenException
//     The NextToken string was altered unexpectedly, and the operation has stopped.
//     Run the operation without changing the NextToken string, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/DescribeAddresses
func (c *Snowball) DescribeAddresses(input *DescribeAddressesInput) (*DescribeAddressesOutput, error) {
	req, out := c.DescribeAddressesRequest(input)
	return out, req.Send()
}

// DescribeAddressesWithContext is the same as DescribeAddresses with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAddresses for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) DescribeAddressesWithContext(ctx aws.Context, input *DescribeAddressesInput, opts ...request.Option) (*DescribeAddressesOutput, error) {
	req, out := c.DescribeAddressesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeAddressesPages iterates over the pages of a DescribeAddresses operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeAddresses method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeAddresses operation.
//	pageNum := 0
//	err := client.DescribeAddressesPages(params,
//	    func(page *snowball.DescribeAddressesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Snowball) DescribeAddressesPages(input *DescribeAddressesInput, fn func(*DescribeAddressesOutput, bool) bool) error {
	return c.DescribeAddressesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeAddressesPagesWithContext same as DescribeAddressesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) DescribeAddressesPagesWithContext(ctx aws.Context, input *DescribeAddressesInput, fn func(*DescribeAddressesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeAddressesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeAddressesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeAddressesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeCluster = "DescribeCluster"

// DescribeClusterRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCluster for more information on using the DescribeCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeClusterRequest method.
//	req, resp := client.DescribeClusterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/DescribeCluster
func (c *Snowball) DescribeClusterRequest(input *DescribeClusterInput) (req *request.Request, output *DescribeClusterOutput) {
	op := &request.Operation{
		Name:       opDescribeCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeClusterInput{}
	}

	output = &DescribeClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCluster API operation for Amazon Import/Export Snowball.
//
// Returns information about a specific cluster including shipping information,
// cluster status, and other important metadata.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation DescribeCluster for usage and error information.
//
// Returned Error Types:
//   - InvalidResourceException
//     The specified resource can't be found. Check the information you provided
//     in your last request, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/DescribeCluster
func (c *Snowball) DescribeCluster(input *DescribeClusterInput) (*DescribeClusterOutput, error) {
	req, out := c.DescribeClusterRequest(input)
	return out, req.Send()
}

// DescribeClusterWithContext is the same as DescribeCluster with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) DescribeClusterWithContext(ctx aws.Context, input *DescribeClusterInput, opts ...request.Option) (*DescribeClusterOutput, error) {
	req, out := c.DescribeClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeJob = "DescribeJob"

// DescribeJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeJob for more information on using the DescribeJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeJobRequest method.
//	req, resp := client.DescribeJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/DescribeJob
func (c *Snowball) DescribeJobRequest(input *DescribeJobInput) (req *request.Request, output *DescribeJobOutput) {
	op := &request.Operation{
		Name:       opDescribeJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeJobInput{}
	}

	output = &DescribeJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeJob API operation for Amazon Import/Export Snowball.
//
// Returns information about a specific job including shipping information,
// job status, and other important metadata.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation DescribeJob for usage and error information.
//
// Returned Error Types:
//   - InvalidResourceException
//     The specified resource can't be found. Check the information you provided
//     in your last request, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/DescribeJob
func (c *Snowball) DescribeJob(input *DescribeJobInput) (*DescribeJobOutput, error) {
	req, out := c.DescribeJobRequest(input)
	return out, req.Send()
}

// DescribeJobWithContext is the same as DescribeJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) DescribeJobWithContext(ctx aws.Context, input *DescribeJobInput, opts ...request.Option) (*DescribeJobOutput, error) {
	req, out := c.DescribeJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeReturnShippingLabel = "DescribeReturnShippingLabel"

// DescribeReturnShippingLabelRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReturnShippingLabel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReturnShippingLabel for more information on using the DescribeReturnShippingLabel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeReturnShippingLabelRequest method.
//	req, resp := client.DescribeReturnShippingLabelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/DescribeReturnShippingLabel
func (c *Snowball) DescribeReturnShippingLabelRequest(input *DescribeReturnShippingLabelInput) (req *request.Request, output *DescribeReturnShippingLabelOutput) {
	op := &request.Operation{
		Name:       opDescribeReturnShippingLabel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeReturnShippingLabelInput{}
	}

	output = &DescribeReturnShippingLabelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReturnShippingLabel API operation for Amazon Import/Export Snowball.
//
// Information on the shipping label of a Snow device that is being returned
// to Amazon Web Services.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation DescribeReturnShippingLabel for usage and error information.
//
// Returned Error Types:
//
//   - InvalidResourceException
//     The specified resource can't be found. Check the information you provided
//     in your last request, and try again.
//
//   - InvalidJobStateException
//     The action can't be performed because the job's current state doesn't allow
//     that action to be performed.
//
//   - ConflictException
//     You get this exception when you call CreateReturnShippingLabel more than
//     once when other requests are not completed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/DescribeReturnShippingLabel
func (c *Snowball) DescribeReturnShippingLabel(input *DescribeReturnShippingLabelInput) (*DescribeReturnShippingLabelOutput, error) {
	req, out := c.DescribeReturnShippingLabelRequest(input)
	return out, req.Send()
}

// DescribeReturnShippingLabelWithContext is the same as DescribeReturnShippingLabel with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReturnShippingLabel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) DescribeReturnShippingLabelWithContext(ctx aws.Context, input *DescribeReturnShippingLabelInput, opts ...request.Option) (*DescribeReturnShippingLabelOutput, error) {
	req, out := c.DescribeReturnShippingLabelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetJobManifest = "GetJobManifest"

// GetJobManifestRequest generates a "aws/request.Request" representing the
// client's request for the GetJobManifest operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetJobManifest for more information on using the GetJobManifest
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetJobManifestRequest method.
//	req, resp := client.GetJobManifestRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/GetJobManifest
func (c *Snowball) GetJobManifestRequest(input *GetJobManifestInput) (req *request.Request, output *GetJobManifestOutput) {
	op := &request.Operation{
		Name:       opGetJobManifest,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetJobManifestInput{}
	}

	output = &GetJobManifestOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetJobManifest API operation for Amazon Import/Export Snowball.
//
// Returns a link to an Amazon S3 presigned URL for the manifest file associated
// with the specified JobId value. You can access the manifest file for up to
// 60 minutes after this request has been made. To access the manifest file
// after 60 minutes have passed, you'll have to make another call to the GetJobManifest
// action.
//
// The manifest is an encrypted file that you can download after your job enters
// the WithCustomer status. This is the only valid status for calling this API
// as the manifest and UnlockCode code value are used for securing your device
// and should only be used when you have the device. The manifest is decrypted
// by using the UnlockCode code value, when you pass both values to the Snow
// device through the Snowball client when the client is started for the first
// time.
//
// As a best practice, we recommend that you don't save a copy of an UnlockCode
// value in the same location as the manifest file for that job. Saving these
// separately helps prevent unauthorized parties from gaining access to the
// Snow device associated with that job.
//
// The credentials of a given job, including its manifest file and unlock code,
// expire 360 days after the job is created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation GetJobManifest for usage and error information.
//
// Returned Error Types:
//
//   - InvalidResourceException
//     The specified resource can't be found. Check the information you provided
//     in your last request, and try again.
//
//   - InvalidJobStateException
//     The action can't be performed because the job's current state doesn't allow
//     that action to be performed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/GetJobManifest
func (c *Snowball) GetJobManifest(input *GetJobManifestInput) (*GetJobManifestOutput, error) {
	req, out := c.GetJobManifestRequest(input)
	return out, req.Send()
}

// GetJobManifestWithContext is the same as GetJobManifest with the addition of
// the ability to pass a context and additional request options.
//
// See GetJobManifest for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) GetJobManifestWithContext(ctx aws.Context, input *GetJobManifestInput, opts ...request.Option) (*GetJobManifestOutput, error) {
	req, out := c.GetJobManifestRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetJobUnlockCode = "GetJobUnlockCode"

// GetJobUnlockCodeRequest generates a "aws/request.Request" representing the
// client's request for the GetJobUnlockCode operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetJobUnlockCode for more information on using the GetJobUnlockCode
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetJobUnlockCodeRequest method.
//	req, resp := client.GetJobUnlockCodeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/GetJobUnlockCode
func (c *Snowball) GetJobUnlockCodeRequest(input *GetJobUnlockCodeInput) (req *request.Request, output *GetJobUnlockCodeOutput) {
	op := &request.Operation{
		Name:       opGetJobUnlockCode,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetJobUnlockCodeInput{}
	}

	output = &GetJobUnlockCodeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetJobUnlockCode API operation for Amazon Import/Export Snowball.
//
// Returns the UnlockCode code value for the specified job. A particular UnlockCode
// value can be accessed for up to 360 days after the associated job has been
// created.
//
// The UnlockCode value is a 29-character code with 25 alphanumeric characters
// and 4 hyphens. This code is used to decrypt the manifest file when it is
// passed along with the manifest to the Snow device through the Snowball client
// when the client is started for the first time. The only valid status for
// calling this API is WithCustomer as the manifest and Unlock code values are
// used for securing your device and should only be used when you have the device.
//
// As a best practice, we recommend that you don't save a copy of the UnlockCode
// in the same location as the manifest file for that job. Saving these separately
// helps prevent unauthorized parties from gaining access to the Snow device
// associated with that job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation GetJobUnlockCode for usage and error information.
//
// Returned Error Types:
//
//   - InvalidResourceException
//     The specified resource can't be found. Check the information you provided
//     in your last request, and try again.
//
//   - InvalidJobStateException
//     The action can't be performed because the job's current state doesn't allow
//     that action to be performed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/GetJobUnlockCode
func (c *Snowball) GetJobUnlockCode(input *GetJobUnlockCodeInput) (*GetJobUnlockCodeOutput, error) {
	req, out := c.GetJobUnlockCodeRequest(input)
	return out, req.Send()
}

// GetJobUnlockCodeWithContext is the same as GetJobUnlockCode with the addition of
// the ability to pass a context and additional request options.
//
// See GetJobUnlockCode for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) GetJobUnlockCodeWithContext(ctx aws.Context, input *GetJobUnlockCodeInput, opts ...request.Option) (*GetJobUnlockCodeOutput, error) {
	req, out := c.GetJobUnlockCodeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSnowballUsage = "GetSnowballUsage"

// GetSnowballUsageRequest generates a "aws/request.Request" representing the
// client's request for the GetSnowballUsage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSnowballUsage for more information on using the GetSnowballUsage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSnowballUsageRequest method.
//	req, resp := client.GetSnowballUsageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/GetSnowballUsage
func (c *Snowball) GetSnowballUsageRequest(input *GetSnowballUsageInput) (req *request.Request, output *GetSnowballUsageOutput) {
	op := &request.Operation{
		Name:       opGetSnowballUsage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSnowballUsageInput{}
	}

	output = &GetSnowballUsageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSnowballUsage API operation for Amazon Import/Export Snowball.
//
// Returns information about the Snow Family service limit for your account,
// and also the number of Snow devices your account has in use.
//
// The default service limit for the number of Snow devices that you can have
// at one time is 1. If you want to increase your service limit, contact Amazon
// Web Services Support.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation GetSnowballUsage for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/GetSnowballUsage
func (c *Snowball) GetSnowballUsage(input *GetSnowballUsageInput) (*GetSnowballUsageOutput, error) {
	req, out := c.GetSnowballUsageRequest(input)
	return out, req.Send()
}

// GetSnowballUsageWithContext is the same as GetSnowballUsage with the addition of
// the ability to pass a context and additional request options.
//
// See GetSnowballUsage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) GetSnowballUsageWithContext(ctx aws.Context, input *GetSnowballUsageInput, opts ...request.Option) (*GetSnowballUsageOutput, error) {
	req, out := c.GetSnowballUsageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSoftwareUpdates = "GetSoftwareUpdates"

// GetSoftwareUpdatesRequest generates a "aws/request.Request" representing the
// client's request for the GetSoftwareUpdates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSoftwareUpdates for more information on using the GetSoftwareUpdates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSoftwareUpdatesRequest method.
//	req, resp := client.GetSoftwareUpdatesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/GetSoftwareUpdates
func (c *Snowball) GetSoftwareUpdatesRequest(input *GetSoftwareUpdatesInput) (req *request.Request, output *GetSoftwareUpdatesOutput) {
	op := &request.Operation{
		Name:       opGetSoftwareUpdates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSoftwareUpdatesInput{}
	}

	output = &GetSoftwareUpdatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSoftwareUpdates API operation for Amazon Import/Export Snowball.
//
// Returns an Amazon S3 presigned URL for an update file associated with a specified
// JobId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation GetSoftwareUpdates for usage and error information.
//
// Returned Error Types:
//
//   - InvalidResourceException
//     The specified resource can't be found. Check the information you provided
//     in your last request, and try again.
//
//   - InvalidJobStateException
//     The action can't be performed because the job's current state doesn't allow
//     that action to be performed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/GetSoftwareUpdates
func (c *Snowball) GetSoftwareUpdates(input *GetSoftwareUpdatesInput) (*GetSoftwareUpdatesOutput, error) {
	req, out := c.GetSoftwareUpdatesRequest(input)
	return out, req.Send()
}

// GetSoftwareUpdatesWithContext is the same as GetSoftwareUpdates with the addition of
// the ability to pass a context and additional request options.
//
// See GetSoftwareUpdates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) GetSoftwareUpdatesWithContext(ctx aws.Context, input *GetSoftwareUpdatesInput, opts ...request.Option) (*GetSoftwareUpdatesOutput, error) {
	req, out := c.GetSoftwareUpdatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListClusterJobs = "ListClusterJobs"

// ListClusterJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListClusterJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListClusterJobs for more information on using the ListClusterJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListClusterJobsRequest method.
//	req, resp := client.ListClusterJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListClusterJobs
func (c *Snowball) ListClusterJobsRequest(input *ListClusterJobsInput) (req *request.Request, output *ListClusterJobsOutput) {
	op := &request.Operation{
		Name:       opListClusterJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListClusterJobsInput{}
	}

	output = &ListClusterJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListClusterJobs API operation for Amazon Import/Export Snowball.
//
// Returns an array of JobListEntry objects of the specified length. Each JobListEntry
// object is for a job in the specified cluster and contains a job's state,
// a job's ID, and other information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation ListClusterJobs for usage and error information.
//
// Returned Error Types:
//
//   - InvalidResourceException
//     The specified resource can't be found. Check the information you provided
//     in your last request, and try again.
//
//   - InvalidNextTokenException
//     The NextToken string was altered unexpectedly, and the operation has stopped.
//     Run the operation without changing the NextToken string, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListClusterJobs
func (c *Snowball) ListClusterJobs(input *ListClusterJobsInput) (*ListClusterJobsOutput, error) {
	req, out := c.ListClusterJobsRequest(input)
	return out, req.Send()
}

// ListClusterJobsWithContext is the same as ListClusterJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListClusterJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) ListClusterJobsWithContext(ctx aws.Context, input *ListClusterJobsInput, opts ...request.Option) (*ListClusterJobsOutput, error) {
	req, out := c.ListClusterJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListClusterJobsPages iterates over the pages of a ListClusterJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListClusterJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListClusterJobs operation.
//	pageNum := 0
//	err := client.ListClusterJobsPages(params,
//	    func(page *snowball.ListClusterJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Snowball) ListClusterJobsPages(input *ListClusterJobsInput, fn func(*ListClusterJobsOutput, bool) bool) error {
	return c.ListClusterJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListClusterJobsPagesWithContext same as ListClusterJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) ListClusterJobsPagesWithContext(ctx aws.Context, input *ListClusterJobsInput, fn func(*ListClusterJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListClusterJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListClusterJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListClusterJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListClusters = "ListClusters"

// ListClustersRequest generates a "aws/request.Request" representing the
// client's request for the ListClusters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListClusters for more information on using the ListClusters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListClustersRequest method.
//	req, resp := client.ListClustersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListClusters
func (c *Snowball) ListClustersRequest(input *ListClustersInput) (req *request.Request, output *ListClustersOutput) {
	op := &request.Operation{
		Name:       opListClusters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListClustersInput{}
	}

	output = &ListClustersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListClusters API operation for Amazon Import/Export Snowball.
//
// Returns an array of ClusterListEntry objects of the specified length. Each
// ClusterListEntry object contains a cluster's state, a cluster's ID, and other
// important status information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation ListClusters for usage and error information.
//
// Returned Error Types:
//   - InvalidNextTokenException
//     The NextToken string was altered unexpectedly, and the operation has stopped.
//     Run the operation without changing the NextToken string, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListClusters
func (c *Snowball) ListClusters(input *ListClustersInput) (*ListClustersOutput, error) {
	req, out := c.ListClustersRequest(input)
	return out, req.Send()
}

// ListClustersWithContext is the same as ListClusters with the addition of
// the ability to pass a context and additional request options.
//
// See ListClusters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) ListClustersWithContext(ctx aws.Context, input *ListClustersInput, opts ...request.Option) (*ListClustersOutput, error) {
	req, out := c.ListClustersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListClustersPages iterates over the pages of a ListClusters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListClusters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListClusters operation.
//	pageNum := 0
//	err := client.ListClustersPages(params,
//	    func(page *snowball.ListClustersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Snowball) ListClustersPages(input *ListClustersInput, fn func(*ListClustersOutput, bool) bool) error {
	return c.ListClustersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListClustersPagesWithContext same as ListClustersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) ListClustersPagesWithContext(ctx aws.Context, input *ListClustersInput, fn func(*ListClustersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListClustersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListClustersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListClustersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCompatibleImages = "ListCompatibleImages"

// ListCompatibleImagesRequest generates a "aws/request.Request" representing the
// client's request for the ListCompatibleImages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCompatibleImages for more information on using the ListCompatibleImages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCompatibleImagesRequest method.
//	req, resp := client.ListCompatibleImagesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListCompatibleImages
func (c *Snowball) ListCompatibleImagesRequest(input *ListCompatibleImagesInput) (req *request.Request, output *ListCompatibleImagesOutput) {
	op := &request.Operation{
		Name:       opListCompatibleImages,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCompatibleImagesInput{}
	}

	output = &ListCompatibleImagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCompatibleImages API operation for Amazon Import/Export Snowball.
//
// This action returns a list of the different Amazon EC2-compatible Amazon
// Machine Images (AMIs) that are owned by your Amazon Web Services accountthat
// would be supported for use on a Snow device. Currently, supported AMIs are
// based on the Amazon Linux-2, Ubuntu 20.04 LTS - Focal, or Ubuntu 22.04 LTS
// - Jammy images, available on the Amazon Web Services Marketplace. Ubuntu
// 16.04 LTS - Xenial (HVM) images are no longer supported in the Market, but
// still supported for use on devices through Amazon EC2 VM Import/Export and
// running locally in AMIs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation ListCompatibleImages for usage and error information.
//
// Returned Error Types:
//
//   - InvalidNextTokenException
//     The NextToken string was altered unexpectedly, and the operation has stopped.
//     Run the operation without changing the NextToken string, and try again.
//
//   - Ec2RequestFailedException
//     Your user lacks the necessary Amazon EC2 permissions to perform the attempted
//     action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListCompatibleImages
func (c *Snowball) ListCompatibleImages(input *ListCompatibleImagesInput) (*ListCompatibleImagesOutput, error) {
	req, out := c.ListCompatibleImagesRequest(input)
	return out, req.Send()
}

// ListCompatibleImagesWithContext is the same as ListCompatibleImages with the addition of
// the ability to pass a context and additional request options.
//
// See ListCompatibleImages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) ListCompatibleImagesWithContext(ctx aws.Context, input *ListCompatibleImagesInput, opts ...request.Option) (*ListCompatibleImagesOutput, error) {
	req, out := c.ListCompatibleImagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCompatibleImagesPages iterates over the pages of a ListCompatibleImages operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCompatibleImages method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCompatibleImages operation.
//	pageNum := 0
//	err := client.ListCompatibleImagesPages(params,
//	    func(page *snowball.ListCompatibleImagesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Snowball) ListCompatibleImagesPages(input *ListCompatibleImagesInput, fn func(*ListCompatibleImagesOutput, bool) bool) error {
	return c.ListCompatibleImagesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCompatibleImagesPagesWithContext same as ListCompatibleImagesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) ListCompatibleImagesPagesWithContext(ctx aws.Context, input *ListCompatibleImagesInput, fn func(*ListCompatibleImagesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCompatibleImagesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCompatibleImagesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCompatibleImagesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListJobs = "ListJobs"

// ListJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListJobs for more information on using the ListJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListJobsRequest method.
//	req, resp := client.ListJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListJobs
func (c *Snowball) ListJobsRequest(input *ListJobsInput) (req *request.Request, output *ListJobsOutput) {
	op := &request.Operation{
		Name:       opListJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListJobsInput{}
	}

	output = &ListJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListJobs API operation for Amazon Import/Export Snowball.
//
// Returns an array of JobListEntry objects of the specified length. Each JobListEntry
// object contains a job's state, a job's ID, and a value that indicates whether
// the job is a job part, in the case of export jobs. Calling this API action
// in one of the US regions will return jobs from the list of all jobs associated
// with this account in all US regions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation ListJobs for usage and error information.
//
// Returned Error Types:
//   - InvalidNextTokenException
//     The NextToken string was altered unexpectedly, and the operation has stopped.
//     Run the operation without changing the NextToken string, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListJobs
func (c *Snowball) ListJobs(input *ListJobsInput) (*ListJobsOutput, error) {
	req, out := c.ListJobsRequest(input)
	return out, req.Send()
}

// ListJobsWithContext is the same as ListJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) ListJobsWithContext(ctx aws.Context, input *ListJobsInput, opts ...request.Option) (*ListJobsOutput, error) {
	req, out := c.ListJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListJobsPages iterates over the pages of a ListJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListJobs operation.
//	pageNum := 0
//	err := client.ListJobsPages(params,
//	    func(page *snowball.ListJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Snowball) ListJobsPages(input *ListJobsInput, fn func(*ListJobsOutput, bool) bool) error {
	return c.ListJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListJobsPagesWithContext same as ListJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) ListJobsPagesWithContext(ctx aws.Context, input *ListJobsInput, fn func(*ListJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListLongTermPricing = "ListLongTermPricing"

// ListLongTermPricingRequest generates a "aws/request.Request" representing the
// client's request for the ListLongTermPricing operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLongTermPricing for more information on using the ListLongTermPricing
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListLongTermPricingRequest method.
//	req, resp := client.ListLongTermPricingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListLongTermPricing
func (c *Snowball) ListLongTermPricingRequest(input *ListLongTermPricingInput) (req *request.Request, output *ListLongTermPricingOutput) {
	op := &request.Operation{
		Name:       opListLongTermPricing,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLongTermPricingInput{}
	}

	output = &ListLongTermPricingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLongTermPricing API operation for Amazon Import/Export Snowball.
//
// Lists all long-term pricing types.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation ListLongTermPricing for usage and error information.
//
// Returned Error Types:
//
//   - InvalidResourceException
//     The specified resource can't be found. Check the information you provided
//     in your last request, and try again.
//
//   - InvalidNextTokenException
//     The NextToken string was altered unexpectedly, and the operation has stopped.
//     Run the operation without changing the NextToken string, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListLongTermPricing
func (c *Snowball) ListLongTermPricing(input *ListLongTermPricingInput) (*ListLongTermPricingOutput, error) {
	req, out := c.ListLongTermPricingRequest(input)
	return out, req.Send()
}

// ListLongTermPricingWithContext is the same as ListLongTermPricing with the addition of
// the ability to pass a context and additional request options.
//
// See ListLongTermPricing for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) ListLongTermPricingWithContext(ctx aws.Context, input *ListLongTermPricingInput, opts ...request.Option) (*ListLongTermPricingOutput, error) {
	req, out := c.ListLongTermPricingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLongTermPricingPages iterates over the pages of a ListLongTermPricing operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLongTermPricing method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListLongTermPricing operation.
//	pageNum := 0
//	err := client.ListLongTermPricingPages(params,
//	    func(page *snowball.ListLongTermPricingOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Snowball) ListLongTermPricingPages(input *ListLongTermPricingInput, fn func(*ListLongTermPricingOutput, bool) bool) error {
	return c.ListLongTermPricingPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLongTermPricingPagesWithContext same as ListLongTermPricingPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) ListLongTermPricingPagesWithContext(ctx aws.Context, input *ListLongTermPricingInput, fn func(*ListLongTermPricingOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLongTermPricingInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLongTermPricingRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLongTermPricingOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPickupLocations = "ListPickupLocations"

// ListPickupLocationsRequest generates a "aws/request.Request" representing the
// client's request for the ListPickupLocations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPickupLocations for more information on using the ListPickupLocations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPickupLocationsRequest method.
//	req, resp := client.ListPickupLocationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListPickupLocations
func (c *Snowball) ListPickupLocationsRequest(input *ListPickupLocationsInput) (req *request.Request, output *ListPickupLocationsOutput) {
	op := &request.Operation{
		Name:       opListPickupLocations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPickupLocationsInput{}
	}

	output = &ListPickupLocationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPickupLocations API operation for Amazon Import/Export Snowball.
//
// A list of locations from which the customer can choose to pickup a device.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation ListPickupLocations for usage and error information.
//
// Returned Error Types:
//   - InvalidResourceException
//     The specified resource can't be found. Check the information you provided
//     in your last request, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListPickupLocations
func (c *Snowball) ListPickupLocations(input *ListPickupLocationsInput) (*ListPickupLocationsOutput, error) {
	req, out := c.ListPickupLocationsRequest(input)
	return out, req.Send()
}

// ListPickupLocationsWithContext is the same as ListPickupLocations with the addition of
// the ability to pass a context and additional request options.
//
// See ListPickupLocations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) ListPickupLocationsWithContext(ctx aws.Context, input *ListPickupLocationsInput, opts ...request.Option) (*ListPickupLocationsOutput, error) {
	req, out := c.ListPickupLocationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPickupLocationsPages iterates over the pages of a ListPickupLocations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPickupLocations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPickupLocations operation.
//	pageNum := 0
//	err := client.ListPickupLocationsPages(params,
//	    func(page *snowball.ListPickupLocationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Snowball) ListPickupLocationsPages(input *ListPickupLocationsInput, fn func(*ListPickupLocationsOutput, bool) bool) error {
	return c.ListPickupLocationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPickupLocationsPagesWithContext same as ListPickupLocationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) ListPickupLocationsPagesWithContext(ctx aws.Context, input *ListPickupLocationsInput, fn func(*ListPickupLocationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPickupLocationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPickupLocationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPickupLocationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListServiceVersions = "ListServiceVersions"

// ListServiceVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListServiceVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListServiceVersions for more information on using the ListServiceVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListServiceVersionsRequest method.
//	req, resp := client.ListServiceVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListServiceVersions
func (c *Snowball) ListServiceVersionsRequest(input *ListServiceVersionsInput) (req *request.Request, output *ListServiceVersionsOutput) {
	op := &request.Operation{
		Name:       opListServiceVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListServiceVersionsInput{}
	}

	output = &ListServiceVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListServiceVersions API operation for Amazon Import/Export Snowball.
//
// Lists all supported versions for Snow on-device services. Returns an array
// of ServiceVersion object containing the supported versions for a particular
// service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation ListServiceVersions for usage and error information.
//
// Returned Error Types:
//
//   - InvalidNextTokenException
//     The NextToken string was altered unexpectedly, and the operation has stopped.
//     Run the operation without changing the NextToken string, and try again.
//
//   - InvalidResourceException
//     The specified resource can't be found. Check the information you provided
//     in your last request, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListServiceVersions
func (c *Snowball) ListServiceVersions(input *ListServiceVersionsInput) (*ListServiceVersionsOutput, error) {
	req, out := c.ListServiceVersionsRequest(input)
	return out, req.Send()
}

// ListServiceVersionsWithContext is the same as ListServiceVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListServiceVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) ListServiceVersionsWithContext(ctx aws.Context, input *ListServiceVersionsInput, opts ...request.Option) (*ListServiceVersionsOutput, error) {
	req, out := c.ListServiceVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCluster = "UpdateCluster"

// UpdateClusterRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCluster for more information on using the UpdateCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateClusterRequest method.
//	req, resp := client.UpdateClusterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/UpdateCluster
func (c *Snowball) UpdateClusterRequest(input *UpdateClusterInput) (req *request.Request, output *UpdateClusterOutput) {
	op := &request.Operation{
		Name:       opUpdateCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateClusterInput{}
	}

	output = &UpdateClusterOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateCluster API operation for Amazon Import/Export Snowball.
//
// While a cluster's ClusterState value is in the AwaitingQuorum state, you
// can update some of the information associated with a cluster. Once the cluster
// changes to a different job state, usually 60 minutes after the cluster being
// created, this action is no longer available.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation UpdateCluster for usage and error information.
//
// Returned Error Types:
//
//   - InvalidResourceException
//     The specified resource can't be found. Check the information you provided
//     in your last request, and try again.
//
//   - InvalidJobStateException
//     The action can't be performed because the job's current state doesn't allow
//     that action to be performed.
//
//   - KMSRequestFailedException
//     The provided Key Management Service key lacks the permissions to perform
//     the specified CreateJob or UpdateJob action.
//
//   - InvalidInputCombinationException
//     Job or cluster creation failed. One or more inputs were invalid. Confirm
//     that the CreateClusterRequest$SnowballType value supports your CreateJobRequest$JobType,
//     and try again.
//
//   - Ec2RequestFailedException
//     Your user lacks the necessary Amazon EC2 permissions to perform the attempted
//     action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/UpdateCluster
func (c *Snowball) UpdateCluster(input *UpdateClusterInput) (*UpdateClusterOutput, error) {
	req, out := c.UpdateClusterRequest(input)
	return out, req.Send()
}

// UpdateClusterWithContext is the same as UpdateCluster with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) UpdateClusterWithContext(ctx aws.Context, input *UpdateClusterInput, opts ...request.Option) (*UpdateClusterOutput, error) {
	req, out := c.UpdateClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateJob = "UpdateJob"

// UpdateJobRequest generates a "aws/request.Request" representing the
// client's request for the UpdateJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateJob for more information on using the UpdateJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateJobRequest method.
//	req, resp := client.UpdateJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/UpdateJob
func (c *Snowball) UpdateJobRequest(input *UpdateJobInput) (req *request.Request, output *UpdateJobOutput) {
	op := &request.Operation{
		Name:       opUpdateJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateJobInput{}
	}

	output = &UpdateJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateJob API operation for Amazon Import/Export Snowball.
//
// While a job's JobState value is New, you can update some of the information
// associated with a job. Once the job changes to a different job state, usually
// within 60 minutes of the job being created, this action is no longer available.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation UpdateJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidResourceException
//     The specified resource can't be found. Check the information you provided
//     in your last request, and try again.
//
//   - InvalidJobStateException
//     The action can't be performed because the job's current state doesn't allow
//     that action to be performed.
//
//   - KMSRequestFailedException
//     The provided Key Management Service key lacks the permissions to perform
//     the specified CreateJob or UpdateJob action.
//
//   - InvalidInputCombinationException
//     Job or cluster creation failed. One or more inputs were invalid. Confirm
//     that the CreateClusterRequest$SnowballType value supports your CreateJobRequest$JobType,
//     and try again.
//
//   - ClusterLimitExceededException
//     Job creation failed. Currently, clusters support five nodes. If you have
//     fewer than five nodes for your cluster and you have more nodes to create
//     for this cluster, try again and create jobs until your cluster has exactly
//     five nodes.
//
//   - Ec2RequestFailedException
//     Your user lacks the necessary Amazon EC2 permissions to perform the attempted
//     action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/UpdateJob
func (c *Snowball) UpdateJob(input *UpdateJobInput) (*UpdateJobOutput, error) {
	req, out := c.UpdateJobRequest(input)
	return out, req.Send()
}

// UpdateJobWithContext is the same as UpdateJob with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) UpdateJobWithContext(ctx aws.Context, input *UpdateJobInput, opts ...request.Option) (*UpdateJobOutput, error) {
	req, out := c.UpdateJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateJobShipmentState = "UpdateJobShipmentState"

// UpdateJobShipmentStateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateJobShipmentState operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateJobShipmentState for more information on using the UpdateJobShipmentState
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateJobShipmentStateRequest method.
//	req, resp := client.UpdateJobShipmentStateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/UpdateJobShipmentState
func (c *Snowball) UpdateJobShipmentStateRequest(input *UpdateJobShipmentStateInput) (req *request.Request, output *UpdateJobShipmentStateOutput) {
	op := &request.Operation{
		Name:       opUpdateJobShipmentState,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateJobShipmentStateInput{}
	}

	output = &UpdateJobShipmentStateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateJobShipmentState API operation for Amazon Import/Export Snowball.
//
// Updates the state when a shipment state changes to a different state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation UpdateJobShipmentState for usage and error information.
//
// Returned Error Types:
//
//   - InvalidResourceException
//     The specified resource can't be found. Check the information you provided
//     in your last request, and try again.
//
//   - InvalidJobStateException
//     The action can't be performed because the job's current state doesn't allow
//     that action to be performed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/UpdateJobShipmentState
func (c *Snowball) UpdateJobShipmentState(input *UpdateJobShipmentStateInput) (*UpdateJobShipmentStateOutput, error) {
	req, out := c.UpdateJobShipmentStateRequest(input)
	return out, req.Send()
}

// UpdateJobShipmentStateWithContext is the same as UpdateJobShipmentState with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateJobShipmentState for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) UpdateJobShipmentStateWithContext(ctx aws.Context, input *UpdateJobShipmentStateInput, opts ...request.Option) (*UpdateJobShipmentStateOutput, error) {
	req, out := c.UpdateJobShipmentStateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateLongTermPricing = "UpdateLongTermPricing"

// UpdateLongTermPricingRequest generates a "aws/request.Request" representing the
// client's request for the UpdateLongTermPricing operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateLongTermPricing for more information on using the UpdateLongTermPricing
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateLongTermPricingRequest method.
//	req, resp := client.UpdateLongTermPricingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/UpdateLongTermPricing
func (c *Snowball) UpdateLongTermPricingRequest(input *UpdateLongTermPricingInput) (req *request.Request, output *UpdateLongTermPricingOutput) {
	op := &request.Operation{
		Name:       opUpdateLongTermPricing,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateLongTermPricingInput{}
	}

	output = &UpdateLongTermPricingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateLongTermPricing API operation for Amazon Import/Export Snowball.
//
// Updates the long-term pricing type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation UpdateLongTermPricing for usage and error information.
//
// Returned Error Types:
//   - InvalidResourceException
//     The specified resource can't be found. Check the information you provided
//     in your last request, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/UpdateLongTermPricing
func (c *Snowball) UpdateLongTermPricing(input *UpdateLongTermPricingInput) (*UpdateLongTermPricingOutput, error) {
	req, out := c.UpdateLongTermPricingRequest(input)
	return out, req.Send()
}

// UpdateLongTermPricingWithContext is the same as UpdateLongTermPricing with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateLongTermPricing for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) UpdateLongTermPricingWithContext(ctx aws.Context, input *UpdateLongTermPricingInput, opts ...request.Option) (*UpdateLongTermPricingOutput, error) {
	req, out := c.UpdateLongTermPricingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The address that you want the Snow device(s) associated with a specific job
// to be shipped to. Addresses are validated at the time of creation. The address
// you provide must be located within the serviceable area of your region. Although
// no individual elements of the Address are required, if the address is invalid
// or unsupported, then an exception is thrown.
type Address struct {
	_ struct{} `type:"structure"`

	// The unique ID for an address.
	AddressId *string `min:"40" type:"string"`

	// The city in an address that a Snow device is to be delivered to.
	City *string `min:"1" type:"string"`

	// The name of the company to receive a Snow device at an address.
	Company *string `min:"1" type:"string"`

	// The country in an address that a Snow device is to be delivered to.
	Country *string `min:"1" type:"string"`

	// If the address you are creating is a primary address, then set this option
	// to true. This field is not supported in most regions.
	IsRestricted *bool `type:"boolean"`

	// This field is no longer used and the value is ignored.
	Landmark *string `min:"1" type:"string"`

	// The name of a person to receive a Snow device at an address.
	Name *string `min:"1" type:"string"`

	// The phone number associated with an address that a Snow device is to be delivered
	// to.
	PhoneNumber *string `min:"1" type:"string"`

	// The postal code in an address that a Snow device is to be delivered to.
	PostalCode *string `min:"1" type:"string"`

	// This field is no longer used and the value is ignored.
	PrefectureOrDistrict *string `min:"1" type:"string"`

	// The state or province in an address that a Snow device is to be delivered
	// to.
	StateOrProvince *string `min:"1" type:"string"`

	// The first line in a street address that a Snow device is to be delivered
	// to.
	Street1 *string `min:"1" type:"string"`

	// The second line in a street address that a Snow device is to be delivered
	// to.
	Street2 *string `min:"1" type:"string"`

	// The third line in a street address that a Snow device is to be delivered
	// to.
	Street3 *string `min:"1" type:"string"`

	// Differentiates between delivery address and pickup address in the customer
	// account. Provided at job creation.
	Type *string `type:"string" enum:"AddressType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Address) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Address) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Address) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Address"}
	if s.AddressId != nil && len(*s.AddressId) < 40 {
		invalidParams.Add(request.NewErrParamMinLen("AddressId", 40))
	}
	if s.City != nil && len(*s.City) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("City", 1))
	}
	if s.Company != nil && len(*s.Company) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Company", 1))
	}
	if s.Country != nil && len(*s.Country) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Country", 1))
	}
	if s.Landmark != nil && len(*s.Landmark) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Landmark", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.PhoneNumber != nil && len(*s.PhoneNumber) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PhoneNumber", 1))
	}
	if s.PostalCode != nil && len(*s.PostalCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PostalCode", 1))
	}
	if s.PrefectureOrDistrict != nil && len(*s.PrefectureOrDistrict) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrefectureOrDistrict", 1))
	}
	if s.StateOrProvince != nil && len(*s.StateOrProvince) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StateOrProvince", 1))
	}
	if s.Street1 != nil && len(*s.Street1) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Street1", 1))
	}
	if s.Street2 != nil && len(*s.Street2) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Street2", 1))
	}
	if s.Street3 != nil && len(*s.Street3) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Street3", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddressId sets the AddressId field's value.
func (s *Address) SetAddressId(v string) *Address {
	s.AddressId = &v
	return s
}

// SetCity sets the City field's value.
func (s *Address) SetCity(v string) *Address {
	s.City = &v
	return s
}

// SetCompany sets the Company field's value.
func (s *Address) SetCompany(v string) *Address {
	s.Company = &v
	return s
}

// SetCountry sets the Country field's value.
func (s *Address) SetCountry(v string) *Address {
	s.Country = &v
	return s
}

// SetIsRestricted sets the IsRestricted field's value.
func (s *Address) SetIsRestricted(v bool) *Address {
	s.IsRestricted = &v
	return s
}

// SetLandmark sets the Landmark field's value.
func (s *Address) SetLandmark(v string) *Address {
	s.Landmark = &v
	return s
}

// SetName sets the Name field's value.
func (s *Address) SetName(v string) *Address {
	s.Name = &v
	return s
}

// SetPhoneNumber sets the PhoneNumber field's value.
func (s *Address) SetPhoneNumber(v string) *Address {
	s.PhoneNumber = &v
	return s
}

// SetPostalCode sets the PostalCode field's value.
func (s *Address) SetPostalCode(v string) *Address {
	s.PostalCode = &v
	return s
}

// SetPrefectureOrDistrict sets the PrefectureOrDistrict field's value.
func (s *Address) SetPrefectureOrDistrict(v string) *Address {
	s.PrefectureOrDistrict = &v
	return s
}

// SetStateOrProvince sets the StateOrProvince field's value.
func (s *Address) SetStateOrProvince(v string) *Address {
	s.StateOrProvince = &v
	return s
}

// SetStreet1 sets the Street1 field's value.
func (s *Address) SetStreet1(v string) *Address {
	s.Street1 = &v
	return s
}

// SetStreet2 sets the Street2 field's value.
func (s *Address) SetStreet2(v string) *Address {
	s.Street2 = &v
	return s
}

// SetStreet3 sets the Street3 field's value.
func (s *Address) SetStreet3(v string) *Address {
	s.Street3 = &v
	return s
}

// SetType sets the Type field's value.
func (s *Address) SetType(v string) *Address {
	s.Type = &v
	return s
}

type CancelClusterInput struct {
	_ struct{} `type:"structure"`

	// The 39-character ID for the cluster that you want to cancel, for example
	// CID123e4567-e89b-12d3-a456-426655440000.
	//
	// ClusterId is a required field
	ClusterId *string `min:"39" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelClusterInput"}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}
	if s.ClusterId != nil && len(*s.ClusterId) < 39 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterId", 39))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterId sets the ClusterId field's value.
func (s *CancelClusterInput) SetClusterId(v string) *CancelClusterInput {
	s.ClusterId = &v
	return s
}

type CancelClusterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelClusterOutput) GoString() string {
	return s.String()
}

type CancelJobInput struct {
	_ struct{} `type:"structure"`

	// The 39-character job ID for the job that you want to cancel, for example
	// JID123e4567-e89b-12d3-a456-426655440000.
	//
	// JobId is a required field
	JobId *string `min:"39" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 39 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 39))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *CancelJobInput) SetJobId(v string) *CancelJobInput {
	s.JobId = &v
	return s
}

type CancelJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelJobOutput) GoString() string {
	return s.String()
}

// Job creation failed. Currently, clusters support five nodes. If you have
// fewer than five nodes for your cluster and you have more nodes to create
// for this cluster, try again and create jobs until your cluster has exactly
// five nodes.
type ClusterLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterLimitExceededException) GoString() string {
	return s.String()
}

func newErrorClusterLimitExceededException(v protocol.ResponseMetadata) error {
	return &ClusterLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ClusterLimitExceededException) Code() string {
	return "ClusterLimitExceededException"
}

// Message returns the exception's message.
func (s *ClusterLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ClusterLimitExceededException) OrigErr() error {
	return nil
}

func (s *ClusterLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ClusterLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ClusterLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains a cluster's state, a cluster's ID, and other important information.
type ClusterListEntry struct {
	_ struct{} `type:"structure"`

	// The 39-character ID for the cluster that you want to list, for example CID123e4567-e89b-12d3-a456-426655440000.
	ClusterId *string `min:"1" type:"string"`

	// The current state of this cluster. For information about the state of a specific
	// node, see JobListEntry$JobState.
	ClusterState *string `type:"string" enum:"ClusterState"`

	// The creation date for this cluster.
	CreationDate *time.Time `type:"timestamp"`

	// Defines an optional description of the cluster, for example Environmental
	// Data Cluster-01.
	Description *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterListEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterListEntry) GoString() string {
	return s.String()
}

// SetClusterId sets the ClusterId field's value.
func (s *ClusterListEntry) SetClusterId(v string) *ClusterListEntry {
	s.ClusterId = &v
	return s
}

// SetClusterState sets the ClusterState field's value.
func (s *ClusterListEntry) SetClusterState(v string) *ClusterListEntry {
	s.ClusterState = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *ClusterListEntry) SetCreationDate(v time.Time) *ClusterListEntry {
	s.CreationDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ClusterListEntry) SetDescription(v string) *ClusterListEntry {
	s.Description = &v
	return s
}

// Contains metadata about a specific cluster.
type ClusterMetadata struct {
	_ struct{} `type:"structure"`

	// The automatically generated ID for a specific address.
	AddressId *string `min:"40" type:"string"`

	// The automatically generated ID for a cluster.
	ClusterId *string `min:"1" type:"string"`

	// The current status of the cluster.
	ClusterState *string `type:"string" enum:"ClusterState"`

	// The creation date for this cluster.
	CreationDate *time.Time `type:"timestamp"`

	// The optional description of the cluster.
	Description *string `min:"1" type:"string"`

	// The ID of the address that you want a cluster shipped to, after it will be
	// shipped to its primary address. This field is not supported in most regions.
	ForwardingAddressId *string `min:"40" type:"string"`

	// The type of job for this cluster. Currently, the only job type supported
	// for clusters is LOCAL_USE.
	JobType *string `type:"string" enum:"JobType"`

	// The KmsKeyARN Amazon Resource Name (ARN) associated with this cluster. This
	// ARN was created using the CreateKey (https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html)
	// API action in Key Management Service (KMS.
	KmsKeyARN *string `type:"string"`

	// The Amazon Simple Notification Service (Amazon SNS) notification settings
	// for this cluster.
	Notification *Notification `type:"structure"`

	// Represents metadata and configuration settings for services on an Amazon
	// Web Services Snow Family device.
	OnDeviceServiceConfiguration *OnDeviceServiceConfiguration `type:"structure"`

	// The arrays of JobResource objects that can include updated S3Resource objects
	// or LambdaResource objects.
	Resources *JobResource `type:"structure"`

	// The role ARN associated with this cluster. This ARN was created using the
	// CreateRole (https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html)
	// API action in Identity and Access Management (IAM).
	RoleARN *string `type:"string"`

	// The shipping speed for each node in this cluster. This speed doesn't dictate
	// how soon you'll get each device, rather it represents how quickly each device
	// moves to its destination while in transit. Regional shipping speeds are as
	// follows:
	//
	//    * In Australia, you have access to express shipping. Typically, devices
	//    shipped express are delivered in about a day.
	//
	//    * In the European Union (EU), you have access to express shipping. Typically,
	//    Snow devices shipped express are delivered in about a day. In addition,
	//    most countries in the EU have access to standard shipping, which typically
	//    takes less than a week, one way.
	//
	//    * In India, Snow devices are delivered in one to seven days.
	//
	//    * In the US, you have access to one-day shipping and two-day shipping.
	ShippingOption *string `type:"string" enum:"ShippingOption"`

	// The type of Snowcone device to use for this cluster.
	//
	// For cluster jobs, Amazon Web Services Snow Family currently supports only
	// the EDGE device type.
	SnowballType *string `type:"string" enum:"Type"`

	// The tax documents required in your Amazon Web Services Region.
	TaxDocuments *TaxDocuments `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterMetadata) GoString() string {
	return s.String()
}

// SetAddressId sets the AddressId field's value.
func (s *ClusterMetadata) SetAddressId(v string) *ClusterMetadata {
	s.AddressId = &v
	return s
}

// SetClusterId sets the ClusterId field's value.
func (s *ClusterMetadata) SetClusterId(v string) *ClusterMetadata {
	s.ClusterId = &v
	return s
}

// SetClusterState sets the ClusterState field's value.
func (s *ClusterMetadata) SetClusterState(v string) *ClusterMetadata {
	s.ClusterState = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *ClusterMetadata) SetCreationDate(v time.Time) *ClusterMetadata {
	s.CreationDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ClusterMetadata) SetDescription(v string) *ClusterMetadata {
	s.Description = &v
	return s
}

// SetForwardingAddressId sets the ForwardingAddressId field's value.
func (s *ClusterMetadata) SetForwardingAddressId(v string) *ClusterMetadata {
	s.ForwardingAddressId = &v
	return s
}

// SetJobType sets the JobType field's value.
func (s *ClusterMetadata) SetJobType(v string) *ClusterMetadata {
	s.JobType = &v
	return s
}

// SetKmsKeyARN sets the KmsKeyARN field's value.
func (s *ClusterMetadata) SetKmsKeyARN(v string) *ClusterMetadata {
	s.KmsKeyARN = &v
	return s
}

// SetNotification sets the Notification field's value.
func (s *ClusterMetadata) SetNotification(v *Notification) *ClusterMetadata {
	s.Notification = v
	return s
}

// SetOnDeviceServiceConfiguration sets the OnDeviceServiceConfiguration field's value.
func (s *ClusterMetadata) SetOnDeviceServiceConfiguration(v *OnDeviceServiceConfiguration) *ClusterMetadata {
	s.OnDeviceServiceConfiguration = v
	return s
}

// SetResources sets the Resources field's value.
func (s *ClusterMetadata) SetResources(v *JobResource) *ClusterMetadata {
	s.Resources = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *ClusterMetadata) SetRoleARN(v string) *ClusterMetadata {
	s.RoleARN = &v
	return s
}

// SetShippingOption sets the ShippingOption field's value.
func (s *ClusterMetadata) SetShippingOption(v string) *ClusterMetadata {
	s.ShippingOption = &v
	return s
}

// SetSnowballType sets the SnowballType field's value.
func (s *ClusterMetadata) SetSnowballType(v string) *ClusterMetadata {
	s.SnowballType = &v
	return s
}

// SetTaxDocuments sets the TaxDocuments field's value.
func (s *ClusterMetadata) SetTaxDocuments(v *TaxDocuments) *ClusterMetadata {
	s.TaxDocuments = v
	return s
}

// A JSON-formatted object that describes a compatible Amazon Machine Image
// (AMI), including the ID and name for a Snow device AMI. This AMI is compatible
// with the device's physical hardware requirements, and it should be able to
// be run in an SBE1 instance on the device.
type CompatibleImage struct {
	_ struct{} `type:"structure"`

	// The unique identifier for an individual Snow device AMI.
	AmiId *string `min:"1" type:"string"`

	// The optional name of a compatible image.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompatibleImage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompatibleImage) GoString() string {
	return s.String()
}

// SetAmiId sets the AmiId field's value.
func (s *CompatibleImage) SetAmiId(v string) *CompatibleImage {
	s.AmiId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CompatibleImage) SetName(v string) *CompatibleImage {
	s.Name = &v
	return s
}

// You get this exception when you call CreateReturnShippingLabel more than
// once when other requests are not completed.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// You get this resource when you call CreateReturnShippingLabel more than once
	// when other requests are not completed. .
	ConflictResource *string `min:"1" type:"string"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateAddressInput struct {
	_ struct{} `type:"structure"`

	// The address that you want the Snow device shipped to.
	//
	// Address is a required field
	Address *Address `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAddressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAddressInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAddressInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAddressInput"}
	if s.Address == nil {
		invalidParams.Add(request.NewErrParamRequired("Address"))
	}
	if s.Address != nil {
		if err := s.Address.Validate(); err != nil {
			invalidParams.AddNested("Address", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddress sets the Address field's value.
func (s *CreateAddressInput) SetAddress(v *Address) *CreateAddressInput {
	s.Address = v
	return s
}

type CreateAddressOutput struct {
	_ struct{} `type:"structure"`

	// The automatically generated ID for a specific address. You'll use this ID
	// when you create a job to specify which address you want the Snow device for
	// that job shipped to.
	AddressId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAddressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAddressOutput) GoString() string {
	return s.String()
}

// SetAddressId sets the AddressId field's value.
func (s *CreateAddressOutput) SetAddressId(v string) *CreateAddressOutput {
	s.AddressId = &v
	return s
}

type CreateClusterInput struct {
	_ struct{} `type:"structure"`

	// The ID for the address that you want the cluster shipped to.
	//
	// AddressId is a required field
	AddressId *string `min:"40" type:"string" required:"true"`

	// An optional description of this specific cluster, for example Environmental
	// Data Cluster-01.
	Description *string `min:"1" type:"string"`

	// Force to create cluster when user attempts to overprovision or underprovision
	// a cluster. A cluster is overprovisioned or underprovisioned if the initial
	// size of the cluster is more (overprovisioned) or less (underprovisioned)
	// than what needed to meet capacity requirement specified with OnDeviceServiceConfiguration.
	ForceCreateJobs *bool `type:"boolean"`

	// The forwarding address ID for a cluster. This field is not supported in most
	// regions.
	ForwardingAddressId *string `min:"40" type:"string"`

	// If provided, each job will be automatically created and associated with the
	// new cluster. If not provided, will be treated as 0.
	InitialClusterSize *int64 `type:"integer"`

	// The type of job for this cluster. Currently, the only job type supported
	// for clusters is LOCAL_USE.
	//
	// For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html"
	// (Snow Family Devices and Capacity) in the Snowcone User Guide or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html"
	// (Snow Family Devices and Capacity) in the Snowcone User Guide.
	//
	// JobType is a required field
	JobType *string `type:"string" required:"true" enum:"JobType"`

	// The KmsKeyARN value that you want to associate with this cluster. KmsKeyARN
	// values are created by using the CreateKey (https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html)
	// API action in Key Management Service (KMS).
	KmsKeyARN *string `type:"string"`

	// Lists long-term pricing id that will be used to associate with jobs automatically
	// created for the new cluster.
	LongTermPricingIds []*string `type:"list"`

	// The Amazon Simple Notification Service (Amazon SNS) notification settings
	// for this cluster.
	Notification *Notification `type:"structure"`

	// Specifies the service or services on the Snow Family device that your transferred
	// data will be exported from or imported into. Amazon Web Services Snow Family
	// device clusters support Amazon S3 and NFS (Network File System).
	OnDeviceServiceConfiguration *OnDeviceServiceConfiguration `type:"structure"`

	// Allows you to securely operate and manage Snow devices in a cluster remotely
	// from outside of your internal network. When set to INSTALLED_AUTOSTART, remote
	// management will automatically be available when the device arrives at your
	// location. Otherwise, you need to use the Snowball Client to manage the device.
	RemoteManagement *string `type:"string" enum:"RemoteManagement"`

	// The resources associated with the cluster job. These resources include Amazon
	// S3 buckets and optional Lambda functions written in the Python language.
	Resources *JobResource `type:"structure"`

	// The RoleARN that you want to associate with this cluster. RoleArn values
	// are created by using the CreateRole (https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html)
	// API action in Identity and Access Management (IAM).
	RoleARN *string `type:"string"`

	// The shipping speed for each node in this cluster. This speed doesn't dictate
	// how soon you'll get each Snowball Edge device, rather it represents how quickly
	// each device moves to its destination while in transit. Regional shipping
	// speeds are as follows:
	//
	//    * In Australia, you have access to express shipping. Typically, Snow devices
	//    shipped express are delivered in about a day.
	//
	//    * In the European Union (EU), you have access to express shipping. Typically,
	//    Snow devices shipped express are delivered in about a day. In addition,
	//    most countries in the EU have access to standard shipping, which typically
	//    takes less than a week, one way.
	//
	//    * In India, Snow devices are delivered in one to seven days.
	//
	//    * In the United States of America (US), you have access to one-day shipping
	//    and two-day shipping.
	//
	//    * In Australia, you have access to express shipping. Typically, devices
	//    shipped express are delivered in about a day.
	//
	//    * In the European Union (EU), you have access to express shipping. Typically,
	//    Snow devices shipped express are delivered in about a day. In addition,
	//    most countries in the EU have access to standard shipping, which typically
	//    takes less than a week, one way.
	//
	//    * In India, Snow devices are delivered in one to seven days.
	//
	//    * In the US, you have access to one-day shipping and two-day shipping.
	//
	// ShippingOption is a required field
	ShippingOption *string `type:"string" required:"true" enum:"ShippingOption"`

	// If your job is being created in one of the US regions, you have the option
	// of specifying what size Snow device you'd like for this job. In all other
	// regions, Snowballs come with 80 TB in storage capacity.
	//
	// For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html"
	// (Snow Family Devices and Capacity) in the Snowcone User Guide or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html"
	// (Snow Family Devices and Capacity) in the Snowcone User Guide.
	SnowballCapacityPreference *string `type:"string" enum:"Capacity"`

	// The type of Snow Family devices to use for this cluster.
	//
	// For cluster jobs, Amazon Web Services Snow Family currently supports only
	// the EDGE device type.
	//
	// For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html"
	// (Snow Family Devices and Capacity) in the Snowcone User Guide or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html"
	// (Snow Family Devices and Capacity) in the Snowcone User Guide.
	//
	// SnowballType is a required field
	SnowballType *string `type:"string" required:"true" enum:"Type"`

	// The tax documents required in your Amazon Web Services Region.
	TaxDocuments *TaxDocuments `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateClusterInput"}
	if s.AddressId == nil {
		invalidParams.Add(request.NewErrParamRequired("AddressId"))
	}
	if s.AddressId != nil && len(*s.AddressId) < 40 {
		invalidParams.Add(request.NewErrParamMinLen("AddressId", 40))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.ForwardingAddressId != nil && len(*s.ForwardingAddressId) < 40 {
		invalidParams.Add(request.NewErrParamMinLen("ForwardingAddressId", 40))
	}
	if s.JobType == nil {
		invalidParams.Add(request.NewErrParamRequired("JobType"))
	}
	if s.ShippingOption == nil {
		invalidParams.Add(request.NewErrParamRequired("ShippingOption"))
	}
	if s.SnowballType == nil {
		invalidParams.Add(request.NewErrParamRequired("SnowballType"))
	}
	if s.OnDeviceServiceConfiguration != nil {
		if err := s.OnDeviceServiceConfiguration.Validate(); err != nil {
			invalidParams.AddNested("OnDeviceServiceConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Resources != nil {
		if err := s.Resources.Validate(); err != nil {
			invalidParams.AddNested("Resources", err.(request.ErrInvalidParams))
		}
	}
	if s.TaxDocuments != nil {
		if err := s.TaxDocuments.Validate(); err != nil {
			invalidParams.AddNested("TaxDocuments", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddressId sets the AddressId field's value.
func (s *CreateClusterInput) SetAddressId(v string) *CreateClusterInput {
	s.AddressId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateClusterInput) SetDescription(v string) *CreateClusterInput {
	s.Description = &v
	return s
}

// SetForceCreateJobs sets the ForceCreateJobs field's value.
func (s *CreateClusterInput) SetForceCreateJobs(v bool) *CreateClusterInput {
	s.ForceCreateJobs = &v
	return s
}

// SetForwardingAddressId sets the ForwardingAddressId field's value.
func (s *CreateClusterInput) SetForwardingAddressId(v string) *CreateClusterInput {
	s.ForwardingAddressId = &v
	return s
}

// SetInitialClusterSize sets the InitialClusterSize field's value.
func (s *CreateClusterInput) SetInitialClusterSize(v int64) *CreateClusterInput {
	s.InitialClusterSize = &v
	return s
}

// SetJobType sets the JobType field's value.
func (s *CreateClusterInput) SetJobType(v string) *CreateClusterInput {
	s.JobType = &v
	return s
}

// SetKmsKeyARN sets the KmsKeyARN field's value.
func (s *CreateClusterInput) SetKmsKeyARN(v string) *CreateClusterInput {
	s.KmsKeyARN = &v
	return s
}

// SetLongTermPricingIds sets the LongTermPricingIds field's value.
func (s *CreateClusterInput) SetLongTermPricingIds(v []*string) *CreateClusterInput {
	s.LongTermPricingIds = v
	return s
}

// SetNotification sets the Notification field's value.
func (s *CreateClusterInput) SetNotification(v *Notification) *CreateClusterInput {
	s.Notification = v
	return s
}

// SetOnDeviceServiceConfiguration sets the OnDeviceServiceConfiguration field's value.
func (s *CreateClusterInput) SetOnDeviceServiceConfiguration(v *OnDeviceServiceConfiguration) *CreateClusterInput {
	s.OnDeviceServiceConfiguration = v
	return s
}

// SetRemoteManagement sets the RemoteManagement field's value.
func (s *CreateClusterInput) SetRemoteManagement(v string) *CreateClusterInput {
	s.RemoteManagement = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *CreateClusterInput) SetResources(v *JobResource) *CreateClusterInput {
	s.Resources = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *CreateClusterInput) SetRoleARN(v string) *CreateClusterInput {
	s.RoleARN = &v
	return s
}

// SetShippingOption sets the ShippingOption field's value.
func (s *CreateClusterInput) SetShippingOption(v string) *CreateClusterInput {
	s.ShippingOption = &v
	return s
}

// SetSnowballCapacityPreference sets the SnowballCapacityPreference field's value.
func (s *CreateClusterInput) SetSnowballCapacityPreference(v string) *CreateClusterInput {
	s.SnowballCapacityPreference = &v
	return s
}

// SetSnowballType sets the SnowballType field's value.
func (s *CreateClusterInput) SetSnowballType(v string) *CreateClusterInput {
	s.SnowballType = &v
	return s
}

// SetTaxDocuments sets the TaxDocuments field's value.
func (s *CreateClusterInput) SetTaxDocuments(v *TaxDocuments) *CreateClusterInput {
	s.TaxDocuments = v
	return s
}

type CreateClusterOutput struct {
	_ struct{} `type:"structure"`

	// The automatically generated ID for a cluster.
	ClusterId *string `min:"39" type:"string"`

	// List of jobs created for this cluster. For syntax, see ListJobsResult$JobListEntries
	// (http://amazonaws.com/snowball/latest/api-reference/API_ListJobs.html#API_ListJobs_ResponseSyntax)
	// in this guide.
	JobListEntries []*JobListEntry `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterOutput) GoString() string {
	return s.String()
}

// SetClusterId sets the ClusterId field's value.
func (s *CreateClusterOutput) SetClusterId(v string) *CreateClusterOutput {
	s.ClusterId = &v
	return s
}

// SetJobListEntries sets the JobListEntries field's value.
func (s *CreateClusterOutput) SetJobListEntries(v []*JobListEntry) *CreateClusterOutput {
	s.JobListEntries = v
	return s
}

type CreateJobInput struct {
	_ struct{} `type:"structure"`

	// The ID for the address that you want the Snow device shipped to.
	AddressId *string `min:"40" type:"string"`

	// The ID of a cluster. If you're creating a job for a node in a cluster, you
	// need to provide only this clusterId value. The other job attributes are inherited
	// from the cluster.
	ClusterId *string `min:"39" type:"string"`

	// Defines an optional description of this specific job, for example Important
	// Photos 2016-08-11.
	Description *string `min:"1" type:"string"`

	// Defines the device configuration for an Snowcone job.
	//
	// For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html"
	// (Snow Family Devices and Capacity) in the Snowcone User Guide or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html"
	// (Snow Family Devices and Capacity) in the Snowcone User Guide.
	DeviceConfiguration *DeviceConfiguration `type:"structure"`

	// The forwarding address ID for a job. This field is not supported in most
	// Regions.
	ForwardingAddressId *string `min:"40" type:"string"`

	// The highest impact level of data that will be stored or processed on the
	// device, provided at job creation.
	ImpactLevel *string `type:"string" enum:"ImpactLevel"`

	// Defines the type of job that you're creating.
	JobType *string `type:"string" enum:"JobType"`

	// The KmsKeyARN that you want to associate with this job. KmsKeyARNs are created
	// using the CreateKey (https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html)
	// Key Management Service (KMS) API action.
	KmsKeyARN *string `type:"string"`

	// The ID of the long-term pricing type for the device.
	LongTermPricingId *string `min:"41" type:"string"`

	// Defines the Amazon Simple Notification Service (Amazon SNS) notification
	// settings for this job.
	Notification *Notification `type:"structure"`

	// Specifies the service or services on the Snow Family device that your transferred
	// data will be exported from or imported into. Amazon Web Services Snow Family
	// supports Amazon S3 and NFS (Network File System) and the Amazon Web Services
	// Storage Gateway service Tape Gateway type.
	OnDeviceServiceConfiguration *OnDeviceServiceConfiguration `type:"structure"`

	// Information identifying the person picking up the device.
	PickupDetails *PickupDetails `type:"structure"`

	// Allows you to securely operate and manage Snowcone devices remotely from
	// outside of your internal network. When set to INSTALLED_AUTOSTART, remote
	// management will automatically be available when the device arrives at your
	// location. Otherwise, you need to use the Snowball Edge client to manage the
	// device. When set to NOT_INSTALLED, remote management will not be available
	// on the device.
	RemoteManagement *string `type:"string" enum:"RemoteManagement"`

	// Defines the Amazon S3 buckets associated with this job.
	//
	// With IMPORT jobs, you specify the bucket or buckets that your transferred
	// data will be imported into.
	//
	// With EXPORT jobs, you specify the bucket or buckets that your transferred
	// data will be exported from. Optionally, you can also specify a KeyRange value.
	// If you choose to export a range, you define the length of the range by providing
	// either an inclusive BeginMarker value, an inclusive EndMarker value, or both.
	// Ranges are UTF-8 binary sorted.
	Resources *JobResource `type:"structure"`

	// The RoleARN that you want to associate with this job. RoleArns are created
	// using the CreateRole (https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html)
	// Identity and Access Management (IAM) API action.
	RoleARN *string `type:"string"`

	// The shipping speed for this job. This speed doesn't dictate how soon you'll
	// get the Snow device, rather it represents how quickly the Snow device moves
	// to its destination while in transit. Regional shipping speeds are as follows:
	//
	//    * In Australia, you have access to express shipping. Typically, Snow devices
	//    shipped express are delivered in about a day.
	//
	//    * In the European Union (EU), you have access to express shipping. Typically,
	//    Snow devices shipped express are delivered in about a day. In addition,
	//    most countries in the EU have access to standard shipping, which typically
	//    takes less than a week, one way.
	//
	//    * In India, Snow devices are delivered in one to seven days.
	//
	//    * In the US, you have access to one-day shipping and two-day shipping.
	ShippingOption *string `type:"string" enum:"ShippingOption"`

	// If your job is being created in one of the US regions, you have the option
	// of specifying what size Snow device you'd like for this job. In all other
	// regions, Snowballs come with 80 TB in storage capacity.
	//
	// For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html"
	// (Snow Family Devices and Capacity) in the Snowcone User Guide or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html"
	// (Snow Family Devices and Capacity) in the Snowcone User Guide.
	SnowballCapacityPreference *string `type:"string" enum:"Capacity"`

	// The type of Snow Family devices to use for this job.
	//
	// For cluster jobs, Amazon Web Services Snow Family currently supports only
	// the EDGE device type.
	//
	// The type of Amazon Web Services Snow device to use for this job. Currently,
	// the only supported device type for cluster jobs is EDGE.
	//
	// For more information, see Snowball Edge Device Options (https://docs.aws.amazon.com/snowball/latest/developer-guide/device-differences.html)
	// in the Snowball Edge Developer Guide.
	//
	// For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html"
	// (Snow Family Devices and Capacity) in the Snowcone User Guide or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html"
	// (Snow Family Devices and Capacity) in the Snowcone User Guide.
	SnowballType *string `type:"string" enum:"Type"`

	// The tax documents required in your Amazon Web Services Region.
	TaxDocuments *TaxDocuments `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateJobInput"}
	if s.AddressId != nil && len(*s.AddressId) < 40 {
		invalidParams.Add(request.NewErrParamMinLen("AddressId", 40))
	}
	if s.ClusterId != nil && len(*s.ClusterId) < 39 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterId", 39))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.ForwardingAddressId != nil && len(*s.ForwardingAddressId) < 40 {
		invalidParams.Add(request.NewErrParamMinLen("ForwardingAddressId", 40))
	}
	if s.LongTermPricingId != nil && len(*s.LongTermPricingId) < 41 {
		invalidParams.Add(request.NewErrParamMinLen("LongTermPricingId", 41))
	}
	if s.OnDeviceServiceConfiguration != nil {
		if err := s.OnDeviceServiceConfiguration.Validate(); err != nil {
			invalidParams.AddNested("OnDeviceServiceConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.PickupDetails != nil {
		if err := s.PickupDetails.Validate(); err != nil {
			invalidParams.AddNested("PickupDetails", err.(request.ErrInvalidParams))
		}
	}
	if s.Resources != nil {
		if err := s.Resources.Validate(); err != nil {
			invalidParams.AddNested("Resources", err.(request.ErrInvalidParams))
		}
	}
	if s.TaxDocuments != nil {
		if err := s.TaxDocuments.Validate(); err != nil {
			invalidParams.AddNested("TaxDocuments", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddressId sets the AddressId field's value.
func (s *CreateJobInput) SetAddressId(v string) *CreateJobInput {
	s.AddressId = &v
	return s
}

// SetClusterId sets the ClusterId field's value.
func (s *CreateJobInput) SetClusterId(v string) *CreateJobInput {
	s.ClusterId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateJobInput) SetDescription(v string) *CreateJobInput {
	s.Description = &v
	return s
}

// SetDeviceConfiguration sets the DeviceConfiguration field's value.
func (s *CreateJobInput) SetDeviceConfiguration(v *DeviceConfiguration) *CreateJobInput {
	s.DeviceConfiguration = v
	return s
}

// SetForwardingAddressId sets the ForwardingAddressId field's value.
func (s *CreateJobInput) SetForwardingAddressId(v string) *CreateJobInput {
	s.ForwardingAddressId = &v
	return s
}

// SetImpactLevel sets the ImpactLevel field's value.
func (s *CreateJobInput) SetImpactLevel(v string) *CreateJobInput {
	s.ImpactLevel = &v
	return s
}

// SetJobType sets the JobType field's value.
func (s *CreateJobInput) SetJobType(v string) *CreateJobInput {
	s.JobType = &v
	return s
}

// SetKmsKeyARN sets the KmsKeyARN field's value.
func (s *CreateJobInput) SetKmsKeyARN(v string) *CreateJobInput {
	s.KmsKeyARN = &v
	return s
}

// SetLongTermPricingId sets the LongTermPricingId field's value.
func (s *CreateJobInput) SetLongTermPricingId(v string) *CreateJobInput {
	s.LongTermPricingId = &v
	return s
}

// SetNotification sets the Notification field's value.
func (s *CreateJobInput) SetNotification(v *Notification) *CreateJobInput {
	s.Notification = v
	return s
}

// SetOnDeviceServiceConfiguration sets the OnDeviceServiceConfiguration field's value.
func (s *CreateJobInput) SetOnDeviceServiceConfiguration(v *OnDeviceServiceConfiguration) *CreateJobInput {
	s.OnDeviceServiceConfiguration = v
	return s
}

// SetPickupDetails sets the PickupDetails field's value.
func (s *CreateJobInput) SetPickupDetails(v *PickupDetails) *CreateJobInput {
	s.PickupDetails = v
	return s
}

// SetRemoteManagement sets the RemoteManagement field's value.
func (s *CreateJobInput) SetRemoteManagement(v string) *CreateJobInput {
	s.RemoteManagement = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *CreateJobInput) SetResources(v *JobResource) *CreateJobInput {
	s.Resources = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *CreateJobInput) SetRoleARN(v string) *CreateJobInput {
	s.RoleARN = &v
	return s
}

// SetShippingOption sets the ShippingOption field's value.
func (s *CreateJobInput) SetShippingOption(v string) *CreateJobInput {
	s.ShippingOption = &v
	return s
}

// SetSnowballCapacityPreference sets the SnowballCapacityPreference field's value.
func (s *CreateJobInput) SetSnowballCapacityPreference(v string) *CreateJobInput {
	s.SnowballCapacityPreference = &v
	return s
}

// SetSnowballType sets the SnowballType field's value.
func (s *CreateJobInput) SetSnowballType(v string) *CreateJobInput {
	s.SnowballType = &v
	return s
}

// SetTaxDocuments sets the TaxDocuments field's value.
func (s *CreateJobInput) SetTaxDocuments(v *TaxDocuments) *CreateJobInput {
	s.TaxDocuments = v
	return s
}

type CreateJobOutput struct {
	_ struct{} `type:"structure"`

	// The automatically generated ID for a job, for example JID123e4567-e89b-12d3-a456-426655440000.
	JobId *string `min:"39" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *CreateJobOutput) SetJobId(v string) *CreateJobOutput {
	s.JobId = &v
	return s
}

type CreateLongTermPricingInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether the current long-term pricing type for the device should
	// be renewed.
	IsLongTermPricingAutoRenew *bool `type:"boolean"`

	// The type of long-term pricing option you want for the device, either 1-year
	// or 3-year long-term pricing.
	//
	// LongTermPricingType is a required field
	LongTermPricingType *string `type:"string" required:"true" enum:"LongTermPricingType"`

	// The type of Snow Family devices to use for the long-term pricing job.
	//
	// SnowballType is a required field
	SnowballType *string `type:"string" required:"true" enum:"Type"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLongTermPricingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLongTermPricingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLongTermPricingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLongTermPricingInput"}
	if s.LongTermPricingType == nil {
		invalidParams.Add(request.NewErrParamRequired("LongTermPricingType"))
	}
	if s.SnowballType == nil {
		invalidParams.Add(request.NewErrParamRequired("SnowballType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIsLongTermPricingAutoRenew sets the IsLongTermPricingAutoRenew field's value.
func (s *CreateLongTermPricingInput) SetIsLongTermPricingAutoRenew(v bool) *CreateLongTermPricingInput {
	s.IsLongTermPricingAutoRenew = &v
	return s
}

// SetLongTermPricingType sets the LongTermPricingType field's value.
func (s *CreateLongTermPricingInput) SetLongTermPricingType(v string) *CreateLongTermPricingInput {
	s.LongTermPricingType = &v
	return s
}

// SetSnowballType sets the SnowballType field's value.
func (s *CreateLongTermPricingInput) SetSnowballType(v string) *CreateLongTermPricingInput {
	s.SnowballType = &v
	return s
}

type CreateLongTermPricingOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the long-term pricing type for the device.
	LongTermPricingId *string `min:"41" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLongTermPricingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLongTermPricingOutput) GoString() string {
	return s.String()
}

// SetLongTermPricingId sets the LongTermPricingId field's value.
func (s *CreateLongTermPricingOutput) SetLongTermPricingId(v string) *CreateLongTermPricingOutput {
	s.LongTermPricingId = &v
	return s
}

type CreateReturnShippingLabelInput struct {
	_ struct{} `type:"structure"`

	// The ID for a job that you want to create the return shipping label for; for
	// example, JID123e4567-e89b-12d3-a456-426655440000.
	//
	// JobId is a required field
	JobId *string `min:"39" type:"string" required:"true"`

	// The shipping speed for a particular job. This speed doesn't dictate how soon
	// the device is returned to Amazon Web Services. This speed represents how
	// quickly it moves to its destination while in transit. Regional shipping speeds
	// are as follows:
	ShippingOption *string `type:"string" enum:"ShippingOption"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReturnShippingLabelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReturnShippingLabelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateReturnShippingLabelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateReturnShippingLabelInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 39 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 39))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *CreateReturnShippingLabelInput) SetJobId(v string) *CreateReturnShippingLabelInput {
	s.JobId = &v
	return s
}

// SetShippingOption sets the ShippingOption field's value.
func (s *CreateReturnShippingLabelInput) SetShippingOption(v string) *CreateReturnShippingLabelInput {
	s.ShippingOption = &v
	return s
}

type CreateReturnShippingLabelOutput struct {
	_ struct{} `type:"structure"`

	// The status information of the task on a Snow device that is being returned
	// to Amazon Web Services.
	Status *string `type:"string" enum:"ShippingLabelStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReturnShippingLabelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReturnShippingLabelOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *CreateReturnShippingLabelOutput) SetStatus(v string) *CreateReturnShippingLabelOutput {
	s.Status = &v
	return s
}

// Defines the real-time status of a Snow device's data transfer while the device
// is at Amazon Web Services. This data is only available while a job has a
// JobState value of InProgress, for both import and export jobs.
type DataTransfer struct {
	_ struct{} `type:"structure"`

	// The number of bytes transferred between a Snow device and Amazon S3.
	BytesTransferred *int64 `type:"long"`

	// The number of objects transferred between a Snow device and Amazon S3.
	ObjectsTransferred *int64 `type:"long"`

	// The total bytes of data for a transfer between a Snow device and Amazon S3.
	// This value is set to 0 (zero) until all the keys that will be transferred
	// have been listed.
	TotalBytes *int64 `type:"long"`

	// The total number of objects for a transfer between a Snow device and Amazon
	// S3. This value is set to 0 (zero) until all the keys that will be transferred
	// have been listed.
	TotalObjects *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataTransfer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataTransfer) GoString() string {
	return s.String()
}

// SetBytesTransferred sets the BytesTransferred field's value.
func (s *DataTransfer) SetBytesTransferred(v int64) *DataTransfer {
	s.BytesTransferred = &v
	return s
}

// SetObjectsTransferred sets the ObjectsTransferred field's value.
func (s *DataTransfer) SetObjectsTransferred(v int64) *DataTransfer {
	s.ObjectsTransferred = &v
	return s
}

// SetTotalBytes sets the TotalBytes field's value.
func (s *DataTransfer) SetTotalBytes(v int64) *DataTransfer {
	s.TotalBytes = &v
	return s
}

// SetTotalObjects sets the TotalObjects field's value.
func (s *DataTransfer) SetTotalObjects(v int64) *DataTransfer {
	s.TotalObjects = &v
	return s
}

// The name and version of the service dependant on the requested service.
type DependentService struct {
	_ struct{} `type:"structure"`

	// The name of the dependent service.
	ServiceName *string `type:"string" enum:"ServiceName"`

	// The version of the dependent service.
	ServiceVersion *ServiceVersion `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DependentService) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DependentService) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DependentService) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DependentService"}
	if s.ServiceVersion != nil {
		if err := s.ServiceVersion.Validate(); err != nil {
			invalidParams.AddNested("ServiceVersion", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServiceName sets the ServiceName field's value.
func (s *DependentService) SetServiceName(v string) *DependentService {
	s.ServiceName = &v
	return s
}

// SetServiceVersion sets the ServiceVersion field's value.
func (s *DependentService) SetServiceVersion(v *ServiceVersion) *DependentService {
	s.ServiceVersion = v
	return s
}

type DescribeAddressInput struct {
	_ struct{} `type:"structure"`

	// The automatically generated ID for a specific address.
	//
	// AddressId is a required field
	AddressId *string `min:"40" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAddressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAddressInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAddressInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAddressInput"}
	if s.AddressId == nil {
		invalidParams.Add(request.NewErrParamRequired("AddressId"))
	}
	if s.AddressId != nil && len(*s.AddressId) < 40 {
		invalidParams.Add(request.NewErrParamMinLen("AddressId", 40))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddressId sets the AddressId field's value.
func (s *DescribeAddressInput) SetAddressId(v string) *DescribeAddressInput {
	s.AddressId = &v
	return s
}

type DescribeAddressOutput struct {
	_ struct{} `type:"structure"`

	// The address that you want the Snow device(s) associated with a specific job
	// to be shipped to.
	Address *Address `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAddressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAddressOutput) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *DescribeAddressOutput) SetAddress(v *Address) *DescribeAddressOutput {
	s.Address = v
	return s
}

type DescribeAddressesInput struct {
	_ struct{} `type:"structure"`

	// The number of ADDRESS objects to return.
	MaxResults *int64 `type:"integer"`

	// HTTP requests are stateless. To identify what object comes "next" in the
	// list of ADDRESS objects, you have the option of specifying a value for NextToken
	// as the starting point for your list of returned addresses.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAddressesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAddressesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAddressesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAddressesInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeAddressesInput) SetMaxResults(v int64) *DescribeAddressesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAddressesInput) SetNextToken(v string) *DescribeAddressesInput {
	s.NextToken = &v
	return s
}

type DescribeAddressesOutput struct {
	_ struct{} `type:"structure"`

	// The Snow device shipping addresses that were created for this account.
	Addresses []*Address `type:"list"`

	// HTTP requests are stateless. If you use the automatically generated NextToken
	// value in your next DescribeAddresses call, your list of returned addresses
	// will start from this point in the array.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAddressesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAddressesOutput) GoString() string {
	return s.String()
}

// SetAddresses sets the Addresses field's value.
func (s *DescribeAddressesOutput) SetAddresses(v []*Address) *DescribeAddressesOutput {
	s.Addresses = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAddressesOutput) SetNextToken(v string) *DescribeAddressesOutput {
	s.NextToken = &v
	return s
}

type DescribeClusterInput struct {
	_ struct{} `type:"structure"`

	// The automatically generated ID for a cluster.
	//
	// ClusterId is a required field
	ClusterId *string `min:"39" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeClusterInput"}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}
	if s.ClusterId != nil && len(*s.ClusterId) < 39 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterId", 39))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterId sets the ClusterId field's value.
func (s *DescribeClusterInput) SetClusterId(v string) *DescribeClusterInput {
	s.ClusterId = &v
	return s
}

type DescribeClusterOutput struct {
	_ struct{} `type:"structure"`

	// Information about a specific cluster, including shipping information, cluster
	// status, and other important metadata.
	ClusterMetadata *ClusterMetadata `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClusterOutput) GoString() string {
	return s.String()
}

// SetClusterMetadata sets the ClusterMetadata field's value.
func (s *DescribeClusterOutput) SetClusterMetadata(v *ClusterMetadata) *DescribeClusterOutput {
	s.ClusterMetadata = v
	return s
}

type DescribeJobInput struct {
	_ struct{} `type:"structure"`

	// The automatically generated ID for a job, for example JID123e4567-e89b-12d3-a456-426655440000.
	//
	// JobId is a required field
	JobId *string `min:"39" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 39 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 39))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribeJobInput) SetJobId(v string) *DescribeJobInput {
	s.JobId = &v
	return s
}

type DescribeJobOutput struct {
	_ struct{} `type:"structure"`

	// Information about a specific job, including shipping information, job status,
	// and other important metadata.
	JobMetadata *JobMetadata `type:"structure"`

	// Information about a specific job part (in the case of an export job), including
	// shipping information, job status, and other important metadata.
	SubJobMetadata []*JobMetadata `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobOutput) GoString() string {
	return s.String()
}

// SetJobMetadata sets the JobMetadata field's value.
func (s *DescribeJobOutput) SetJobMetadata(v *JobMetadata) *DescribeJobOutput {
	s.JobMetadata = v
	return s
}

// SetSubJobMetadata sets the SubJobMetadata field's value.
func (s *DescribeJobOutput) SetSubJobMetadata(v []*JobMetadata) *DescribeJobOutput {
	s.SubJobMetadata = v
	return s
}

type DescribeReturnShippingLabelInput struct {
	_ struct{} `type:"structure"`

	// The automatically generated ID for a job, for example JID123e4567-e89b-12d3-a456-426655440000.
	//
	// JobId is a required field
	JobId *string `min:"39" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReturnShippingLabelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReturnShippingLabelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReturnShippingLabelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeReturnShippingLabelInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 39 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 39))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribeReturnShippingLabelInput) SetJobId(v string) *DescribeReturnShippingLabelInput {
	s.JobId = &v
	return s
}

type DescribeReturnShippingLabelOutput struct {
	_ struct{} `type:"structure"`

	// The expiration date of the current return shipping label.
	ExpirationDate *time.Time `type:"timestamp"`

	// The pre-signed Amazon S3 URI used to download the return shipping label.
	ReturnShippingLabelURI *string `min:"1" type:"string"`

	// The status information of the task on a Snow device that is being returned
	// to Amazon Web Services.
	Status *string `type:"string" enum:"ShippingLabelStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReturnShippingLabelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReturnShippingLabelOutput) GoString() string {
	return s.String()
}

// SetExpirationDate sets the ExpirationDate field's value.
func (s *DescribeReturnShippingLabelOutput) SetExpirationDate(v time.Time) *DescribeReturnShippingLabelOutput {
	s.ExpirationDate = &v
	return s
}

// SetReturnShippingLabelURI sets the ReturnShippingLabelURI field's value.
func (s *DescribeReturnShippingLabelOutput) SetReturnShippingLabelURI(v string) *DescribeReturnShippingLabelOutput {
	s.ReturnShippingLabelURI = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeReturnShippingLabelOutput) SetStatus(v string) *DescribeReturnShippingLabelOutput {
	s.Status = &v
	return s
}

// The container for SnowconeDeviceConfiguration.
type DeviceConfiguration struct {
	_ struct{} `type:"structure"`

	// Returns information about the device configuration for an Snowcone job.
	SnowconeDeviceConfiguration *SnowconeDeviceConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceConfiguration) GoString() string {
	return s.String()
}

// SetSnowconeDeviceConfiguration sets the SnowconeDeviceConfiguration field's value.
func (s *DeviceConfiguration) SetSnowconeDeviceConfiguration(v *SnowconeDeviceConfiguration) *DeviceConfiguration {
	s.SnowconeDeviceConfiguration = v
	return s
}

// An object representing the metadata and configuration settings of EKS Anywhere
// on the Snow Family device.
type EKSOnDeviceServiceConfiguration struct {
	_ struct{} `type:"structure"`

	// The optional version of EKS Anywhere on the Snow Family device.
	EKSAnywhereVersion *string `min:"1" type:"string"`

	// The Kubernetes version for EKS Anywhere on the Snow Family device.
	KubernetesVersion *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EKSOnDeviceServiceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EKSOnDeviceServiceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EKSOnDeviceServiceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EKSOnDeviceServiceConfiguration"}
	if s.EKSAnywhereVersion != nil && len(*s.EKSAnywhereVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EKSAnywhereVersion", 1))
	}
	if s.KubernetesVersion != nil && len(*s.KubernetesVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KubernetesVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEKSAnywhereVersion sets the EKSAnywhereVersion field's value.
func (s *EKSOnDeviceServiceConfiguration) SetEKSAnywhereVersion(v string) *EKSOnDeviceServiceConfiguration {
	s.EKSAnywhereVersion = &v
	return s
}

// SetKubernetesVersion sets the KubernetesVersion field's value.
func (s *EKSOnDeviceServiceConfiguration) SetKubernetesVersion(v string) *EKSOnDeviceServiceConfiguration {
	s.KubernetesVersion = &v
	return s
}

// A JSON-formatted object that contains the IDs for an Amazon Machine Image
// (AMI), including the Amazon EC2-compatible AMI ID and the Snow device AMI
// ID. Each AMI has these two IDs to simplify identifying the AMI in both the
// Amazon Web Services Cloud and on the device.
type Ec2AmiResource struct {
	_ struct{} `type:"structure"`

	// The ID of the AMI in Amazon EC2.
	//
	// AmiId is a required field
	AmiId *string `min:"12" type:"string" required:"true"`

	// The ID of the AMI on the Snow device.
	SnowballAmiId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ec2AmiResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ec2AmiResource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Ec2AmiResource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Ec2AmiResource"}
	if s.AmiId == nil {
		invalidParams.Add(request.NewErrParamRequired("AmiId"))
	}
	if s.AmiId != nil && len(*s.AmiId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AmiId", 12))
	}
	if s.SnowballAmiId != nil && len(*s.SnowballAmiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SnowballAmiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmiId sets the AmiId field's value.
func (s *Ec2AmiResource) SetAmiId(v string) *Ec2AmiResource {
	s.AmiId = &v
	return s
}

// SetSnowballAmiId sets the SnowballAmiId field's value.
func (s *Ec2AmiResource) SetSnowballAmiId(v string) *Ec2AmiResource {
	s.SnowballAmiId = &v
	return s
}

// Your user lacks the necessary Amazon EC2 permissions to perform the attempted
// action.
type Ec2RequestFailedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ec2RequestFailedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ec2RequestFailedException) GoString() string {
	return s.String()
}

func newErrorEc2RequestFailedException(v protocol.ResponseMetadata) error {
	return &Ec2RequestFailedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *Ec2RequestFailedException) Code() string {
	return "Ec2RequestFailedException"
}

// Message returns the exception's message.
func (s *Ec2RequestFailedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *Ec2RequestFailedException) OrigErr() error {
	return nil
}

func (s *Ec2RequestFailedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *Ec2RequestFailedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *Ec2RequestFailedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The container for the EventTriggerDefinition$EventResourceARN.
type EventTriggerDefinition struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for any local Amazon S3 resource that is an
	// Lambda function's event trigger associated with this job.
	EventResourceARN *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventTriggerDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventTriggerDefinition) GoString() string {
	return s.String()
}

// SetEventResourceARN sets the EventResourceARN field's value.
func (s *EventTriggerDefinition) SetEventResourceARN(v string) *EventTriggerDefinition {
	s.EventResourceARN = &v
	return s
}

type GetJobManifestInput struct {
	_ struct{} `type:"structure"`

	// The ID for a job that you want to get the manifest file for, for example
	// JID123e4567-e89b-12d3-a456-426655440000.
	//
	// JobId is a required field
	JobId *string `min:"39" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetJobManifestInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetJobManifestInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetJobManifestInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetJobManifestInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 39 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 39))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *GetJobManifestInput) SetJobId(v string) *GetJobManifestInput {
	s.JobId = &v
	return s
}

type GetJobManifestOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 presigned URL for the manifest file associated with the specified
	// JobId value.
	ManifestURI *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetJobManifestOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetJobManifestOutput) GoString() string {
	return s.String()
}

// SetManifestURI sets the ManifestURI field's value.
func (s *GetJobManifestOutput) SetManifestURI(v string) *GetJobManifestOutput {
	s.ManifestURI = &v
	return s
}

type GetJobUnlockCodeInput struct {
	_ struct{} `type:"structure"`

	// The ID for the job that you want to get the UnlockCode value for, for example
	// JID123e4567-e89b-12d3-a456-426655440000.
	//
	// JobId is a required field
	JobId *string `min:"39" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetJobUnlockCodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetJobUnlockCodeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetJobUnlockCodeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetJobUnlockCodeInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 39 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 39))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *GetJobUnlockCodeInput) SetJobId(v string) *GetJobUnlockCodeInput {
	s.JobId = &v
	return s
}

type GetJobUnlockCodeOutput struct {
	_ struct{} `type:"structure"`

	// The UnlockCode value for the specified job. The UnlockCode value can be accessed
	// for up to 360 days after the job has been created.
	UnlockCode *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetJobUnlockCodeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetJobUnlockCodeOutput) GoString() string {
	return s.String()
}

// SetUnlockCode sets the UnlockCode field's value.
func (s *GetJobUnlockCodeOutput) SetUnlockCode(v string) *GetJobUnlockCodeOutput {
	s.UnlockCode = &v
	return s
}

type GetSnowballUsageInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSnowballUsageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSnowballUsageInput) GoString() string {
	return s.String()
}

type GetSnowballUsageOutput struct {
	_ struct{} `type:"structure"`

	// The service limit for number of Snow devices this account can have at once.
	// The default service limit is 1 (one).
	SnowballLimit *int64 `type:"integer"`

	// The number of Snow devices that this account is currently using.
	SnowballsInUse *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSnowballUsageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSnowballUsageOutput) GoString() string {
	return s.String()
}

// SetSnowballLimit sets the SnowballLimit field's value.
func (s *GetSnowballUsageOutput) SetSnowballLimit(v int64) *GetSnowballUsageOutput {
	s.SnowballLimit = &v
	return s
}

// SetSnowballsInUse sets the SnowballsInUse field's value.
func (s *GetSnowballUsageOutput) SetSnowballsInUse(v int64) *GetSnowballUsageOutput {
	s.SnowballsInUse = &v
	return s
}

type GetSoftwareUpdatesInput struct {
	_ struct{} `type:"structure"`

	// The ID for a job that you want to get the software update file for, for example
	// JID123e4567-e89b-12d3-a456-426655440000.
	//
	// JobId is a required field
	JobId *string `min:"39" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSoftwareUpdatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSoftwareUpdatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSoftwareUpdatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSoftwareUpdatesInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 39 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 39))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *GetSoftwareUpdatesInput) SetJobId(v string) *GetSoftwareUpdatesInput {
	s.JobId = &v
	return s
}

type GetSoftwareUpdatesOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 presigned URL for the update file associated with the specified
	// JobId value. The software update will be available for 2 days after this
	// request is made. To access an update after the 2 days have passed, you'll
	// have to make another call to GetSoftwareUpdates.
	UpdatesURI *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSoftwareUpdatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSoftwareUpdatesOutput) GoString() string {
	return s.String()
}

// SetUpdatesURI sets the UpdatesURI field's value.
func (s *GetSoftwareUpdatesOutput) SetUpdatesURI(v string) *GetSoftwareUpdatesOutput {
	s.UpdatesURI = &v
	return s
}

// The tax documents required in Amazon Web Services Region in India.
type INDTaxDocuments struct {
	_ struct{} `type:"structure"`

	// The Goods and Services Tax (GST) documents required in Amazon Web Services
	// Region in India.
	GSTIN *string `min:"15" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s INDTaxDocuments) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s INDTaxDocuments) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *INDTaxDocuments) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "INDTaxDocuments"}
	if s.GSTIN != nil && len(*s.GSTIN) < 15 {
		invalidParams.Add(request.NewErrParamMinLen("GSTIN", 15))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGSTIN sets the GSTIN field's value.
func (s *INDTaxDocuments) SetGSTIN(v string) *INDTaxDocuments {
	s.GSTIN = &v
	return s
}

// The address provided was invalid. Check the address with your region's carrier,
// and try again.
type InvalidAddressException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidAddressException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidAddressException) GoString() string {
	return s.String()
}

func newErrorInvalidAddressException(v protocol.ResponseMetadata) error {
	return &InvalidAddressException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidAddressException) Code() string {
	return "InvalidAddressException"
}

// Message returns the exception's message.
func (s *InvalidAddressException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidAddressException) OrigErr() error {
	return nil
}

func (s *InvalidAddressException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidAddressException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidAddressException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Job or cluster creation failed. One or more inputs were invalid. Confirm
// that the CreateClusterRequest$SnowballType value supports your CreateJobRequest$JobType,
// and try again.
type InvalidInputCombinationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidInputCombinationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidInputCombinationException) GoString() string {
	return s.String()
}

func newErrorInvalidInputCombinationException(v protocol.ResponseMetadata) error {
	return &InvalidInputCombinationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidInputCombinationException) Code() string {
	return "InvalidInputCombinationException"
}

// Message returns the exception's message.
func (s *InvalidInputCombinationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidInputCombinationException) OrigErr() error {
	return nil
}

func (s *InvalidInputCombinationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidInputCombinationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidInputCombinationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The action can't be performed because the job's current state doesn't allow
// that action to be performed.
type InvalidJobStateException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidJobStateException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidJobStateException) GoString() string {
	return s.String()
}

func newErrorInvalidJobStateException(v protocol.ResponseMetadata) error {
	return &InvalidJobStateException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidJobStateException) Code() string {
	return "InvalidJobStateException"
}

// Message returns the exception's message.
func (s *InvalidJobStateException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidJobStateException) OrigErr() error {
	return nil
}

func (s *InvalidJobStateException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidJobStateException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidJobStateException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The NextToken string was altered unexpectedly, and the operation has stopped.
// Run the operation without changing the NextToken string, and try again.
type InvalidNextTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidNextTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidNextTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidNextTokenException(v protocol.ResponseMetadata) error {
	return &InvalidNextTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidNextTokenException) Code() string {
	return "InvalidNextTokenException"
}

// Message returns the exception's message.
func (s *InvalidNextTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidNextTokenException) OrigErr() error {
	return nil
}

func (s *InvalidNextTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidNextTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidNextTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified resource can't be found. Check the information you provided
// in your last request, and try again.
type InvalidResourceException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`

	// The provided resource value is invalid.
	ResourceType *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidResourceException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidResourceException) GoString() string {
	return s.String()
}

func newErrorInvalidResourceException(v protocol.ResponseMetadata) error {
	return &InvalidResourceException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidResourceException) Code() string {
	return "InvalidResourceException"
}

// Message returns the exception's message.
func (s *InvalidResourceException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidResourceException) OrigErr() error {
	return nil
}

func (s *InvalidResourceException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidResourceException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidResourceException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Each JobListEntry object contains a job's state, a job's ID, and a value
// that indicates whether the job is a job part, in the case of an export job.
type JobListEntry struct {
	_ struct{} `type:"structure"`

	// The creation date for this job.
	CreationDate *time.Time `type:"timestamp"`

	// The optional description of this specific job, for example Important Photos
	// 2016-08-11.
	Description *string `min:"1" type:"string"`

	// A value that indicates that this job is a main job. A main job represents
	// a successful request to create an export job. Main jobs aren't associated
	// with any Snowballs. Instead, each main job will have at least one job part,
	// and each job part is associated with a Snowball. It might take some time
	// before the job parts associated with a particular main job are listed, because
	// they are created after the main job is created.
	IsMaster *bool `type:"boolean"`

	// The automatically generated ID for a job, for example JID123e4567-e89b-12d3-a456-426655440000.
	JobId *string `min:"1" type:"string"`

	// The current state of this job.
	JobState *string `type:"string" enum:"JobState"`

	// The type of job.
	JobType *string `type:"string" enum:"JobType"`

	// The type of device used with this job.
	SnowballType *string `type:"string" enum:"Type"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobListEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobListEntry) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *JobListEntry) SetCreationDate(v time.Time) *JobListEntry {
	s.CreationDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *JobListEntry) SetDescription(v string) *JobListEntry {
	s.Description = &v
	return s
}

// SetIsMaster sets the IsMaster field's value.
func (s *JobListEntry) SetIsMaster(v bool) *JobListEntry {
	s.IsMaster = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *JobListEntry) SetJobId(v string) *JobListEntry {
	s.JobId = &v
	return s
}

// SetJobState sets the JobState field's value.
func (s *JobListEntry) SetJobState(v string) *JobListEntry {
	s.JobState = &v
	return s
}

// SetJobType sets the JobType field's value.
func (s *JobListEntry) SetJobType(v string) *JobListEntry {
	s.JobType = &v
	return s
}

// SetSnowballType sets the SnowballType field's value.
func (s *JobListEntry) SetSnowballType(v string) *JobListEntry {
	s.SnowballType = &v
	return s
}

// Contains job logs. Whenever a Snow device is used to import data into or
// export data out of Amazon S3, you'll have the option of downloading a PDF
// job report. Job logs are returned as a part of the response syntax of the
// DescribeJob action in the JobMetadata data type. The job logs can be accessed
// for up to 60 minutes after this request has been made. To access any of the
// job logs after 60 minutes have passed, you'll have to make another call to
// the DescribeJob action.
//
// For import jobs, the PDF job report becomes available at the end of the import
// process. For export jobs, your job report typically becomes available while
// the Snow device for your job part is being delivered to you.
//
// The job report provides you insight into the state of your Amazon S3 data
// transfer. The report includes details about your job or job part for your
// records.
//
// For deeper visibility into the status of your transferred objects, you can
// look at the two associated logs: a success log and a failure log. The logs
// are saved in comma-separated value (CSV) format, and the name of each log
// includes the ID of the job or job part that the log describes.
type JobLogs struct {
	_ struct{} `type:"structure"`

	// A link to an Amazon S3 presigned URL where the job completion report is located.
	JobCompletionReportURI *string `min:"1" type:"string"`

	// A link to an Amazon S3 presigned URL where the job failure log is located.
	JobFailureLogURI *string `min:"1" type:"string"`

	// A link to an Amazon S3 presigned URL where the job success log is located.
	JobSuccessLogURI *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobLogs) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobLogs) GoString() string {
	return s.String()
}

// SetJobCompletionReportURI sets the JobCompletionReportURI field's value.
func (s *JobLogs) SetJobCompletionReportURI(v string) *JobLogs {
	s.JobCompletionReportURI = &v
	return s
}

// SetJobFailureLogURI sets the JobFailureLogURI field's value.
func (s *JobLogs) SetJobFailureLogURI(v string) *JobLogs {
	s.JobFailureLogURI = &v
	return s
}

// SetJobSuccessLogURI sets the JobSuccessLogURI field's value.
func (s *JobLogs) SetJobSuccessLogURI(v string) *JobLogs {
	s.JobSuccessLogURI = &v
	return s
}

// Contains information about a specific job including shipping information,
// job status, and other important metadata. This information is returned as
// a part of the response syntax of the DescribeJob action.
type JobMetadata struct {
	_ struct{} `type:"structure"`

	// The ID for the address that you want the Snow device shipped to.
	AddressId *string `min:"40" type:"string"`

	// The 39-character ID for the cluster, for example CID123e4567-e89b-12d3-a456-426655440000.
	ClusterId *string `min:"1" type:"string"`

	// The creation date for this job.
	CreationDate *time.Time `type:"timestamp"`

	// A value that defines the real-time status of a Snow device's data transfer
	// while the device is at Amazon Web Services. This data is only available while
	// a job has a JobState value of InProgress, for both import and export jobs.
	DataTransferProgress *DataTransfer `type:"structure"`

	// The description of the job, provided at job creation.
	Description *string `min:"1" type:"string"`

	// The container for SnowconeDeviceConfiguration.
	DeviceConfiguration *DeviceConfiguration `type:"structure"`

	// The ID of the address that you want a job shipped to, after it will be shipped
	// to its primary address. This field is not supported in most regions.
	ForwardingAddressId *string `min:"40" type:"string"`

	// The highest impact level of data that will be stored or processed on the
	// device, provided at job creation.
	ImpactLevel *string `type:"string" enum:"ImpactLevel"`

	// The automatically generated ID for a job, for example JID123e4567-e89b-12d3-a456-426655440000.
	JobId *string `min:"1" type:"string"`

	// Links to Amazon S3 presigned URLs for the job report and logs. For import
	// jobs, the PDF job report becomes available at the end of the import process.
	// For export jobs, your job report typically becomes available while the Snow
	// device for your job part is being delivered to you.
	JobLogInfo *JobLogs `type:"structure"`

	// The current status of the jobs.
	JobState *string `type:"string" enum:"JobState"`

	// The type of job.
	JobType *string `type:"string" enum:"JobType"`

	// The Amazon Resource Name (ARN) for the Key Management Service (KMS) key associated
	// with this job. This ARN was created using the CreateKey (https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html)
	// API action in KMS.
	KmsKeyARN *string `type:"string"`

	// The ID of the long-term pricing type for the device.
	LongTermPricingId *string `min:"41" type:"string"`

	// The Amazon Simple Notification Service (Amazon SNS) notification settings
	// associated with a specific job. The Notification object is returned as a
	// part of the response syntax of the DescribeJob action in the JobMetadata
	// data type.
	Notification *Notification `type:"structure"`

	// Represents metadata and configuration settings for services on an Amazon
	// Web Services Snow Family device.
	OnDeviceServiceConfiguration *OnDeviceServiceConfiguration `type:"structure"`

	// Information identifying the person picking up the device.
	PickupDetails *PickupDetails `type:"structure"`

	// Allows you to securely operate and manage Snowcone devices remotely from
	// outside of your internal network. When set to INSTALLED_AUTOSTART, remote
	// management will automatically be available when the device arrives at your
	// location. Otherwise, you need to use the Snowball Client to manage the device.
	RemoteManagement *string `type:"string" enum:"RemoteManagement"`

	// An array of S3Resource objects. Each S3Resource object represents an Amazon
	// S3 bucket that your transferred data will be exported from or imported into.
	Resources *JobResource `type:"structure"`

	// The role ARN associated with this job. This ARN was created using the CreateRole
	// (https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html)
	// API action in Identity and Access Management.
	RoleARN *string `type:"string"`

	// A job's shipping information, including inbound and outbound tracking numbers
	// and shipping speed options.
	ShippingDetails *ShippingDetails `type:"structure"`

	// The Snow device capacity preference for this job, specified at job creation.
	// In US regions, you can choose between 50 TB and 80 TB Snowballs. All other
	// regions use 80 TB capacity Snowballs.
	//
	// For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html"
	// (Snow Family Devices and Capacity) in the Snowcone User Guide or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html"
	// (Snow Family Devices and Capacity) in the Snowcone User Guide.
	SnowballCapacityPreference *string `type:"string" enum:"Capacity"`

	// Unique ID associated with a device.
	SnowballId *string `min:"1" type:"string"`

	// The type of device used with this job.
	SnowballType *string `type:"string" enum:"Type"`

	// The metadata associated with the tax documents required in your Amazon Web
	// Services Region.
	TaxDocuments *TaxDocuments `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobMetadata) GoString() string {
	return s.String()
}

// SetAddressId sets the AddressId field's value.
func (s *JobMetadata) SetAddressId(v string) *JobMetadata {
	s.AddressId = &v
	return s
}

// SetClusterId sets the ClusterId field's value.
func (s *JobMetadata) SetClusterId(v string) *JobMetadata {
	s.ClusterId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *JobMetadata) SetCreationDate(v time.Time) *JobMetadata {
	s.CreationDate = &v
	return s
}

// SetDataTransferProgress sets the DataTransferProgress field's value.
func (s *JobMetadata) SetDataTransferProgress(v *DataTransfer) *JobMetadata {
	s.DataTransferProgress = v
	return s
}

// SetDescription sets the Description field's value.
func (s *JobMetadata) SetDescription(v string) *JobMetadata {
	s.Description = &v
	return s
}

// SetDeviceConfiguration sets the DeviceConfiguration field's value.
func (s *JobMetadata) SetDeviceConfiguration(v *DeviceConfiguration) *JobMetadata {
	s.DeviceConfiguration = v
	return s
}

// SetForwardingAddressId sets the ForwardingAddressId field's value.
func (s *JobMetadata) SetForwardingAddressId(v string) *JobMetadata {
	s.ForwardingAddressId = &v
	return s
}

// SetImpactLevel sets the ImpactLevel field's value.
func (s *JobMetadata) SetImpactLevel(v string) *JobMetadata {
	s.ImpactLevel = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *JobMetadata) SetJobId(v string) *JobMetadata {
	s.JobId = &v
	return s
}

// SetJobLogInfo sets the JobLogInfo field's value.
func (s *JobMetadata) SetJobLogInfo(v *JobLogs) *JobMetadata {
	s.JobLogInfo = v
	return s
}

// SetJobState sets the JobState field's value.
func (s *JobMetadata) SetJobState(v string) *JobMetadata {
	s.JobState = &v
	return s
}

// SetJobType sets the JobType field's value.
func (s *JobMetadata) SetJobType(v string) *JobMetadata {
	s.JobType = &v
	return s
}

// SetKmsKeyARN sets the KmsKeyARN field's value.
func (s *JobMetadata) SetKmsKeyARN(v string) *JobMetadata {
	s.KmsKeyARN = &v
	return s
}

// SetLongTermPricingId sets the LongTermPricingId field's value.
func (s *JobMetadata) SetLongTermPricingId(v string) *JobMetadata {
	s.LongTermPricingId = &v
	return s
}

// SetNotification sets the Notification field's value.
func (s *JobMetadata) SetNotification(v *Notification) *JobMetadata {
	s.Notification = v
	return s
}

// SetOnDeviceServiceConfiguration sets the OnDeviceServiceConfiguration field's value.
func (s *JobMetadata) SetOnDeviceServiceConfiguration(v *OnDeviceServiceConfiguration) *JobMetadata {
	s.OnDeviceServiceConfiguration = v
	return s
}

// SetPickupDetails sets the PickupDetails field's value.
func (s *JobMetadata) SetPickupDetails(v *PickupDetails) *JobMetadata {
	s.PickupDetails = v
	return s
}

// SetRemoteManagement sets the RemoteManagement field's value.
func (s *JobMetadata) SetRemoteManagement(v string) *JobMetadata {
	s.RemoteManagement = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *JobMetadata) SetResources(v *JobResource) *JobMetadata {
	s.Resources = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *JobMetadata) SetRoleARN(v string) *JobMetadata {
	s.RoleARN = &v
	return s
}

// SetShippingDetails sets the ShippingDetails field's value.
func (s *JobMetadata) SetShippingDetails(v *ShippingDetails) *JobMetadata {
	s.ShippingDetails = v
	return s
}

// SetSnowballCapacityPreference sets the SnowballCapacityPreference field's value.
func (s *JobMetadata) SetSnowballCapacityPreference(v string) *JobMetadata {
	s.SnowballCapacityPreference = &v
	return s
}

// SetSnowballId sets the SnowballId field's value.
func (s *JobMetadata) SetSnowballId(v string) *JobMetadata {
	s.SnowballId = &v
	return s
}

// SetSnowballType sets the SnowballType field's value.
func (s *JobMetadata) SetSnowballType(v string) *JobMetadata {
	s.SnowballType = &v
	return s
}

// SetTaxDocuments sets the TaxDocuments field's value.
func (s *JobMetadata) SetTaxDocuments(v *TaxDocuments) *JobMetadata {
	s.TaxDocuments = v
	return s
}

// Contains an array of Amazon Web Services resource objects. Each object represents
// an Amazon S3 bucket, an Lambda function, or an Amazon Machine Image (AMI)
// based on Amazon EC2 that is associated with a particular job.
type JobResource struct {
	_ struct{} `type:"structure"`

	// The Amazon Machine Images (AMIs) associated with this job.
	Ec2AmiResources []*Ec2AmiResource `type:"list"`

	// The Python-language Lambda functions for this job.
	LambdaResources []*LambdaResource `type:"list"`

	// An array of S3Resource objects.
	S3Resources []*S3Resource `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobResource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobResource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JobResource"}
	if s.Ec2AmiResources != nil {
		for i, v := range s.Ec2AmiResources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Ec2AmiResources", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.S3Resources != nil {
		for i, v := range s.S3Resources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "S3Resources", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEc2AmiResources sets the Ec2AmiResources field's value.
func (s *JobResource) SetEc2AmiResources(v []*Ec2AmiResource) *JobResource {
	s.Ec2AmiResources = v
	return s
}

// SetLambdaResources sets the LambdaResources field's value.
func (s *JobResource) SetLambdaResources(v []*LambdaResource) *JobResource {
	s.LambdaResources = v
	return s
}

// SetS3Resources sets the S3Resources field's value.
func (s *JobResource) SetS3Resources(v []*S3Resource) *JobResource {
	s.S3Resources = v
	return s
}

// The provided Key Management Service key lacks the permissions to perform
// the specified CreateJob or UpdateJob action.
type KMSRequestFailedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KMSRequestFailedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KMSRequestFailedException) GoString() string {
	return s.String()
}

func newErrorKMSRequestFailedException(v protocol.ResponseMetadata) error {
	return &KMSRequestFailedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *KMSRequestFailedException) Code() string {
	return "KMSRequestFailedException"
}

// Message returns the exception's message.
func (s *KMSRequestFailedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *KMSRequestFailedException) OrigErr() error {
	return nil
}

func (s *KMSRequestFailedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *KMSRequestFailedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *KMSRequestFailedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains a key range. For export jobs, a S3Resource object can have an optional
// KeyRange value. The length of the range is defined at job creation, and has
// either an inclusive BeginMarker, an inclusive EndMarker, or both. Ranges
// are UTF-8 binary sorted.
type KeyRange struct {
	_ struct{} `type:"structure"`

	// The key that starts an optional key range for an export job. Ranges are inclusive
	// and UTF-8 binary sorted.
	BeginMarker *string `min:"1" type:"string"`

	// The key that ends an optional key range for an export job. Ranges are inclusive
	// and UTF-8 binary sorted.
	EndMarker *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KeyRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KeyRange"}
	if s.BeginMarker != nil && len(*s.BeginMarker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BeginMarker", 1))
	}
	if s.EndMarker != nil && len(*s.EndMarker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EndMarker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBeginMarker sets the BeginMarker field's value.
func (s *KeyRange) SetBeginMarker(v string) *KeyRange {
	s.BeginMarker = &v
	return s
}

// SetEndMarker sets the EndMarker field's value.
func (s *KeyRange) SetEndMarker(v string) *KeyRange {
	s.EndMarker = &v
	return s
}

// Identifies
type LambdaResource struct {
	_ struct{} `type:"structure"`

	// The array of ARNs for S3Resource objects to trigger the LambdaResource objects
	// associated with this job.
	EventTriggers []*EventTriggerDefinition `type:"list"`

	// An Amazon Resource Name (ARN) that represents an Lambda function to be triggered
	// by PUT object actions on the associated local Amazon S3 resource.
	LambdaArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaResource) GoString() string {
	return s.String()
}

// SetEventTriggers sets the EventTriggers field's value.
func (s *LambdaResource) SetEventTriggers(v []*EventTriggerDefinition) *LambdaResource {
	s.EventTriggers = v
	return s
}

// SetLambdaArn sets the LambdaArn field's value.
func (s *LambdaResource) SetLambdaArn(v string) *LambdaResource {
	s.LambdaArn = &v
	return s
}

type ListClusterJobsInput struct {
	_ struct{} `type:"structure"`

	// The 39-character ID for the cluster that you want to list, for example CID123e4567-e89b-12d3-a456-426655440000.
	//
	// ClusterId is a required field
	ClusterId *string `min:"39" type:"string" required:"true"`

	// The number of JobListEntry objects to return.
	MaxResults *int64 `type:"integer"`

	// HTTP requests are stateless. To identify what object comes "next" in the
	// list of JobListEntry objects, you have the option of specifying NextToken
	// as the starting point for your returned list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClusterJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClusterJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListClusterJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListClusterJobsInput"}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}
	if s.ClusterId != nil && len(*s.ClusterId) < 39 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterId", 39))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterId sets the ClusterId field's value.
func (s *ListClusterJobsInput) SetClusterId(v string) *ListClusterJobsInput {
	s.ClusterId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListClusterJobsInput) SetMaxResults(v int64) *ListClusterJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListClusterJobsInput) SetNextToken(v string) *ListClusterJobsInput {
	s.NextToken = &v
	return s
}

type ListClusterJobsOutput struct {
	_ struct{} `type:"structure"`

	// Each JobListEntry object contains a job's state, a job's ID, and a value
	// that indicates whether the job is a job part, in the case of export jobs.
	JobListEntries []*JobListEntry `type:"list"`

	// HTTP requests are stateless. If you use the automatically generated NextToken
	// value in your next ListClusterJobsResult call, your list of returned jobs
	// will start from this point in the array.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClusterJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClusterJobsOutput) GoString() string {
	return s.String()
}

// SetJobListEntries sets the JobListEntries field's value.
func (s *ListClusterJobsOutput) SetJobListEntries(v []*JobListEntry) *ListClusterJobsOutput {
	s.JobListEntries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListClusterJobsOutput) SetNextToken(v string) *ListClusterJobsOutput {
	s.NextToken = &v
	return s
}

type ListClustersInput struct {
	_ struct{} `type:"structure"`

	// The number of ClusterListEntry objects to return.
	MaxResults *int64 `type:"integer"`

	// HTTP requests are stateless. To identify what object comes "next" in the
	// list of ClusterListEntry objects, you have the option of specifying NextToken
	// as the starting point for your returned list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClustersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClustersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListClustersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListClustersInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListClustersInput) SetMaxResults(v int64) *ListClustersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListClustersInput) SetNextToken(v string) *ListClustersInput {
	s.NextToken = &v
	return s
}

type ListClustersOutput struct {
	_ struct{} `type:"structure"`

	// Each ClusterListEntry object contains a cluster's state, a cluster's ID,
	// and other important status information.
	ClusterListEntries []*ClusterListEntry `type:"list"`

	// HTTP requests are stateless. If you use the automatically generated NextToken
	// value in your next ClusterListEntry call, your list of returned clusters
	// will start from this point in the array.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClustersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClustersOutput) GoString() string {
	return s.String()
}

// SetClusterListEntries sets the ClusterListEntries field's value.
func (s *ListClustersOutput) SetClusterListEntries(v []*ClusterListEntry) *ListClustersOutput {
	s.ClusterListEntries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListClustersOutput) SetNextToken(v string) *ListClustersOutput {
	s.NextToken = &v
	return s
}

type ListCompatibleImagesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results for the list of compatible images. Currently,
	// a Snowball Edge device can store 10 AMIs.
	MaxResults *int64 `type:"integer"`

	// HTTP requests are stateless. To identify what object comes "next" in the
	// list of compatible images, you can specify a value for NextToken as the starting
	// point for your list of returned images.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCompatibleImagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCompatibleImagesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCompatibleImagesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCompatibleImagesInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCompatibleImagesInput) SetMaxResults(v int64) *ListCompatibleImagesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCompatibleImagesInput) SetNextToken(v string) *ListCompatibleImagesInput {
	s.NextToken = &v
	return s
}

type ListCompatibleImagesOutput struct {
	_ struct{} `type:"structure"`

	// A JSON-formatted object that describes a compatible AMI, including the ID
	// and name for a Snow device AMI.
	CompatibleImages []*CompatibleImage `type:"list"`

	// Because HTTP requests are stateless, this is the starting point for your
	// next list of returned images.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCompatibleImagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCompatibleImagesOutput) GoString() string {
	return s.String()
}

// SetCompatibleImages sets the CompatibleImages field's value.
func (s *ListCompatibleImagesOutput) SetCompatibleImages(v []*CompatibleImage) *ListCompatibleImagesOutput {
	s.CompatibleImages = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCompatibleImagesOutput) SetNextToken(v string) *ListCompatibleImagesOutput {
	s.NextToken = &v
	return s
}

type ListJobsInput struct {
	_ struct{} `type:"structure"`

	// The number of JobListEntry objects to return.
	MaxResults *int64 `type:"integer"`

	// HTTP requests are stateless. To identify what object comes "next" in the
	// list of JobListEntry objects, you have the option of specifying NextToken
	// as the starting point for your returned list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListJobsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListJobsInput) SetMaxResults(v int64) *ListJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJobsInput) SetNextToken(v string) *ListJobsInput {
	s.NextToken = &v
	return s
}

type ListJobsOutput struct {
	_ struct{} `type:"structure"`

	// Each JobListEntry object contains a job's state, a job's ID, and a value
	// that indicates whether the job is a job part, in the case of export jobs.
	JobListEntries []*JobListEntry `type:"list"`

	// HTTP requests are stateless. If you use this automatically generated NextToken
	// value in your next ListJobs call, your returned JobListEntry objects will
	// start from this point in the array.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobsOutput) GoString() string {
	return s.String()
}

// SetJobListEntries sets the JobListEntries field's value.
func (s *ListJobsOutput) SetJobListEntries(v []*JobListEntry) *ListJobsOutput {
	s.JobListEntries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJobsOutput) SetNextToken(v string) *ListJobsOutput {
	s.NextToken = &v
	return s
}

type ListLongTermPricingInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of ListLongTermPricing objects to return.
	MaxResults *int64 `type:"integer"`

	// Because HTTP requests are stateless, this is the starting point for your
	// next list of ListLongTermPricing to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLongTermPricingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLongTermPricingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLongTermPricingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLongTermPricingInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListLongTermPricingInput) SetMaxResults(v int64) *ListLongTermPricingInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLongTermPricingInput) SetNextToken(v string) *ListLongTermPricingInput {
	s.NextToken = &v
	return s
}

type ListLongTermPricingOutput struct {
	_ struct{} `type:"structure"`

	// Each LongTermPricingEntry object contains a status, ID, and other information
	// about the LongTermPricing type.
	LongTermPricingEntries []*LongTermPricingListEntry `type:"list"`

	// Because HTTP requests are stateless, this is the starting point for your
	// next list of returned ListLongTermPricing list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLongTermPricingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLongTermPricingOutput) GoString() string {
	return s.String()
}

// SetLongTermPricingEntries sets the LongTermPricingEntries field's value.
func (s *ListLongTermPricingOutput) SetLongTermPricingEntries(v []*LongTermPricingListEntry) *ListLongTermPricingOutput {
	s.LongTermPricingEntries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLongTermPricingOutput) SetNextToken(v string) *ListLongTermPricingOutput {
	s.NextToken = &v
	return s
}

type ListPickupLocationsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of locations to list per page.
	MaxResults *int64 `type:"integer"`

	// HTTP requests are stateless. To identify what object comes "next" in the
	// list of ListPickupLocationsRequest objects, you have the option of specifying
	// NextToken as the starting point for your returned list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPickupLocationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPickupLocationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPickupLocationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPickupLocationsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPickupLocationsInput) SetMaxResults(v int64) *ListPickupLocationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPickupLocationsInput) SetNextToken(v string) *ListPickupLocationsInput {
	s.NextToken = &v
	return s
}

type ListPickupLocationsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the address of pickup locations.
	Addresses []*Address `type:"list"`

	// HTTP requests are stateless. To identify what object comes "next" in the
	// list of ListPickupLocationsResult objects, you have the option of specifying
	// NextToken as the starting point for your returned list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPickupLocationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPickupLocationsOutput) GoString() string {
	return s.String()
}

// SetAddresses sets the Addresses field's value.
func (s *ListPickupLocationsOutput) SetAddresses(v []*Address) *ListPickupLocationsOutput {
	s.Addresses = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPickupLocationsOutput) SetNextToken(v string) *ListPickupLocationsOutput {
	s.NextToken = &v
	return s
}

type ListServiceVersionsInput struct {
	_ struct{} `type:"structure"`

	// A list of names and versions of dependant services of the requested service.
	DependentServices []*DependentService `type:"list"`

	// The maximum number of ListServiceVersions objects to return.
	MaxResults *int64 `type:"integer"`

	// Because HTTP requests are stateless, this is the starting point for the next
	// list of returned ListServiceVersionsRequest versions.
	NextToken *string `min:"1" type:"string"`

	// The name of the service for which you're requesting supported versions.
	//
	// ServiceName is a required field
	ServiceName *string `type:"string" required:"true" enum:"ServiceName"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListServiceVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListServiceVersionsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceName"))
	}
	if s.DependentServices != nil {
		for i, v := range s.DependentServices {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DependentServices", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDependentServices sets the DependentServices field's value.
func (s *ListServiceVersionsInput) SetDependentServices(v []*DependentService) *ListServiceVersionsInput {
	s.DependentServices = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListServiceVersionsInput) SetMaxResults(v int64) *ListServiceVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServiceVersionsInput) SetNextToken(v string) *ListServiceVersionsInput {
	s.NextToken = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *ListServiceVersionsInput) SetServiceName(v string) *ListServiceVersionsInput {
	s.ServiceName = &v
	return s
}

type ListServiceVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of names and versions of dependant services of the service for which
	// the system provided supported versions.
	DependentServices []*DependentService `type:"list"`

	// Because HTTP requests are stateless, this is the starting point of the next
	// list of returned ListServiceVersionsResult results.
	NextToken *string `min:"1" type:"string"`

	// The name of the service for which the system provided supported versions.
	//
	// ServiceName is a required field
	ServiceName *string `type:"string" required:"true" enum:"ServiceName"`

	// A list of supported versions.
	//
	// ServiceVersions is a required field
	ServiceVersions []*ServiceVersion `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceVersionsOutput) GoString() string {
	return s.String()
}

// SetDependentServices sets the DependentServices field's value.
func (s *ListServiceVersionsOutput) SetDependentServices(v []*DependentService) *ListServiceVersionsOutput {
	s.DependentServices = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServiceVersionsOutput) SetNextToken(v string) *ListServiceVersionsOutput {
	s.NextToken = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *ListServiceVersionsOutput) SetServiceName(v string) *ListServiceVersionsOutput {
	s.ServiceName = &v
	return s
}

// SetServiceVersions sets the ServiceVersions field's value.
func (s *ListServiceVersionsOutput) SetServiceVersions(v []*ServiceVersion) *ListServiceVersionsOutput {
	s.ServiceVersions = v
	return s
}

// Each LongTermPricingListEntry object contains information about a long-term
// pricing type.
type LongTermPricingListEntry struct {
	_ struct{} `type:"structure"`

	// The current active jobs on the device the long-term pricing type.
	CurrentActiveJob *string `min:"39" type:"string"`

	// If set to true, specifies that the current long-term pricing type for the
	// device should be automatically renewed before the long-term pricing contract
	// expires.
	IsLongTermPricingAutoRenew *bool `type:"boolean"`

	// The IDs of the jobs that are associated with a long-term pricing type.
	JobIds []*string `type:"list"`

	// The end date the long-term pricing contract.
	LongTermPricingEndDate *time.Time `type:"timestamp"`

	// The ID of the long-term pricing type for the device.
	LongTermPricingId *string `min:"41" type:"string"`

	// The start date of the long-term pricing contract.
	LongTermPricingStartDate *time.Time `type:"timestamp"`

	// The status of the long-term pricing type.
	LongTermPricingStatus *string `min:"1" type:"string"`

	// The type of long-term pricing that was selected for the device.
	LongTermPricingType *string `type:"string" enum:"LongTermPricingType"`

	// A new device that replaces a device that is ordered with long-term pricing.
	ReplacementJob *string `min:"39" type:"string"`

	// The type of Snow Family devices associated with this long-term pricing job.
	SnowballType *string `type:"string" enum:"Type"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LongTermPricingListEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LongTermPricingListEntry) GoString() string {
	return s.String()
}

// SetCurrentActiveJob sets the CurrentActiveJob field's value.
func (s *LongTermPricingListEntry) SetCurrentActiveJob(v string) *LongTermPricingListEntry {
	s.CurrentActiveJob = &v
	return s
}

// SetIsLongTermPricingAutoRenew sets the IsLongTermPricingAutoRenew field's value.
func (s *LongTermPricingListEntry) SetIsLongTermPricingAutoRenew(v bool) *LongTermPricingListEntry {
	s.IsLongTermPricingAutoRenew = &v
	return s
}

// SetJobIds sets the JobIds field's value.
func (s *LongTermPricingListEntry) SetJobIds(v []*string) *LongTermPricingListEntry {
	s.JobIds = v
	return s
}

// SetLongTermPricingEndDate sets the LongTermPricingEndDate field's value.
func (s *LongTermPricingListEntry) SetLongTermPricingEndDate(v time.Time) *LongTermPricingListEntry {
	s.LongTermPricingEndDate = &v
	return s
}

// SetLongTermPricingId sets the LongTermPricingId field's value.
func (s *LongTermPricingListEntry) SetLongTermPricingId(v string) *LongTermPricingListEntry {
	s.LongTermPricingId = &v
	return s
}

// SetLongTermPricingStartDate sets the LongTermPricingStartDate field's value.
func (s *LongTermPricingListEntry) SetLongTermPricingStartDate(v time.Time) *LongTermPricingListEntry {
	s.LongTermPricingStartDate = &v
	return s
}

// SetLongTermPricingStatus sets the LongTermPricingStatus field's value.
func (s *LongTermPricingListEntry) SetLongTermPricingStatus(v string) *LongTermPricingListEntry {
	s.LongTermPricingStatus = &v
	return s
}

// SetLongTermPricingType sets the LongTermPricingType field's value.
func (s *LongTermPricingListEntry) SetLongTermPricingType(v string) *LongTermPricingListEntry {
	s.LongTermPricingType = &v
	return s
}

// SetReplacementJob sets the ReplacementJob field's value.
func (s *LongTermPricingListEntry) SetReplacementJob(v string) *LongTermPricingListEntry {
	s.ReplacementJob = &v
	return s
}

// SetSnowballType sets the SnowballType field's value.
func (s *LongTermPricingListEntry) SetSnowballType(v string) *LongTermPricingListEntry {
	s.SnowballType = &v
	return s
}

// An object that represents the metadata and configuration settings for the
// NFS (Network File System) service on an Amazon Web Services Snow Family device.
type NFSOnDeviceServiceConfiguration struct {
	_ struct{} `type:"structure"`

	// The maximum NFS storage for one Snow Family device.
	StorageLimit *int64 `type:"integer"`

	// The scale unit of the NFS storage on the device.
	//
	// Valid values: TB.
	StorageUnit *string `type:"string" enum:"StorageUnit"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NFSOnDeviceServiceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NFSOnDeviceServiceConfiguration) GoString() string {
	return s.String()
}

// SetStorageLimit sets the StorageLimit field's value.
func (s *NFSOnDeviceServiceConfiguration) SetStorageLimit(v int64) *NFSOnDeviceServiceConfiguration {
	s.StorageLimit = &v
	return s
}

// SetStorageUnit sets the StorageUnit field's value.
func (s *NFSOnDeviceServiceConfiguration) SetStorageUnit(v string) *NFSOnDeviceServiceConfiguration {
	s.StorageUnit = &v
	return s
}

// The Amazon Simple Notification Service (Amazon SNS) notification settings
// associated with a specific job. The Notification object is returned as a
// part of the response syntax of the DescribeJob action in the JobMetadata
// data type.
//
// When the notification settings are defined during job creation, you can choose
// to notify based on a specific set of job states using the JobStatesToNotify
// array of strings, or you can specify that you want to have Amazon SNS notifications
// sent out for all job states with NotifyAll set to true.
type Notification struct {
	_ struct{} `type:"structure"`

	// Used to send SNS notifications for the person picking up the device (identified
	// during job creation).
	DevicePickupSnsTopicARN *string `type:"string"`

	// The list of job states that will trigger a notification for this job.
	JobStatesToNotify []*string `type:"list" enum:"JobState"`

	// Any change in job state will trigger a notification for this job.
	NotifyAll *bool `type:"boolean"`

	// The new SNS TopicArn that you want to associate with this job. You can create
	// Amazon Resource Names (ARNs) for topics by using the CreateTopic (https://docs.aws.amazon.com/sns/latest/api/API_CreateTopic.html)
	// Amazon SNS API action.
	//
	// You can subscribe email addresses to an Amazon SNS topic through the Amazon
	// Web Services Management Console, or by using the Subscribe (https://docs.aws.amazon.com/sns/latest/api/API_Subscribe.html)
	// Amazon Simple Notification Service (Amazon SNS) API action.
	SnsTopicARN *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Notification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Notification) GoString() string {
	return s.String()
}

// SetDevicePickupSnsTopicARN sets the DevicePickupSnsTopicARN field's value.
func (s *Notification) SetDevicePickupSnsTopicARN(v string) *Notification {
	s.DevicePickupSnsTopicARN = &v
	return s
}

// SetJobStatesToNotify sets the JobStatesToNotify field's value.
func (s *Notification) SetJobStatesToNotify(v []*string) *Notification {
	s.JobStatesToNotify = v
	return s
}

// SetNotifyAll sets the NotifyAll field's value.
func (s *Notification) SetNotifyAll(v bool) *Notification {
	s.NotifyAll = &v
	return s
}

// SetSnsTopicARN sets the SnsTopicARN field's value.
func (s *Notification) SetSnsTopicARN(v string) *Notification {
	s.SnsTopicARN = &v
	return s
}

// An object that represents the metadata and configuration settings for services
// on an Amazon Web Services Snow Family device.
type OnDeviceServiceConfiguration struct {
	_ struct{} `type:"structure"`

	// The configuration of EKS Anywhere on the Snow Family device.
	EKSOnDeviceService *EKSOnDeviceServiceConfiguration `type:"structure"`

	// Represents the NFS (Network File System) service on a Snow Family device.
	NFSOnDeviceService *NFSOnDeviceServiceConfiguration `type:"structure"`

	// Configuration for Amazon S3 compatible storage on Snow family devices.
	S3OnDeviceService *S3OnDeviceServiceConfiguration `type:"structure"`

	// Represents the Storage Gateway service Tape Gateway type on a Snow Family
	// device.
	TGWOnDeviceService *TGWOnDeviceServiceConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OnDeviceServiceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OnDeviceServiceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OnDeviceServiceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OnDeviceServiceConfiguration"}
	if s.EKSOnDeviceService != nil {
		if err := s.EKSOnDeviceService.Validate(); err != nil {
			invalidParams.AddNested("EKSOnDeviceService", err.(request.ErrInvalidParams))
		}
	}
	if s.S3OnDeviceService != nil {
		if err := s.S3OnDeviceService.Validate(); err != nil {
			invalidParams.AddNested("S3OnDeviceService", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEKSOnDeviceService sets the EKSOnDeviceService field's value.
func (s *OnDeviceServiceConfiguration) SetEKSOnDeviceService(v *EKSOnDeviceServiceConfiguration) *OnDeviceServiceConfiguration {
	s.EKSOnDeviceService = v
	return s
}

// SetNFSOnDeviceService sets the NFSOnDeviceService field's value.
func (s *OnDeviceServiceConfiguration) SetNFSOnDeviceService(v *NFSOnDeviceServiceConfiguration) *OnDeviceServiceConfiguration {
	s.NFSOnDeviceService = v
	return s
}

// SetS3OnDeviceService sets the S3OnDeviceService field's value.
func (s *OnDeviceServiceConfiguration) SetS3OnDeviceService(v *S3OnDeviceServiceConfiguration) *OnDeviceServiceConfiguration {
	s.S3OnDeviceService = v
	return s
}

// SetTGWOnDeviceService sets the TGWOnDeviceService field's value.
func (s *OnDeviceServiceConfiguration) SetTGWOnDeviceService(v *TGWOnDeviceServiceConfiguration) *OnDeviceServiceConfiguration {
	s.TGWOnDeviceService = v
	return s
}

// Information identifying the person picking up the device.
type PickupDetails struct {
	_ struct{} `type:"structure"`

	// The unique ID for a device that will be picked up.
	DevicePickupId *string `min:"40" type:"string"`

	// The email address of the person picking up the device.
	//
	// Email is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PickupDetails's
	// String and GoString methods.
	Email *string `min:"3" type:"string" sensitive:"true"`

	// Expiration date of the credential identifying the person picking up the device.
	IdentificationExpirationDate *time.Time `type:"timestamp"`

	// Organization that issued the credential identifying the person picking up
	// the device.
	IdentificationIssuingOrg *string `min:"1" type:"string"`

	// The number on the credential identifying the person picking up the device.
	IdentificationNumber *string `min:"1" type:"string"`

	// The name of the person picking up the device.
	Name *string `min:"1" type:"string"`

	// The phone number of the person picking up the device.
	//
	// PhoneNumber is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PickupDetails's
	// String and GoString methods.
	PhoneNumber *string `min:"7" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PickupDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PickupDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PickupDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PickupDetails"}
	if s.DevicePickupId != nil && len(*s.DevicePickupId) < 40 {
		invalidParams.Add(request.NewErrParamMinLen("DevicePickupId", 40))
	}
	if s.Email != nil && len(*s.Email) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Email", 3))
	}
	if s.IdentificationIssuingOrg != nil && len(*s.IdentificationIssuingOrg) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentificationIssuingOrg", 1))
	}
	if s.IdentificationNumber != nil && len(*s.IdentificationNumber) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentificationNumber", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.PhoneNumber != nil && len(*s.PhoneNumber) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("PhoneNumber", 7))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDevicePickupId sets the DevicePickupId field's value.
func (s *PickupDetails) SetDevicePickupId(v string) *PickupDetails {
	s.DevicePickupId = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *PickupDetails) SetEmail(v string) *PickupDetails {
	s.Email = &v
	return s
}

// SetIdentificationExpirationDate sets the IdentificationExpirationDate field's value.
func (s *PickupDetails) SetIdentificationExpirationDate(v time.Time) *PickupDetails {
	s.IdentificationExpirationDate = &v
	return s
}

// SetIdentificationIssuingOrg sets the IdentificationIssuingOrg field's value.
func (s *PickupDetails) SetIdentificationIssuingOrg(v string) *PickupDetails {
	s.IdentificationIssuingOrg = &v
	return s
}

// SetIdentificationNumber sets the IdentificationNumber field's value.
func (s *PickupDetails) SetIdentificationNumber(v string) *PickupDetails {
	s.IdentificationNumber = &v
	return s
}

// SetName sets the Name field's value.
func (s *PickupDetails) SetName(v string) *PickupDetails {
	s.Name = &v
	return s
}

// SetPhoneNumber sets the PhoneNumber field's value.
func (s *PickupDetails) SetPhoneNumber(v string) *PickupDetails {
	s.PhoneNumber = &v
	return s
}

// You get this exception if you call CreateReturnShippingLabel and a valid
// return shipping label already exists. In this case, use DescribeReturnShippingLabel
// to get the URL.
type ReturnShippingLabelAlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReturnShippingLabelAlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReturnShippingLabelAlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorReturnShippingLabelAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &ReturnShippingLabelAlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ReturnShippingLabelAlreadyExistsException) Code() string {
	return "ReturnShippingLabelAlreadyExistsException"
}

// Message returns the exception's message.
func (s *ReturnShippingLabelAlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ReturnShippingLabelAlreadyExistsException) OrigErr() error {
	return nil
}

func (s *ReturnShippingLabelAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ReturnShippingLabelAlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ReturnShippingLabelAlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Amazon S3 compatible storage on Snow family devices configuration items.
type S3OnDeviceServiceConfiguration struct {
	_ struct{} `type:"structure"`

	// >Fault tolerance level of the cluster. This indicates the number of nodes
	// that can go down without degrading the performance of the cluster. This additional
	// input helps when the specified StorageLimit matches more than one Amazon
	// S3 compatible storage on Snow family devices service configuration.
	FaultTolerance *int64 `min:"1" type:"integer"`

	// Applicable when creating a cluster. Specifies how many nodes are needed for
	// Amazon S3 compatible storage on Snow family devices. If specified, the other
	// input can be omitted.
	ServiceSize *int64 `min:"3" type:"integer"`

	// If the specified storage limit value matches storage limit of one of the
	// defined configurations, that configuration will be used. If the specified
	// storage limit value does not match any defined configuration, the request
	// will fail. If more than one configuration has the same storage limit as specified,
	// the other input need to be provided.
	StorageLimit *float64 `type:"double"`

	// Storage unit. Currently the only supported unit is TB.
	StorageUnit *string `type:"string" enum:"StorageUnit"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3OnDeviceServiceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3OnDeviceServiceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3OnDeviceServiceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3OnDeviceServiceConfiguration"}
	if s.FaultTolerance != nil && *s.FaultTolerance < 1 {
		invalidParams.Add(request.NewErrParamMinValue("FaultTolerance", 1))
	}
	if s.ServiceSize != nil && *s.ServiceSize < 3 {
		invalidParams.Add(request.NewErrParamMinValue("ServiceSize", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFaultTolerance sets the FaultTolerance field's value.
func (s *S3OnDeviceServiceConfiguration) SetFaultTolerance(v int64) *S3OnDeviceServiceConfiguration {
	s.FaultTolerance = &v
	return s
}

// SetServiceSize sets the ServiceSize field's value.
func (s *S3OnDeviceServiceConfiguration) SetServiceSize(v int64) *S3OnDeviceServiceConfiguration {
	s.ServiceSize = &v
	return s
}

// SetStorageLimit sets the StorageLimit field's value.
func (s *S3OnDeviceServiceConfiguration) SetStorageLimit(v float64) *S3OnDeviceServiceConfiguration {
	s.StorageLimit = &v
	return s
}

// SetStorageUnit sets the StorageUnit field's value.
func (s *S3OnDeviceServiceConfiguration) SetStorageUnit(v string) *S3OnDeviceServiceConfiguration {
	s.StorageUnit = &v
	return s
}

// Each S3Resource object represents an Amazon S3 bucket that your transferred
// data will be exported from or imported into. For export jobs, this object
// can have an optional KeyRange value. The length of the range is defined at
// job creation, and has either an inclusive BeginMarker, an inclusive EndMarker,
// or both. Ranges are UTF-8 binary sorted.
type S3Resource struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an Amazon S3 bucket.
	BucketArn *string `type:"string"`

	// For export jobs, you can provide an optional KeyRange within a specific Amazon
	// S3 bucket. The length of the range is defined at job creation, and has either
	// an inclusive BeginMarker, an inclusive EndMarker, or both. Ranges are UTF-8
	// binary sorted.
	KeyRange *KeyRange `type:"structure"`

	// Specifies the service or services on the Snow Family device that your transferred
	// data will be exported from or imported into. Amazon Web Services Snow Family
	// supports Amazon S3 and NFS (Network File System).
	TargetOnDeviceServices []*TargetOnDeviceService `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Resource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Resource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Resource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Resource"}
	if s.KeyRange != nil {
		if err := s.KeyRange.Validate(); err != nil {
			invalidParams.AddNested("KeyRange", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketArn sets the BucketArn field's value.
func (s *S3Resource) SetBucketArn(v string) *S3Resource {
	s.BucketArn = &v
	return s
}

// SetKeyRange sets the KeyRange field's value.
func (s *S3Resource) SetKeyRange(v *KeyRange) *S3Resource {
	s.KeyRange = v
	return s
}

// SetTargetOnDeviceServices sets the TargetOnDeviceServices field's value.
func (s *S3Resource) SetTargetOnDeviceServices(v []*TargetOnDeviceService) *S3Resource {
	s.TargetOnDeviceServices = v
	return s
}

// The version of the requested service.
type ServiceVersion struct {
	_ struct{} `type:"structure"`

	// The version number of the requested service.
	Version *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceVersion) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServiceVersion) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ServiceVersion"}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVersion sets the Version field's value.
func (s *ServiceVersion) SetVersion(v string) *ServiceVersion {
	s.Version = &v
	return s
}

// The Status and TrackingNumber information for an inbound or outbound shipment.
type Shipment struct {
	_ struct{} `type:"structure"`

	// Status information for a shipment.
	Status *string `min:"1" type:"string"`

	// The tracking number for this job. Using this tracking number with your region's
	// carrier's website, you can track a Snow device as the carrier transports
	// it.
	//
	// For India, the carrier is Amazon Logistics. For all other regions, UPS is
	// the carrier.
	TrackingNumber *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Shipment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Shipment) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *Shipment) SetStatus(v string) *Shipment {
	s.Status = &v
	return s
}

// SetTrackingNumber sets the TrackingNumber field's value.
func (s *Shipment) SetTrackingNumber(v string) *Shipment {
	s.TrackingNumber = &v
	return s
}

// A job's shipping information, including inbound and outbound tracking numbers
// and shipping speed options.
type ShippingDetails struct {
	_ struct{} `type:"structure"`

	// The Status and TrackingNumber values for a Snow device being returned to
	// Amazon Web Services for a particular job.
	InboundShipment *Shipment `type:"structure"`

	// The Status and TrackingNumber values for a Snow device being delivered to
	// the address that you specified for a particular job.
	OutboundShipment *Shipment `type:"structure"`

	// The shipping speed for a particular job. This speed doesn't dictate how soon
	// you'll get the Snow device from the job's creation date. This speed represents
	// how quickly it moves to its destination while in transit. Regional shipping
	// speeds are as follows:
	//
	//    * In Australia, you have access to express shipping. Typically, Snow devices
	//    shipped express are delivered in about a day.
	//
	//    * In the European Union (EU), you have access to express shipping. Typically,
	//    Snow devices shipped express are delivered in about a day. In addition,
	//    most countries in the EU have access to standard shipping, which typically
	//    takes less than a week, one way.
	//
	//    * In India, Snow devices are delivered in one to seven days.
	//
	//    * In the United States of America (US), you have access to one-day shipping
	//    and two-day shipping.
	ShippingOption *string `type:"string" enum:"ShippingOption"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ShippingDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ShippingDetails) GoString() string {
	return s.String()
}

// SetInboundShipment sets the InboundShipment field's value.
func (s *ShippingDetails) SetInboundShipment(v *Shipment) *ShippingDetails {
	s.InboundShipment = v
	return s
}

// SetOutboundShipment sets the OutboundShipment field's value.
func (s *ShippingDetails) SetOutboundShipment(v *Shipment) *ShippingDetails {
	s.OutboundShipment = v
	return s
}

// SetShippingOption sets the ShippingOption field's value.
func (s *ShippingDetails) SetShippingOption(v string) *ShippingDetails {
	s.ShippingOption = &v
	return s
}

// Specifies the device configuration for an Snowcone job.
type SnowconeDeviceConfiguration struct {
	_ struct{} `type:"structure"`

	// Configures the wireless connection for the Snowcone device.
	WirelessConnection *WirelessConnection `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SnowconeDeviceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SnowconeDeviceConfiguration) GoString() string {
	return s.String()
}

// SetWirelessConnection sets the WirelessConnection field's value.
func (s *SnowconeDeviceConfiguration) SetWirelessConnection(v *WirelessConnection) *SnowconeDeviceConfiguration {
	s.WirelessConnection = v
	return s
}

// An object that represents the metadata and configuration settings for the
// Storage Gateway service Tape Gateway type on an Amazon Web Services Snow
// Family device.
type TGWOnDeviceServiceConfiguration struct {
	_ struct{} `type:"structure"`

	// The maximum number of virtual tapes to store on one Snow Family device. Due
	// to physical resource limitations, this value must be set to 80 for Snowball
	// Edge.
	StorageLimit *int64 `type:"integer"`

	// The scale unit of the virtual tapes on the device.
	StorageUnit *string `type:"string" enum:"StorageUnit"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TGWOnDeviceServiceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TGWOnDeviceServiceConfiguration) GoString() string {
	return s.String()
}

// SetStorageLimit sets the StorageLimit field's value.
func (s *TGWOnDeviceServiceConfiguration) SetStorageLimit(v int64) *TGWOnDeviceServiceConfiguration {
	s.StorageLimit = &v
	return s
}

// SetStorageUnit sets the StorageUnit field's value.
func (s *TGWOnDeviceServiceConfiguration) SetStorageUnit(v string) *TGWOnDeviceServiceConfiguration {
	s.StorageUnit = &v
	return s
}

// An object that represents the service or services on the Snow Family device
// that your transferred data will be exported from or imported into. Amazon
// Web Services Snow Family supports Amazon S3 and NFS (Network File System).
type TargetOnDeviceService struct {
	_ struct{} `type:"structure"`

	// Specifies the name of the service on the Snow Family device that your transferred
	// data will be exported from or imported into.
	ServiceName *string `type:"string" enum:"DeviceServiceName"`

	// Specifies whether the data is being imported or exported. You can import
	// or export the data, or use it locally on the device.
	TransferOption *string `type:"string" enum:"TransferOption"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetOnDeviceService) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetOnDeviceService) GoString() string {
	return s.String()
}

// SetServiceName sets the ServiceName field's value.
func (s *TargetOnDeviceService) SetServiceName(v string) *TargetOnDeviceService {
	s.ServiceName = &v
	return s
}

// SetTransferOption sets the TransferOption field's value.
func (s *TargetOnDeviceService) SetTransferOption(v string) *TargetOnDeviceService {
	s.TransferOption = &v
	return s
}

// The tax documents required in your Amazon Web Services Region.
type TaxDocuments struct {
	_ struct{} `type:"structure"`

	// The tax documents required in Amazon Web Services Region in India.
	IND *INDTaxDocuments `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaxDocuments) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaxDocuments) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TaxDocuments) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TaxDocuments"}
	if s.IND != nil {
		if err := s.IND.Validate(); err != nil {
			invalidParams.AddNested("IND", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIND sets the IND field's value.
func (s *TaxDocuments) SetIND(v *INDTaxDocuments) *TaxDocuments {
	s.IND = v
	return s
}

// The address is either outside the serviceable area for your region, or an
// error occurred. Check the address with your region's carrier and try again.
// If the issue persists, contact Amazon Web Services Support.
type UnsupportedAddressException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedAddressException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedAddressException) GoString() string {
	return s.String()
}

func newErrorUnsupportedAddressException(v protocol.ResponseMetadata) error {
	return &UnsupportedAddressException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnsupportedAddressException) Code() string {
	return "UnsupportedAddressException"
}

// Message returns the exception's message.
func (s *UnsupportedAddressException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnsupportedAddressException) OrigErr() error {
	return nil
}

func (s *UnsupportedAddressException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnsupportedAddressException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnsupportedAddressException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UpdateClusterInput struct {
	_ struct{} `type:"structure"`

	// The ID of the updated Address object.
	AddressId *string `min:"40" type:"string"`

	// The cluster ID of the cluster that you want to update, for example CID123e4567-e89b-12d3-a456-426655440000.
	//
	// ClusterId is a required field
	ClusterId *string `min:"39" type:"string" required:"true"`

	// The updated description of this cluster.
	Description *string `min:"1" type:"string"`

	// The updated ID for the forwarding address for a cluster. This field is not
	// supported in most regions.
	ForwardingAddressId *string `min:"40" type:"string"`

	// The new or updated Notification object.
	Notification *Notification `type:"structure"`

	// Specifies the service or services on the Snow Family device that your transferred
	// data will be exported from or imported into. Amazon Web Services Snow Family
	// device clusters support Amazon S3 and NFS (Network File System).
	OnDeviceServiceConfiguration *OnDeviceServiceConfiguration `type:"structure"`

	// The updated arrays of JobResource objects that can include updated S3Resource
	// objects or LambdaResource objects.
	Resources *JobResource `type:"structure"`

	// The new role Amazon Resource Name (ARN) that you want to associate with this
	// cluster. To create a role ARN, use the CreateRole (https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html)
	// API action in Identity and Access Management (IAM).
	RoleARN *string `type:"string"`

	// The updated shipping option value of this cluster's ShippingDetails object.
	ShippingOption *string `type:"string" enum:"ShippingOption"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateClusterInput"}
	if s.AddressId != nil && len(*s.AddressId) < 40 {
		invalidParams.Add(request.NewErrParamMinLen("AddressId", 40))
	}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}
	if s.ClusterId != nil && len(*s.ClusterId) < 39 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterId", 39))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.ForwardingAddressId != nil && len(*s.ForwardingAddressId) < 40 {
		invalidParams.Add(request.NewErrParamMinLen("ForwardingAddressId", 40))
	}
	if s.OnDeviceServiceConfiguration != nil {
		if err := s.OnDeviceServiceConfiguration.Validate(); err != nil {
			invalidParams.AddNested("OnDeviceServiceConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Resources != nil {
		if err := s.Resources.Validate(); err != nil {
			invalidParams.AddNested("Resources", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddressId sets the AddressId field's value.
func (s *UpdateClusterInput) SetAddressId(v string) *UpdateClusterInput {
	s.AddressId = &v
	return s
}

// SetClusterId sets the ClusterId field's value.
func (s *UpdateClusterInput) SetClusterId(v string) *UpdateClusterInput {
	s.ClusterId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateClusterInput) SetDescription(v string) *UpdateClusterInput {
	s.Description = &v
	return s
}

// SetForwardingAddressId sets the ForwardingAddressId field's value.
func (s *UpdateClusterInput) SetForwardingAddressId(v string) *UpdateClusterInput {
	s.ForwardingAddressId = &v
	return s
}

// SetNotification sets the Notification field's value.
func (s *UpdateClusterInput) SetNotification(v *Notification) *UpdateClusterInput {
	s.Notification = v
	return s
}

// SetOnDeviceServiceConfiguration sets the OnDeviceServiceConfiguration field's value.
func (s *UpdateClusterInput) SetOnDeviceServiceConfiguration(v *OnDeviceServiceConfiguration) *UpdateClusterInput {
	s.OnDeviceServiceConfiguration = v
	return s
}

// SetResources sets the Resources field's value.
func (s *UpdateClusterInput) SetResources(v *JobResource) *UpdateClusterInput {
	s.Resources = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *UpdateClusterInput) SetRoleARN(v string) *UpdateClusterInput {
	s.RoleARN = &v
	return s
}

// SetShippingOption sets the ShippingOption field's value.
func (s *UpdateClusterInput) SetShippingOption(v string) *UpdateClusterInput {
	s.ShippingOption = &v
	return s
}

type UpdateClusterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterOutput) GoString() string {
	return s.String()
}

type UpdateJobInput struct {
	_ struct{} `type:"structure"`

	// The ID of the updated Address object.
	AddressId *string `min:"40" type:"string"`

	// The updated description of this job's JobMetadata object.
	Description *string `min:"1" type:"string"`

	// The updated ID for the forwarding address for a job. This field is not supported
	// in most regions.
	ForwardingAddressId *string `min:"40" type:"string"`

	// The job ID of the job that you want to update, for example JID123e4567-e89b-12d3-a456-426655440000.
	//
	// JobId is a required field
	JobId *string `min:"39" type:"string" required:"true"`

	// The new or updated Notification object.
	Notification *Notification `type:"structure"`

	// Specifies the service or services on the Snow Family device that your transferred
	// data will be exported from or imported into. Amazon Web Services Snow Family
	// supports Amazon S3 and NFS (Network File System) and the Amazon Web Services
	// Storage Gateway service Tape Gateway type.
	OnDeviceServiceConfiguration *OnDeviceServiceConfiguration `type:"structure"`

	// Information identifying the person picking up the device.
	PickupDetails *PickupDetails `type:"structure"`

	// The updated JobResource object, or the updated JobResource object.
	Resources *JobResource `type:"structure"`

	// The new role Amazon Resource Name (ARN) that you want to associate with this
	// job. To create a role ARN, use the CreateRole (https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html)Identity
	// and Access Management (IAM) API action.
	RoleARN *string `type:"string"`

	// The updated shipping option value of this job's ShippingDetails object.
	ShippingOption *string `type:"string" enum:"ShippingOption"`

	// The updated SnowballCapacityPreference of this job's JobMetadata object.
	// The 50 TB Snowballs are only available in the US regions.
	//
	// For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html"
	// (Snow Family Devices and Capacity) in the Snowcone User Guide or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html"
	// (Snow Family Devices and Capacity) in the Snowcone User Guide.
	SnowballCapacityPreference *string `type:"string" enum:"Capacity"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateJobInput"}
	if s.AddressId != nil && len(*s.AddressId) < 40 {
		invalidParams.Add(request.NewErrParamMinLen("AddressId", 40))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.ForwardingAddressId != nil && len(*s.ForwardingAddressId) < 40 {
		invalidParams.Add(request.NewErrParamMinLen("ForwardingAddressId", 40))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 39 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 39))
	}
	if s.OnDeviceServiceConfiguration != nil {
		if err := s.OnDeviceServiceConfiguration.Validate(); err != nil {
			invalidParams.AddNested("OnDeviceServiceConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.PickupDetails != nil {
		if err := s.PickupDetails.Validate(); err != nil {
			invalidParams.AddNested("PickupDetails", err.(request.ErrInvalidParams))
		}
	}
	if s.Resources != nil {
		if err := s.Resources.Validate(); err != nil {
			invalidParams.AddNested("Resources", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddressId sets the AddressId field's value.
func (s *UpdateJobInput) SetAddressId(v string) *UpdateJobInput {
	s.AddressId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateJobInput) SetDescription(v string) *UpdateJobInput {
	s.Description = &v
	return s
}

// SetForwardingAddressId sets the ForwardingAddressId field's value.
func (s *UpdateJobInput) SetForwardingAddressId(v string) *UpdateJobInput {
	s.ForwardingAddressId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *UpdateJobInput) SetJobId(v string) *UpdateJobInput {
	s.JobId = &v
	return s
}

// SetNotification sets the Notification field's value.
func (s *UpdateJobInput) SetNotification(v *Notification) *UpdateJobInput {
	s.Notification = v
	return s
}

// SetOnDeviceServiceConfiguration sets the OnDeviceServiceConfiguration field's value.
func (s *UpdateJobInput) SetOnDeviceServiceConfiguration(v *OnDeviceServiceConfiguration) *UpdateJobInput {
	s.OnDeviceServiceConfiguration = v
	return s
}

// SetPickupDetails sets the PickupDetails field's value.
func (s *UpdateJobInput) SetPickupDetails(v *PickupDetails) *UpdateJobInput {
	s.PickupDetails = v
	return s
}

// SetResources sets the Resources field's value.
func (s *UpdateJobInput) SetResources(v *JobResource) *UpdateJobInput {
	s.Resources = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *UpdateJobInput) SetRoleARN(v string) *UpdateJobInput {
	s.RoleARN = &v
	return s
}

// SetShippingOption sets the ShippingOption field's value.
func (s *UpdateJobInput) SetShippingOption(v string) *UpdateJobInput {
	s.ShippingOption = &v
	return s
}

// SetSnowballCapacityPreference sets the SnowballCapacityPreference field's value.
func (s *UpdateJobInput) SetSnowballCapacityPreference(v string) *UpdateJobInput {
	s.SnowballCapacityPreference = &v
	return s
}

type UpdateJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateJobOutput) GoString() string {
	return s.String()
}

type UpdateJobShipmentStateInput struct {
	_ struct{} `type:"structure"`

	// The job ID of the job whose shipment date you want to update, for example
	// JID123e4567-e89b-12d3-a456-426655440000.
	//
	// JobId is a required field
	JobId *string `min:"39" type:"string" required:"true"`

	// The state of a device when it is being shipped.
	//
	// Set to RECEIVED when the device arrives at your location.
	//
	// Set to RETURNED when you have returned the device to Amazon Web Services.
	//
	// ShipmentState is a required field
	ShipmentState *string `type:"string" required:"true" enum:"ShipmentState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateJobShipmentStateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateJobShipmentStateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateJobShipmentStateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateJobShipmentStateInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 39 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 39))
	}
	if s.ShipmentState == nil {
		invalidParams.Add(request.NewErrParamRequired("ShipmentState"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *UpdateJobShipmentStateInput) SetJobId(v string) *UpdateJobShipmentStateInput {
	s.JobId = &v
	return s
}

// SetShipmentState sets the ShipmentState field's value.
func (s *UpdateJobShipmentStateInput) SetShipmentState(v string) *UpdateJobShipmentStateInput {
	s.ShipmentState = &v
	return s
}

type UpdateJobShipmentStateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateJobShipmentStateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateJobShipmentStateOutput) GoString() string {
	return s.String()
}

type UpdateLongTermPricingInput struct {
	_ struct{} `type:"structure"`

	// If set to true, specifies that the current long-term pricing type for the
	// device should be automatically renewed before the long-term pricing contract
	// expires.
	IsLongTermPricingAutoRenew *bool `type:"boolean"`

	// The ID of the long-term pricing type for the device.
	//
	// LongTermPricingId is a required field
	LongTermPricingId *string `min:"41" type:"string" required:"true"`

	// Specifies that a device that is ordered with long-term pricing should be
	// replaced with a new device.
	ReplacementJob *string `min:"39" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLongTermPricingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLongTermPricingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateLongTermPricingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateLongTermPricingInput"}
	if s.LongTermPricingId == nil {
		invalidParams.Add(request.NewErrParamRequired("LongTermPricingId"))
	}
	if s.LongTermPricingId != nil && len(*s.LongTermPricingId) < 41 {
		invalidParams.Add(request.NewErrParamMinLen("LongTermPricingId", 41))
	}
	if s.ReplacementJob != nil && len(*s.ReplacementJob) < 39 {
		invalidParams.Add(request.NewErrParamMinLen("ReplacementJob", 39))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIsLongTermPricingAutoRenew sets the IsLongTermPricingAutoRenew field's value.
func (s *UpdateLongTermPricingInput) SetIsLongTermPricingAutoRenew(v bool) *UpdateLongTermPricingInput {
	s.IsLongTermPricingAutoRenew = &v
	return s
}

// SetLongTermPricingId sets the LongTermPricingId field's value.
func (s *UpdateLongTermPricingInput) SetLongTermPricingId(v string) *UpdateLongTermPricingInput {
	s.LongTermPricingId = &v
	return s
}

// SetReplacementJob sets the ReplacementJob field's value.
func (s *UpdateLongTermPricingInput) SetReplacementJob(v string) *UpdateLongTermPricingInput {
	s.ReplacementJob = &v
	return s
}

type UpdateLongTermPricingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLongTermPricingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLongTermPricingOutput) GoString() string {
	return s.String()
}

// Configures the wireless connection on an Snowcone device.
type WirelessConnection struct {
	_ struct{} `type:"structure"`

	// Enables the Wi-Fi adapter on an Snowcone device.
	IsWifiEnabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WirelessConnection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WirelessConnection) GoString() string {
	return s.String()
}

// SetIsWifiEnabled sets the IsWifiEnabled field's value.
func (s *WirelessConnection) SetIsWifiEnabled(v bool) *WirelessConnection {
	s.IsWifiEnabled = &v
	return s
}

const (
	// AddressTypeCustPickup is a AddressType enum value
	AddressTypeCustPickup = "CUST_PICKUP"

	// AddressTypeAwsShip is a AddressType enum value
	AddressTypeAwsShip = "AWS_SHIP"
)

// AddressType_Values returns all elements of the AddressType enum
func AddressType_Values() []string {
	return []string{
		AddressTypeCustPickup,
		AddressTypeAwsShip,
	}
}

const (
	// CapacityT50 is a Capacity enum value
	CapacityT50 = "T50"

	// CapacityT80 is a Capacity enum value
	CapacityT80 = "T80"

	// CapacityT100 is a Capacity enum value
	CapacityT100 = "T100"

	// CapacityT42 is a Capacity enum value
	CapacityT42 = "T42"

	// CapacityT98 is a Capacity enum value
	CapacityT98 = "T98"

	// CapacityT8 is a Capacity enum value
	CapacityT8 = "T8"

	// CapacityT14 is a Capacity enum value
	CapacityT14 = "T14"

	// CapacityT32 is a Capacity enum value
	CapacityT32 = "T32"

	// CapacityNoPreference is a Capacity enum value
	CapacityNoPreference = "NoPreference"

	// CapacityT240 is a Capacity enum value
	CapacityT240 = "T240"

	// CapacityT13 is a Capacity enum value
	CapacityT13 = "T13"
)

// Capacity_Values returns all elements of the Capacity enum
func Capacity_Values() []string {
	return []string{
		CapacityT50,
		CapacityT80,
		CapacityT100,
		CapacityT42,
		CapacityT98,
		CapacityT8,
		CapacityT14,
		CapacityT32,
		CapacityNoPreference,
		CapacityT240,
		CapacityT13,
	}
}

const (
	// ClusterStateAwaitingQuorum is a ClusterState enum value
	ClusterStateAwaitingQuorum = "AwaitingQuorum"

	// ClusterStatePending is a ClusterState enum value
	ClusterStatePending = "Pending"

	// ClusterStateInUse is a ClusterState enum value
	ClusterStateInUse = "InUse"

	// ClusterStateComplete is a ClusterState enum value
	ClusterStateComplete = "Complete"

	// ClusterStateCancelled is a ClusterState enum value
	ClusterStateCancelled = "Cancelled"
)

// ClusterState_Values returns all elements of the ClusterState enum
func ClusterState_Values() []string {
	return []string{
		ClusterStateAwaitingQuorum,
		ClusterStatePending,
		ClusterStateInUse,
		ClusterStateComplete,
		ClusterStateCancelled,
	}
}

const (
	// DeviceServiceNameNfsOnDeviceService is a DeviceServiceName enum value
	DeviceServiceNameNfsOnDeviceService = "NFS_ON_DEVICE_SERVICE"

	// DeviceServiceNameS3OnDeviceService is a DeviceServiceName enum value
	DeviceServiceNameS3OnDeviceService = "S3_ON_DEVICE_SERVICE"
)

// DeviceServiceName_Values returns all elements of the DeviceServiceName enum
func DeviceServiceName_Values() []string {
	return []string{
		DeviceServiceNameNfsOnDeviceService,
		DeviceServiceNameS3OnDeviceService,
	}
}

const (
	// ImpactLevelIl2 is a ImpactLevel enum value
	ImpactLevelIl2 = "IL2"

	// ImpactLevelIl4 is a ImpactLevel enum value
	ImpactLevelIl4 = "IL4"

	// ImpactLevelIl5 is a ImpactLevel enum value
	ImpactLevelIl5 = "IL5"

	// ImpactLevelIl6 is a ImpactLevel enum value
	ImpactLevelIl6 = "IL6"

	// ImpactLevelIl99 is a ImpactLevel enum value
	ImpactLevelIl99 = "IL99"
)

// ImpactLevel_Values returns all elements of the ImpactLevel enum
func ImpactLevel_Values() []string {
	return []string{
		ImpactLevelIl2,
		ImpactLevelIl4,
		ImpactLevelIl5,
		ImpactLevelIl6,
		ImpactLevelIl99,
	}
}

const (
	// JobStateNew is a JobState enum value
	JobStateNew = "New"

	// JobStatePreparingAppliance is a JobState enum value
	JobStatePreparingAppliance = "PreparingAppliance"

	// JobStatePreparingShipment is a JobState enum value
	JobStatePreparingShipment = "PreparingShipment"

	// JobStateInTransitToCustomer is a JobState enum value
	JobStateInTransitToCustomer = "InTransitToCustomer"

	// JobStateWithCustomer is a JobState enum value
	JobStateWithCustomer = "WithCustomer"

	// JobStateInTransitToAws is a JobState enum value
	JobStateInTransitToAws = "InTransitToAWS"

	// JobStateWithAwssortingFacility is a JobState enum value
	JobStateWithAwssortingFacility = "WithAWSSortingFacility"

	// JobStateWithAws is a JobState enum value
	JobStateWithAws = "WithAWS"

	// JobStateInProgress is a JobState enum value
	JobStateInProgress = "InProgress"

	// JobStateComplete is a JobState enum value
	JobStateComplete = "Complete"

	// JobStateCancelled is a JobState enum value
	JobStateCancelled = "Cancelled"

	// JobStateListing is a JobState enum value
	JobStateListing = "Listing"

	// JobStatePending is a JobState enum value
	JobStatePending = "Pending"
)

// JobState_Values returns all elements of the JobState enum
func JobState_Values() []string {
	return []string{
		JobStateNew,
		JobStatePreparingAppliance,
		JobStatePreparingShipment,
		JobStateInTransitToCustomer,
		JobStateWithCustomer,
		JobStateInTransitToAws,
		JobStateWithAwssortingFacility,
		JobStateWithAws,
		JobStateInProgress,
		JobStateComplete,
		JobStateCancelled,
		JobStateListing,
		JobStatePending,
	}
}

const (
	// JobTypeImport is a JobType enum value
	JobTypeImport = "IMPORT"

	// JobTypeExport is a JobType enum value
	JobTypeExport = "EXPORT"

	// JobTypeLocalUse is a JobType enum value
	JobTypeLocalUse = "LOCAL_USE"
)

// JobType_Values returns all elements of the JobType enum
func JobType_Values() []string {
	return []string{
		JobTypeImport,
		JobTypeExport,
		JobTypeLocalUse,
	}
}

const (
	// LongTermPricingTypeOneYear is a LongTermPricingType enum value
	LongTermPricingTypeOneYear = "OneYear"

	// LongTermPricingTypeThreeYear is a LongTermPricingType enum value
	LongTermPricingTypeThreeYear = "ThreeYear"

	// LongTermPricingTypeOneMonth is a LongTermPricingType enum value
	LongTermPricingTypeOneMonth = "OneMonth"
)

// LongTermPricingType_Values returns all elements of the LongTermPricingType enum
func LongTermPricingType_Values() []string {
	return []string{
		LongTermPricingTypeOneYear,
		LongTermPricingTypeThreeYear,
		LongTermPricingTypeOneMonth,
	}
}

const (
	// RemoteManagementInstalledOnly is a RemoteManagement enum value
	RemoteManagementInstalledOnly = "INSTALLED_ONLY"

	// RemoteManagementInstalledAutostart is a RemoteManagement enum value
	RemoteManagementInstalledAutostart = "INSTALLED_AUTOSTART"

	// RemoteManagementNotInstalled is a RemoteManagement enum value
	RemoteManagementNotInstalled = "NOT_INSTALLED"
)

// RemoteManagement_Values returns all elements of the RemoteManagement enum
func RemoteManagement_Values() []string {
	return []string{
		RemoteManagementInstalledOnly,
		RemoteManagementInstalledAutostart,
		RemoteManagementNotInstalled,
	}
}

const (
	// ServiceNameKubernetes is a ServiceName enum value
	ServiceNameKubernetes = "KUBERNETES"

	// ServiceNameEksAnywhere is a ServiceName enum value
	ServiceNameEksAnywhere = "EKS_ANYWHERE"
)

// ServiceName_Values returns all elements of the ServiceName enum
func ServiceName_Values() []string {
	return []string{
		ServiceNameKubernetes,
		ServiceNameEksAnywhere,
	}
}

const (
	// ShipmentStateReceived is a ShipmentState enum value
	ShipmentStateReceived = "RECEIVED"

	// ShipmentStateReturned is a ShipmentState enum value
	ShipmentStateReturned = "RETURNED"
)

// ShipmentState_Values returns all elements of the ShipmentState enum
func ShipmentState_Values() []string {
	return []string{
		ShipmentStateReceived,
		ShipmentStateReturned,
	}
}

const (
	// ShippingLabelStatusInProgress is a ShippingLabelStatus enum value
	ShippingLabelStatusInProgress = "InProgress"

	// ShippingLabelStatusTimedOut is a ShippingLabelStatus enum value
	ShippingLabelStatusTimedOut = "TimedOut"

	// ShippingLabelStatusSucceeded is a ShippingLabelStatus enum value
	ShippingLabelStatusSucceeded = "Succeeded"

	// ShippingLabelStatusFailed is a ShippingLabelStatus enum value
	ShippingLabelStatusFailed = "Failed"
)

// ShippingLabelStatus_Values returns all elements of the ShippingLabelStatus enum
func ShippingLabelStatus_Values() []string {
	return []string{
		ShippingLabelStatusInProgress,
		ShippingLabelStatusTimedOut,
		ShippingLabelStatusSucceeded,
		ShippingLabelStatusFailed,
	}
}

const (
	// ShippingOptionSecondDay is a ShippingOption enum value
	ShippingOptionSecondDay = "SECOND_DAY"

	// ShippingOptionNextDay is a ShippingOption enum value
	ShippingOptionNextDay = "NEXT_DAY"

	// ShippingOptionExpress is a ShippingOption enum value
	ShippingOptionExpress = "EXPRESS"

	// ShippingOptionStandard is a ShippingOption enum value
	ShippingOptionStandard = "STANDARD"
)

// ShippingOption_Values returns all elements of the ShippingOption enum
func ShippingOption_Values() []string {
	return []string{
		ShippingOptionSecondDay,
		ShippingOptionNextDay,
		ShippingOptionExpress,
		ShippingOptionStandard,
	}
}

const (
	// StorageUnitTb is a StorageUnit enum value
	StorageUnitTb = "TB"
)

// StorageUnit_Values returns all elements of the StorageUnit enum
func StorageUnit_Values() []string {
	return []string{
		StorageUnitTb,
	}
}

const (
	// TransferOptionImport is a TransferOption enum value
	TransferOptionImport = "IMPORT"

	// TransferOptionExport is a TransferOption enum value
	TransferOptionExport = "EXPORT"

	// TransferOptionLocalUse is a TransferOption enum value
	TransferOptionLocalUse = "LOCAL_USE"
)

// TransferOption_Values returns all elements of the TransferOption enum
func TransferOption_Values() []string {
	return []string{
		TransferOptionImport,
		TransferOptionExport,
		TransferOptionLocalUse,
	}
}

const (
	// TypeStandard is a Type enum value
	TypeStandard = "STANDARD"

	// TypeEdge is a Type enum value
	TypeEdge = "EDGE"

	// TypeEdgeC is a Type enum value
	TypeEdgeC = "EDGE_C"

	// TypeEdgeCg is a Type enum value
	TypeEdgeCg = "EDGE_CG"

	// TypeEdgeS is a Type enum value
	TypeEdgeS = "EDGE_S"

	// TypeSnc1Hdd is a Type enum value
	TypeSnc1Hdd = "SNC1_HDD"

	// TypeSnc1Ssd is a Type enum value
	TypeSnc1Ssd = "SNC1_SSD"

	// TypeV35c is a Type enum value
	TypeV35c = "V3_5C"

	// TypeV35s is a Type enum value
	TypeV35s = "V3_5S"

	// TypeRack5uC is a Type enum value
	TypeRack5uC = "RACK_5U_C"
)

// Type_Values returns all elements of the Type enum
func Type_Values() []string {
	return []string{
		TypeStandard,
		TypeEdge,
		TypeEdgeC,
		TypeEdgeCg,
		TypeEdgeS,
		TypeSnc1Hdd,
		TypeSnc1Ssd,
		TypeV35c,
		TypeV35s,
		TypeRack5uC,
	}
}
