// Copyright 2017 The Go Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// https://developers.google.com/protocol-buffers/docs/proto3

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.27.1
// 	protoc        v3.12.4
// source: api.proto

package apipb

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type HasAncestorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Commit   string `protobuf:"bytes,1,opt,name=commit,proto3" json:"commit,omitempty"`     // full git commit hash (subject of query)
	Ancestor string `protobuf:"bytes,2,opt,name=ancestor,proto3" json:"ancestor,omitempty"` // full git commit hash of sought ancestor
}

func (x *HasAncestorRequest) Reset() {
	*x = HasAncestorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HasAncestorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HasAncestorRequest) ProtoMessage() {}

func (x *HasAncestorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HasAncestorRequest.ProtoReflect.Descriptor instead.
func (*HasAncestorRequest) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{0}
}

func (x *HasAncestorRequest) GetCommit() string {
	if x != nil {
		return x.Commit
	}
	return ""
}

func (x *HasAncestorRequest) GetAncestor() string {
	if x != nil {
		return x.Ancestor
	}
	return ""
}

type HasAncestorResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// has_ancestor is whether ancestor appears in commit's history.
	HasAncestor bool `protobuf:"varint,1,opt,name=has_ancestor,json=hasAncestor,proto3" json:"has_ancestor,omitempty"`
	// unknown_commit is true if the provided commit was unknown.
	UnknownCommit bool `protobuf:"varint,2,opt,name=unknown_commit,json=unknownCommit,proto3" json:"unknown_commit,omitempty"`
}

func (x *HasAncestorResponse) Reset() {
	*x = HasAncestorResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HasAncestorResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HasAncestorResponse) ProtoMessage() {}

func (x *HasAncestorResponse) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HasAncestorResponse.ProtoReflect.Descriptor instead.
func (*HasAncestorResponse) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{1}
}

func (x *HasAncestorResponse) GetHasAncestor() bool {
	if x != nil {
		return x.HasAncestor
	}
	return false
}

func (x *HasAncestorResponse) GetUnknownCommit() bool {
	if x != nil {
		return x.UnknownCommit
	}
	return false
}

type GetRefRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Ref string `protobuf:"bytes,1,opt,name=ref,proto3" json:"ref,omitempty"` // "HEAD", "refs/heads/master", etc.
	// Either gerrit_server & gerrit_project must be specified, or
	// github. Currently only Gerrit is supported.
	GerritServer  string `protobuf:"bytes,2,opt,name=gerrit_server,json=gerritServer,proto3" json:"gerrit_server,omitempty"`    // "go.googlesource.com"
	GerritProject string `protobuf:"bytes,3,opt,name=gerrit_project,json=gerritProject,proto3" json:"gerrit_project,omitempty"` // "go"
}

func (x *GetRefRequest) Reset() {
	*x = GetRefRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetRefRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRefRequest) ProtoMessage() {}

func (x *GetRefRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRefRequest.ProtoReflect.Descriptor instead.
func (*GetRefRequest) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{2}
}

func (x *GetRefRequest) GetRef() string {
	if x != nil {
		return x.Ref
	}
	return ""
}

func (x *GetRefRequest) GetGerritServer() string {
	if x != nil {
		return x.GerritServer
	}
	return ""
}

func (x *GetRefRequest) GetGerritProject() string {
	if x != nil {
		return x.GerritProject
	}
	return ""
}

type GetRefResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"` // git commit, or empty string on miss
}

func (x *GetRefResponse) Reset() {
	*x = GetRefResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetRefResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRefResponse) ProtoMessage() {}

func (x *GetRefResponse) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRefResponse.ProtoReflect.Descriptor instead.
func (*GetRefResponse) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{3}
}

func (x *GetRefResponse) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

type GoFindTryWorkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// for_staging says whether this is a trybot request for the staging
	// cluster. When using staging, the comment "Run-StagingTryBot"
	// is used instead of label:Run-TryBot=1.
	ForStaging bool `protobuf:"varint,1,opt,name=for_staging,json=forStaging,proto3" json:"for_staging,omitempty"`
}

func (x *GoFindTryWorkRequest) Reset() {
	*x = GoFindTryWorkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GoFindTryWorkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GoFindTryWorkRequest) ProtoMessage() {}

func (x *GoFindTryWorkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GoFindTryWorkRequest.ProtoReflect.Descriptor instead.
func (*GoFindTryWorkRequest) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{4}
}

func (x *GoFindTryWorkRequest) GetForStaging() bool {
	if x != nil {
		return x.ForStaging
	}
	return false
}

type GoFindTryWorkResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// waiting are the Gerrit CLs wanting a trybot run and not yet with results.
	// These might already be running.
	Waiting []*GerritTryWorkItem `protobuf:"bytes,1,rep,name=waiting,proto3" json:"waiting,omitempty"`
}

func (x *GoFindTryWorkResponse) Reset() {
	*x = GoFindTryWorkResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GoFindTryWorkResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GoFindTryWorkResponse) ProtoMessage() {}

func (x *GoFindTryWorkResponse) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GoFindTryWorkResponse.ProtoReflect.Descriptor instead.
func (*GoFindTryWorkResponse) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{5}
}

func (x *GoFindTryWorkResponse) GetWaiting() []*GerritTryWorkItem {
	if x != nil {
		return x.Waiting
	}
	return nil
}

type GerritTryWorkItem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Project  string `protobuf:"bytes,1,opt,name=project,proto3" json:"project,omitempty"`                   // "go", "net", etc. (Gerrit Project)
	Branch   string `protobuf:"bytes,2,opt,name=branch,proto3" json:"branch,omitempty"`                     // "master", "release-branch.go1.8", etc.
	ChangeId string `protobuf:"bytes,3,opt,name=change_id,json=changeId,proto3" json:"change_id,omitempty"` // "I1a27695838409259d1586a0adfa9f92bccf7ceba"
	Commit   string `protobuf:"bytes,4,opt,name=commit,proto3" json:"commit,omitempty"`                     // "ecf3dffc81dc21408fb02159af352651882a8383"
	// go_commit is set for subrepos and is the Go commit(s) to test against.
	// go_branch is a branch name of go_commit, for showing to users when
	// a try set fails.
	GoCommit []string `protobuf:"bytes,5,rep,name=go_commit,json=goCommit,proto3" json:"go_commit,omitempty"` // "4833e920c1d7f6b23458e6ff3c73951fcf754219"
	GoBranch []string `protobuf:"bytes,6,rep,name=go_branch,json=goBranch,proto3" json:"go_branch,omitempty"` // "master", "release-branch.go1.8", etc.
	// go_version specifies the major and minor version of the targeted Go toolchain.
	// For Go repo, it contains exactly one element.
	// For subrepos, it contains elements that correspond to go_commit.
	GoVersion []*MajorMinor `protobuf:"bytes,7,rep,name=go_version,json=goVersion,proto3" json:"go_version,omitempty"`
	// try_message is the list of TRY=xxxx messages associated with Run-TryBot votes.
	// It's sorted from oldest to newest.
	TryMessage  []*TryVoteMessage `protobuf:"bytes,8,rep,name=try_message,json=tryMessage,proto3" json:"try_message,omitempty"`
	Version     int32             `protobuf:"varint,9,opt,name=version,proto3" json:"version,omitempty"`                            // which Gerrit revision number commit is
	AuthorEmail string            `protobuf:"bytes,10,opt,name=author_email,json=authorEmail,proto3" json:"author_email,omitempty"` // "foo@bar.com"
}

func (x *GerritTryWorkItem) Reset() {
	*x = GerritTryWorkItem{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GerritTryWorkItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GerritTryWorkItem) ProtoMessage() {}

func (x *GerritTryWorkItem) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GerritTryWorkItem.ProtoReflect.Descriptor instead.
func (*GerritTryWorkItem) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{6}
}

func (x *GerritTryWorkItem) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *GerritTryWorkItem) GetBranch() string {
	if x != nil {
		return x.Branch
	}
	return ""
}

func (x *GerritTryWorkItem) GetChangeId() string {
	if x != nil {
		return x.ChangeId
	}
	return ""
}

func (x *GerritTryWorkItem) GetCommit() string {
	if x != nil {
		return x.Commit
	}
	return ""
}

func (x *GerritTryWorkItem) GetGoCommit() []string {
	if x != nil {
		return x.GoCommit
	}
	return nil
}

func (x *GerritTryWorkItem) GetGoBranch() []string {
	if x != nil {
		return x.GoBranch
	}
	return nil
}

func (x *GerritTryWorkItem) GetGoVersion() []*MajorMinor {
	if x != nil {
		return x.GoVersion
	}
	return nil
}

func (x *GerritTryWorkItem) GetTryMessage() []*TryVoteMessage {
	if x != nil {
		return x.TryMessage
	}
	return nil
}

func (x *GerritTryWorkItem) GetVersion() int32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *GerritTryWorkItem) GetAuthorEmail() string {
	if x != nil {
		return x.AuthorEmail
	}
	return ""
}

type TryVoteMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Message  string `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`                    // just the part after "TRY=" until end of line, without \n
	AuthorId int64  `protobuf:"varint,2,opt,name=author_id,json=authorId,proto3" json:"author_id,omitempty"` // Gerrit-internal ID
	Version  int32  `protobuf:"varint,3,opt,name=version,proto3" json:"version,omitempty"`                   // revision number comment was for
}

func (x *TryVoteMessage) Reset() {
	*x = TryVoteMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TryVoteMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TryVoteMessage) ProtoMessage() {}

func (x *TryVoteMessage) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TryVoteMessage.ProtoReflect.Descriptor instead.
func (*TryVoteMessage) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{7}
}

func (x *TryVoteMessage) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *TryVoteMessage) GetAuthorId() int64 {
	if x != nil {
		return x.AuthorId
	}
	return 0
}

func (x *TryVoteMessage) GetVersion() int32 {
	if x != nil {
		return x.Version
	}
	return 0
}

type MajorMinor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Major int32 `protobuf:"varint,1,opt,name=major,proto3" json:"major,omitempty"`
	Minor int32 `protobuf:"varint,2,opt,name=minor,proto3" json:"minor,omitempty"`
}

func (x *MajorMinor) Reset() {
	*x = MajorMinor{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MajorMinor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MajorMinor) ProtoMessage() {}

func (x *MajorMinor) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MajorMinor.ProtoReflect.Descriptor instead.
func (*MajorMinor) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{8}
}

func (x *MajorMinor) GetMajor() int32 {
	if x != nil {
		return x.Major
	}
	return 0
}

func (x *MajorMinor) GetMinor() int32 {
	if x != nil {
		return x.Minor
	}
	return 0
}

type ListGoReleasesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ListGoReleasesRequest) Reset() {
	*x = ListGoReleasesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListGoReleasesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGoReleasesRequest) ProtoMessage() {}

func (x *ListGoReleasesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGoReleasesRequest.ProtoReflect.Descriptor instead.
func (*ListGoReleasesRequest) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{9}
}

type ListGoReleasesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Releases []*GoRelease `protobuf:"bytes,1,rep,name=releases,proto3" json:"releases,omitempty"`
}

func (x *ListGoReleasesResponse) Reset() {
	*x = ListGoReleasesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListGoReleasesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGoReleasesResponse) ProtoMessage() {}

func (x *ListGoReleasesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGoReleasesResponse.ProtoReflect.Descriptor instead.
func (*ListGoReleasesResponse) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{10}
}

func (x *ListGoReleasesResponse) GetReleases() []*GoRelease {
	if x != nil {
		return x.Releases
	}
	return nil
}

type GoRelease struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Major     int32  `protobuf:"varint,1,opt,name=major,proto3" json:"major,omitempty"`
	Minor     int32  `protobuf:"varint,2,opt,name=minor,proto3" json:"minor,omitempty"`
	Patch     int32  `protobuf:"varint,3,opt,name=patch,proto3" json:"patch,omitempty"`
	TagName   string `protobuf:"bytes,4,opt,name=tag_name,json=tagName,proto3" json:"tag_name,omitempty"`       // "go1.11.1", etc.
	TagCommit string `protobuf:"bytes,5,opt,name=tag_commit,json=tagCommit,proto3" json:"tag_commit,omitempty"` // "26957168c4c0cdcc7ca4f0b19d0eb19474d224ac"
	// Release branch information for this major-minor version pair.
	BranchName   string `protobuf:"bytes,6,opt,name=branch_name,json=branchName,proto3" json:"branch_name,omitempty"`       // "release-branch.go1.11", etc.
	BranchCommit string `protobuf:"bytes,7,opt,name=branch_commit,json=branchCommit,proto3" json:"branch_commit,omitempty"` // most recent commit on the release branch, e.g., "edb6c16b9b62ed8586d2e3e422911d646095b7e5"
}

func (x *GoRelease) Reset() {
	*x = GoRelease{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GoRelease) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GoRelease) ProtoMessage() {}

func (x *GoRelease) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GoRelease.ProtoReflect.Descriptor instead.
func (*GoRelease) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{11}
}

func (x *GoRelease) GetMajor() int32 {
	if x != nil {
		return x.Major
	}
	return 0
}

func (x *GoRelease) GetMinor() int32 {
	if x != nil {
		return x.Minor
	}
	return 0
}

func (x *GoRelease) GetPatch() int32 {
	if x != nil {
		return x.Patch
	}
	return 0
}

func (x *GoRelease) GetTagName() string {
	if x != nil {
		return x.TagName
	}
	return ""
}

func (x *GoRelease) GetTagCommit() string {
	if x != nil {
		return x.TagCommit
	}
	return ""
}

func (x *GoRelease) GetBranchName() string {
	if x != nil {
		return x.BranchName
	}
	return ""
}

func (x *GoRelease) GetBranchCommit() string {
	if x != nil {
		return x.BranchCommit
	}
	return ""
}

type DashboardRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// page is the zero-based page number.
	// TODO: deprecate, replace with time or commit continuation token.
	Page int32 `protobuf:"varint,1,opt,name=page,proto3" json:"page,omitempty"`
	// repo is which repo to show ("go", "golang.org/x/net", "" means go).
	Repo string `protobuf:"bytes,2,opt,name=repo,proto3" json:"repo,omitempty"`
	// branch specifies which branch to show ("master", "release-branch.go1.13").
	// Empty means "master".
	// The special branch value "mixed" means to blend together all branches by commit time.
	Branch string `protobuf:"bytes,3,opt,name=branch,proto3" json:"branch,omitempty"`
	// max_commits specifies the number of commits that are desired.
	// Zero means to use a default.
	MaxCommits int32 `protobuf:"varint,4,opt,name=max_commits,json=maxCommits,proto3" json:"max_commits,omitempty"`
}

func (x *DashboardRequest) Reset() {
	*x = DashboardRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DashboardRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DashboardRequest) ProtoMessage() {}

func (x *DashboardRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DashboardRequest.ProtoReflect.Descriptor instead.
func (*DashboardRequest) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{12}
}

func (x *DashboardRequest) GetPage() int32 {
	if x != nil {
		return x.Page
	}
	return 0
}

func (x *DashboardRequest) GetRepo() string {
	if x != nil {
		return x.Repo
	}
	return ""
}

func (x *DashboardRequest) GetBranch() string {
	if x != nil {
		return x.Branch
	}
	return ""
}

func (x *DashboardRequest) GetMaxCommits() int32 {
	if x != nil {
		return x.MaxCommits
	}
	return 0
}

type DashboardResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// commits are the commits to display, starting with the newest.
	Commits []*DashCommit `protobuf:"bytes,1,rep,name=commits,proto3" json:"commits,omitempty"`
	// commits_truncated is whether the returned commits were truncated.
	CommitsTruncated bool `protobuf:"varint,5,opt,name=commits_truncated,json=commitsTruncated,proto3" json:"commits_truncated,omitempty"`
	// repo_heads contains the current head commit (of their master
	// branch) for every repo on Go's Gerrit server.
	RepoHeads []*DashRepoHead `protobuf:"bytes,2,rep,name=repo_heads,json=repoHeads,proto3" json:"repo_heads,omitempty"`
	Branches  []string        `protobuf:"bytes,3,rep,name=branches,proto3" json:"branches,omitempty"`
	// releases is the same content is ListGoReleasesResponse, but with the addition of a "master"
	// release first, containing the info for the "master" branch, which is just commits[0]
	// if page 0. But if page != 0, the master head wouldn't be
	// available otherwise, so we denormalize it a bit here:
	// It's sorted from newest to oldest (master, release-branch.go1.latest, release-branch.go1.prior)
	// Only the branch_name and branch_commit fields are guaranteed to be populated.
	Releases []*GoRelease `protobuf:"bytes,4,rep,name=releases,proto3" json:"releases,omitempty"`
}

func (x *DashboardResponse) Reset() {
	*x = DashboardResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DashboardResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DashboardResponse) ProtoMessage() {}

func (x *DashboardResponse) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DashboardResponse.ProtoReflect.Descriptor instead.
func (*DashboardResponse) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{13}
}

func (x *DashboardResponse) GetCommits() []*DashCommit {
	if x != nil {
		return x.Commits
	}
	return nil
}

func (x *DashboardResponse) GetCommitsTruncated() bool {
	if x != nil {
		return x.CommitsTruncated
	}
	return false
}

func (x *DashboardResponse) GetRepoHeads() []*DashRepoHead {
	if x != nil {
		return x.RepoHeads
	}
	return nil
}

func (x *DashboardResponse) GetBranches() []string {
	if x != nil {
		return x.Branches
	}
	return nil
}

func (x *DashboardResponse) GetReleases() []*GoRelease {
	if x != nil {
		return x.Releases
	}
	return nil
}

type DashCommit struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// commit is the git commit hash ("26957168c4c0cdcc7ca4f0b19d0eb19474d224ac").
	Commit string `protobuf:"bytes,1,opt,name=commit,proto3" json:"commit,omitempty"`
	// author_name is the git author name part ("Foo Bar").
	AuthorName string `protobuf:"bytes,2,opt,name=author_name,json=authorName,proto3" json:"author_name,omitempty"` // "Foo Bar"
	// author_email is the git author email part ("foo@bar.com").
	AuthorEmail string `protobuf:"bytes,3,opt,name=author_email,json=authorEmail,proto3" json:"author_email,omitempty"` // "foo@bar.com"
	// commit_time_sec is the timestamp of git commit time, in unix seconds.
	CommitTimeSec int64 `protobuf:"varint,4,opt,name=commit_time_sec,json=commitTimeSec,proto3" json:"commit_time_sec,omitempty"`
	// title is the git commit's first line ("runtime: fix all the bugs").
	Title string `protobuf:"bytes,5,opt,name=title,proto3" json:"title,omitempty"`
	// branch is the branch this commit was queried from ("master", "release-branch.go1.14")/
	// This is normally redundant but is useful when DashboardRequest.branch == "mixed".
	Branch string `protobuf:"bytes,7,opt,name=branch,proto3" json:"branch,omitempty"`
	// For non-go repos, go_commit_at_time is what the Go master commit was at
	// the time of DashCommit.commit_time.
	GoCommitAtTime string `protobuf:"bytes,6,opt,name=go_commit_at_time,json=goCommitAtTime,proto3" json:"go_commit_at_time,omitempty"`
	// For non-go repos, go_commit_latest is the most recent Go master commit that's
	// older than the following x/foo commit's commit_time.
	// If DashCommit is the current HEAD, go_commit_at_time can continue to update.
	// go_commit_at_time might be the same as go_commit_at_time.
	GoCommitLatest string `protobuf:"bytes,8,opt,name=go_commit_latest,json=goCommitLatest,proto3" json:"go_commit_latest,omitempty"`
}

func (x *DashCommit) Reset() {
	*x = DashCommit{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DashCommit) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DashCommit) ProtoMessage() {}

func (x *DashCommit) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DashCommit.ProtoReflect.Descriptor instead.
func (*DashCommit) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{14}
}

func (x *DashCommit) GetCommit() string {
	if x != nil {
		return x.Commit
	}
	return ""
}

func (x *DashCommit) GetAuthorName() string {
	if x != nil {
		return x.AuthorName
	}
	return ""
}

func (x *DashCommit) GetAuthorEmail() string {
	if x != nil {
		return x.AuthorEmail
	}
	return ""
}

func (x *DashCommit) GetCommitTimeSec() int64 {
	if x != nil {
		return x.CommitTimeSec
	}
	return 0
}

func (x *DashCommit) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *DashCommit) GetBranch() string {
	if x != nil {
		return x.Branch
	}
	return ""
}

func (x *DashCommit) GetGoCommitAtTime() string {
	if x != nil {
		return x.GoCommitAtTime
	}
	return ""
}

func (x *DashCommit) GetGoCommitLatest() string {
	if x != nil {
		return x.GoCommitLatest
	}
	return ""
}

type DashRepoHead struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// gerrit_project is Gerrit project name ("net", "go").
	GerritProject string `protobuf:"bytes,1,opt,name=gerrit_project,json=gerritProject,proto3" json:"gerrit_project,omitempty"`
	// commit is the current top-level commit in that project.
	// (currently always on the master branch)
	Commit *DashCommit `protobuf:"bytes,2,opt,name=commit,proto3" json:"commit,omitempty"`
}

func (x *DashRepoHead) Reset() {
	*x = DashRepoHead{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DashRepoHead) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DashRepoHead) ProtoMessage() {}

func (x *DashRepoHead) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DashRepoHead.ProtoReflect.Descriptor instead.
func (*DashRepoHead) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{15}
}

func (x *DashRepoHead) GetGerritProject() string {
	if x != nil {
		return x.GerritProject
	}
	return ""
}

func (x *DashRepoHead) GetCommit() *DashCommit {
	if x != nil {
		return x.Commit
	}
	return nil
}

var File_api_proto protoreflect.FileDescriptor

var file_api_proto_rawDesc = []byte{
	0x0a, 0x09, 0x61, 0x70, 0x69, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x05, 0x61, 0x70, 0x69,
	0x70, 0x62, 0x22, 0x48, 0x0a, 0x12, 0x48, 0x61, 0x73, 0x41, 0x6e, 0x63, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x63, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74,
	0x12, 0x1a, 0x0a, 0x08, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x22, 0x5f, 0x0a, 0x13,
	0x48, 0x61, 0x73, 0x41, 0x6e, 0x63, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x68, 0x61, 0x73, 0x5f, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x68, 0x61, 0x73, 0x41, 0x6e,
	0x63, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x12, 0x25, 0x0a, 0x0e, 0x75, 0x6e, 0x6b, 0x6e, 0x6f, 0x77,
	0x6e, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d,
	0x75, 0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x22, 0x6d, 0x0a,
	0x0d, 0x47, 0x65, 0x74, 0x52, 0x65, 0x66, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x10,
	0x0a, 0x03, 0x72, 0x65, 0x66, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x72, 0x65, 0x66,
	0x12, 0x23, 0x0a, 0x0d, 0x67, 0x65, 0x72, 0x72, 0x69, 0x74, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x67, 0x65, 0x72, 0x72, 0x69, 0x74, 0x53,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x12, 0x25, 0x0a, 0x0e, 0x67, 0x65, 0x72, 0x72, 0x69, 0x74, 0x5f,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x67,
	0x65, 0x72, 0x72, 0x69, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x22, 0x26, 0x0a, 0x0e,
	0x47, 0x65, 0x74, 0x52, 0x65, 0x66, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x22, 0x37, 0x0a, 0x14, 0x47, 0x6f, 0x46, 0x69, 0x6e, 0x64, 0x54, 0x72,
	0x79, 0x57, 0x6f, 0x72, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1f, 0x0a, 0x0b,
	0x66, 0x6f, 0x72, 0x5f, 0x73, 0x74, 0x61, 0x67, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0a, 0x66, 0x6f, 0x72, 0x53, 0x74, 0x61, 0x67, 0x69, 0x6e, 0x67, 0x22, 0x4b, 0x0a,
	0x15, 0x47, 0x6f, 0x46, 0x69, 0x6e, 0x64, 0x54, 0x72, 0x79, 0x57, 0x6f, 0x72, 0x6b, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x32, 0x0a, 0x07, 0x77, 0x61, 0x69, 0x74, 0x69, 0x6e,
	0x67, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e,
	0x47, 0x65, 0x72, 0x72, 0x69, 0x74, 0x54, 0x72, 0x79, 0x57, 0x6f, 0x72, 0x6b, 0x49, 0x74, 0x65,
	0x6d, 0x52, 0x07, 0x77, 0x61, 0x69, 0x74, 0x69, 0x6e, 0x67, 0x22, 0xdb, 0x02, 0x0a, 0x11, 0x47,
	0x65, 0x72, 0x72, 0x69, 0x74, 0x54, 0x72, 0x79, 0x57, 0x6f, 0x72, 0x6b, 0x49, 0x74, 0x65, 0x6d,
	0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x62, 0x72,
	0x61, 0x6e, 0x63, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x62, 0x72, 0x61, 0x6e,
	0x63, 0x68, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x49, 0x64, 0x12,
	0x16, 0x0a, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x67, 0x6f, 0x5f, 0x63, 0x6f,
	0x6d, 0x6d, 0x69, 0x74, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x67, 0x6f, 0x43, 0x6f,
	0x6d, 0x6d, 0x69, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x67, 0x6f, 0x5f, 0x62, 0x72, 0x61, 0x6e, 0x63,
	0x68, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x67, 0x6f, 0x42, 0x72, 0x61, 0x6e, 0x63,
	0x68, 0x12, 0x30, 0x0a, 0x0a, 0x67, 0x6f, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e, 0x4d, 0x61,
	0x6a, 0x6f, 0x72, 0x4d, 0x69, 0x6e, 0x6f, 0x72, 0x52, 0x09, 0x67, 0x6f, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x36, 0x0a, 0x0b, 0x74, 0x72, 0x79, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62,
	0x2e, 0x54, 0x72, 0x79, 0x56, 0x6f, 0x74, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52,
	0x0a, 0x74, 0x72, 0x79, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x52, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x5f,
	0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x61, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x22, 0x61, 0x0a, 0x0e, 0x54, 0x72, 0x79, 0x56,
	0x6f, 0x74, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x49,
	0x64, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x38, 0x0a, 0x0a, 0x4d,
	0x61, 0x6a, 0x6f, 0x72, 0x4d, 0x69, 0x6e, 0x6f, 0x72, 0x12, 0x14, 0x0a, 0x05, 0x6d, 0x61, 0x6a,
	0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x6d, 0x61, 0x6a, 0x6f, 0x72, 0x12,
	0x14, 0x0a, 0x05, 0x6d, 0x69, 0x6e, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05,
	0x6d, 0x69, 0x6e, 0x6f, 0x72, 0x22, 0x17, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x6f, 0x52,
	0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x46,
	0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x6f, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2c, 0x0a, 0x08, 0x72, 0x65, 0x6c, 0x65,
	0x61, 0x73, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x61, 0x70, 0x69,
	0x70, 0x62, 0x2e, 0x47, 0x6f, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x08, 0x72, 0x65,
	0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x22, 0xcd, 0x01, 0x0a, 0x09, 0x47, 0x6f, 0x52, 0x65, 0x6c,
	0x65, 0x61, 0x73, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x6d, 0x61, 0x6a, 0x6f, 0x72, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x05, 0x6d, 0x61, 0x6a, 0x6f, 0x72, 0x12, 0x14, 0x0a, 0x05, 0x6d, 0x69,
	0x6e, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x6d, 0x69, 0x6e, 0x6f, 0x72,
	0x12, 0x14, 0x0a, 0x05, 0x70, 0x61, 0x74, 0x63, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x05, 0x70, 0x61, 0x74, 0x63, 0x68, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x61, 0x67, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x74, 0x61, 0x67, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x61, 0x67, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x74, 0x61, 0x67, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74,
	0x12, 0x1f, 0x0a, 0x0b, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x23, 0x0a, 0x0d, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x5f, 0x63, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68,
	0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x22, 0x73, 0x0a, 0x10, 0x44, 0x61, 0x73, 0x68, 0x62, 0x6f,
	0x61, 0x72, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61,
	0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x70, 0x61, 0x67, 0x65, 0x12, 0x12,
	0x0a, 0x04, 0x72, 0x65, 0x70, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x72, 0x65,
	0x70, 0x6f, 0x12, 0x16, 0x0a, 0x06, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x61,
	0x78, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x0a, 0x6d, 0x61, 0x78, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x73, 0x22, 0xeb, 0x01, 0x0a, 0x11,
	0x44, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x2b, 0x0a, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x11, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e, 0x44, 0x61, 0x73, 0x68, 0x43,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x52, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x2b,
	0x0a, 0x11, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x73, 0x5f, 0x74, 0x72, 0x75, 0x6e, 0x63, 0x61,
	0x74, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x63, 0x6f, 0x6d, 0x6d, 0x69,
	0x74, 0x73, 0x54, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x64, 0x12, 0x32, 0x0a, 0x0a, 0x72,
	0x65, 0x70, 0x6f, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x13, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e, 0x44, 0x61, 0x73, 0x68, 0x52, 0x65, 0x70, 0x6f,
	0x48, 0x65, 0x61, 0x64, 0x52, 0x09, 0x72, 0x65, 0x70, 0x6f, 0x48, 0x65, 0x61, 0x64, 0x73, 0x12,
	0x1a, 0x0a, 0x08, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x08, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x65, 0x73, 0x12, 0x2c, 0x0a, 0x08, 0x72,
	0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x10, 0x2e,
	0x61, 0x70, 0x69, 0x70, 0x62, 0x2e, 0x47, 0x6f, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x52,
	0x08, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x22, 0x93, 0x02, 0x0a, 0x0a, 0x44, 0x61,
	0x73, 0x68, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x63, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74,
	0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x21, 0x0a, 0x0c, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x5f, 0x65, 0x6d, 0x61, 0x69,
	0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x45,
	0x6d, 0x61, 0x69, 0x6c, 0x12, 0x26, 0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x63, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x63,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x63, 0x12, 0x14, 0x0a, 0x05,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x69, 0x74,
	0x6c, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x12, 0x29, 0x0a, 0x11, 0x67, 0x6f,
	0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x61, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x67, 0x6f, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x41,
	0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x28, 0x0a, 0x10, 0x67, 0x6f, 0x5f, 0x63, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x5f, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0e, 0x67, 0x6f, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x4c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x22,
	0x60, 0x0a, 0x0c, 0x44, 0x61, 0x73, 0x68, 0x52, 0x65, 0x70, 0x6f, 0x48, 0x65, 0x61, 0x64, 0x12,
	0x25, 0x0a, 0x0e, 0x67, 0x65, 0x72, 0x72, 0x69, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x67, 0x65, 0x72, 0x72, 0x69, 0x74, 0x50,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x29, 0x0a, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e, 0x44,
	0x61, 0x73, 0x68, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x52, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x69,
	0x74, 0x32, 0xec, 0x02, 0x0a, 0x0f, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x6e, 0x65, 0x72, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x44, 0x0a, 0x0b, 0x48, 0x61, 0x73, 0x41, 0x6e, 0x63, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x12, 0x19, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e, 0x48, 0x61, 0x73,
	0x41, 0x6e, 0x63, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1a, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e, 0x48, 0x61, 0x73, 0x41, 0x6e, 0x63, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x35, 0x0a, 0x06, 0x47,
	0x65, 0x74, 0x52, 0x65, 0x66, 0x12, 0x14, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e, 0x47, 0x65,
	0x74, 0x52, 0x65, 0x66, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x61, 0x70,
	0x69, 0x70, 0x62, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x66, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x4a, 0x0a, 0x0d, 0x47, 0x6f, 0x46, 0x69, 0x6e, 0x64, 0x54, 0x72, 0x79, 0x57,
	0x6f, 0x72, 0x6b, 0x12, 0x1b, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e, 0x47, 0x6f, 0x46, 0x69,
	0x6e, 0x64, 0x54, 0x72, 0x79, 0x57, 0x6f, 0x72, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1c, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e, 0x47, 0x6f, 0x46, 0x69, 0x6e, 0x64, 0x54,
	0x72, 0x79, 0x57, 0x6f, 0x72, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4d,
	0x0a, 0x0e, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x6f, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73,
	0x12, 0x1c, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x6f, 0x52,
	0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x6f, 0x52, 0x65, 0x6c,
	0x65, 0x61, 0x73, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x41, 0x0a,
	0x0c, 0x47, 0x65, 0x74, 0x44, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x12, 0x17, 0x2e,
	0x61, 0x70, 0x69, 0x70, 0x62, 0x2e, 0x44, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x18, 0x2e, 0x61, 0x70, 0x69, 0x70, 0x62, 0x2e, 0x44,
	0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x42, 0x2d, 0x5a, 0x2b, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x78,
	0x2f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2f, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x6e, 0x65, 0x72, 0x2f,
	0x6d, 0x61, 0x69, 0x6e, 0x74, 0x6e, 0x65, 0x72, 0x64, 0x2f, 0x61, 0x70, 0x69, 0x70, 0x62, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_api_proto_rawDescOnce sync.Once
	file_api_proto_rawDescData = file_api_proto_rawDesc
)

func file_api_proto_rawDescGZIP() []byte {
	file_api_proto_rawDescOnce.Do(func() {
		file_api_proto_rawDescData = protoimpl.X.CompressGZIP(file_api_proto_rawDescData)
	})
	return file_api_proto_rawDescData
}

var file_api_proto_msgTypes = make([]protoimpl.MessageInfo, 16)
var file_api_proto_goTypes = []interface{}{
	(*HasAncestorRequest)(nil),     // 0: apipb.HasAncestorRequest
	(*HasAncestorResponse)(nil),    // 1: apipb.HasAncestorResponse
	(*GetRefRequest)(nil),          // 2: apipb.GetRefRequest
	(*GetRefResponse)(nil),         // 3: apipb.GetRefResponse
	(*GoFindTryWorkRequest)(nil),   // 4: apipb.GoFindTryWorkRequest
	(*GoFindTryWorkResponse)(nil),  // 5: apipb.GoFindTryWorkResponse
	(*GerritTryWorkItem)(nil),      // 6: apipb.GerritTryWorkItem
	(*TryVoteMessage)(nil),         // 7: apipb.TryVoteMessage
	(*MajorMinor)(nil),             // 8: apipb.MajorMinor
	(*ListGoReleasesRequest)(nil),  // 9: apipb.ListGoReleasesRequest
	(*ListGoReleasesResponse)(nil), // 10: apipb.ListGoReleasesResponse
	(*GoRelease)(nil),              // 11: apipb.GoRelease
	(*DashboardRequest)(nil),       // 12: apipb.DashboardRequest
	(*DashboardResponse)(nil),      // 13: apipb.DashboardResponse
	(*DashCommit)(nil),             // 14: apipb.DashCommit
	(*DashRepoHead)(nil),           // 15: apipb.DashRepoHead
}
var file_api_proto_depIdxs = []int32{
	6,  // 0: apipb.GoFindTryWorkResponse.waiting:type_name -> apipb.GerritTryWorkItem
	8,  // 1: apipb.GerritTryWorkItem.go_version:type_name -> apipb.MajorMinor
	7,  // 2: apipb.GerritTryWorkItem.try_message:type_name -> apipb.TryVoteMessage
	11, // 3: apipb.ListGoReleasesResponse.releases:type_name -> apipb.GoRelease
	14, // 4: apipb.DashboardResponse.commits:type_name -> apipb.DashCommit
	15, // 5: apipb.DashboardResponse.repo_heads:type_name -> apipb.DashRepoHead
	11, // 6: apipb.DashboardResponse.releases:type_name -> apipb.GoRelease
	14, // 7: apipb.DashRepoHead.commit:type_name -> apipb.DashCommit
	0,  // 8: apipb.MaintnerService.HasAncestor:input_type -> apipb.HasAncestorRequest
	2,  // 9: apipb.MaintnerService.GetRef:input_type -> apipb.GetRefRequest
	4,  // 10: apipb.MaintnerService.GoFindTryWork:input_type -> apipb.GoFindTryWorkRequest
	9,  // 11: apipb.MaintnerService.ListGoReleases:input_type -> apipb.ListGoReleasesRequest
	12, // 12: apipb.MaintnerService.GetDashboard:input_type -> apipb.DashboardRequest
	1,  // 13: apipb.MaintnerService.HasAncestor:output_type -> apipb.HasAncestorResponse
	3,  // 14: apipb.MaintnerService.GetRef:output_type -> apipb.GetRefResponse
	5,  // 15: apipb.MaintnerService.GoFindTryWork:output_type -> apipb.GoFindTryWorkResponse
	10, // 16: apipb.MaintnerService.ListGoReleases:output_type -> apipb.ListGoReleasesResponse
	13, // 17: apipb.MaintnerService.GetDashboard:output_type -> apipb.DashboardResponse
	13, // [13:18] is the sub-list for method output_type
	8,  // [8:13] is the sub-list for method input_type
	8,  // [8:8] is the sub-list for extension type_name
	8,  // [8:8] is the sub-list for extension extendee
	0,  // [0:8] is the sub-list for field type_name
}

func init() { file_api_proto_init() }
func file_api_proto_init() {
	if File_api_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_api_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HasAncestorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HasAncestorResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetRefRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetRefResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GoFindTryWorkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GoFindTryWorkResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GerritTryWorkItem); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TryVoteMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MajorMinor); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListGoReleasesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListGoReleasesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GoRelease); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DashboardRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DashboardResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DashCommit); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DashRepoHead); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_api_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   16,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_api_proto_goTypes,
		DependencyIndexes: file_api_proto_depIdxs,
		MessageInfos:      file_api_proto_msgTypes,
	}.Build()
	File_api_proto = out.File
	file_api_proto_rawDesc = nil
	file_api_proto_goTypes = nil
	file_api_proto_depIdxs = nil
}
