/*
 *  Copyright (C) 1999 Peter Amstutz
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of *the
 *  License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307 USA 
 */
#ifndef _BALLISTICS_H_
#define _BALLISTICS_H_

#define INITSHOT(prj) (prj->wpn->initguidance(&(prj->prjpos), \
	&(prj->guidanceinfo), \
	prj->wpn->initexplosion,\
	&(prj->explosioninfo)))

typedef enum
{ HOLDING = 0, FLYING, EXPLODING, FREEING }
Shellstat_bal;

typedef enum
{ WND_OFF, WND_CONST, WND_RANDOM }
WindModes_bal;

/* don't use WALL_LAST: it's only for calculations */
typedef enum
{ WALL_OFF, WALL_CONCRETE, WALL_PADDED, WALL_RUBBER, WALL_SPRING,
    WALL_WRAPAROUND, WALL_RANDOM, WALL_LAST
}
WallTypes_bal;

typedef enum
{NO_ISECT=0, TERRAIN_ISECT, TANK_ISECT, WALL_ISECT}
IsectTypes_bal;

struct Projectilepos_bal;
struct Projectilelist_bal;

#include "weapons/weapon.h"
#include "player.h"

typedef struct Projectilepos_bal
{
    int id;			/* player who fired this shot */
    int wid;			/* weapon which fired this shot */
    double rox, roy;		/* real ox and real oy (not modified by balEnvironmentAdjustProjPos when the wall type is wraparound) */
    double ox, oy;
    double x, y;
    double vx, vy;
}
Projectilepos_bal;

struct Projectilelist_bal
{
    Shellstat_bal stat;
    int gen;

    Projectilepos_bal prjpos;

    void *guidanceinfo;
    void *explosioninfo;
    struct Weapon_wep *wpn;

    struct Projectilelist_bal *next;
    struct Projectilelist_bal *prev;
};

extern struct Projectilelist_bal *bal_Projectiles;
extern double bal_grav, bal_lerp_tweak;
extern int bal_wind;
extern int bal_wind_maxspeed;
extern WindModes_bal bal_wind_mode;
extern WallTypes_bal bal_wall;	/* current wall - different when bal_wall_type=WALL_RANDOM */
extern WallTypes_bal bal_wall_type;	/* wall type */

struct Projectilelist_bal *balNewShotAV(int id, int gen, int x, int y,
					double a, double v,
					struct Weapon_wep *wpn);
struct Projectilelist_bal *balNewShotXY(int id, int gen, int x, int y,
					double vx, double vy,
					struct Weapon_wep *wpn);
int balAdvanceProjectiles();
int balCheckIntersect(int x1, int y1, int x2, int y2,
		      struct Player_pl **plhit, int *ix, int *iy);
int balCheckTankIntersect(int x, int y, struct Player_pl **pl, int *ix,
			  int *iy);
Shellstat_bal balEnvironmentAdjustProjPos(struct Projectilepos_bal *prjpos);
void balInit();
void balCalcWind();
void balRecalcWind();
void balPrintWind(char *buf);
void balSetWall();
/* Free the projectiles list */
void balClearAllProjectiles();

#endif
