/* mixer.h
 *
 * Copyright (c) 1999 Scott Manley, Barath Raghavan, Jack Moffitt, and Alexander Havng
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License  
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */


/* data structures used by mixer.c  and others */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif


#include <stdio.h>          /* for FILE type */
#include <sys/types.h>      /* for pid_t type */
#include <unistd.h>


#ifdef HAVE_LIBCURSES
#define HAVE_CURSES
#endif


#ifdef HAVE_LIBCURSES
#include <curses.h>
#endif

#define BUF_SIZE    2048
#define MAX_SAMPLE  32766

#define CLIP        30000
#define CLIP_A      ((MAX_SAMPLE-CLIP)*(MAX_SAMPLE-CLIP))
#define CLIP_B      (MAX_SAMPLE-2*CLIP)


/* Timing parameters used to synchronise output in NO_SOUNDCARD mode */

/*#define MAX_SYNC_HISTORY 256
#define MIN_SYNC_HISTORY 128
#define MAX_SYNC_LAG 32
*/

#define MAX_CHANNELS 8

/* Playlist data formats */
enum { RAW_AUDIO, WAV_AUDIO , EXECUTABLE , MPEG , SHORTEN , ICECAST_SERVER , MISC_AUDIO , MPEG_LAYER_3};

/*
handling methods for audio - 
RAW_AUDIO - direct disk 
WAV_AUDIO - read header then read from disk
EXECUTABLE - spawn process
MPEG - spawn mpg123
SHORTEN - spawn shorten
ICECAST_SERVER - dunno
MPEG_LAYER_3  - internal decoder library
*/

/* Sample Data Formats */
/* add more as nescessary */

enum { SIGNED_16, UNSIGNED_16, SIGNED_8 , UNSIGNED_8 };


typedef struct format {
	int sample_format;
	int rate;
	int channels;
	float speed;
} Format;



typedef struct track_list *tptr;

/* new track list structure with all sorts of bells and whistles */
typedef struct track_list {
	char *filename;
	int t_type;
	Format fmt;
	int active;
        char *formvars;  /* obviously random crap */
	tptr next;
	tptr prev;
} track;



typedef struct channel_list *cptr;

typedef struct channel_list {
	short inbuf[BUF_SIZE];
	char name[64];
	tptr curnt;
	float volume;
	float speed;
	int rate;            
	int channels;         
	int on;
	int stayon;          /* controls play behaviour */
	int bad;             /* keeps track of bad plays....*/
	int stream;
	FILE *fstr;           /* use std buffering to simplify things */
	int  control;         /* the pipe we send control data to */
	pid_t pid;
        char *title;
        char *artist;
        char *album;
        char *url;
        void *decoder_dat;
#ifdef HAVE_LIBCURSES
	WINDOW *c_display;
#endif
} channel;

typedef struct mix_dat {
	int t_number;
	int c_number;
	int rate;
	int channels;
	int soundcard;
	int out_mode;                /* controls what you hear */
	int compression_vol;
	int noise_gate;
	float compression_power;
	FILE *control_file;
	double seq_time;
	double time_resolution;         /* time between commands */
	cptr c_list[MAX_CHANNELS]; 
	tptr t_list;
} m_dat;

/* now declare this chunk of data everyone will use */

m_dat mixer;    /* global data field for the mixer */


void init_channel_display(cptr ch);
void update_channel_display(cptr ch,int num);
void reset_track_pointers(void);
void change_channel(cptr ch,int inc);
void write_logfile(cptr ch);
void execute_update_script(cptr ch);
