# Branding
## CMake
Use CMake to set the common overridden variables.
```
cmake -DDISTRO_NAME=KDistro
      -DDISTRO_VERSION=123
      -DDISTRO_LOGO=kdistro
      -DBACKGROUND_TOP_COLOR=kdistro_green
      -DBACKGROUND_BOTTOM_COLOR=kdistro_blue
      ..
```

## Graphics (breeze)

Branding in the graphics mode is done via the code in
breeze.script. Do note the guidelines below when changing things.
In particular you want to change the following variables

```
// Title and font settings.
global.title.text = "Plasma 5.6";
global.defaults.font.default = "Noto Sans 12";
global.defaults.font.title = "Noto Sans 14";

// Same color or different for gradient.
palette.background.top = colors.plasma_blue;
palette.background.bottom = colors.icon_blue;
```

## Text (breeze-text)

The text theme is configured via the .plymouth theme file,
so you can simply install your own theme file to apply branding.

```
[Plymouth Theme]
Name=Our theme (text)
Description=A splash for text mode
ModuleName=breeze-text

[breeze-text]
title=openSUSE 14
black=0xfcfcfc # This is the background
white=0x000000 # This is the progress bar & title
```

## Grub

breeze/breeze.grub is a special grub scripting file which mostly sets sane
defaults in the event that breeze-grub (when used) is malfunctioning. You can
simply cat the file into your grub.cfg (happens automatically on Debian systems
when the plymouth theme is configured as default)

# Design Guideline
## Logo

- 128x128
- A monochrome logo is fine, it should use a color consistent with the
  default font color though (default is "Cardboard Grey")

## 16bit

- Solid color background. We default to the same color as GRUB
- None of the graphics must have transparent parts (see below for why)
- Logo must be monochrome contrastful color consistent with font color.
  We default to "Cardboard Grey".
- Text must use same color as Logo.

# 16bit - What? Why? How?
Sometimes text displays offer no more than 4 bits per pixel, for these cases we
have a special 16 color version of images. Those images should not contain
alpha channels and use solid color throughout (no gradients etc.).

In the script itself we use a solid color background, the images should use
matching colors when needing to avoid alpha.

Usually the workflow is to take the regular version and replace the alpha,
then possibly also overly colorful elements, save it and convert to 16 colors.
Most of the time you can use drop shadows, but all in all no more than 16
colors can be used, so you will have to make sure the clipped version's drop
is still appearing as expected.

When converting to <= 16bit colors please note that you first want to assign a
static background color for fully transparent bits that matches the background
color used in the script. Since alpha transparency is possibly not available
or limited to 4bits any transparency will be stripped as part of quantization.

To assing a background and convert to <= 16bit color version
(< when fewer colors found) you can use:
```
  for foo in *; do
    convert $foo -alpha Background -background "#000000" -fill "#000000" -flatten $foo
    pngtopnm $foo | pnmquant 16 | pnmtopng > 16.png; mv 16.png $foo
  done
```

You may want to check that the output makes sense.
