/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.gjt.jclasslib.structures.AbstractStructureWithAttributes;
import org.gjt.jclasslib.structures.AccessFlags;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.constants.ConstantUtf8Info;

public abstract class ClassMember
extends AbstractStructureWithAttributes
implements AccessFlags {
    protected int accessFlags;
    protected int nameIndex;
    protected int descriptorIndex;

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public void setAccessFlags(int n) {
        this.accessFlags = n;
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    public void setNameIndex(int n) {
        this.nameIndex = n;
    }

    public int getDescriptorIndex() {
        return this.descriptorIndex;
    }

    public void setDescriptorIndex(int n) {
        this.descriptorIndex = n;
    }

    public String getName() throws InvalidByteCodeException {
        ConstantUtf8Info constantUtf8Info = this.classFile.getConstantPoolUtf8Entry(this.nameIndex);
        if (constantUtf8Info == null) {
            return "invalid constant pool index";
        }
        return constantUtf8Info.getString();
    }

    public String getDescriptor() throws InvalidByteCodeException {
        ConstantUtf8Info constantUtf8Info = this.classFile.getConstantPoolUtf8Entry(this.descriptorIndex);
        if (constantUtf8Info == null) {
            return "invalid constant pool index";
        }
        return constantUtf8Info.getString();
    }

    public String getFormattedAccessFlags() {
        return this.printAccessFlags(this.accessFlags);
    }

    public String getAccessFlagsVerbose() {
        return this.printAccessFlagsVerbose(this.accessFlags);
    }

    public void read(DataInput dataInput) throws InvalidByteCodeException, IOException {
        this.accessFlags = dataInput.readUnsignedShort();
        this.nameIndex = dataInput.readUnsignedShort();
        this.descriptorIndex = dataInput.readUnsignedShort();
        this.readAttributes(dataInput);
    }

    public void write(DataOutput dataOutput) throws InvalidByteCodeException, IOException {
        dataOutput.writeShort(this.accessFlags);
        dataOutput.writeShort(this.nameIndex);
        dataOutput.writeShort(this.descriptorIndex);
        this.writeAttributes(dataOutput);
    }
}

