---
layout: default
title: ICU 78
nav_order: 898
has_children: false
parent: Downloading ICU
---

<!--
© 2025 and later: Unicode, Inc. and others.
License & terms of use: http://www.unicode.org/copyright.html
-->

# ICU 78

ICU is the [premier library for software internationalization](https://icu.unicode.org/#h.i33fakvpjb7o),
used by a [wide array of companies and organizations](https://icu.unicode.org/#h.f9qwubthqabj).

## Draft page

**This is an early draft of the ICU 78 download page. Nothing is published yet.**

## Release Overview

* Download: TODO [releases/tag/release-78-1](https://github.com/unicode-org/icu/releases/tag/release-78-1)
* TODO [Maven: com.ibm.icu / icu4j / version 78.1](https://mvnrepository.com/artifact/com.ibm.icu/icu4j/78.1)

ICU 78 updates to
[Unicode 17](https://www.unicode.org/versions/Unicode17.0.0/)
([blog](https://blog.unicode.org/2025/09/unicode-170-release-announcement.html)),
including new characters and scripts, emoji, collation & IDNA changes, and corresponding APIs and implementations.

It also updates to
[CLDR 48](https://cldr.unicode.org/downloads/cldr-48)
([beta blog](https://blog.unicode.org/2025/10/unicode-cldr-48-beta-available-for.html))
locale data with new locales, and various additions and corrections.

In Java, there is a draft new Segmenter API which is easier and safer to use than BreakIterator.
In C++, there is a new set of APIs for Unicode string (UTF-8/16/32) code point iteration
that works seamlessly with modern C++ iterators and ranges.

The Java implementation of the
[CLDR MessageFormat 2.0 specification](https://www.unicode.org/reports/tr35/tr35-messageFormat.html)
has been updated to CLDR 48.
The core API has been upgraded to “draft”, while the Data Model API remains in technology preview.

The C++ implementation of MessageFormat 2.0 is at CLDR 47 level and remains in technology preview.

ICU 78 and CLDR 48 are major releases, including a new version of Unicode and major locale data improvements.

For more details, including migration issues, see below.

Please use the [icu-support mailing list](https://icu.unicode.org/contacts) and/or
[find/submit error reports](https://icu.unicode.org/bugs).

### Version Number

The initial release has library version number 78.1.

* Release date: 2025-10-TODO
  * [List of tickets fixed in ICU 78](https://unicode-org.atlassian.net/issues/?jql=project%20%3D%20ICU%20AND%20status%20%3D%20Done%20AND%20resolution%20in%20%28Fixed%2C%20%22Fixed%20by%20Other%20Ticket%22%29%20AND%20fixVersion%20%3D%2078.1%20ORDER%20BY%20component%20ASC%2C%20created%20DESC)

If there are maintenance releases, they will be 78.2, 78.3, etc. (During ICU 78 development, the library version number was 78.0.x.)

Note: There may be additional commits on the [maint/maint-78](https://github.com/unicode-org/icu/tree/maint/maint-78) branch that are not included in the prepackaged download files.

## Common Changes

* [Unicode 17](https://www.unicode.org/versions/Unicode17.0.0/)
  ([blog](https://blog.unicode.org/2025/09/unicode-170-release-announcement.html)):
  * Adds two modern-use scripts: Beria Erfe & Tolong Siki
  * Adds two historic scripts & more than 4300 new CJK ideographs
  * New currency sign: SAUDI RIYAL SIGN
  * Eight new emoji characters
  * Segmentation improvements (word & line breaking)
  * Identifiers & security:
    The majority of CJK ideographs, the Bopomofo script,
    and more than 1100 other pre-Unicode 17 characters,
    are no longer recommended for use in identifiers by default
    (Identifier_Status & Identifier_Type properties),
    after thorough review.
    * For CJK ideographs, only 19,842 that are in modern common use (out of now more than 100,000)
      remain recommended for default identifier use.
* [CLDR 48](https://cldr.unicode.org/downloads/cldr-48)
  ([beta blog](https://blog.unicode.org/2025/10/unicode-cldr-48-beta-available-for.html)):
  * TODO: old news here
  * No major data collection for existing locales; focus on bug fixes and structural improvements
  * New regional variants: English in several European countries, and Cantonese in Macau (`yue_Hant_MO`)
  * Improved RBNF (number spellout) and transliteration data
* TODO: old news here
* Subtle segmentation changes to make ICU fully conform to Unicode 16
  * Word break: Root tailoring of colon reverted, Swedish & Finnish tailorings removed
    ([ICU-22941](https://unicode-org.atlassian.net/browse/ICU-22941))
    * These tailorings were introduced in ICU 72, but feedback has been negative,
      and the UTC declined to adopt these changes.
  * Line break: Fixed a bug in the line breaking of obscure sequences
    ⟨no-break space, combining mark, hyphen, alphabetic character⟩
    ([ICU-22986](https://unicode-org.atlassian.net/browse/ICU-22986)).
  * Updated Indic grapheme clusters to use the latest `Indic_Conjunct_Break` data
    ([ICU-22956](https://unicode-org.atlassian.net/browse/ICU-22956))
* Time zone data (tzdata) version 2025b (2025-mar).

## ICU4C Specific Changes

* [API changes since ICU4C 77 (Markdown)](https://github.com/unicode-org/icu/blob/maint/maint-78/icu4c/APIChangeReport.md) / [(HTML)](https://htmlpreview.github.io/?https://github.com/unicode-org/icu/blob/maint/maint-78/icu4c/APIChangeReport.html)
  * TODO: In C++, there is a new set of APIs for Unicode string (UTF-8/16/32) code point iteration
    that works seamlessly with modern C++ iterators and ranges.
  * TODO: old news here
  * New APIs for colloquial C++ use of C USet ([ICU-22876](https://unicode-org.atlassian.net/browse/ICU-22876))
    and C UCollator ([ICU-22879](https://unicode-org.atlassian.net/browse/ICU-22879))
    * These were added in ICU 76, but some of the new APIs did not actually compile with `U_SHOW_CPLUSPLUS_API=0`.
      They have been fixed in ICU 77 and thoroughly tested.
      USetElementIterator now returns std::u16string instead of icu::UnicodeString,
      and therefore it and related APIs have been changed to `@draft ICU 77`.
      ([ICU-22954](https://unicode-org.atlassian.net/browse/ICU-22954))
    * For details about these APIs and an example see the
      “C++ Header-Only APIs” section of the [ICU 76 Migration Issues](76.md#migration-issues).

## ICU4J Specific Changes

* The minimum required Java version has been upgraded from Java 8 to Java 11.
  ([ICU-23072](https://unicode-org.atlassian.net/browse/ICU-23072))\
  This is a significant, useful update in terms of the Java language and
  standard library, and simplifies ICU tooling.
  Note that [Android desugaring](https://developer.android.com/studio/write/java11-default-support-table)
  supports at least Java 11 since late 2023.
* [API Changes since ICU4J 77](https://htmlpreview.github.io/?https://github.com/unicode-org/icu/blob/maint/maint-78/icu4j/APIChangeReport.html)
  * TODO: In Java, there is a draft new Segmenter API which is easier and safer to use than BreakIterator.
* We have removed the
   [ICU4J Locale Service Provider](../userguide/icu4j/locale-service-provider.md)
   ([ICU-23071](https://unicode-org.atlassian.net/browse/ICU-23071))\
   ([Maven: com.ibm.icu / icu4j-localespi / version 77.1](https://mvnrepository.com/artifact/com.ibm.icu/icu4j-localespi/77.1)).
   It had become much less useful than when we added it and had very low usage.
   Projects that used it should call ICU4J directly instead.
* The Java implementation of the
  [CLDR MessageFormat 2.0 specification](https://www.unicode.org/reports/tr35/tr35-messageFormat.html)
  has been updated to CLDR 48.
  The core API has been upgraded to “draft”, while the Data Model API remains in technology preview.

## Known Issues

* (none yet)

## Migration Issues

* (none yet)

### Migration Issues Related to CLDR
* See [CLDR 48 migration issues](https://cldr.unicode.org/downloads/cldr-48#migration)

## ICU4C Platform Support

ICU4C requires C++17 and has been tested with up to C++23.

We routinely test on recent versions of Linux, macOS, and Windows.

We accept patches for other platforms.

Windows: The minimum supported version is Windows 7.
(See [How To Build And Install On Windows](../userguide/icu4c/build.html#how-to-build-and-install-on-windows)
for more details.)

## ICU4J Platform Support

ICU4J works on Java 11..25 (at least).

ICU4J should work on Android API level 21 and later but may require “[library desugaring](https://developer.android.com/studio/write/java8-support#library-desugaring)”.

## Download

### GitHub
TODO rc tag:
Source and binary downloads are available on the git/GitHub tag page: <https://github.com/unicode-org/icu/releases/tag/release-78.1rc>

See the [Source Code Setup](../devsetup/source/) page for how to download the ICU file tree directly from GitHub.

ICU locale data was generated from CLDR data equivalent to:

* <https://github.com/unicode-org/cldr/releases/tag/release-48-beta2>
* <https://github.com/unicode-org/cldr-staging/releases/tag/release-48-beta2>

### Maven
* TODO: not published yet
* https://mvnrepository.com/artifact/com.ibm.icu/icu4j/78.1
* https://mvnrepository.com/artifact/com.ibm.icu/icu4j-charset/78.1
* https://mvnrepository.com/artifact/com.ibm.icu/icu4j-localespi/78.1
