/* poppler-qiodevicestream-private.h: Qt6 interface to poppler
 * Copyright (C) 2008, Pino Toscano <pino@kde.org>
 * Copyright (C) 2013 Adrian Johnson <ajohnson@redneon.com>
 * Copyright (C) 2021, 2025 Albert Astals Cid <aacid@kde.org>
 * Copyright (C) 2021, Even Rouault <even.rouault@spatialys.com>
 * Copyright (C) 2024, g10 Code GmbH, Author: Sune Stolborg Vuorela <sune@vuorela.dk>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street - Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef POPPLER_QIODEVICESTREAM_PRIVATE_H
#define POPPLER_QIODEVICESTREAM_PRIVATE_H

#include "Stream.h"

class QIODevice;

namespace Poppler {

class QIODeviceOutStream : public OutStream
{
public:
    explicit QIODeviceOutStream(QIODevice *device);
    ~QIODeviceOutStream() override;

    void close() override;
    Goffset getPos() override;
    void put(char c) override;
    size_t write(std::span<const unsigned char> data) override;
    void printf(const char *format, ...) override GCC_PRINTF_FORMAT(2, 3);

private:
    QIODevice *m_device;
};

}

#endif
