// NOTE: File has been autogenerated by utils/aarch64_builtins_test_generator.py
// RUN: %clang_cc1 %s -fsyntax-only -triple aarch64-none-linux-gnu -target-feature +sme -target-feature +sme-tmop -target-feature +sme2 -target-feature +sve -verify=streaming-guard

// REQUIRES: aarch64-registered-target

#include <arm_sme.h>

// Properties: guard="" streaming_guard="sme,sme2,sme-tmop" flags="streaming-only,requires-za"

void test(void) __arm_inout("za"){
  svbfloat16_t svbfloat16_t_val;
  svbfloat16x2_t svbfloat16x2_t_val;
  svfloat16_t svfloat16_t_val;
  svfloat16x2_t svfloat16x2_t_val;
  svfloat32_t svfloat32_t_val;
  svfloat32x2_t svfloat32x2_t_val;
  svint8_t svint8_t_val;
  svint8x2_t svint8x2_t_val;
  svint16_t svint16_t_val;
  svint16x2_t svint16x2_t_val;
  svuint8_t svuint8_t_val;
  svuint8x2_t svuint8x2_t_val;
  svuint16_t svuint16_t_val;
  svuint16x2_t svuint16x2_t_val;

  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svtmopa_lane_za32(2, svbfloat16x2_t_val, svbfloat16_t_val, svuint8_t_val, 2);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svtmopa_lane_za32(2, svfloat16x2_t_val, svfloat16_t_val, svuint8_t_val, 2);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svtmopa_lane_za32(2, svfloat32x2_t_val, svfloat32_t_val, svuint8_t_val, 2);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svtmopa_lane_za32(2, svint8x2_t_val, svint8_t_val, svuint8_t_val, 2);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svtmopa_lane_za32(2, svint8x2_t_val, svuint8_t_val, svuint8_t_val, 2);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svtmopa_lane_za32(2, svint16x2_t_val, svint16_t_val, svuint8_t_val, 2);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svtmopa_lane_za32(2, svuint8x2_t_val, svint8_t_val, svuint8_t_val, 2);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svtmopa_lane_za32(2, svuint8x2_t_val, svuint8_t_val, svuint8_t_val, 2);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svtmopa_lane_za32(2, svuint16x2_t_val, svuint16_t_val, svuint8_t_val, 2);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svtmopa_lane_za32_bf16_bf16(2, svbfloat16x2_t_val, svbfloat16_t_val, svuint8_t_val, 2);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svtmopa_lane_za32_f16_f16(2, svfloat16x2_t_val, svfloat16_t_val, svuint8_t_val, 2);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svtmopa_lane_za32_f32_f32(2, svfloat32x2_t_val, svfloat32_t_val, svuint8_t_val, 2);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svtmopa_lane_za32_s8_s8(2, svint8x2_t_val, svint8_t_val, svuint8_t_val, 2);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svtmopa_lane_za32_s8_u8(2, svint8x2_t_val, svuint8_t_val, svuint8_t_val, 2);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svtmopa_lane_za32_s16_s16(2, svint16x2_t_val, svint16_t_val, svuint8_t_val, 2);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svtmopa_lane_za32_u8_s8(2, svuint8x2_t_val, svint8_t_val, svuint8_t_val, 2);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svtmopa_lane_za32_u8_u8(2, svuint8x2_t_val, svuint8_t_val, svuint8_t_val, 2);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svtmopa_lane_za32_u16_u16(2, svuint16x2_t_val, svuint16_t_val, svuint8_t_val, 2);
}

void test_streaming(void) __arm_streaming __arm_inout("za"){
  svbfloat16_t svbfloat16_t_val;
  svbfloat16x2_t svbfloat16x2_t_val;
  svfloat16_t svfloat16_t_val;
  svfloat16x2_t svfloat16x2_t_val;
  svfloat32_t svfloat32_t_val;
  svfloat32x2_t svfloat32x2_t_val;
  svint8_t svint8_t_val;
  svint8x2_t svint8x2_t_val;
  svint16_t svint16_t_val;
  svint16x2_t svint16x2_t_val;
  svuint8_t svuint8_t_val;
  svuint8x2_t svuint8x2_t_val;
  svuint16_t svuint16_t_val;
  svuint16x2_t svuint16x2_t_val;

  svtmopa_lane_za32(2, svbfloat16x2_t_val, svbfloat16_t_val, svuint8_t_val, 2);
  svtmopa_lane_za32(2, svfloat16x2_t_val, svfloat16_t_val, svuint8_t_val, 2);
  svtmopa_lane_za32(2, svfloat32x2_t_val, svfloat32_t_val, svuint8_t_val, 2);
  svtmopa_lane_za32(2, svint8x2_t_val, svint8_t_val, svuint8_t_val, 2);
  svtmopa_lane_za32(2, svint8x2_t_val, svuint8_t_val, svuint8_t_val, 2);
  svtmopa_lane_za32(2, svint16x2_t_val, svint16_t_val, svuint8_t_val, 2);
  svtmopa_lane_za32(2, svuint8x2_t_val, svint8_t_val, svuint8_t_val, 2);
  svtmopa_lane_za32(2, svuint8x2_t_val, svuint8_t_val, svuint8_t_val, 2);
  svtmopa_lane_za32(2, svuint16x2_t_val, svuint16_t_val, svuint8_t_val, 2);
  svtmopa_lane_za32_bf16_bf16(2, svbfloat16x2_t_val, svbfloat16_t_val, svuint8_t_val, 2);
  svtmopa_lane_za32_f16_f16(2, svfloat16x2_t_val, svfloat16_t_val, svuint8_t_val, 2);
  svtmopa_lane_za32_f32_f32(2, svfloat32x2_t_val, svfloat32_t_val, svuint8_t_val, 2);
  svtmopa_lane_za32_s8_s8(2, svint8x2_t_val, svint8_t_val, svuint8_t_val, 2);
  svtmopa_lane_za32_s8_u8(2, svint8x2_t_val, svuint8_t_val, svuint8_t_val, 2);
  svtmopa_lane_za32_s16_s16(2, svint16x2_t_val, svint16_t_val, svuint8_t_val, 2);
  svtmopa_lane_za32_u8_s8(2, svuint8x2_t_val, svint8_t_val, svuint8_t_val, 2);
  svtmopa_lane_za32_u8_u8(2, svuint8x2_t_val, svuint8_t_val, svuint8_t_val, 2);
  svtmopa_lane_za32_u16_u16(2, svuint16x2_t_val, svuint16_t_val, svuint8_t_val, 2);
}

void test_streaming_compatible(void) __arm_streaming_compatible __arm_inout("za"){
  svbfloat16_t svbfloat16_t_val;
  svbfloat16x2_t svbfloat16x2_t_val;
  svfloat16_t svfloat16_t_val;
  svfloat16x2_t svfloat16x2_t_val;
  svfloat32_t svfloat32_t_val;
  svfloat32x2_t svfloat32x2_t_val;
  svint8_t svint8_t_val;
  svint8x2_t svint8x2_t_val;
  svint16_t svint16_t_val;
  svint16x2_t svint16x2_t_val;
  svuint8_t svuint8_t_val;
  svuint8x2_t svuint8x2_t_val;
  svuint16_t svuint16_t_val;
  svuint16x2_t svuint16x2_t_val;

  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svtmopa_lane_za32(2, svbfloat16x2_t_val, svbfloat16_t_val, svuint8_t_val, 2);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svtmopa_lane_za32(2, svfloat16x2_t_val, svfloat16_t_val, svuint8_t_val, 2);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svtmopa_lane_za32(2, svfloat32x2_t_val, svfloat32_t_val, svuint8_t_val, 2);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svtmopa_lane_za32(2, svint8x2_t_val, svint8_t_val, svuint8_t_val, 2);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svtmopa_lane_za32(2, svint8x2_t_val, svuint8_t_val, svuint8_t_val, 2);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svtmopa_lane_za32(2, svint16x2_t_val, svint16_t_val, svuint8_t_val, 2);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svtmopa_lane_za32(2, svuint8x2_t_val, svint8_t_val, svuint8_t_val, 2);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svtmopa_lane_za32(2, svuint8x2_t_val, svuint8_t_val, svuint8_t_val, 2);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svtmopa_lane_za32(2, svuint16x2_t_val, svuint16_t_val, svuint8_t_val, 2);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svtmopa_lane_za32_bf16_bf16(2, svbfloat16x2_t_val, svbfloat16_t_val, svuint8_t_val, 2);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svtmopa_lane_za32_f16_f16(2, svfloat16x2_t_val, svfloat16_t_val, svuint8_t_val, 2);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svtmopa_lane_za32_f32_f32(2, svfloat32x2_t_val, svfloat32_t_val, svuint8_t_val, 2);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svtmopa_lane_za32_s8_s8(2, svint8x2_t_val, svint8_t_val, svuint8_t_val, 2);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svtmopa_lane_za32_s8_u8(2, svint8x2_t_val, svuint8_t_val, svuint8_t_val, 2);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svtmopa_lane_za32_s16_s16(2, svint16x2_t_val, svint16_t_val, svuint8_t_val, 2);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svtmopa_lane_za32_u8_s8(2, svuint8x2_t_val, svint8_t_val, svuint8_t_val, 2);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svtmopa_lane_za32_u8_u8(2, svuint8x2_t_val, svuint8_t_val, svuint8_t_val, 2);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svtmopa_lane_za32_u16_u16(2, svuint16x2_t_val, svuint16_t_val, svuint8_t_val, 2);
}
