include(RunCMake)

function(run_test name)
  set(RunCMake_TEST_BINARY_DIR ${RunCMake_BINARY_DIR}/${name}-build)
  run_cmake(${name})
  set(RunCMake_TEST_NO_CLEAN 1)
  run_cmake_command(${name}-build ${CMAKE_COMMAND} --build . --config Debug)
  run_cmake_command(${name}-test ${CMAKE_CTEST_COMMAND} -C Debug)
endfunction()

function(run_build_verbose name)
  set(RunCMake_TEST_BINARY_DIR ${RunCMake_BINARY_DIR}/${name}-build)
  run_cmake(${name})
  set(RunCMake_TEST_NO_CLEAN 1)
  run_cmake_command(${name}-build ${CMAKE_COMMAND} --build . --verbose --config Debug)
endfunction()

run_cmake(DisabledPch)
run_cmake(PchDebugGenex)
if (RunCMake_GENERATOR MATCHES "(Ninja|Makefiles|Visual Studio)")
  run_cmake(PchDebugGenexShort)
endif ()
run_test(PchInterface)
if (RunCMake_GENERATOR MATCHES "(Ninja|Makefiles|Visual Studio)")
  run_test(PchInterfaceShort)
endif ()
run_test(PchInterfaceUnity)
run_cmake(PchPrologueEpilogue)
run_test(SkipPrecompileHeaders)
run_test(CXXnotC)
run_test(PchReuseFrom-CMP0141-OLD)
run_test(PchReuseFrom-CMP0141-NEW)
if(CMAKE_C_COMPILER_ID STREQUAL "MSVC")
  run_test(PchReuseFrom-CMP0141-NEW-empty)
endif()
run_test(PchReuseFromPrefixed)
run_test(PchReuseFromSubdir)
run_build_verbose(PchReuseFromIgnoreOwnProps)
run_build_verbose(PchReuseFromUseUpdatedProps)
run_build_verbose(PchReuseConsistency)
run_cmake(PchReuseFromCycle)
run_cmake(PchReuseWithoutPch)
run_build_verbose(PchReuseAppend)
run_cmake(PchMultilanguage)
run_build_verbose(PchReuseDeclarationOrder)
if(RunCMake_GENERATOR MATCHES "Make|Ninja")
  run_cmake(PchWarnInvalid)

  if(CMAKE_C_COMPILER_ID STREQUAL "Clang" AND
      CMAKE_C_COMPILER_VERSION VERSION_GREATER_EQUAL 11.0.0 AND
      NOT CMAKE_C_SIMULATE_ID STREQUAL "MSVC")
    run_cmake(PchInstantiateTemplates)
  endif()
endif()
run_test(PchReuseFromObjLib)
run_test(PchIncludedAllLanguages)
run_test(PchIncludedOneLanguage)
run_test(PchLibObjLibExe)
