/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.config.CssProcessor;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.runtime.XStep;
import com.xmlcalabash.util.Base64;
import com.xmlcalabash.util.S9apiUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import java.util.Vector;
import jp.co.antenna.XfoJavaCtl.MessageListener;
import jp.co.antenna.XfoJavaCtl.XfoException;
import jp.co.antenna.XfoJavaCtl.XfoFormatPageListener;
import jp.co.antenna.XfoJavaCtl.XfoObj;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;

public class CssAH
implements CssProcessor {
    private static final QName _content_type = new QName("content-type");
    private static final QName _encoding = new QName("", "encoding");
    XProcRuntime runtime = null;
    Properties options = null;
    String primarySS = null;
    Vector<String> userSS = new Vector();
    XStep step = null;
    XfoObj ah = null;

    @Override
    public void initialize(XProcRuntime runtime, XStep step, Properties options) {
        this.runtime = runtime;
        this.step = step;
        this.options = options;
        try {
            Boolean b;
            this.ah = new XfoObj();
            this.ah.setFormatterType(3);
            FoMessages msgs = new FoMessages();
            this.ah.setMessageListener((MessageListener)msgs);
            String s = this.getStringProp("OptionsFileURI");
            if (s != null) {
                this.ah.setOptionFileURI(s);
            }
            this.ah.setExitLevel(4);
            Integer i = this.getIntProp("ExitLevel");
            if (i != null) {
                this.ah.setExitLevel(i.intValue());
            }
            if ((s = this.getStringProp("EmbedAllFontsEx")) != null) {
                if ("part".equals(s.toLowerCase())) {
                    this.ah.setPdfEmbedAllFontsEx(0);
                } else if ("base14".equals(s.toLowerCase())) {
                    this.ah.setPdfEmbedAllFontsEx(2);
                } else if ("all".equals(s.toLowerCase())) {
                    this.ah.setPdfEmbedAllFontsEx(1);
                } else {
                    throw new XProcException("Unrecognized value for EmbedAllFontsEx");
                }
            }
            if ((i = this.getIntProp("ImageCompression")) != null) {
                this.ah.setPdfImageCompression(i.intValue());
            }
            if ((b = this.getBooleanProp("NoAccessibility")) != null) {
                this.ah.setPdfNoAccessibility(b.booleanValue());
            }
            if ((b = this.getBooleanProp("NoAddingOrChangingComments")) != null) {
                this.ah.setPdfNoAddingOrChangingComments(b.booleanValue());
            }
            if ((b = this.getBooleanProp("NoAssembleDoc")) != null) {
                this.ah.setPdfNoAssembleDoc(b.booleanValue());
            }
            if ((b = this.getBooleanProp("NoChanging")) != null) {
                this.ah.setPdfNoChanging(b.booleanValue());
            }
            if ((b = this.getBooleanProp("NoContentCopying")) != null) {
                this.ah.setPdfNoContentCopying(b.booleanValue());
            }
            if ((b = this.getBooleanProp("NoFillForm")) != null) {
                this.ah.setPdfNoFillForm(b.booleanValue());
            }
            if ((b = this.getBooleanProp("NoPrinting")) != null) {
                this.ah.setPdfNoPrinting(b.booleanValue());
            }
            if ((s = this.getStringProp("OwnersPassword")) != null) {
                this.ah.setPdfOwnerPassword(s);
            }
            if ((b = this.getBooleanProp("TwoPassFormatting")) != null) {
                this.ah.setTwoPassFormatting(b.booleanValue());
            }
        }
        catch (XfoException xfoe) {
            throw new XProcException(xfoe);
        }
    }

    @Override
    public void addStylesheet(XdmNode doc) {
        File temp;
        doc = S9apiUtils.getDocumentElement(doc);
        String stylesheet = null;
        if (XProcConstants.c_data.equals((Object)doc.getNodeName()) && "application/octet-stream".equals(doc.getAttributeValue(_content_type)) || "base64".equals(doc.getAttributeValue(_encoding))) {
            byte[] decoded = Base64.decode(doc.getStringValue());
            stylesheet = new String(decoded);
        } else {
            stylesheet = doc.getStringValue();
        }
        String prefix = "temp";
        String suffix = ".css";
        try {
            temp = File.createTempFile(prefix, suffix);
        }
        catch (IOException ioe) {
            throw new XProcException(this.step.getNode(), "Failed to create temporary file for CSS");
        }
        temp.deleteOnExit();
        try {
            PrintStream cssout = new PrintStream(temp);
            cssout.print(stylesheet);
            cssout.close();
        }
        catch (FileNotFoundException fnfe) {
            throw new XProcException(this.step.getNode(), "Failed to write to temporary CSS file");
        }
        if (this.primarySS == null) {
            this.primarySS = temp.toURI().toASCIIString();
        } else {
            this.userSS.add(temp.toURI().toASCIIString());
        }
    }

    @Override
    public void format(XdmNode doc, OutputStream out, String contentType) {
        String outputFormat = null;
        if (contentType == null || "application/pdf".equals(contentType)) {
            outputFormat = "@PDF";
        } else if ("application/PostScript".equals(contentType)) {
            outputFormat = "@PS";
        } else if ("image/svg+xml".equals(contentType)) {
            outputFormat = "@SVG";
        } else if ("application/vnd.inx".equals(contentType)) {
            outputFormat = "@INX";
        } else if ("application/vnd.mif".equals(contentType)) {
            outputFormat = "@MIF";
        } else if ("text/plain".equals(contentType)) {
            outputFormat = "@TXT";
        } else {
            throw new XProcException(this.step.getNode(), "Unsupported content-type on p:xsl-formatter: " + contentType);
        }
        try {
            if (this.primarySS == null) {
                throw new XProcException("No CSS stylesheets provided");
            }
            this.ah.setStylesheetURI(this.primarySS);
            for (String uri : this.userSS) {
                this.ah.addUserStylesheetURI(uri);
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(doc.toString().getBytes("UTF-8"));
            this.ah.render((InputStream)bis, out, outputFormat);
            this.ah.releaseObjectEx();
        }
        catch (XfoException e) {
            if (this.runtime.getDebug()) {
                System.out.println("ErrorLevel = " + e.getErrorLevel() + "\nErrorCode = " + e.getErrorCode() + "\n" + e.getErrorMessage());
                e.printStackTrace();
            }
            throw new XProcException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new XProcException(e);
        }
    }

    private String getStringProp(String name) {
        return this.options.getProperty(name);
    }

    private Integer getIntProp(String name) {
        String s = this.getStringProp(name);
        if (s != null) {
            try {
                int i = Integer.parseInt(s);
                return new Integer(i);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        return null;
    }

    private Boolean getBooleanProp(String name) {
        String s = this.options.getProperty(name);
        if (s != null) {
            return "true".equals(s);
        }
        return null;
    }

    private class FoMessages
    implements MessageListener,
    XfoFormatPageListener {
        private FoMessages() {
        }

        public void onMessage(int errLevel, int errCode, String errMessage) {
            switch (errLevel) {
                case 1: {
                    CssAH.this.step.info(CssAH.this.step.getNode(), errMessage);
                    return;
                }
                case 2: {
                    CssAH.this.step.warning(CssAH.this.step.getNode(), errMessage);
                    return;
                }
            }
            CssAH.this.step.error(CssAH.this.step.getNode(), errMessage, XProcConstants.stepError(errCode));
        }

        public void onFormatPage(int pageNo) {
            CssAH.this.step.finest(CssAH.this.step.getNode(), "Formatted PDF page " + pageNo);
        }
    }
}

