/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Foreign;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Library {
    private static final Map<String, WeakReference<Library>> cache = new ConcurrentHashMap<String, WeakReference<Library>>();
    private static final Object lock = new Object();
    private static final ThreadLocal<String> lastError = new ThreadLocal();
    public static final int LAZY = 1;
    public static final int NOW = 2;
    public static final int LOCAL = 4;
    public static final int GLOBAL = 8;
    private final long handle;
    private final String name;

    private static final long dlopen(String name, int flags) {
        Foreign foreign = Foreign.getInstance();
        try {
            return foreign.dlopen(name, flags);
        }
        catch (UnsatisfiedLinkError ex) {
            lastError.set(ex.getMessage());
            return 0L;
        }
    }

    public static final Library getDefault() {
        return DefaultLibrary.INSTANCE;
    }

    public static final Library getCachedInstance(String name, int flags) {
        Library lib;
        if (name == null) {
            return Library.getDefault();
        }
        WeakReference<Library> ref = cache.get(name);
        Library library = lib = ref != null ? (Library)ref.get() : null;
        if (lib != null) {
            return lib;
        }
        lib = Library.openLibrary(name, flags);
        if (lib == null) {
            return null;
        }
        cache.put(name, new WeakReference<Library>(lib));
        return lib;
    }

    public static final Library openLibrary(String name, int flags) {
        long address;
        if (flags == 0) {
            flags = 5;
        }
        return (address = Library.dlopen(name, flags)) != 0L ? new Library(name, address) : null;
    }

    private Library(String name, long address) {
        this.name = name;
        this.handle = address;
    }

    public final long getSymbolAddress(String name) {
        Foreign foreign = Foreign.getInstance();
        try {
            return foreign.dlsym(this.handle, name);
        }
        catch (UnsatisfiedLinkError ex) {
            lastError.set(foreign.dlerror());
            return 0L;
        }
    }

    public static final String getLastError() {
        String error = lastError.get();
        return error != null ? error : "unknown";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.handle != 0L) {
                Foreign.getInstance().dlclose(this.handle);
            }
        }
        finally {
            super.finalize();
        }
    }

    static /* synthetic */ long access$000(String x0, int x1) {
        return Library.dlopen(x0, x1);
    }

    private static final class DefaultLibrary {
        private static final Library INSTANCE = new Library(null, Library.access$000(null, 9));

        private DefaultLibrary() {
        }
    }
}

