/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import java.io.Serializable;
import net.sf.saxon.Configuration;
import net.sf.saxon.Platform;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.CalendarValueComparer;
import net.sf.saxon.expr.sort.CodepointCollatingComparer;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.CollatingAtomicComparer;
import net.sf.saxon.expr.sort.ComparableAtomicValueComparer;
import net.sf.saxon.expr.sort.ComparisonKey;
import net.sf.saxon.expr.sort.EqualityComparer;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.StringValue;

public class GenericAtomicComparer
implements AtomicComparer,
Serializable {
    private StringCollator collator;
    private transient XPathContext context;

    public GenericAtomicComparer(StringCollator collator, XPathContext conversionContext) {
        this.collator = collator;
        if (collator == null) {
            this.collator = CodepointCollator.getInstance();
        }
        this.context = conversionContext;
    }

    public static AtomicComparer makeAtomicComparer(BuiltInAtomicType type0, BuiltInAtomicType type1, StringCollator collator, XPathContext context) {
        int fp1;
        int fp0 = type0.getFingerprint();
        if (fp0 == (fp1 = type1.getFingerprint())) {
            switch (fp0) {
                case 519: 
                case 520: 
                case 521: 
                case 522: 
                case 523: 
                case 524: 
                case 525: 
                case 526: {
                    return new CalendarValueComparer(context);
                }
                case 514: 
                case 633: 
                case 634: {
                    return ComparableAtomicValueComparer.getInstance();
                }
                case 527: 
                case 528: 
                case 530: 
                case 531: {
                    return EqualityComparer.getInstance();
                }
            }
        }
        if (type0.isPrimitiveNumeric() && type1.isPrimitiveNumeric()) {
            return ComparableAtomicValueComparer.getInstance();
        }
        if (!(fp0 != 513 && fp0 != 631 && fp0 != 529 || fp1 != 513 && fp1 != 631 && fp1 != 529)) {
            if (collator instanceof CodepointCollator) {
                return CodepointCollatingComparer.getInstance();
            }
            return new CollatingAtomicComparer(collator, Configuration.getPlatform());
        }
        return new GenericAtomicComparer(collator, context);
    }

    public StringCollator getCollator() {
        return this.collator;
    }

    public AtomicComparer provideContext(XPathContext context) {
        return new GenericAtomicComparer(this.collator, context);
    }

    public StringCollator getStringCollator() {
        return this.collator;
    }

    public int compareAtomicValues(AtomicValue a, AtomicValue b) throws NoDynamicContextException {
        if (a == null) {
            return b == null ? 0 : -1;
        }
        if (b == null) {
            return 1;
        }
        if (a instanceof StringValue && b instanceof StringValue) {
            if (this.collator instanceof CodepointCollator) {
                return ((CodepointCollator)this.collator).compareCS(a.getStringValueCS(), b.getStringValueCS());
            }
            return this.collator.compareStrings(a.getStringValue(), b.getStringValue());
        }
        Comparable ac = (Comparable)a.getXPathComparable(true, this.collator, this.context);
        Comparable bc = (Comparable)b.getXPathComparable(true, this.collator, this.context);
        if (ac == null || bc == null) {
            throw new ClassCastException("Objects are not comparable (" + Type.displayTypeName(a) + ", " + Type.displayTypeName(b) + ')');
        }
        return ac.compareTo(bc);
    }

    public boolean comparesEqual(AtomicValue a, AtomicValue b) throws NoDynamicContextException {
        if (a instanceof StringValue && b instanceof StringValue) {
            return this.collator.comparesEqual(a.getStringValue(), b.getStringValue());
        }
        if (a instanceof CalendarValue && b instanceof CalendarValue) {
            return ((CalendarValue)a).compareTo((CalendarValue)b, this.context) == 0;
        }
        Object ac = a.getXPathComparable(false, this.collator, this.context);
        Object bc = b.getXPathComparable(false, this.collator, this.context);
        return ac.equals(bc);
    }

    public ComparisonKey getComparisonKey(AtomicValue a) {
        if (a instanceof StringValue) {
            Platform platform = Configuration.getPlatform();
            if (platform.canReturnCollationKeys(this.collator)) {
                return new ComparisonKey(513, this.collator.getCollationKey(a.getStringValue()));
            }
            return new ComparisonKey(513, a.getStringValue());
        }
        return new ComparisonKey(513, a);
    }
}

