/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.standard;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.standard.StandardTokenizerImpl;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.Version;

public final class StandardTokenizer
extends Tokenizer {
    private final StandardTokenizerImpl scanner;
    public static final int ALPHANUM = 0;
    public static final int APOSTROPHE = 1;
    public static final int ACRONYM = 2;
    public static final int COMPANY = 3;
    public static final int EMAIL = 4;
    public static final int HOST = 5;
    public static final int NUM = 6;
    public static final int CJ = 7;
    public static final int ACRONYM_DEP = 8;
    public static final String[] TOKEN_TYPES = new String[]{"<ALPHANUM>", "<APOSTROPHE>", "<ACRONYM>", "<COMPANY>", "<EMAIL>", "<HOST>", "<NUM>", "<CJ>", "<ACRONYM_DEP>"};
    private boolean replaceInvalidAcronym;
    private int maxTokenLength = 255;
    private TermAttribute termAtt;
    private OffsetAttribute offsetAtt;
    private PositionIncrementAttribute posIncrAtt;
    private TypeAttribute typeAtt;

    public void setMaxTokenLength(int length) {
        this.maxTokenLength = length;
    }

    public int getMaxTokenLength() {
        return this.maxTokenLength;
    }

    public StandardTokenizer(Version matchVersion, Reader input) {
        this.scanner = new StandardTokenizerImpl(input);
        this.init(input, matchVersion);
    }

    public StandardTokenizer(Version matchVersion, AttributeSource source, Reader input) {
        super(source);
        this.scanner = new StandardTokenizerImpl(input);
        this.init(input, matchVersion);
    }

    public StandardTokenizer(Version matchVersion, AttributeSource.AttributeFactory factory, Reader input) {
        super(factory);
        this.scanner = new StandardTokenizerImpl(input);
        this.init(input, matchVersion);
    }

    private void init(Reader input, Version matchVersion) {
        this.replaceInvalidAcronym = matchVersion.onOrAfter(Version.LUCENE_24);
        this.input = input;
        this.termAtt = this.addAttribute(TermAttribute.class);
        this.offsetAtt = this.addAttribute(OffsetAttribute.class);
        this.posIncrAtt = this.addAttribute(PositionIncrementAttribute.class);
        this.typeAtt = this.addAttribute(TypeAttribute.class);
    }

    public final boolean incrementToken() throws IOException {
        this.clearAttributes();
        int posIncr = 1;
        int tokenType;
        while ((tokenType = this.scanner.getNextToken()) != -1) {
            if (this.scanner.yylength() <= this.maxTokenLength) {
                this.posIncrAtt.setPositionIncrement(posIncr);
                this.scanner.getText(this.termAtt);
                int start = this.scanner.yychar();
                this.offsetAtt.setOffset(this.correctOffset(start), this.correctOffset(start + this.termAtt.termLength()));
                if (tokenType == 8) {
                    if (this.replaceInvalidAcronym) {
                        this.typeAtt.setType(StandardTokenizerImpl.TOKEN_TYPES[5]);
                        this.termAtt.setTermLength(this.termAtt.termLength() - 1);
                    } else {
                        this.typeAtt.setType(StandardTokenizerImpl.TOKEN_TYPES[2]);
                    }
                } else {
                    this.typeAtt.setType(StandardTokenizerImpl.TOKEN_TYPES[tokenType]);
                }
                return true;
            }
            ++posIncr;
        }
        return false;
    }

    public final void end() {
        int finalOffset = this.correctOffset(this.scanner.yychar() + this.scanner.yylength());
        this.offsetAtt.setOffset(finalOffset, finalOffset);
    }

    public void reset() throws IOException {
        super.reset();
        this.scanner.yyreset(this.input);
    }

    public void reset(Reader reader) throws IOException {
        super.reset(reader);
        this.reset();
    }

    public boolean isReplaceInvalidAcronym() {
        return this.replaceInvalidAcronym;
    }

    public void setReplaceInvalidAcronym(boolean replaceInvalidAcronym) {
        this.replaceInvalidAcronym = replaceInvalidAcronym;
    }
}

