/* gnome-desktop-4.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Gnome", gir_namespace = "GnomeDesktop", gir_version = "4.0", lower_case_cprefix = "gnome_")]
namespace Gnome {
	namespace DesktopThumbnail {
		[CCode (cheader_filename = "libgnome-desktop/gnome-desktop-thumbnail.h")]
		[Version (since = "2.2")]
		public static bool is_valid (Gdk.Pixbuf pixbuf, string uri, time_t mtime);
		[CCode (cheader_filename = "libgnome-desktop/gnome-desktop-thumbnail.h")]
		[Version (since = "2.2")]
		public static string path_for_uri (string uri, Gnome.DesktopThumbnailSize size);
	}
	namespace Languages {
		[CCode (array_length = false, array_null_terminated = true, cheader_filename = "libgnome-desktop/gnome-languages.h", cname = "gnome_get_all_locales")]
		[Version (since = "3.8")]
		public static string[] get_all_locales ();
		[CCode (cheader_filename = "libgnome-desktop/gnome-languages.h", cname = "gnome_get_country_from_code")]
		[Version (since = "3.8")]
		public static string get_country_from_code (string code, string? translation);
		[CCode (cheader_filename = "libgnome-desktop/gnome-languages.h", cname = "gnome_get_country_from_locale")]
		[Version (since = "3.8")]
		public static string get_country_from_locale (string locale, string? translation);
		[CCode (cheader_filename = "libgnome-desktop/gnome-languages.h", cname = "gnome_get_input_source_from_locale")]
		[Version (since = "3.8")]
		public static bool get_input_source_from_locale (string locale, out unowned string type, out unowned string id);
		[CCode (cheader_filename = "libgnome-desktop/gnome-languages.h", cname = "gnome_get_language_from_code")]
		[Version (since = "3.8")]
		public static string get_language_from_code (string code, string? translation);
		[CCode (cheader_filename = "libgnome-desktop/gnome-languages.h", cname = "gnome_get_language_from_locale")]
		[Version (since = "3.8")]
		public static string get_language_from_locale (string locale, string? translation);
		[CCode (cheader_filename = "libgnome-desktop/gnome-languages.h", cname = "gnome_get_translated_modifier")]
		[Version (since = "3.34")]
		public static string get_translated_modifier (string modifier, string? translation);
		[CCode (cheader_filename = "libgnome-desktop/gnome-languages.h", cname = "gnome_language_has_translations")]
		[Version (since = "3.8")]
		public static bool language_has_translations (string code);
		[CCode (cheader_filename = "libgnome-desktop/gnome-languages.h", cname = "gnome_normalize_locale")]
		[Version (since = "3.8")]
		public static string normalize_locale (string locale);
		[CCode (cheader_filename = "libgnome-desktop/gnome-languages.h", cname = "gnome_parse_locale")]
		[Version (since = "3.8")]
		public static bool parse_locale (string locale, out string language_codep, out string? country_codep, out string? codesetp, out string? modifierp);
	}
	[CCode (cheader_filename = "libgnome-desktop/gnome-desktop-thumbnail.h", type_id = "gnome_desktop_thumbnail_factory_get_type ()")]
	public class DesktopThumbnailFactory : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "2.2")]
		public DesktopThumbnailFactory (Gnome.DesktopThumbnailSize size);
		[Version (since = "2.2")]
		public bool can_thumbnail (string uri, string mime_type, time_t mtime);
		[Version (since = "2.2")]
		public void create_failed_thumbnail (string uri, time_t mtime);
		public async void create_failed_thumbnail_async (string uri, time_t original_mtime, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "2.2")]
		public Gdk.Pixbuf generate_thumbnail (string uri, string mime_type);
		public async Gdk.Pixbuf generate_thumbnail_async (string uri, string mime_type, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "2.2")]
		public bool has_valid_failed_thumbnail (string uri, time_t mtime);
		[Version (since = "2.2")]
		public string lookup (string uri, time_t mtime);
		[Version (since = "2.2")]
		public void save_thumbnail (Gdk.Pixbuf thumbnail, string uri, time_t original_mtime);
		public async void save_thumbnail_async (Gdk.Pixbuf thumbnail, string uri, time_t original_mtime, GLib.Cancellable? cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "libgnome-desktop/gnome-idle-monitor.h", type_id = "gnome_idle_monitor_get_type ()")]
	public class IdleMonitor : GLib.Object, GLib.Initable {
		[CCode (has_construct_function = false)]
		public IdleMonitor ();
		public uint add_idle_watch (uint64 interval_msec, owned Gnome.IdleMonitorWatchFunc? callback);
		public uint add_user_active_watch (owned Gnome.IdleMonitorWatchFunc? callback);
		public uint64 get_idletime ();
		public void remove_watch (uint id);
	}
	[CCode (cheader_filename = "libgnome-desktop/gnome-pnp-ids.h", type_id = "gnome_pnp_ids_get_type ()")]
	public class PnpIds : GLib.Object {
		[CCode (has_construct_function = false)]
		public PnpIds ();
		public string get_pnp_id (string pnp_id);
	}
	[CCode (cheader_filename = "libgnome-desktop/gnome-wall-clock.h", type_id = "gnome_wall_clock_get_type ()")]
	public class WallClock : GLib.Object {
		[CCode (has_construct_function = false)]
		public WallClock ();
		public unowned string get_clock ();
		public unowned GLib.TimeZone get_timezone ();
		public string string_for_datetime (GLib.DateTime now, GDesktop.ClockFormat clock_format, bool show_weekday, bool show_full_date, bool show_seconds);
		public string clock { get; }
		[NoAccessorMethod]
		public bool force_seconds { get; set; }
		[NoAccessorMethod]
		public bool time_only { get; set; }
		public GLib.TimeZone timezone { get; }
	}
	[CCode (cheader_filename = "libgnome-desktop/gnome-xkb-info.h", type_id = "gnome_xkb_info_get_type ()")]
	public class XkbInfo : GLib.Object {
		[CCode (has_construct_function = false)]
		public XkbInfo ();
		[Version (since = "3.8")]
		public unowned string description_for_group (string group_id);
		[Version (since = "3.6")]
		public unowned string description_for_option (string group_id, string id);
		[Version (since = "3.6")]
		public GLib.List<weak string> get_all_layouts ();
		[Version (since = "3.6")]
		public GLib.List<weak string> get_all_option_groups ();
		[Version (since = "3.18")]
		public GLib.List<weak string> get_languages_for_layout (string layout_id);
		[Version (since = "3.6")]
		public bool get_layout_info (string id, out unowned string? display_name, out unowned string? short_name, out unowned string? xkb_layout, out unowned string? xkb_variant);
		[Version (since = "3.8")]
		public GLib.List<weak string> get_layouts_for_country (string country_code);
		[Version (since = "3.8")]
		public GLib.List<weak string> get_layouts_for_language (string language_code);
		[Version (since = "3.6")]
		public GLib.List<weak string> get_options_for_group (string group_id);
		public signal void layouts_changed ();
	}
	[CCode (cheader_filename = "libgnome-desktop/gnome-desktop-thumbnail.h", cprefix = "GNOME_DESKTOP_THUMBNAIL_SIZE_", has_type_id = false)]
	public enum DesktopThumbnailSize {
		NORMAL,
		LARGE,
		XLARGE,
		XXLARGE
	}
	[CCode (cheader_filename = "libgnome-desktop/gnome-idle-monitor.h", instance_pos = 2.9)]
	public delegate void IdleMonitorWatchFunc (Gnome.IdleMonitor monitor, uint id);
	[CCode (cheader_filename = "libgnome-desktop/gnome-desktop-version.h", cname = "GNOME_DESKTOP_PLATFORM_VERSION")]
	public const int DESKTOP_PLATFORM_VERSION;
	[CCode (cheader_filename = "libgnome-desktop/gnome-desktop-version.h")]
	[Version (since = "43.0")]
	public static int get_platform_version ();
	[CCode (cheader_filename = "libgnome-desktop/gnome-systemd.h")]
	public static async bool start_systemd_scope (string name, int32 pid, string? description, GLib.DBusConnection? connection, GLib.Cancellable? cancellable) throws GLib.Error;
}
