/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Generic {
    public static final int CHM_INITIAL_CAPACITY = 16;
    public static final float CHM_LOAD_FACTOR = 0.75f;
    public static final int CHM_CONCURRENCY_LEVEL = 2;

    public static <T> List<T> list() {
        return new ArrayList();
    }

    public static <T, U extends T> List<T> list(U ... contents) {
        ArrayList<U> l = new ArrayList<U>(contents.length);
        for (U t : contents) {
            l.add(t);
        }
        return l;
    }

    public static <K, V> Map<K, V> map() {
        return new HashMap();
    }

    public static <K, V> ConcurrentMap<K, V> concurrentMap() {
        return new ConcurrentHashMap(16, 0.75f, 2);
    }

    public static <E> Set<E> set() {
        return new HashSet();
    }

    public static <T, U extends T> Set<T> set(U ... contents) {
        HashSet<U> s = new HashSet<U>(contents.length);
        for (U u : contents) {
            s.add(u);
        }
        return s;
    }

    public static <E> Set<E> concurrentSet() {
        return Generic.newSetFromMap(Generic.concurrentMap());
    }

    public static <E> Set<E> newSetFromMap(Map<E, Boolean> map) {
        return new SetFromMap<E>(map);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetFromMap<E>
    extends AbstractSet<E>
    implements Serializable {
        private final Map<E, Boolean> map;
        private transient Set<E> keySet;

        public SetFromMap(Map<E, Boolean> map) {
            if (!map.isEmpty()) {
                throw new IllegalArgumentException("Map is non-empty");
            }
            this.map = map;
            this.keySet = map.keySet();
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.map.containsKey(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.keySet.containsAll(c);
        }

        @Override
        public Iterator<E> iterator() {
            return this.keySet.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.keySet.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.keySet.toArray(a);
        }

        @Override
        public boolean add(E e) {
            return this.map.put(e, Boolean.TRUE) == null;
        }

        @Override
        public boolean remove(Object o) {
            return this.map.remove(o) != null;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.keySet.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.keySet.retainAll(c);
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public boolean equals(Object o) {
            return o == this || ((Object)this.keySet).equals(o);
        }

        @Override
        public int hashCode() {
            return ((Object)this.keySet).hashCode();
        }

        @Override
        public String toString() {
            return this.keySet.toString();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.keySet = this.map.keySet();
        }
    }
}

