/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.sort.IntHashSet;
import net.sf.saxon.expr.sort.IntSet;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;

public class TypeHierarchy
implements Serializable {
    private Map map;
    private Configuration config;
    public static final int SAME_TYPE = 0;
    public static final int SUBSUMES = 1;
    public static final int SUBSUMED_BY = 2;
    public static final int OVERLAPS = 3;
    public static final int DISJOINT = 4;

    public TypeHierarchy(Configuration config) {
        this.config = config;
        this.map = new ConcurrentHashMap();
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public boolean isSubType(ItemType subtype, ItemType supertype) {
        int relation = this.relationship(subtype, supertype);
        return relation == 0 || relation == 2;
    }

    public int relationship(ItemType t1, ItemType t2) {
        if (t1 == null) {
            throw new NullPointerException();
        }
        if (t1.equals(t2)) {
            return 0;
        }
        ItemTypePair pair = new ItemTypePair(t1, t2);
        Integer result = (Integer)this.map.get(pair);
        if (result == null) {
            int r = this.computeRelationship(t1, t2);
            result = r;
            this.map.put(pair, result);
        }
        return result;
    }

    private int computeRelationship(ItemType t1, ItemType t2) {
        if (t1 == t2) {
            return 0;
        }
        if (t1 instanceof AnyItemType) {
            if (t2 instanceof AnyItemType) {
                return 0;
            }
            return 1;
        }
        if (t2 instanceof AnyItemType) {
            return 2;
        }
        if (t1.isAtomicType()) {
            if (t2 instanceof NodeTest || t2 instanceof FunctionItemType) {
                return 4;
            }
            if (t1 instanceof ExternalObjectType) {
                if (t2 instanceof ExternalObjectType) {
                    return ((ExternalObjectType)t1).getRelationship((ExternalObjectType)t2);
                }
                if (((AtomicType)t2).getFingerprint() == 632) {
                    return 2;
                }
                return 4;
            }
            if (t2 instanceof ExternalObjectType) {
                if (((AtomicType)t1).getFingerprint() == 632) {
                    return 1;
                }
                return 4;
            }
            if (((AtomicType)t1).getFingerprint() == ((AtomicType)t2).getFingerprint()) {
                return 0;
            }
            ItemType t = t2;
            while (t.isAtomicType()) {
                if (((AtomicType)t1).getFingerprint() == ((AtomicType)t).getFingerprint()) {
                    return 1;
                }
                t = t.getSuperType(this);
            }
            t = t1;
            while (t.isAtomicType()) {
                if (((AtomicType)t).getFingerprint() == ((AtomicType)t2).getFingerprint()) {
                    return 2;
                }
                t = t.getSuperType(this);
            }
            return 4;
        }
        if (t1 instanceof NodeTest) {
            int contentRelationship;
            int m2;
            if (t2.isAtomicType() || t2 instanceof FunctionItemType) {
                return 4;
            }
            if (t1 instanceof AnyNodeTest) {
                if (t2 instanceof AnyNodeTest) {
                    return 0;
                }
                return 1;
            }
            if (t2 instanceof AnyNodeTest) {
                return 2;
            }
            if (t1 instanceof EmptySequenceTest) {
                return 4;
            }
            if (t2 instanceof EmptySequenceTest) {
                return 4;
            }
            int m1 = ((NodeTest)t1).getNodeKindMask();
            if ((m1 & (m2 = ((NodeTest)t2).getNodeKindMask())) == 0) {
                return 4;
            }
            int nodeKindRelationship = m1 == m2 ? 0 : ((m1 & m2) == m1 ? 2 : ((m1 & m2) == m2 ? 1 : 3));
            IntSet n1 = ((NodeTest)t1).getRequiredNodeNames();
            IntSet n2 = ((NodeTest)t2).getRequiredNodeNames();
            int nodeNameRelationship = n1 == null ? (n2 == null ? 0 : 1) : (n2 == null ? 2 : (n1.containsAll(n2) ? (n1.size() == n2.size() ? 0 : 1) : (n2.containsAll(n1) ? 2 : (IntHashSet.containsSome(n1, n2) ? 3 : 4))));
            if (t1 instanceof DocumentNodeTest) {
                contentRelationship = t2 instanceof DocumentNodeTest ? this.relationship(((DocumentNodeTest)t1).getElementTest(), ((DocumentNodeTest)t2).getElementTest()) : 2;
            } else if (t2 instanceof DocumentNodeTest) {
                contentRelationship = 1;
            } else {
                SchemaType s1 = ((NodeTest)t1).getContentType();
                SchemaType s2 = ((NodeTest)t2).getContentType();
                contentRelationship = TypeHierarchy.schemaTypeRelationship(s1, s2);
            }
            if (nodeKindRelationship == 0 && nodeNameRelationship == 0 && contentRelationship == 0) {
                return 0;
            }
            if (!(nodeKindRelationship != 0 && nodeKindRelationship != 1 || nodeNameRelationship != 0 && nodeNameRelationship != 1 || contentRelationship != 0 && contentRelationship != 1)) {
                return 1;
            }
            if (!(nodeKindRelationship != 0 && nodeKindRelationship != 2 || nodeNameRelationship != 0 && nodeNameRelationship != 2 || contentRelationship != 0 && contentRelationship != 2)) {
                return 2;
            }
            if (nodeKindRelationship == 4 || nodeNameRelationship == 4 || contentRelationship == 4) {
                return 4;
            }
            return 3;
        }
        if (t2 instanceof FunctionItemType) {
            return ((FunctionItemType)t1).relationship((FunctionItemType)t2, this);
        }
        return 4;
    }

    public boolean isIdCode(int typeCode) {
        if ((typeCode &= 0xFFFFF) == 560) {
            return true;
        }
        if (typeCode < 1024) {
            return false;
        }
        SchemaType type = this.config.getSchemaType(typeCode);
        if (type == null) {
            return false;
        }
        return type.isIdType();
    }

    public boolean isIdrefsCode(int typeCode) {
        if ((typeCode &= 0xFFFFF) == 561 || typeCode == 562) {
            return true;
        }
        if (typeCode < 1024) {
            return false;
        }
        SchemaType type = this.config.getSchemaType(typeCode);
        if (type == null) {
            return false;
        }
        return type.isIdRefType();
    }

    public static int schemaTypeRelationship(SchemaType s1, SchemaType s2) {
        if (s1.isSameType(s2)) {
            return 0;
        }
        if (s1 instanceof AnyType) {
            return 1;
        }
        if (s2 instanceof AnyType) {
            return 2;
        }
        SchemaType t1 = s1;
        while ((t1 = t1.getBaseType()) != null) {
            if (!t1.isSameType(s2)) continue;
            return 2;
        }
        SchemaType t2 = s2;
        while ((t2 = t2.getBaseType()) != null) {
            if (!t2.isSameType(s1)) continue;
            return 1;
        }
        return 4;
    }

    private static class ItemTypePair
    implements Serializable {
        ItemType s;
        ItemType t;

        public ItemTypePair(ItemType s, ItemType t) {
            this.s = s;
            this.t = t;
        }

        public int hashCode() {
            return this.s.hashCode() ^ this.t.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ItemTypePair) {
                ItemTypePair pair = (ItemTypePair)obj;
                return this.s.equals(pair.s) && this.t.equals(pair.t);
            }
            return false;
        }
    }
}

