/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.model;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.model.ComputableValue;
import java.net.URI;
import java.util.Hashtable;
import java.util.Vector;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.ItemTypeFactory;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.value.StringValue;

public class RuntimeValue {
    private Vector<XdmItem> generalValue = null;
    private String value = null;
    private XdmNode node = null;
    private ComputableValue val = null;
    private boolean initialized = false;
    private Hashtable<String, String> nsBindings = null;

    public RuntimeValue() {
    }

    public RuntimeValue(String string, XdmNode xdmNode) {
        this.value = string;
        this.node = xdmNode;
        this.initialized = true;
        this.nsBindings = new Hashtable();
        XdmSequenceIterator xdmSequenceIterator = xdmNode.axisIterator(Axis.NAMESPACE);
        while (xdmSequenceIterator.hasNext()) {
            XdmNode xdmNode2 = (XdmNode)xdmSequenceIterator.next();
            QName qName = xdmNode2.getNodeName();
            String string2 = xdmNode2.getStringValue();
            if (qName == null) {
                this.nsBindings.put("", string2);
                continue;
            }
            String string3 = qName.getLocalName();
            this.nsBindings.put(string3, string2);
        }
    }

    public RuntimeValue(String string, XdmNode xdmNode, Hashtable<String, String> hashtable) {
        this.value = string;
        this.node = xdmNode;
        this.nsBindings = hashtable;
        this.initialized = true;
    }

    public RuntimeValue(String string, Vector<XdmItem> vector, XdmNode xdmNode, Hashtable<String, String> hashtable) {
        this.value = string;
        this.generalValue = vector;
        this.node = xdmNode;
        this.nsBindings = hashtable;
        this.initialized = true;
    }

    public RuntimeValue(String string) {
        this.value = string;
        this.initialized = true;
    }

    public boolean initialized() {
        return this.initialized;
    }

    public XdmAtomicValue getUntypedAtomic(XProcRuntime xProcRuntime) {
        try {
            ItemTypeFactory itemTypeFactory = new ItemTypeFactory(xProcRuntime.getProcessor());
            ItemType itemType = itemTypeFactory.getAtomicType(new QName("http://www.w3.org/2001/XMLSchema", "xs:untypedAtomic"));
            XdmAtomicValue xdmAtomicValue = new XdmAtomicValue(this.value, itemType);
            return xdmAtomicValue;
        }
        catch (SaxonApiException saxonApiException) {
            throw new XProcException(saxonApiException);
        }
    }

    public String getString() {
        return this.value;
    }

    public boolean hasGeneralValue() {
        return this.generalValue != null;
    }

    public XdmValue getValue() {
        if (this.generalValue == null) {
            throw new XProcException(this.node, "Unexpexted null value in getValue()");
        }
        if (this.generalValue.size() == 1) {
            return (XdmValue)this.generalValue.get(0);
        }
        return new XdmValue(this.generalValue);
    }

    public StringValue getStringValue() {
        return new StringValue((CharSequence)this.value);
    }

    public QName getQName() {
        if (this.value.contains(":")) {
            return new QName(this.value, this.node);
        }
        return new QName("", this.value);
    }

    public XdmNode getNode() {
        return this.node;
    }

    public URI getBaseURI() {
        return this.node.getBaseURI();
    }

    public Hashtable<String, String> getNamespaceBindings() {
        return this.nsBindings;
    }

    public boolean getBoolean() {
        if ("true".equals(this.value) || "1".equals(this.value)) {
            return true;
        }
        if ("false".equals(this.value) || "0".equals(this.value)) {
            return false;
        }
        throw new XProcException(this.node, "Non boolean string: " + this.value);
    }

    public int getInt() {
        int n = Integer.parseInt(this.value);
        return n;
    }

    public XdmSequenceIterator getNamespaces() {
        return this.node.axisIterator(Axis.NAMESPACE);
    }
}

