/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.style.SAXONFunction;
import com.icl.saxon.style.StandardNames;
import com.icl.saxon.style.XSLFallback;
import com.icl.saxon.style.XSLGeneralVariable;
import com.icl.saxon.tree.AttributeCollection;
import com.icl.saxon.tree.NodeImpl;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public class SAXONReturn
extends XSLGeneralVariable {
    public boolean isInstruction() {
        return true;
    }

    public int getVariableFingerprint() {
        return -1;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            int n3 = n2 & 0xFFFFF;
            if (n3 == standardNames.SELECT) {
                string = attributeCollection.getValue(n);
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string != null) {
            this.select = this.makeExpression(string);
        }
    }

    public void validate() throws TransformerConfigurationException {
        NodeImpl nodeImpl;
        NodeInfo nodeInfo = (NodeInfo)((Object)this.getParentNode());
        while (nodeInfo != null) {
            if (nodeInfo instanceof SAXONFunction) break;
            if (nodeInfo instanceof XSLGeneralVariable) {
                this.compileError(this.getDisplayName() + " must not be used within a variable definition");
            }
            nodeInfo = nodeInfo.getParent();
        }
        if (nodeInfo == null) {
            this.compileError(this.getDisplayName() + " must only be used within a function definition");
        }
        if ((nodeImpl = (NodeImpl)this.getNextSibling()) != null && !(nodeImpl instanceof XSLFallback)) {
            this.compileError(this.getDisplayName() + " must be the last instruction in its template body");
        }
        if (this.select == null && !this.hasChildNodes()) {
            this.select = new StringValue("");
        }
    }

    public void process(Context context) throws TransformerException {
        Value value = this.getSelectValue(context);
        context.setReturnValue(value);
    }
}

