/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.config.XMLCalabashConfigurer;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadableData;
import com.xmlcalabash.io.ReadableDocument;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.library.Load;
import com.xmlcalabash.model.DataBinding;
import com.xmlcalabash.model.DocumentBinding;
import com.xmlcalabash.model.RuntimeValue;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;

public class DefaultXMLCalabashConfigurer
implements XMLCalabashConfigurer {
    private static final QName _href = new QName("href");
    private static final QName _dtd_validate = new QName("dtd-validate");
    private static final QName cx_filemask = new QName("cx", "http://xmlcalabash.com/ns/extensions", "filemask");
    protected XProcRuntime runtime = null;

    public DefaultXMLCalabashConfigurer(XProcRuntime xProcRuntime) {
        this.runtime = xProcRuntime;
    }

    @Override
    public void configRuntime(XProcRuntime xProcRuntime) {
    }

    @Override
    public XdmNode loadDocument(Load load) {
        boolean bl = load.getOption(_dtd_validate, false);
        RuntimeValue runtimeValue = load.getOption(_href);
        String string = runtimeValue.getBaseURI().toASCIIString();
        if (this.runtime.getSafeMode() && string.startsWith("file:")) {
            throw XProcException.dynamicError(21);
        }
        return this.runtime.parse(runtimeValue.getString(), string, bl);
    }

    @Override
    public ReadablePipe makeReadableData(XProcRuntime xProcRuntime, DataBinding dataBinding) {
        return new ReadableData(xProcRuntime, dataBinding.getWrapper(), dataBinding.getHref(), dataBinding.getContentType());
    }

    @Override
    public ReadablePipe makeReadableDocument(XProcRuntime xProcRuntime, DocumentBinding documentBinding) {
        String string = documentBinding.getExtensionAttribute(cx_filemask);
        String string2 = documentBinding.getNode().getBaseURI().toASCIIString();
        return new ReadableDocument(xProcRuntime, documentBinding.getNode(), documentBinding.getHref(), string2, string);
    }
}

