/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.model;

import com.xmlcalabash.core.XProcRuntime;
import java.util.Hashtable;
import java.util.Set;
import java.util.logging.Logger;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;

public abstract class SourceArtifact {
    protected XdmNode node = null;
    protected XProcRuntime runtime = null;
    protected Hashtable<QName, String> extnAttrs = null;
    protected Logger logger = null;

    public SourceArtifact(XProcRuntime xProcRuntime, XdmNode xdmNode) {
        this.runtime = xProcRuntime;
        this.node = xdmNode;
        this.logger = Logger.getLogger(this.getClass().getName());
    }

    public XProcRuntime getXProc() {
        return this.runtime;
    }

    public XdmNode getNode() {
        return this.node;
    }

    public String xplFile() {
        if (this.node == null) {
            return "";
        }
        return this.node.getDocumentURI().toASCIIString();
    }

    public int xplLine() {
        if (this.node == null) {
            return -1;
        }
        return this.node.getLineNumber();
    }

    public void addExtensionAttribute(XdmNode xdmNode) {
        if (this.extnAttrs == null) {
            this.extnAttrs = new Hashtable();
        }
        this.extnAttrs.put(xdmNode.getNodeName(), xdmNode.getStringValue());
    }

    public String getExtensionAttribute(QName qName) {
        if (this.extnAttrs == null || !this.extnAttrs.containsKey(qName)) {
            return null;
        }
        return this.extnAttrs.get(qName);
    }

    public Set<QName> getExtensionAttributes() {
        if (this.extnAttrs == null) {
            this.extnAttrs = new Hashtable();
        }
        return this.extnAttrs.keySet();
    }

    public void error(String string, QName qName) {
        this.runtime.error(null, this.node, string, qName);
    }

    public void error(XdmNode xdmNode, String string, QName qName) {
        this.runtime.error(null, xdmNode, string, qName);
    }
}

