/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.io.Serializable;
import java.util.Arrays;
import net.sf.saxon.expr.sort.IntHashMap;
import net.sf.saxon.trans.XPathException;

public class DecimalSymbols
implements Serializable {
    public int decimalSeparator = 46;
    public int groupingSeparator = 44;
    public int digit = 35;
    public int minusSign = 45;
    public int percent = 37;
    public int permill = 8240;
    public int zeroDigit = 48;
    public int patternSeparator = 59;
    public String infinity = "Infinity";
    public String NaN = "NaN";
    static int[] zeroDigits = new int[]{48, 1632, 1776, 2406, 2534, 2662, 2790, 2918, 3046, 3174, 3302, 3430, 3664, 3792, 3872, 4160, 6112, 6160, 6470, 6608, 65296, 66720, 120782, 120792, 120802, 120812, 120822};

    public void checkDistinctRoles() throws XPathException {
        IntHashMap<String> map = new IntHashMap<String>(20);
        map.put(this.decimalSeparator, "decimal-separator");
        if (map.get(this.groupingSeparator) != null) {
            this.duplicate("grouping-separator", (String)map.get(this.groupingSeparator));
        }
        map.put(this.groupingSeparator, "grouping-separator");
        if (map.get(this.percent) != null) {
            this.duplicate("percent", (String)map.get(this.percent));
        }
        map.put(this.percent, "percent");
        if (map.get(this.permill) != null) {
            this.duplicate("per-mille", (String)map.get(this.permill));
        }
        map.put(this.permill, "per-mille");
        if (map.get(this.zeroDigit) != null) {
            this.duplicate("zero-digit", (String)map.get(this.zeroDigit));
        }
        map.put(this.zeroDigit, "zero-digit");
        if (map.get(this.digit) != null) {
            this.duplicate("digit", (String)map.get(this.digit));
        }
        map.put(this.digit, "digit");
        if (map.get(this.patternSeparator) != null) {
            this.duplicate("pattern-separator", (String)map.get(this.patternSeparator));
        }
    }

    private void duplicate(String role1, String role2) throws XPathException {
        throw new XPathException("The same character is used as the " + role1 + " and as the " + role2);
    }

    public boolean isValidZeroDigit() throws XPathException {
        return Arrays.binarySearch(zeroDigits, this.zeroDigit) >= 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DecimalSymbols)) {
            return false;
        }
        DecimalSymbols o = (DecimalSymbols)obj;
        return this.decimalSeparator == o.decimalSeparator && this.groupingSeparator == o.groupingSeparator && this.digit == o.digit && this.minusSign == o.minusSign && this.percent == o.percent && this.permill == o.permill && this.zeroDigit == o.zeroDigit && this.patternSeparator == o.patternSeparator && this.infinity.equals(o.infinity) && this.NaN.equals(o.NaN);
    }

    public int hashCode() {
        return this.decimalSeparator + 37 * this.groupingSeparator + 41 * this.digit;
    }
}

