/*
 * Decompiled with CFR 0.152.
 */
package com.nwalsh.xalan;

import com.nwalsh.xalan.Callout;
import com.nwalsh.xalan.FormatCallout;
import com.nwalsh.xalan.FormatDingbatCallout;
import com.nwalsh.xalan.FormatGraphicCallout;
import com.nwalsh.xalan.FormatTextCallout;
import com.nwalsh.xalan.FormatUnicodeCallout;
import com.nwalsh.xalan.Params;
import java.util.Arrays;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xalan.extensions.ExpressionContext;
import org.apache.xml.utils.DOMBuilder;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Verbatim {
    private Stack elementStack = null;
    private Stack tempStack = null;
    private int lineNumber = 0;
    private int colNumber = 0;
    private int modulus = 0;
    private int width = 0;
    private String separator = "";
    private Callout[] callout = null;
    private int calloutCount = 0;
    private int calloutPos = 0;
    private String graphicsPath = null;
    private String graphicsExt = null;
    private int graphicsMax = 10;
    private static String iconSize = null;
    private boolean graphicsFO = false;
    private static final String foURI = "http://www.w3.org/1999/XSL/Format";
    private static final String xhURI = "http://www.w3.org/1999/xhtml";

    public DocumentFragment numberLines(ExpressionContext context, NodeIterator xalanNI) {
        int xalanMod = Params.getInt(context, "linenumbering.everyNth");
        int xalanWidth = Params.getInt(context, "linenumbering.width");
        String xalanSep = Params.getString(context, "linenumbering.separator");
        DocumentFragment xalanRTF = (DocumentFragment)xalanNI.nextNode();
        int numLines = this.countLineBreaks(xalanRTF) + 1;
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = docFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            System.out.println("PCE!");
            return xalanRTF;
        }
        Document doc = docBuilder.newDocument();
        DocumentFragment df = doc.createDocumentFragment();
        DOMBuilder db = new DOMBuilder(doc, df);
        this.elementStack = new Stack();
        this.lineNumber = 0;
        this.modulus = numLines < xalanMod ? 1 : xalanMod;
        this.width = xalanWidth;
        this.separator = xalanSep;
        double log10numLines = Math.log(numLines) / Math.log(10.0);
        if ((double)this.width < log10numLines + 1.0) {
            this.width = (int)Math.floor(log10numLines + 1.0);
        }
        this.lineNumberFragment(db, xalanRTF);
        return df;
    }

    private int countLineBreaks(Node node) {
        int numLines;
        block3: {
            block2: {
                numLines = 0;
                if (node.getNodeType() != 11 && node.getNodeType() != 9 && node.getNodeType() != 1) break block2;
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    numLines += this.countLineBreaks(child);
                }
                break block3;
            }
            if (node.getNodeType() != 3) break block3;
            String text = node.getNodeValue();
            boolean pos = false;
            for (int count = 0; count < text.length(); ++count) {
                if (text.charAt(count) != '\n') continue;
                ++numLines;
            }
        }
        return numLines;
    }

    private void lineNumberFragment(DOMBuilder rtf, Node node) {
        try {
            char[] chars;
            String text;
            String name;
            String localName;
            String ns;
            if (node.getNodeType() == 11 || node.getNodeType() == 9) {
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    this.lineNumberFragment(rtf, child);
                }
            } else if (node.getNodeType() == 1) {
                ns = node.getNamespaceURI();
                localName = node.getLocalName();
                name = ((Element)node).getTagName();
                rtf.startElement(ns, localName, name, this.copyAttributes((Element)node));
                this.elementStack.push(node);
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    this.lineNumberFragment(rtf, child);
                }
            } else if (node.getNodeType() == 3) {
                text = node.getNodeValue();
                if (this.lineNumber == 0) {
                    this.formatLineNumber(rtf, ++this.lineNumber);
                }
                chars = text.toCharArray();
                int pos = 0;
                for (int count = 0; count < text.length(); ++count) {
                    if (text.charAt(count) == '\n') {
                        if (pos > 0) {
                            rtf.characters(chars, 0, pos);
                            pos = 0;
                        }
                        this.closeOpenElements(rtf);
                        chars[pos++] = text.charAt(count);
                        rtf.characters(chars, 0, pos);
                        pos = 0;
                        this.formatLineNumber(rtf, ++this.lineNumber);
                        this.openClosedElements(rtf);
                        continue;
                    }
                    chars[pos++] = text.charAt(count);
                }
                if (pos > 0) {
                    rtf.characters(chars, 0, pos);
                }
            } else if (node.getNodeType() == 8) {
                text = node.getNodeValue();
                chars = text.toCharArray();
                rtf.comment(chars, 0, text.length());
            } else if (node.getNodeType() == 7) {
                rtf.processingInstruction(node.getNodeName(), node.getNodeValue());
            } else {
                System.out.println("Warning: unexpected node type in lineNumberFragment");
            }
            if (node.getNodeType() == 1) {
                ns = node.getNamespaceURI();
                localName = node.getLocalName();
                name = ((Element)node).getTagName();
                rtf.endElement(ns, localName, name);
                this.elementStack.pop();
            }
        }
        catch (SAXException e) {
            System.out.println("SAX Exception in lineNumberFragment");
        }
    }

    private void formatLineNumber(DOMBuilder rtf, int lineNumber) {
        char ch = '\u00a0';
        String lno = "";
        if (lineNumber == 1 || this.modulus >= 1 && lineNumber % this.modulus == 0) {
            lno = "" + lineNumber;
        }
        while (lno.length() < this.width) {
            lno = ch + lno;
        }
        lno = lno + this.separator;
        char[] chars = lno.toCharArray();
        try {
            rtf.characters(chars, 0, lno.length());
        }
        catch (SAXException e) {
            System.out.println("SAX Exception in formatLineNumber");
        }
    }

    public DocumentFragment insertCallouts(ExpressionContext context, NodeIterator areaspecNodeSet, NodeIterator xalanNI) {
        String type = Params.getString(context, "stylesheet.result.type");
        boolean useFO = type.equals("fo");
        int defaultColumn = Params.getInt(context, "callout.defaultcolumn");
        if (Params.getBoolean(context, "callout.graphics")) {
            String gPath = Params.getString(context, "callout.graphics.path");
            String gExt = Params.getString(context, "callout.graphics.extension");
            int gMax = Params.getInt(context, "callout.graphics.number.limit");
            String gSize = Params.getString(context, "callout.icon.size");
            return this.insertGraphicCallouts(areaspecNodeSet, xalanNI, defaultColumn, gPath, gExt, gMax, gSize, useFO);
        }
        if (Params.getBoolean(context, "callout.unicode")) {
            int uStart = Params.getInt(context, "callout.unicode.start.character");
            int uMax = Params.getInt(context, "callout.unicode.number.limit");
            String uFont = Params.getString(context, "callout.unicode.font");
            return this.insertUnicodeCallouts(areaspecNodeSet, xalanNI, defaultColumn, uFont, uStart, uMax, useFO);
        }
        if (Params.getBoolean(context, "callout.dingbats")) {
            int dMax = 10;
            return this.insertDingbatCallouts(areaspecNodeSet, xalanNI, defaultColumn, dMax, useFO);
        }
        return this.insertTextCallouts(areaspecNodeSet, xalanNI, defaultColumn, useFO);
    }

    public DocumentFragment insertGraphicCallouts(NodeIterator areaspecNodeSet, NodeIterator xalanNI, int defaultColumn, String gPath, String gExt, int gMax, String gSize, boolean useFO) {
        FormatGraphicCallout fgc = new FormatGraphicCallout(gPath, gExt, gMax, gSize, useFO);
        return this.insertCallouts(areaspecNodeSet, xalanNI, defaultColumn, fgc);
    }

    public DocumentFragment insertUnicodeCallouts(NodeIterator areaspecNodeSet, NodeIterator xalanNI, int defaultColumn, String uFont, int uStart, int uMax, boolean useFO) {
        FormatUnicodeCallout fuc = new FormatUnicodeCallout(uFont, uStart, uMax, useFO);
        return this.insertCallouts(areaspecNodeSet, xalanNI, defaultColumn, fuc);
    }

    public DocumentFragment insertDingbatCallouts(NodeIterator areaspecNodeSet, NodeIterator xalanNI, int defaultColumn, int gMax, boolean useFO) {
        FormatDingbatCallout fdc = new FormatDingbatCallout(gMax, useFO);
        return this.insertCallouts(areaspecNodeSet, xalanNI, defaultColumn, fdc);
    }

    public DocumentFragment insertTextCallouts(NodeIterator areaspecNodeSet, NodeIterator xalanNI, int defaultColumn, boolean useFO) {
        FormatTextCallout ftc = new FormatTextCallout(useFO);
        return this.insertCallouts(areaspecNodeSet, xalanNI, defaultColumn, ftc);
    }

    public DocumentFragment insertCallouts(NodeIterator areaspecNodeSet, NodeIterator xalanNI, int defaultColumn, FormatCallout fCallout) {
        DocumentFragment xalanRTF = (DocumentFragment)xalanNI.nextNode();
        this.callout = new Callout[10];
        this.calloutCount = 0;
        this.calloutPos = 0;
        this.lineNumber = 1;
        this.colNumber = 1;
        boolean pos = false;
        int coNum = 0;
        boolean inAreaSet = false;
        Node node = areaspecNodeSet.nextNode();
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equals("areaset")) {
                ++coNum;
                for (Node area = node.getFirstChild(); area != null; area = area.getNextSibling()) {
                    if (area.getNodeType() != 1) continue;
                    if (area.getNodeName().equals("area")) {
                        this.addCallout(coNum, area, defaultColumn);
                        continue;
                    }
                    System.out.println("Unexpected element in areaset: " + area.getNodeName());
                }
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("area")) {
                this.addCallout(++coNum, node, defaultColumn);
                continue;
            }
            System.out.println("Unexpected element in areaspec: " + node.getNodeName());
        }
        Arrays.sort(this.callout, 0, this.calloutCount);
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = docFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            System.out.println("PCE 2!");
            return xalanRTF;
        }
        Document doc = docBuilder.newDocument();
        DocumentFragment df = doc.createDocumentFragment();
        DOMBuilder db = new DOMBuilder(doc, df);
        this.elementStack = new Stack();
        this.calloutFragment(db, xalanRTF, fCallout);
        return df;
    }

    private void calloutFragment(DOMBuilder rtf, Node node, FormatCallout fCallout) {
        try {
            char[] chars;
            String text;
            String name;
            String localName;
            String ns;
            if (node.getNodeType() == 11 || node.getNodeType() == 9) {
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    this.calloutFragment(rtf, child, fCallout);
                }
            } else if (node.getNodeType() == 1) {
                ns = node.getNamespaceURI();
                localName = node.getLocalName();
                name = ((Element)node).getTagName();
                rtf.startElement(ns, localName, name, this.copyAttributes((Element)node));
                this.elementStack.push(node);
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    this.calloutFragment(rtf, child, fCallout);
                }
            } else if (node.getNodeType() == 3) {
                text = node.getNodeValue();
                chars = text.toCharArray();
                int pos = 0;
                for (int count = 0; count < text.length(); ++count) {
                    if (this.calloutPos < this.calloutCount && this.callout[this.calloutPos].getLine() == this.lineNumber && this.callout[this.calloutPos].getColumn() == this.colNumber) {
                        if (pos > 0) {
                            rtf.characters(chars, 0, pos);
                            pos = 0;
                        }
                        this.closeOpenElements(rtf);
                        while (this.calloutPos < this.calloutCount && this.callout[this.calloutPos].getLine() == this.lineNumber && this.callout[this.calloutPos].getColumn() == this.colNumber) {
                            fCallout.formatCallout(rtf, this.callout[this.calloutPos]);
                            ++this.calloutPos;
                        }
                        this.openClosedElements(rtf);
                    }
                    if (text.charAt(count) == '\n') {
                        if (this.calloutPos < this.calloutCount && this.callout[this.calloutPos].getLine() == this.lineNumber && this.callout[this.calloutPos].getColumn() > this.colNumber) {
                            if (pos > 0) {
                                rtf.characters(chars, 0, pos);
                                pos = 0;
                            }
                            this.closeOpenElements(rtf);
                            while (this.calloutPos < this.calloutCount && this.callout[this.calloutPos].getLine() == this.lineNumber && this.callout[this.calloutPos].getColumn() > this.colNumber) {
                                this.formatPad(rtf, this.callout[this.calloutPos].getColumn() - this.colNumber);
                                this.colNumber = this.callout[this.calloutPos].getColumn();
                                while (this.calloutPos < this.calloutCount && this.callout[this.calloutPos].getLine() == this.lineNumber && this.callout[this.calloutPos].getColumn() == this.colNumber) {
                                    fCallout.formatCallout(rtf, this.callout[this.calloutPos]);
                                    ++this.calloutPos;
                                }
                            }
                            this.openClosedElements(rtf);
                        }
                        ++this.lineNumber;
                        this.colNumber = 1;
                    } else {
                        ++this.colNumber;
                    }
                    chars[pos++] = text.charAt(count);
                }
                if (pos > 0) {
                    rtf.characters(chars, 0, pos);
                }
            } else if (node.getNodeType() == 8) {
                text = node.getNodeValue();
                chars = text.toCharArray();
                rtf.comment(chars, 0, text.length());
            } else if (node.getNodeType() == 7) {
                rtf.processingInstruction(node.getNodeName(), node.getNodeValue());
            } else {
                System.out.println("Warning: unexpected node type in calloutFragment: " + node.getNodeType() + ": " + node.getNodeName());
            }
            if (node.getNodeType() == 1) {
                ns = node.getNamespaceURI();
                localName = node.getLocalName();
                name = ((Element)node).getTagName();
                rtf.endElement(ns, localName, name);
                this.elementStack.pop();
            }
        }
        catch (SAXException e) {
            System.out.println("SAX Exception in calloutFragment");
        }
    }

    private void addCallout(int coNum, Node node, int defaultColumn) {
        Element area = (Element)node;
        String units = area.getAttribute("units");
        String otherUnits = area.getAttribute("otherunits");
        String coords = area.getAttribute("coords");
        int type = 0;
        String otherType = null;
        if ("".equals(units) || units.equals("linecolumn")) {
            type = 2;
        } else if (units.equals("linerange")) {
            type = 4;
        } else if (units.equals("linecolumnpair")) {
            type = 3;
        } else if (units.equals("calspair")) {
            type = 1;
        } else {
            type = 5;
            otherType = otherUnits;
        }
        if (type != 2 && type != 4) {
            System.out.println("Only linecolumn and linerange units are supported");
            return;
        }
        if (coords == null) {
            System.out.println("Coords must be specified");
            return;
        }
        StringTokenizer st = new StringTokenizer(coords);
        int tokenCount = 0;
        int c1 = 0;
        int c2 = 0;
        while (st.hasMoreTokens()) {
            if (++tokenCount > 2) {
                System.out.println("Unparseable coordinates");
                return;
            }
            try {
                int coord;
                String token = st.nextToken();
                c2 = coord = Integer.parseInt(token);
                if (tokenCount != 1) continue;
                c1 = coord;
            }
            catch (NumberFormatException e) {
                System.out.println("Unparseable coordinate");
                return;
            }
        }
        if (this.calloutCount == this.callout.length) {
            Callout[] bigger = new Callout[this.calloutCount + 10];
            for (int count = 0; count < this.callout.length; ++count) {
                bigger[count] = this.callout[count];
            }
            this.callout = bigger;
        }
        if (tokenCount == 2) {
            if (type == 4) {
                for (int count = c1; count <= c2; ++count) {
                    this.callout[this.calloutCount++] = new Callout(coNum, area, count, defaultColumn, type);
                }
            } else {
                this.callout[this.calloutCount++] = new Callout(coNum, area, c1, c2, type);
            }
        } else {
            this.callout[this.calloutCount++] = new Callout(coNum, area, c1, defaultColumn, type);
        }
    }

    private void formatPad(DOMBuilder rtf, int numBlanks) {
        char[] chars = new char[numBlanks];
        for (int count = 0; count < numBlanks; ++count) {
            chars[count] = 32;
        }
        try {
            rtf.characters(chars, 0, numBlanks);
        }
        catch (SAXException e) {
            System.out.println("SAX Exception in formatCallout");
        }
    }

    private void closeOpenElements(DOMBuilder rtf) throws SAXException {
        this.tempStack = new Stack();
        while (!this.elementStack.empty()) {
            Node elem = (Node)this.elementStack.pop();
            String ns = elem.getNamespaceURI();
            String localName = elem.getLocalName();
            String name = ((Element)elem).getTagName();
            if (this.elementStack.empty() && (ns != null && ns.equals(foURI) && localName.equals("block") || ns == null && localName.equalsIgnoreCase("pre") || ns != null && ns.equals(xhURI) && localName.equals("pre") || ns == null && localName.equalsIgnoreCase("div") || ns != null && ns.equals(xhURI) && localName.equals("div"))) {
                this.elementStack.push(elem);
                break;
            }
            rtf.endElement(ns, localName, name);
            this.tempStack.push(elem);
        }
    }

    private void openClosedElements(DOMBuilder rtf) throws SAXException {
        while (!this.tempStack.empty()) {
            Node elem = (Node)this.tempStack.pop();
            String ns = elem.getNamespaceURI();
            String localName = elem.getLocalName();
            String name = ((Element)elem).getTagName();
            NamedNodeMap domAttr = elem.getAttributes();
            AttributesImpl attr = new AttributesImpl();
            for (int acount = 0; acount < domAttr.getLength(); ++acount) {
                Node a = domAttr.item(acount);
                if ((ns == null || ns == xhURI) && localName.equalsIgnoreCase("a") || a.getLocalName().equalsIgnoreCase("id")) continue;
                attr.addAttribute(a.getNamespaceURI(), a.getLocalName(), a.getNodeName(), "CDATA", a.getNodeValue());
            }
            rtf.startElement(ns, localName, name, (Attributes)attr);
            this.elementStack.push(elem);
        }
        this.tempStack = null;
    }

    private Attributes copyAttributes(Element node) {
        AttributesImpl attrs = new AttributesImpl();
        NamedNodeMap nnm = node.getAttributes();
        for (int count = 0; count < nnm.getLength(); ++count) {
            Attr attr = (Attr)nnm.item(count);
            String name = attr.getName();
            if (name.startsWith("xmlns:") || name.equals("xmlns")) continue;
            attrs.addAttribute(attr.getNamespaceURI(), attr.getName(), attr.getName(), "CDATA", attr.getValue());
        }
        return attrs;
    }
}

