/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.util.HashMap;
import java.util.Map;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.ConstructedItemType;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.OccurrenceIndicator;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.WhitespaceStrippingPolicy;
import net.sf.saxon.s9api.XsltTransformer;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XsltExecutable {
    Processor processor;
    PreparedStylesheet pss;

    protected XsltExecutable(Processor processor, PreparedStylesheet pss) {
        this.processor = processor;
        this.pss = pss;
    }

    public XsltTransformer load() {
        return new XsltTransformer(this.processor, (Controller)this.pss.newTransformer());
    }

    public void explain(Destination destination) throws SaxonApiException {
        Configuration config = this.processor.getUnderlyingConfiguration();
        this.pss.explain(new ExpressionPresenter(config, destination.getReceiver(config)));
    }

    public WhitespaceStrippingPolicy getWhitespaceStrippingPolicy() {
        return new WhitespaceStrippingPolicy(this.pss.getExecutable());
    }

    public HashMap<QName, ParameterDetails> getGlobalParameters() {
        HashMap<StructuredQName, GlobalVariable> globals = this.pss.getExecutable().getCompiledGlobalVariables();
        HashMap<QName, ParameterDetails> params = new HashMap<QName, ParameterDetails>(globals.size());
        for (Map.Entry<StructuredQName, GlobalVariable> e : globals.entrySet()) {
            StructuredQName name = e.getKey();
            GlobalVariable var = e.getValue();
            if (!(var instanceof GlobalParam)) continue;
            ParameterDetails details = new ParameterDetails(var.getRequiredType(), var.isRequiredParam());
            params.put(new QName(name), details);
        }
        return params;
    }

    public PreparedStylesheet getUnderlyingCompiledStylesheet() {
        return this.pss;
    }

    public class ParameterDetails {
        private SequenceType type;
        private boolean isRequired;

        protected ParameterDetails(SequenceType type, boolean isRequired) {
            this.type = type;
            this.isRequired = isRequired;
        }

        public ItemType getDeclaredItemType() {
            return new ConstructedItemType(this.type.getPrimaryType(), XsltExecutable.this.processor);
        }

        public OccurrenceIndicator getDeclaredCardinality() {
            return OccurrenceIndicator.getOccurrenceIndicator(this.type.getCardinality());
        }

        public boolean isRequired() {
            return this.isRequired;
        }
    }
}

