/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.Serializable;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.RangeIterator;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerRange;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public class RangeExpression
extends BinaryExpression {
    public RangeExpression(Expression start, int op, Expression end) {
        super(start, op, end);
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.operand0 = visitor.typeCheck(this.operand0, contextItemType);
        this.operand1 = visitor.typeCheck(this.operand1, contextItemType);
        boolean backCompat = visitor.getStaticContext().isInBackwardsCompatibleMode();
        RoleLocator role0 = new RoleLocator(1, (Serializable)((Object)"to"), 0);
        this.operand0 = TypeChecker.staticTypeCheck(this.operand0, SequenceType.OPTIONAL_INTEGER, backCompat, role0, visitor);
        RoleLocator role1 = new RoleLocator(1, (Serializable)((Object)"to"), 1);
        this.operand1 = TypeChecker.staticTypeCheck(this.operand1, SequenceType.OPTIONAL_INTEGER, backCompat, role1, visitor);
        return this.makeConstantRange();
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.operand0 = visitor.optimize(this.operand0, contextItemType);
        this.operand1 = visitor.optimize(this.operand1, contextItemType);
        return this.makeConstantRange();
    }

    private Expression makeConstantRange() throws XPathException {
        if (this.operand0 instanceof Literal && this.operand1 instanceof Literal) {
            Value v0 = ((Literal)this.operand0).getValue();
            Value v1 = ((Literal)this.operand1).getValue();
            if (v0 instanceof Int64Value && v1 instanceof Int64Value) {
                Literal result;
                long i1;
                long i0 = ((Int64Value)v0).longValue();
                if (i0 > (i1 = ((Int64Value)v1).longValue())) {
                    result = Literal.makeEmptySequence();
                } else if (i0 == i1) {
                    result = Literal.makeLiteral(Int64Value.makeIntegerValue(i0));
                } else {
                    try {
                        result = Literal.makeLiteral(new IntegerRange(i0, i1));
                    }
                    catch (XPathException e) {
                        e.maybeSetLocation(this);
                        throw e;
                    }
                }
                ExpressionTool.copyLocationInfo(this, result);
                return result;
            }
        }
        return this;
    }

    public ItemType getItemType(TypeHierarchy th) {
        return BuiltInAtomicType.INTEGER;
    }

    public int computeCardinality() {
        return 57344;
    }

    public Expression copy() {
        return new RangeExpression(this.operand0.copy(), this.operator, this.operand1.copy());
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        AtomicValue av1 = (AtomicValue)this.operand0.evaluateItem(context);
        if (av1 == null) {
            return EmptyIterator.getInstance();
        }
        NumericValue v1 = (NumericValue)av1;
        AtomicValue av2 = (AtomicValue)this.operand1.evaluateItem(context);
        if (av2 == null) {
            return EmptyIterator.getInstance();
        }
        NumericValue v2 = (NumericValue)av2;
        if (v1.compareTo(v2) > 0) {
            return EmptyIterator.getInstance();
        }
        return new RangeIterator(v1.longValue(), v2.longValue());
    }
}

